/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hbase;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.util.Bytes;

public class ColumnIterator
implements Iterator<String> {
    private static final Log LOG = LogFactory.getLog((String)ColumnIterator.class.getName());
    Iterator<byte[]> _setIterator;
    Iterator<Cell> _listIterator;

    public ColumnIterator(Collection<?> columnCollection) {
        if (columnCollection != null) {
            if (columnCollection instanceof Set) {
                this._setIterator = ((Set)columnCollection).iterator();
            } else if (columnCollection instanceof List) {
                this._listIterator = ((List)columnCollection).iterator();
            } else {
                LOG.error((Object)("Unexpected type " + columnCollection.getClass().getName() + " passed as value in column family collection"));
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this._setIterator != null) {
            return this._setIterator.hasNext();
        }
        if (this._listIterator != null) {
            return this._listIterator.hasNext();
        }
        return false;
    }

    @Override
    public String next() {
        String value = "";
        if (this._setIterator != null) {
            byte[] valueBytes = this._setIterator.next();
            if (valueBytes != null) {
                value = Bytes.toString((byte[])valueBytes);
            }
        } else if (this._listIterator != null) {
            Cell cell = this._listIterator.next();
            byte[] v = CellUtil.cloneQualifier((Cell)cell);
            if (v != null) {
                value = Bytes.toString((byte[])v);
            }
        } else {
            throw new NoSuchElementException("Empty values passed in!");
        }
        return value;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported from iterator!");
    }
}

