/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kylin.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.kylin.client.KylinClient;

public class KylinResourceMgr {
    public static final String PROJECT = "project";
    private static final Logger LOG = Logger.getLogger(KylinResourceMgr.class);

    public static Map<String, Object> validateConfig(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> KylinResourceMgr.validateConfig ServiceName: " + serviceName + "Configs" + configs));
        }
        try {
            ret = KylinClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error((Object)("<== KylinResourceMgr.validateConfig Error: " + e));
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== KylinResourceMgr.validateConfig Result: " + ret));
        }
        return ret;
    }

    public static List<String> getKylinResources(String serviceName, Map<String, String> configs, ResourceLookupContext context) {
        KylinClient kylinClient;
        String userInput = context.getUserInput();
        String resource = context.getResourceName();
        Map resourceMap = context.getResources();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> KylinResourceMgr.getKylinResources()  userInput: " + userInput + ", resource: " + resource + ", resourceMap: " + resourceMap));
        }
        if (MapUtils.isEmpty(configs)) {
            LOG.error((Object)"Connection Config is empty!");
            return null;
        }
        if (StringUtils.isEmpty((String)userInput)) {
            LOG.warn((Object)"User input is empty, set default value : *");
            userInput = "*";
        }
        List projectList = null;
        if (MapUtils.isNotEmpty((Map)resourceMap)) {
            projectList = (List)resourceMap.get(PROJECT);
        }
        if ((kylinClient = KylinClient.getKylinClient(serviceName, configs)) == null) {
            LOG.error((Object)"Failed to getKylinClient!");
            return null;
        }
        List<String> resultList = null;
        resultList = kylinClient.getProjectList(userInput, projectList);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== KylinResourceMgr.getKylinResources() result: " + resultList));
        }
        return resultList;
    }
}

