/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kylin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.kylin.client.KylinResourceMgr;

public class RangerServiceKylin
extends RangerBaseService {
    private static final Log LOG = LogFactory.getLog(RangerServiceKylin.class);

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceKylin.validateConfig Service: (" + serviceName + " )"));
        }
        if (this.configs != null) {
            try {
                ret = KylinResourceMgr.validateConfig(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error((Object)("<== RangerServiceKylin.validateConfig Error:" + e));
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceKylin.validateConfig Response : (" + ret + " )"));
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceKylin.lookupResource Context: (" + context + ")"));
        }
        if (context != null) {
            try {
                ret = KylinResourceMgr.getKylinResources(serviceName, configs, context);
            }
            catch (Exception e) {
                LOG.error((Object)("<==RangerServiceKylin.lookupResource Error : " + e));
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceKylin.lookupResource Response: (" + ret + ")"));
        }
        return ret;
    }
}

