/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hdfs.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.hdfs.client.HdfsClient;

public class HdfsConnectionMgr {
    protected ConcurrentMap<String, HdfsClient> hdfsConnectionCache = new ConcurrentHashMap<String, HdfsClient>();
    protected ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();
    private static final Logger LOG = Logger.getLogger(HdfsConnectionMgr.class);

    public HdfsClient getHadoopConnection(final String serviceName, String serviceType, final Map<String, String> configs) throws Exception {
        HdfsClient hdfsClient = null;
        if (serviceType != null) {
            hdfsClient = (HdfsClient)((Object)this.hdfsConnectionCache.get(serviceName));
            if (hdfsClient == null) {
                Callable<HdfsClient> connectHDFS;
                if (configs == null) {
                    connectHDFS = new Callable<HdfsClient>(){

                        @Override
                        public HdfsClient call() throws Exception {
                            return new HdfsClient(serviceName, configs);
                        }
                    };
                    try {
                        hdfsClient = (HdfsClient)((Object)TimedEventUtil.timedTask((Callable)connectHDFS, (long)10L, (TimeUnit)TimeUnit.SECONDS));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error establishing connection for HDFS repository : " + serviceName), (Throwable)e);
                        throw e;
                    }
                }
                connectHDFS = new Callable<HdfsClient>(){

                    @Override
                    public HdfsClient call() throws Exception {
                        return new HdfsClient(serviceName, configs);
                    }
                };
                try {
                    hdfsClient = (HdfsClient)((Object)TimedEventUtil.timedTask((Callable)connectHDFS, (long)5L, (TimeUnit)TimeUnit.SECONDS));
                }
                catch (Exception e) {
                    LOG.error((Object)("Error establishing connection for HDFS repository : " + serviceName + " using configuration : " + configs), (Throwable)e);
                    throw e;
                }
                HdfsClient oldClient = this.hdfsConnectionCache.putIfAbsent(serviceName, hdfsClient);
                if (oldClient != null) {
                    hdfsClient = oldClient;
                }
                this.repoConnectStatusMap.put(serviceName, true);
            } else {
                List<String> testConnect = null;
                try {
                    testConnect = hdfsClient.listFiles("/", "*", null);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error establishing connection for HDFS repository : " + serviceName + " using configuration : " + configs), (Throwable)e);
                    throw e;
                }
                if (testConnect == null) {
                    this.hdfsConnectionCache.put(serviceName, hdfsClient);
                    hdfsClient = this.getHadoopConnection(serviceName, serviceType, configs);
                }
            }
        } else {
            LOG.error((Object)("Service not found with name " + serviceName), new Throwable());
        }
        return hdfsClient;
    }
}

