/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop;

import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;

class RangerHdfsAuditHandler
extends RangerDefaultAuditHandler {
    private static final Log LOG = LogFactory.getLog(RangerHdfsAuditHandler.class);
    private boolean isAuditEnabled = false;
    private AuthzAuditEvent auditEvent = null;
    private final String pathToBeValidated;
    private final boolean auditOnlyIfDenied;
    private final String hadoopModuleName;
    private final Set<String> excludeUsers;
    private final String operationName;
    private final String callerContext;

    public RangerHdfsAuditHandler(String pathToBeValidated, boolean auditOnlyIfDenied, String hadoopModuleName, Set<String> excludedUsers, String operationName, String callerContext) {
        this.pathToBeValidated = pathToBeValidated;
        this.auditOnlyIfDenied = auditOnlyIfDenied;
        this.hadoopModuleName = hadoopModuleName;
        this.excludeUsers = excludedUsers;
        this.operationName = operationName;
        this.callerContext = callerContext;
    }

    public void processResult(RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerHdfsAuditHandler.logAudit(" + result + ")"));
        }
        if (!this.isAuditEnabled && result.getIsAudited()) {
            this.isAuditEnabled = true;
        }
        if (this.auditEvent == null) {
            this.auditEvent = super.getAuthzEvents(result);
        }
        if (this.auditEvent != null) {
            RangerAccessRequest request = result.getAccessRequest();
            RangerAccessResource resource = request.getResource();
            String resourcePath = resource != null ? resource.getAsString() : null;
            this.auditEvent.setEventTime(request.getAccessTime() != null ? request.getAccessTime() : new Date());
            this.auditEvent.setAccessType(request.getAction());
            this.auditEvent.setResourcePath(this.pathToBeValidated);
            this.auditEvent.setResultReason(resourcePath);
            this.auditEvent.setAccessResult((short)(result.getIsAllowed() ? 1 : 0));
            this.auditEvent.setPolicyId(result.getPolicyId());
            this.auditEvent.setPolicyVersion(result.getPolicyVersion());
            this.auditEvent.setRequestData(this.operationName);
            this.auditEvent.setAction(this.callerContext);
            Set tags = this.getTags(request);
            if (tags != null) {
                this.auditEvent.setTags(tags);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHdfsAuditHandler.logAudit(" + result + "): " + this.auditEvent));
        }
    }

    public void logHadoopEvent(String path, FsAction action, boolean accessGranted) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerHdfsAuditHandler.logHadoopEvent(" + path + ", " + action + ", " + accessGranted + ")"));
        }
        if (this.auditEvent != null) {
            this.auditEvent.setResultReason(path);
            this.auditEvent.setAccessResult((short)(accessGranted ? 1 : 0));
            this.auditEvent.setAccessType(action == null ? null : action.toString());
            this.auditEvent.setAclEnforcer(this.hadoopModuleName);
            this.auditEvent.setPolicyId(-1L);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHdfsAuditHandler.logHadoopEvent(" + path + ", " + action + ", " + accessGranted + "): " + this.auditEvent));
        }
    }

    public void flushAudit() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerHdfsAuditHandler.flushAudit(" + this.isAuditEnabled + ", " + this.auditEvent + ")"));
        }
        if (this.isAuditEnabled && this.auditEvent != null && !StringUtils.isEmpty((String)this.auditEvent.getAccessType())) {
            boolean skipLog;
            String username = this.auditEvent.getUser();
            boolean bl = skipLog = username != null && this.excludeUsers != null && this.excludeUsers.contains(username) || this.auditOnlyIfDenied && this.auditEvent.getAccessResult() != 0;
            if (!skipLog) {
                super.logAuthzAudit(this.auditEvent);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHdfsAuditHandler.flushAudit(" + this.isAuditEnabled + ", " + this.auditEvent + ")"));
        }
    }
}

