/*
 * Decompiled with CFR 0.152.
 */
package nl.techop.kafka;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import nl.techop.kafka.KafkaPartition;
import nl.techop.kafka.KafkaTopic;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.MetadataResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Path(value="/topics")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u0013\t\u00192*\u00194lCR{\u0007/[2t%\u0016\u001cx.\u001e:dK*\u00111\u0001B\u0001\u0006W\u000647.\u0019\u0006\u0003\u000b\u0019\ta\u0001^3dQ>\u0004(\"A\u0004\u0002\u00059d7\u0001A\n\u0003\u0001)\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007\u0002C\t\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\rM,'O^3s!\t\u0019b#D\u0001\u0015\u0015\t\tRCC\u0001\u0004\u0013\t9BCA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\b\u0006\u0002\u001c;A\u0011A\u0004A\u0007\u0002\u0005!)\u0011\u0003\u0007a\u0001%!)q\u0004\u0001C\u0001A\u0005QA.[:u)>\u0004\u0018nY:\u0016\u0003\u0005\u0002BAI\u0014*a5\t1E\u0003\u0002%K\u0005!Q\u000f^5m\u0015\u00051\u0013\u0001\u00026bm\u0006L!\u0001K\u0012\u0003\u00075\u000b\u0007\u000f\u0005\u0002+[9\u00111bK\u0005\u0003Y1\ta\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\u0019\u0019FO]5oO*\u0011A\u0006\u0004\t\u00039EJ!A\r\u0002\u0003\u0015-\u000bgm[1U_BL7\r\u000b\u0002\u001fiA\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\u0003eNT!!\u000f\u001e\u0002\u0005]\u001c(\"A\u001e\u0002\u000b)\fg/\u0019=\n\u0005u2$aA$F)\"\"\u0001a\u0010\"D!\t)\u0004)\u0003\u0002Bm\tA\u0001K]8ek\u000e,7/A\u0003wC2,X\rL\u0001EC\u0005)\u0015\u0001E1qa2L7-\u0019;j_:|#n]8oQ\u0011\u0001qI\u0011&\u0011\u0005UB\u0015BA%7\u0005\u0011\u0001\u0016\r\u001e5\"\u0003-\u000bqa\f;pa&\u001c7\u000f")
public class KafkaTopicsResource {
    private final KafkaServer server;

    @GET
    public java.util.Map<String, KafkaTopic> listTopics() {
        if (this.server.metadataCache() == null) {
            return Collections.emptyMap();
        }
        Set<String> topics = this.server.metadataCache().getAllTopics();
        ListenerName listener = this.server.config().interBrokerListenerName();
        MetadataCache qual$1 = this.server.metadataCache();
        Set<String> x$6 = topics;
        ListenerName x$7 = listener;
        boolean x$8 = true;
        boolean x$9 = qual$1.getTopicMetadata$default$4();
        Seq result = (Seq)((TraversableLike)qual$1.getTopicMetadata(x$6, x$7, x$8, x$9).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple4<MetadataResponse.TopicMetadata, String, Object, Buffer<KafkaPartition>> apply(MetadataResponse.TopicMetadata topicMetadata) {
                String topicName = topicMetadata.topic();
                boolean internal = topicMetadata.isInternal();
                Buffer kafkaPartitions = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitionMetadata()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple5<MetadataResponse.PartitionMetadata, Object, List<Object>, Object, List<Object>> apply(MetadataResponse.PartitionMetadata partitionMetadata) {
                        int partition = partitionMetadata.partition();
                        List replicas = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicas()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Node x$1) {
                                return x$1.id();
                            }
                        }, Buffer$.MODULE$.canBuildFrom())).asJava();
                        int leader = partitionMetadata.leader().id();
                        List isr = (List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isr()).asScala()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Node x$2) {
                                return x$2.id();
                            }
                        }, Buffer$.MODULE$.canBuildFrom())).asJava();
                        return new Tuple5((Object)partitionMetadata, (Object)BoxesRunTime.boxToInteger((int)partition), (Object)replicas, (Object)BoxesRunTime.boxToInteger((int)leader), (Object)isr);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final KafkaPartition apply(Tuple5<MetadataResponse.PartitionMetadata, Object, List<Object>, Object, List<Object>> x$3) {
                        Tuple5<MetadataResponse.PartitionMetadata, Object, List<Object>, Object, List<Object>> tuple5 = x$3;
                        if (tuple5 != null) {
                            int partition = BoxesRunTime.unboxToInt((Object)tuple5._2());
                            List replicas = (List)tuple5._3();
                            int leader = BoxesRunTime.unboxToInt((Object)tuple5._4());
                            List isr = (List)tuple5._5();
                            KafkaPartition kafkaPartition = new KafkaPartition(partition, replicas, leader, isr);
                            return kafkaPartition;
                        }
                        throw new MatchError(tuple5);
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                return new Tuple4((Object)topicMetadata, (Object)topicName, (Object)BoxesRunTime.boxToBoolean((boolean)internal), (Object)kafkaPartitions);
            }
        }, Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple4<MetadataResponse.TopicMetadata, String, Object, Buffer<KafkaPartition>> x$4) {
                Tuple4<MetadataResponse.TopicMetadata, String, Object, Buffer<KafkaPartition>> tuple4 = x$4;
                if (tuple4 != null) {
                    Buffer kafkaPartitions = (Buffer)tuple4._4();
                    boolean bl = !kafkaPartitions.isEmpty();
                    return bl;
                }
                throw new MatchError(tuple4);
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, KafkaTopic> apply(Tuple4<MetadataResponse.TopicMetadata, String, Object, Buffer<KafkaPartition>> x$5) {
                Tuple4<MetadataResponse.TopicMetadata, String, Object, Buffer<KafkaPartition>> tuple4 = x$5;
                if (tuple4 != null) {
                    String topicName = (String)tuple4._2();
                    boolean internal = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
                    Buffer kafkaPartitions = (Buffer)tuple4._4();
                    Tuple2 tuple2 = new Tuple2((Object)topicName, (Object)new KafkaTopic(internal, (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(kafkaPartitions).asJava(), null));
                    return tuple2;
                }
                throw new MatchError(tuple4);
            }
        }, Seq$.MODULE$.canBuildFrom());
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)result.toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    public KafkaTopicsResource(KafkaServer server) {
        this.server = server;
        Predef$.MODULE$.require(server != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "server cannot be null";
            }
        });
    }
}

