/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.typesafe.scalalogging.Logger;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kafka.server.BrokerClientMetrics;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0002\u0015:pIV\u001cWM]*uCR\u001c(BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0011\tQ!\u001e;jYNL!a\u0005\t\u0003\u000f1{wmZ5oO\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u000bqe>$WoY3s\u0007\u0006\u001c\u0007.Z'bqNK'0\u001a\t\u0003\u0013]I!\u0001\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0003U\u0001(o\u001c3vG\u0016\u00148)Y2iK\u0016C\b/\u001b:z\u001bN\u0004\"!\u0003\u000f\n\u0005uQ!\u0001\u0002'p]\u001eDQa\b\u0001\u0005\u0002\u0001\na\u0001P5oSRtDcA\u0011$IA\u0011!\u0005A\u0007\u0002\u0005!)QC\ba\u0001-!)!D\ba\u00017!9a\u0005\u0001b\u0001\n\u00139\u0013a\u00024bGR|'/_\u000b\u0002QA!\u0011\"K\u0016A\u0013\tQ#BA\u0005Gk:\u001cG/[8ocA!\u0011\u0002\f\u00186\u0013\ti#B\u0001\u0004UkBdWM\r\t\u0003_Ir!!\u0003\u0019\n\u0005ER\u0011A\u0002)sK\u0012,g-\u0003\u00024i\t11\u000b\u001e:j]\u001eT!!\r\u0006\u0011\u0005YrT\"A\u001c\u000b\u0005aJ\u0014AB2p[6|gN\u0003\u0002\u0006u)\u00111\bP\u0001\u0007CB\f7\r[3\u000b\u0003u\n1a\u001c:h\u0013\tytG\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005\t\n\u0015B\u0001\"\u0003\u0005M\u0011%o\\6fe\u000ec\u0017.\u001a8u\u001b\u0016$(/[2t\u0011\u0019!\u0005\u0001)A\u0005Q\u0005Aa-Y2u_JL\b\u0005C\u0004G\u0001\t\u0007I\u0011B$\u0002\u001b\rd\u0017.\u001a8u\u001b\u0016$(/[2t+\u0005A\u0005\u0003B\bJW\u0001K!A\u0013\t\u0003\tA{w\u000e\u001c\u0005\u0007\u0019\u0002\u0001\u000b\u0011\u0002%\u0002\u001d\rd\u0017.\u001a8u\u001b\u0016$(/[2tA!9a\n\u0001b\u0001\n\u0013y\u0015a\u0004:f[>4\u0018\r\u001c'jgR,g.\u001a:\u0016\u0003A\u00132!U+^\r\u0011\u00116\u000b\u0001)\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \t\rQ\u0003\u0001\u0015!\u0003Q\u0003A\u0011X-\\8wC2d\u0015n\u001d;f]\u0016\u0014\b\u0005\u0005\u0002W76\tqK\u0003\u0002Y3\u0006!A.\u00198h\u0015\u0005Q\u0016\u0001\u00026bm\u0006L!\u0001X,\u0003\r=\u0013'.Z2u!\u0011q\u0016NL6\u000e\u0003}S!\u0001Y1\u0002\u000b\r\f7\r[3\u000b\u0005\t\u001c\u0017\u0001C2bM\u001a,\u0017N\\3\u000b\u0005\u0011,\u0017\u0001\u00032f]6\fg.Z:\u000b\u0005\u0019<\u0017AB4ji\",(MC\u0001i\u0003\r\u0019w.\\\u0005\u0003U~\u0013qBU3n_Z\fG\u000eT5ti\u0016tWM\u001d\t\u0004Y>,T\"A7\u000b\u00059L\u0016\u0001B;uS2L!\u0001]7\u0003\u0015\r{G\u000e\\3di&|g\u000eC\u0004s\u0001\t\u0007I\u0011B:\u0002\u0017\r\f7\r[3M_\u0006$WM]\u000b\u0002iJ\u0019Q/\u0016=\u0007\tI3\b\u0001\u001e\u0005\u0007o\u0002\u0001\u000b\u0011\u0002;\u0002\u0019\r\f7\r[3M_\u0006$WM\u001d\u0011\u0011\tyKhf[\u0005\u0003u~\u00131bQ1dQ\u0016du.\u00193fe\"9A\u0010\u0001b\u0001\n\u0013i\u0018!F2mS\u0016tG\u000fV8qS\u000e\u0004\u0016M\u001d;ji&|gn]\u000b\u0002}B!al \u0018l\u0013\r\t\ta\u0018\u0002\r\u0019>\fG-\u001b8h\u0007\u0006\u001c\u0007.\u001a\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003\u007f\u0003Y\u0019G.[3oiR{\u0007/[2QCJ$\u0018\u000e^5p]N\u0004\u0003B\u0002$\u0001\t\u0003\tI\u0001F\u0003A\u0003\u0017\ty\u0001C\u0004\u0002\u000e\u0005\u001d\u0001\u0019\u0001\u0018\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Dq!!\u0005\u0002\b\u0001\u0007Q'\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018\u0005i!/Z7pm\u0016lU\r\u001e:jGN$B!!\u0007\u0002 A\u0019\u0011\"a\u0007\n\u0007\u0005u!B\u0001\u0003V]&$\bbBA\u0007\u0003'\u0001\rA\f\u0005\b\u0003+\u0001A\u0011BA\u0012)\u0019\tI\"!\n\u0002(!9\u0011QBA\u0011\u0001\u0004q\u0003bBA\u0015\u0003C\u0001\ra[\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bbBA\u0017\u0001\u0011\u0005\u0011qF\u0001\u0006G2|7/\u001a\u000b\u0003\u00033\u0001")
public class ProducerStats
implements Logging {
    private final Function1<Tuple2<String, TopicPartition>, BrokerClientMetrics> factory;
    private final Pool<Tuple2<String, TopicPartition>, BrokerClientMetrics> kafka$server$ProducerStats$$clientMetrics;
    private final Object removalListener;
    private final Object cacheLoader;
    private final LoadingCache<String, Collection<TopicPartition>> kafka$server$ProducerStats$$clientTopicPartitions;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ProducerStats producerStats = this;
        synchronized (producerStats) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private Function1<Tuple2<String, TopicPartition>, BrokerClientMetrics> factory() {
        return this.factory;
    }

    public Pool<Tuple2<String, TopicPartition>, BrokerClientMetrics> kafka$server$ProducerStats$$clientMetrics() {
        return this.kafka$server$ProducerStats$$clientMetrics;
    }

    private Object removalListener() {
        return this.removalListener;
    }

    private Object cacheLoader() {
        return this.cacheLoader;
    }

    public LoadingCache<String, Collection<TopicPartition>> kafka$server$ProducerStats$$clientTopicPartitions() {
        return this.kafka$server$ProducerStats$$clientTopicPartitions;
    }

    public BrokerClientMetrics clientMetrics(String clientId2, TopicPartition topicPartition) {
        Objects.requireNonNull(topicPartition, "topicPartition can not be null");
        Collection topicPartitions2 = (Collection)this.kafka$server$ProducerStats$$clientTopicPartitions().get((Object)clientId2);
        Object object = topicPartitions2 == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)topicPartitions2.add(topicPartition));
        this.kafka$server$ProducerStats$$clientTopicPartitions().put((Object)clientId2, (Object)topicPartitions2);
        return this.kafka$server$ProducerStats$$clientMetrics().getAndMaybePut((Tuple2<String, TopicPartition>)new Tuple2((Object)clientId2, (Object)topicPartition));
    }

    public void removeMetrics(String clientId2) {
        Collection partitions = (Collection)this.kafka$server$ProducerStats$$clientTopicPartitions().getIfPresent((Object)clientId2);
        this.kafka$server$ProducerStats$$removeMetrics(clientId2, partitions);
    }

    public void kafka$server$ProducerStats$$removeMetrics(String clientId2, Collection<TopicPartition> partitions) {
        this.debug((Function0<String>)new Serializable(this, clientId2, partitions){
            public static final long serialVersionUID = 0L;
            private final String clientId$1;
            private final Collection partitions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing clientId: ", " with partitions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.clientId$1, this.partitions$1}));
            }
            {
                this.clientId$1 = clientId$1;
                this.partitions$1 = partitions$1;
            }
        });
        if (partitions != null && !partitions.isEmpty()) {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(partitions).asScala()).foreach((Function1)new Serializable(this, clientId2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerStats $outer;
                private final String clientId$1;

                public final void apply(TopicPartition tp) {
                    BrokerClientMetrics metrics = this.$outer.kafka$server$ProducerStats$$clientMetrics().remove((Tuple2<String, TopicPartition>)new Tuple2((Object)this.clientId$1, (Object)tp));
                    if (metrics != null) {
                        metrics.close();
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.clientId$1 = clientId$1;
                }
            });
        }
    }

    public void close() {
        this.kafka$server$ProducerStats$$clientMetrics().values().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(BrokerClientMetrics x$2) {
                x$2.close();
            }
        });
    }

    public ProducerStats(int producerCacheMaxSize, long producerCacheExpiryMs) {
        Logging$class.$init$(this);
        Objects.requireNonNull(BoxesRunTime.boxToInteger((int)producerCacheMaxSize), "producerCacheMaxSize can not be null");
        Objects.requireNonNull(BoxesRunTime.boxToLong((long)producerCacheExpiryMs), "producerCacheExpiryMs can not be null");
        this.factory = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerClientMetrics apply(Tuple2<String, TopicPartition> k) {
                return new BrokerClientMetrics((String)k._1(), (TopicPartition)k._2());
            }
        };
        this.kafka$server$ProducerStats$$clientMetrics = new Pool(new Some(this.factory()));
        this.removalListener = new RemovalListener<String, Collection<TopicPartition>>(this){
            private final /* synthetic */ ProducerStats $outer;

            public void onRemoval(String key, Collection<TopicPartition> value2, RemovalCause cause) {
                this.$outer.debug((Function0<String>)new Serializable(this, key, value2){
                    public static final long serialVersionUID = 0L;
                    private final String key$1;
                    private final Collection value$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cache removal listener invoked for key: ", " and value as ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1, this.value$1}));
                    }
                    {
                        this.key$1 = key$1;
                        this.value$1 = value$1;
                    }
                });
                this.$outer.kafka$server$ProducerStats$$removeMetrics(key, value2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.cacheLoader = new CacheLoader<String, Collection<TopicPartition>>(this){

            public Collection<TopicPartition> load(String key) {
                return ConcurrentHashMap.newKeySet();
            }
        };
        this.kafka$server$ProducerStats$$clientTopicPartitions = Caffeine.newBuilder().expireAfterWrite(producerCacheExpiryMs, TimeUnit.MILLISECONDS).expireAfterAccess(producerCacheExpiryMs, TimeUnit.MILLISECONDS).maximumSize((long)producerCacheMaxSize).initialCapacity(producerCacheMaxSize / 2).removalListener(this.removalListener()).build(this.cacheLoader());
        Executors.newScheduledThreadPool(1, new ThreadFactory(this){

            /*
             * WARNING - void declaration
             */
            public Thread newThread(Runnable r) {
                void var2_2;
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName("client-topic-metrics-cache-cleanup-thread");
                thread.setDaemon(true);
                return var2_2;
            }
        }).scheduleWithFixedDelay(new Runnable(this){
            private final /* synthetic */ ProducerStats $outer;

            public void run() {
                this.$outer.kafka$server$ProducerStats$$clientTopicPartitions().cleanUp();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, 5L, 300L, TimeUnit.SECONDS);
    }
}

