/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import kafka.cluster.EndPoint;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.authenticator.LoginManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q<Q!\u0001\u0002\t\u0002\u001d\tQ\u0003R=oC6L7\rT5ti\u0016tWM]\"p]\u001aLwM\u0003\u0002\u0004\t\u000511/\u001a:wKJT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001!\tA\u0011\"D\u0001\u0003\r\u0015Q!\u0001#\u0001\f\u0005U!\u0015P\\1nS\u000ed\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001e\u001c\"!\u0003\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0012\u0002\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0004\u0017\u0013\t\u0007I\u0011A\f\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\t\u0001\u0004E\u0002\u001a9yi\u0011A\u0007\u0006\u000379\t!bY8mY\u0016\u001cG/[8o\u0013\ti\"DA\u0002TKR\u0004\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\t1\fgn\u001a\u0006\u0002G\u0005!!.\u0019<b\u0013\t)\u0003E\u0001\u0004TiJLgn\u001a\u0005\u0007O%\u0001\u000b\u0011\u0002\r\u0002-I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hg\u00022AA\u0003\u0002\u0001SM!\u0001\u0006\u0004\u0016.!\tA1&\u0003\u0002-\u0005\t!\"I]8lKJ\u0014VmY8oM&<WO]1cY\u0016\u0004\"AL\u0019\u000e\u0003=R!\u0001\r\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iz#a\u0002'pO\u001eLgn\u001a\u0005\t\u0007!\u0012\t\u0011)A\u0005iA\u0011\u0001\"N\u0005\u0003m\t\u00111bS1gW\u0006\u001cVM\u001d<fe\")1\u0003\u000bC\u0001qQ\u0011\u0011H\u000f\t\u0003\u0011!BQaA\u001cA\u0002QBQ\u0001\u0010\u0015\u0005Bu\nQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/F\u0001?!\rIBd\u0010\t\u0003\u0001\u000es!!D!\n\u0005\ts\u0011A\u0002)sK\u0012,g-\u0003\u0002&\t*\u0011!I\u0004\u0005\u0006\r\"\"\taR\u0001\u0018m\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:$\"\u0001S&\u0011\u00055I\u0015B\u0001&\u000f\u0005\u0011)f.\u001b;\t\u000b1+\u0005\u0019A'\u0002\u00139,woQ8oM&<\u0007C\u0001\u0005O\u0013\ty%AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"B))\t\u0003\u0011\u0016a\u0003:fG>tg-[4ve\u0016$2\u0001S*V\u0011\u0015!\u0006\u000b1\u0001N\u0003%yG\u000eZ\"p]\u001aLw\rC\u0003M!\u0002\u0007Q\nC\u0003XQ\u0011%\u0001,\u0001\bmSN$XM\\3sgR{W*\u00199\u0015\u0005e{\u0007\u0003B\r[9&L!a\u0017\u000e\u0003\u00075\u000b\u0007\u000f\u0005\u0002^O6\taL\u0003\u0002`A\u00069a.\u001a;x_J\\'BA1c\u0003\u0019\u0019w.\\7p]*\u0011Qa\u0019\u0006\u0003I\u0016\fa!\u00199bG\",'\"\u00014\u0002\u0007=\u0014x-\u0003\u0002i=\naA*[:uK:,'OT1nKB\u0011!.\\\u0007\u0002W*\u0011A\u000eB\u0001\bG2,8\u000f^3s\u0013\tq7N\u0001\u0005F]\u0012\u0004v.\u001b8u\u0011\u0015\u0001h\u000b1\u0001r\u0003%a\u0017n\u001d;f]\u0016\u00148\u000fE\u0002\u001ae&L!a\u001d\u000e\u0003\u0007M+\u0017\u000f")
public class DynamicListenerConfig
implements BrokerReconfigurable,
Logging {
    private final KafkaServer server;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicListenerConfig$.MODULE$.ReconfigurableConfigs();
    }

    private Logger logger$lzycompute() {
        DynamicListenerConfig dynamicListenerConfig = this;
        synchronized (dynamicListenerConfig) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicListenerConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        KafkaConfig oldConfig = this.server.config();
        Map<ListenerName, EndPoint> newListeners = this.listenersToMap(newConfig.listeners());
        Map<ListenerName, EndPoint> newAdvertisedListeners = this.listenersToMap(newConfig.advertisedListeners());
        Map<ListenerName, EndPoint> oldListeners = this.listenersToMap(oldConfig.listeners());
        if (newAdvertisedListeners.keySet().subsetOf((GenSet)newListeners.keySet())) {
            if (newListeners.keySet().subsetOf((GenSet)newConfig.listenerSecurityProtocolMap().keySet())) {
                ((IterableLike)newListeners.keySet().intersect((GenSet)oldListeners.keySet())).foreach((Function1)new Serializable(this, newConfig, oldConfig){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DynamicListenerConfig $outer;
                    private final KafkaConfig newConfig$4;
                    private final KafkaConfig oldConfig$3;

                    public final void apply(ListenerName listenerName) {
                        String prefix = listenerName.configPrefix();
                        Map newListenerProps = this.$outer.kafka$server$DynamicListenerConfig$$immutableListenerConfigs$1(this.newConfig$4, prefix, this.newConfig$4);
                        Map oldListenerProps = this.$outer.kafka$server$DynamicListenerConfig$$immutableListenerConfigs$1(this.oldConfig$3, prefix, this.newConfig$4);
                        Map map = newListenerProps;
                        Map map2 = oldListenerProps;
                        if (!(map != null ? !map.equals(map2) : map2 != null)) {
                            if (BoxesRunTime.equals((Object)this.oldConfig$3.listenerSecurityProtocolMap().apply((Object)listenerName), (Object)this.newConfig$4.listenerSecurityProtocolMap().apply((Object)listenerName))) {
                                return;
                            }
                            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Security protocol cannot be updated for existing listener ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenerName})));
                        }
                        throw new ConfigException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Configs cannot be updated dynamically for existing listener ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenerName}))).append((Object)"restart broker or create a new listener for update").toString());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.newConfig$4 = newConfig$4;
                        this.oldConfig$3 = oldConfig$3;
                    }
                });
                if (newAdvertisedListeners.contains((Object)newConfig.interBrokerListenerName())) {
                    return;
                }
                throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Advertised listener must be specified for inter-broker listener ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newConfig.interBrokerListenerName()})));
            }
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listeners '", "' must be subset of listener map '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newListeners, newConfig.listenerSecurityProtocolMap()})));
        }
        throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Advertised listeners '", "' must be a subset of listeners '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newAdvertisedListeners, newListeners})));
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Seq<EndPoint> newListeners = newConfig.listeners();
        Map<ListenerName, EndPoint> newListenerMap = this.listenersToMap(newListeners);
        Seq<EndPoint> oldListeners = oldConfig.listeners();
        Map<ListenerName, EndPoint> oldListenerMap = this.listenersToMap(oldListeners);
        Seq listenersRemoved = (Seq)oldListeners.filterNot((Function1)new Serializable(this, newListenerMap){
            public static final long serialVersionUID = 0L;
            private final Map newListenerMap$1;

            public final boolean apply(EndPoint e) {
                return this.newListenerMap$1.contains((Object)e.listenerName());
            }
            {
                this.newListenerMap$1 = newListenerMap$1;
            }
        });
        Seq listenersAdded = (Seq)newListeners.filterNot((Function1)new Serializable(this, oldListenerMap){
            public static final long serialVersionUID = 0L;
            private final Map oldListenerMap$1;

            public final boolean apply(EndPoint e) {
                return this.oldListenerMap$1.contains((Object)e.listenerName());
            }
            {
                this.oldListenerMap$1 = oldListenerMap$1;
            }
        });
        if (listenersAdded.nonEmpty() || listenersRemoved.nonEmpty()) {
            LoginManager.closeAll();
        }
        this.server.socketServer().removeListeners((Seq<EndPoint>)listenersRemoved);
        if (listenersAdded.nonEmpty()) {
            this.server.socketServer().addListeners((Seq<EndPoint>)listenersAdded);
        }
        this.server.kafkaController().updateBrokerInfo(this.server.createBrokerInfo());
    }

    private Map<ListenerName, EndPoint> listenersToMap(Seq<EndPoint> listeners2) {
        return ((TraversableOnce)listeners2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ListenerName, EndPoint> apply(EndPoint e) {
                return new Tuple2((Object)e.listenerName(), (Object)e);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public final Map kafka$server$DynamicListenerConfig$$immutableListenerConfigs$1(KafkaConfig kafkaConfig, String prefix, KafkaConfig newConfig$4) {
        return (Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(newConfig$4.originals()).asScala()).filter((Function1)new Serializable(this, prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$1;

            public final boolean apply(Tuple2<String, Object> x0$23) {
                Tuple2<String, Object> tuple2 = x0$23;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    boolean bl = key.startsWith(this.prefix$1) && !DynamicBrokerConfig$.MODULE$.DynamicSecurityConfigs().contains((Object)key);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.prefix$1 = prefix$1;
            }
        });
    }

    public DynamicListenerConfig(KafkaServer server) {
        this.server = server;
        Logging$class.$init$(this);
    }
}

