/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.List;
import java.util.Locale;
import kafka.api.ApiVersion$;
import kafka.cluster.EndPoint$;
import kafka.coordinator.group.OffsetConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ReplicationQuotaManagerConfig$;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.config.SslClientAuth;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.internals.BrokerSecurityConfigs;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;

public final class Defaults$ {
    public static final Defaults$ MODULE$;
    private final int ZkSessionTimeoutMs;
    private final int ZkSyncTimeMs;
    private final boolean ZkEnableSecureAcls;
    private final int ZkMaxInFlightRequests;
    private final boolean BrokerIdGenerationEnable;
    private final int MaxReservedBrokerId;
    private final int BrokerId;
    private final int MessageMaxBytes;
    private final int NumNetworkThreads;
    private final int NumIoThreads;
    private final int BackgroundThreads;
    private final int QueuedMaxRequests;
    private final int QueuedMaxRequestBytes;
    private final String AuthorizerClassName;
    private final int Port;
    private final String HostName;
    private final String ListenerSecurityProtocolMap;
    private final int SocketSendBufferBytes;
    private final int SocketReceiveBufferBytes;
    private final int SocketRequestMaxBytes;
    private final int MaxConnectionsPerIp;
    private final String MaxConnectionsPerIpOverrides;
    private final int MaxConnections;
    private final long ConnectionsMaxIdleMs;
    private final int RequestTimeoutMs;
    private final int FailedAuthenticationDelayMs;
    private final int NumPartitions;
    private final String LogDir;
    private final int LogSegmentBytes;
    private final int LogRollHours;
    private final int LogRollJitterHours;
    private final int LogRetentionHours;
    private final long LogRetentionBytes;
    private final long LogCleanupIntervalMs;
    private final String Delete;
    private final String Compact;
    private final String LogCleanupPolicy;
    private final int LogCleanerThreads;
    private final double LogCleanerIoMaxBytesPerSecond;
    private final long LogCleanerDedupeBufferSize;
    private final int LogCleanerIoBufferSize;
    private final double LogCleanerDedupeBufferLoadFactor;
    private final int LogCleanerBackoffMs;
    private final double LogCleanerMinCleanRatio;
    private final boolean LogCleanerEnable;
    private final long LogCleanerDeleteRetentionMs;
    private final long LogCleanerMinCompactionLagMs;
    private final long LogCleanerMaxCompactionLagMs;
    private final int LogIndexSizeMaxBytes;
    private final int LogIndexIntervalBytes;
    private final long LogFlushIntervalMessages;
    private final int LogDeleteDelayMs;
    private final long LogFlushSchedulerIntervalMs;
    private final int LogFlushOffsetCheckpointIntervalMs;
    private final int LogFlushStartOffsetCheckpointIntervalMs;
    private final boolean LogPreAllocateEnable;
    private String LogMessageFormatVersion;
    private final String LogMessageTimestampType;
    private final long LogMessageTimestampDifferenceMaxMs;
    private final int NumRecoveryThreadsPerDataDir;
    private final boolean AutoCreateTopicsEnable;
    private final int MinInSyncReplicas;
    private final boolean MessageDownConversionEnable;
    private final int ControllerSocketTimeoutMs;
    private final int ControllerMessageQueueSize;
    private final int DefaultReplicationFactor;
    private final long ReplicaLagTimeMaxMs;
    private final int ReplicaSocketTimeoutMs;
    private final int ReplicaSocketReceiveBufferBytes;
    private final int ReplicaFetchMaxBytes;
    private final int ReplicaFetchWaitMaxMs;
    private final int ReplicaFetchMinBytes;
    private final int ReplicaFetchResponseMaxBytes;
    private final int NumReplicaFetchers;
    private final int ReplicaFetchBackoffMs;
    private final long ReplicaHighWatermarkCheckpointIntervalMs;
    private final int FetchPurgatoryPurgeIntervalRequests;
    private final int ProducerPurgatoryPurgeIntervalRequests;
    private final int DeleteRecordsPurgatoryPurgeIntervalRequests;
    private final boolean AutoLeaderRebalanceEnable;
    private final int LeaderImbalancePerBrokerPercentage;
    private final int LeaderImbalanceCheckIntervalSeconds;
    private final boolean UncleanLeaderElectionEnable;
    private final String InterBrokerSecurityProtocol;
    private final String InterBrokerProtocolVersion;
    private final int ControlledShutdownMaxRetries;
    private final int ControlledShutdownRetryBackoffMs;
    private final boolean ControlledShutdownEnable;
    private final int GroupMinSessionTimeoutMs;
    private final int GroupMaxSessionTimeoutMs;
    private final int GroupInitialRebalanceDelayMs;
    private final int GroupMaxSize;
    private final int OffsetMetadataMaxSize;
    private final int OffsetsLoadBufferSize;
    private final short OffsetsTopicReplicationFactor;
    private final int OffsetsTopicPartitions;
    private final int OffsetsTopicSegmentBytes;
    private final int OffsetsTopicCompressionCodec;
    private final int OffsetsRetentionMinutes;
    private final long OffsetsRetentionCheckIntervalMs;
    private final int OffsetCommitTimeoutMs;
    private final short OffsetCommitRequiredAcks;
    private final int TransactionalIdExpirationMs;
    private final int TransactionsMaxTimeoutMs;
    private final int TransactionsTopicMinISR;
    private final int TransactionsLoadBufferSize;
    private final short TransactionsTopicReplicationFactor;
    private final int TransactionsTopicPartitions;
    private final int TransactionsTopicSegmentBytes;
    private final int TransactionsAbortTimedOutTransactionsCleanupIntervalMS;
    private final int TransactionsRemoveExpiredTransactionsCleanupIntervalMS;
    private final int MaxIncrementalFetchSessionCacheSlots;
    private final long ProducerQuotaBytesPerSecondDefault;
    private final long ConsumerQuotaBytesPerSecondDefault;
    private final int NumQuotaSamples;
    private final int QuotaWindowSizeSeconds;
    private final int NumReplicationQuotaSamples;
    private final int ReplicationQuotaWindowSizeSeconds;
    private final int NumAlterLogDirsReplicationQuotaSamples;
    private final int AlterLogDirsReplicationQuotaWindowSizeSeconds;
    private final int TransactionalIdExpirationMsDefault;
    private final boolean DeleteTopicEnable;
    private final String CompressionType;
    private final int MaxIdMapSnapshots;
    private final int MetricNumSamples;
    private final int MetricSampleWindowMs;
    private final String MetricReporterClasses;
    private final String MetricRecordingLevel;
    private final String KafkaMetricReporterClasses;
    private final int KafkaMetricsPollingIntervalSeconds;
    private final boolean ProducerMetricssEnable;
    private final int ProducerMetricsCacheMaxSize;
    private final int ProducerMetricsCacheEntryExpiryMs;
    private final String SslProtocol;
    private final String SslEnabledProtocols;
    private final String SslKeystoreType;
    private final String SslTruststoreType;
    private final String SslKeyManagerAlgorithm;
    private final String SslTrustManagerAlgorithm;
    private final String SslEndpointIdentificationAlgorithm;
    private final String SslClientAuthentication;
    private final String[] SslClientAuthenticationValidValues;
    private final String SslPrincipalMappingRules;
    private final long ConnectionsMaxReauthMsDefault;
    private final String SaslMechanismInterBrokerProtocol;
    private final List<String> SaslEnabledMechanisms;
    private final String SaslKerberosKinitCmd;
    private final double SaslKerberosTicketRenewWindowFactor;
    private final double SaslKerberosTicketRenewJitter;
    private final long SaslKerberosMinTimeBeforeRelogin;
    private final List<String> SaslKerberosPrincipalToLocalRules;
    private final double SaslLoginRefreshWindowFactor;
    private final double SaslLoginRefreshWindowJitter;
    private final short SaslLoginRefreshMinPeriodSeconds;
    private final short SaslLoginRefreshBufferSeconds;
    private final long DelegationTokenMaxLifeTimeMsDefault;
    private final long DelegationTokenExpiryTimeMsDefault;
    private final long DelegationTokenExpiryCheckIntervalMsDefault;
    private final String PasswordEncoderCipherAlgorithm;
    private final int PasswordEncoderKeyLength;
    private final int PasswordEncoderIterations;
    private volatile boolean bitmap$0;

    static {
        new Defaults$();
    }

    private String LogMessageFormatVersion$lzycompute() {
        Defaults$ defaults$ = this;
        synchronized (defaults$) {
            if (!this.bitmap$0) {
                this.LogMessageFormatVersion = this.InterBrokerProtocolVersion();
                this.bitmap$0 = true;
            }
            return this.LogMessageFormatVersion;
        }
    }

    public int ZkSessionTimeoutMs() {
        return this.ZkSessionTimeoutMs;
    }

    public int ZkSyncTimeMs() {
        return this.ZkSyncTimeMs;
    }

    public boolean ZkEnableSecureAcls() {
        return this.ZkEnableSecureAcls;
    }

    public int ZkMaxInFlightRequests() {
        return this.ZkMaxInFlightRequests;
    }

    public boolean BrokerIdGenerationEnable() {
        return this.BrokerIdGenerationEnable;
    }

    public int MaxReservedBrokerId() {
        return this.MaxReservedBrokerId;
    }

    public int BrokerId() {
        return this.BrokerId;
    }

    public int MessageMaxBytes() {
        return this.MessageMaxBytes;
    }

    public int NumNetworkThreads() {
        return this.NumNetworkThreads;
    }

    public int NumIoThreads() {
        return this.NumIoThreads;
    }

    public int BackgroundThreads() {
        return this.BackgroundThreads;
    }

    public int QueuedMaxRequests() {
        return this.QueuedMaxRequests;
    }

    public int QueuedMaxRequestBytes() {
        return this.QueuedMaxRequestBytes;
    }

    public String AuthorizerClassName() {
        return this.AuthorizerClassName;
    }

    public int Port() {
        return this.Port;
    }

    public String HostName() {
        return this.HostName;
    }

    public String ListenerSecurityProtocolMap() {
        return this.ListenerSecurityProtocolMap;
    }

    public int SocketSendBufferBytes() {
        return this.SocketSendBufferBytes;
    }

    public int SocketReceiveBufferBytes() {
        return this.SocketReceiveBufferBytes;
    }

    public int SocketRequestMaxBytes() {
        return this.SocketRequestMaxBytes;
    }

    public int MaxConnectionsPerIp() {
        return this.MaxConnectionsPerIp;
    }

    public String MaxConnectionsPerIpOverrides() {
        return this.MaxConnectionsPerIpOverrides;
    }

    public int MaxConnections() {
        return this.MaxConnections;
    }

    public long ConnectionsMaxIdleMs() {
        return this.ConnectionsMaxIdleMs;
    }

    public int RequestTimeoutMs() {
        return this.RequestTimeoutMs;
    }

    public int FailedAuthenticationDelayMs() {
        return this.FailedAuthenticationDelayMs;
    }

    public int NumPartitions() {
        return this.NumPartitions;
    }

    public String LogDir() {
        return this.LogDir;
    }

    public int LogSegmentBytes() {
        return this.LogSegmentBytes;
    }

    public int LogRollHours() {
        return this.LogRollHours;
    }

    public int LogRollJitterHours() {
        return this.LogRollJitterHours;
    }

    public int LogRetentionHours() {
        return this.LogRetentionHours;
    }

    public long LogRetentionBytes() {
        return this.LogRetentionBytes;
    }

    public long LogCleanupIntervalMs() {
        return this.LogCleanupIntervalMs;
    }

    public String Delete() {
        return this.Delete;
    }

    public String Compact() {
        return this.Compact;
    }

    public String LogCleanupPolicy() {
        return this.LogCleanupPolicy;
    }

    public int LogCleanerThreads() {
        return this.LogCleanerThreads;
    }

    public double LogCleanerIoMaxBytesPerSecond() {
        return this.LogCleanerIoMaxBytesPerSecond;
    }

    public long LogCleanerDedupeBufferSize() {
        return this.LogCleanerDedupeBufferSize;
    }

    public int LogCleanerIoBufferSize() {
        return this.LogCleanerIoBufferSize;
    }

    public double LogCleanerDedupeBufferLoadFactor() {
        return this.LogCleanerDedupeBufferLoadFactor;
    }

    public int LogCleanerBackoffMs() {
        return this.LogCleanerBackoffMs;
    }

    public double LogCleanerMinCleanRatio() {
        return this.LogCleanerMinCleanRatio;
    }

    public boolean LogCleanerEnable() {
        return this.LogCleanerEnable;
    }

    public long LogCleanerDeleteRetentionMs() {
        return this.LogCleanerDeleteRetentionMs;
    }

    public long LogCleanerMinCompactionLagMs() {
        return this.LogCleanerMinCompactionLagMs;
    }

    public long LogCleanerMaxCompactionLagMs() {
        return this.LogCleanerMaxCompactionLagMs;
    }

    public int LogIndexSizeMaxBytes() {
        return this.LogIndexSizeMaxBytes;
    }

    public int LogIndexIntervalBytes() {
        return this.LogIndexIntervalBytes;
    }

    public long LogFlushIntervalMessages() {
        return this.LogFlushIntervalMessages;
    }

    public int LogDeleteDelayMs() {
        return this.LogDeleteDelayMs;
    }

    public long LogFlushSchedulerIntervalMs() {
        return this.LogFlushSchedulerIntervalMs;
    }

    public int LogFlushOffsetCheckpointIntervalMs() {
        return this.LogFlushOffsetCheckpointIntervalMs;
    }

    public int LogFlushStartOffsetCheckpointIntervalMs() {
        return this.LogFlushStartOffsetCheckpointIntervalMs;
    }

    public boolean LogPreAllocateEnable() {
        return this.LogPreAllocateEnable;
    }

    public String LogMessageFormatVersion() {
        return this.bitmap$0 ? this.LogMessageFormatVersion : this.LogMessageFormatVersion$lzycompute();
    }

    public String LogMessageTimestampType() {
        return this.LogMessageTimestampType;
    }

    public long LogMessageTimestampDifferenceMaxMs() {
        return this.LogMessageTimestampDifferenceMaxMs;
    }

    public int NumRecoveryThreadsPerDataDir() {
        return this.NumRecoveryThreadsPerDataDir;
    }

    public boolean AutoCreateTopicsEnable() {
        return this.AutoCreateTopicsEnable;
    }

    public int MinInSyncReplicas() {
        return this.MinInSyncReplicas;
    }

    public boolean MessageDownConversionEnable() {
        return this.MessageDownConversionEnable;
    }

    public int ControllerSocketTimeoutMs() {
        return this.ControllerSocketTimeoutMs;
    }

    public int ControllerMessageQueueSize() {
        return this.ControllerMessageQueueSize;
    }

    public int DefaultReplicationFactor() {
        return this.DefaultReplicationFactor;
    }

    public long ReplicaLagTimeMaxMs() {
        return this.ReplicaLagTimeMaxMs;
    }

    public int ReplicaSocketTimeoutMs() {
        return this.ReplicaSocketTimeoutMs;
    }

    public int ReplicaSocketReceiveBufferBytes() {
        return this.ReplicaSocketReceiveBufferBytes;
    }

    public int ReplicaFetchMaxBytes() {
        return this.ReplicaFetchMaxBytes;
    }

    public int ReplicaFetchWaitMaxMs() {
        return this.ReplicaFetchWaitMaxMs;
    }

    public int ReplicaFetchMinBytes() {
        return this.ReplicaFetchMinBytes;
    }

    public int ReplicaFetchResponseMaxBytes() {
        return this.ReplicaFetchResponseMaxBytes;
    }

    public int NumReplicaFetchers() {
        return this.NumReplicaFetchers;
    }

    public int ReplicaFetchBackoffMs() {
        return this.ReplicaFetchBackoffMs;
    }

    public long ReplicaHighWatermarkCheckpointIntervalMs() {
        return this.ReplicaHighWatermarkCheckpointIntervalMs;
    }

    public int FetchPurgatoryPurgeIntervalRequests() {
        return this.FetchPurgatoryPurgeIntervalRequests;
    }

    public int ProducerPurgatoryPurgeIntervalRequests() {
        return this.ProducerPurgatoryPurgeIntervalRequests;
    }

    public int DeleteRecordsPurgatoryPurgeIntervalRequests() {
        return this.DeleteRecordsPurgatoryPurgeIntervalRequests;
    }

    public boolean AutoLeaderRebalanceEnable() {
        return this.AutoLeaderRebalanceEnable;
    }

    public int LeaderImbalancePerBrokerPercentage() {
        return this.LeaderImbalancePerBrokerPercentage;
    }

    public int LeaderImbalanceCheckIntervalSeconds() {
        return this.LeaderImbalanceCheckIntervalSeconds;
    }

    public boolean UncleanLeaderElectionEnable() {
        return this.UncleanLeaderElectionEnable;
    }

    public String InterBrokerSecurityProtocol() {
        return this.InterBrokerSecurityProtocol;
    }

    public String InterBrokerProtocolVersion() {
        return this.InterBrokerProtocolVersion;
    }

    public int ControlledShutdownMaxRetries() {
        return this.ControlledShutdownMaxRetries;
    }

    public int ControlledShutdownRetryBackoffMs() {
        return this.ControlledShutdownRetryBackoffMs;
    }

    public boolean ControlledShutdownEnable() {
        return this.ControlledShutdownEnable;
    }

    public int GroupMinSessionTimeoutMs() {
        return this.GroupMinSessionTimeoutMs;
    }

    public int GroupMaxSessionTimeoutMs() {
        return this.GroupMaxSessionTimeoutMs;
    }

    public int GroupInitialRebalanceDelayMs() {
        return this.GroupInitialRebalanceDelayMs;
    }

    public int GroupMaxSize() {
        return this.GroupMaxSize;
    }

    public int OffsetMetadataMaxSize() {
        return this.OffsetMetadataMaxSize;
    }

    public int OffsetsLoadBufferSize() {
        return this.OffsetsLoadBufferSize;
    }

    public short OffsetsTopicReplicationFactor() {
        return this.OffsetsTopicReplicationFactor;
    }

    public int OffsetsTopicPartitions() {
        return this.OffsetsTopicPartitions;
    }

    public int OffsetsTopicSegmentBytes() {
        return this.OffsetsTopicSegmentBytes;
    }

    public int OffsetsTopicCompressionCodec() {
        return this.OffsetsTopicCompressionCodec;
    }

    public int OffsetsRetentionMinutes() {
        return this.OffsetsRetentionMinutes;
    }

    public long OffsetsRetentionCheckIntervalMs() {
        return this.OffsetsRetentionCheckIntervalMs;
    }

    public int OffsetCommitTimeoutMs() {
        return this.OffsetCommitTimeoutMs;
    }

    public short OffsetCommitRequiredAcks() {
        return this.OffsetCommitRequiredAcks;
    }

    public int TransactionalIdExpirationMs() {
        return this.TransactionalIdExpirationMs;
    }

    public int TransactionsMaxTimeoutMs() {
        return this.TransactionsMaxTimeoutMs;
    }

    public int TransactionsTopicMinISR() {
        return this.TransactionsTopicMinISR;
    }

    public int TransactionsLoadBufferSize() {
        return this.TransactionsLoadBufferSize;
    }

    public short TransactionsTopicReplicationFactor() {
        return this.TransactionsTopicReplicationFactor;
    }

    public int TransactionsTopicPartitions() {
        return this.TransactionsTopicPartitions;
    }

    public int TransactionsTopicSegmentBytes() {
        return this.TransactionsTopicSegmentBytes;
    }

    public int TransactionsAbortTimedOutTransactionsCleanupIntervalMS() {
        return this.TransactionsAbortTimedOutTransactionsCleanupIntervalMS;
    }

    public int TransactionsRemoveExpiredTransactionsCleanupIntervalMS() {
        return this.TransactionsRemoveExpiredTransactionsCleanupIntervalMS;
    }

    public int MaxIncrementalFetchSessionCacheSlots() {
        return this.MaxIncrementalFetchSessionCacheSlots;
    }

    public long ProducerQuotaBytesPerSecondDefault() {
        return this.ProducerQuotaBytesPerSecondDefault;
    }

    public long ConsumerQuotaBytesPerSecondDefault() {
        return this.ConsumerQuotaBytesPerSecondDefault;
    }

    public int NumQuotaSamples() {
        return this.NumQuotaSamples;
    }

    public int QuotaWindowSizeSeconds() {
        return this.QuotaWindowSizeSeconds;
    }

    public int NumReplicationQuotaSamples() {
        return this.NumReplicationQuotaSamples;
    }

    public int ReplicationQuotaWindowSizeSeconds() {
        return this.ReplicationQuotaWindowSizeSeconds;
    }

    public int NumAlterLogDirsReplicationQuotaSamples() {
        return this.NumAlterLogDirsReplicationQuotaSamples;
    }

    public int AlterLogDirsReplicationQuotaWindowSizeSeconds() {
        return this.AlterLogDirsReplicationQuotaWindowSizeSeconds;
    }

    public int TransactionalIdExpirationMsDefault() {
        return this.TransactionalIdExpirationMsDefault;
    }

    public boolean DeleteTopicEnable() {
        return this.DeleteTopicEnable;
    }

    public String CompressionType() {
        return this.CompressionType;
    }

    public int MaxIdMapSnapshots() {
        return this.MaxIdMapSnapshots;
    }

    public int MetricNumSamples() {
        return this.MetricNumSamples;
    }

    public int MetricSampleWindowMs() {
        return this.MetricSampleWindowMs;
    }

    public String MetricReporterClasses() {
        return this.MetricReporterClasses;
    }

    public String MetricRecordingLevel() {
        return this.MetricRecordingLevel;
    }

    public String KafkaMetricReporterClasses() {
        return this.KafkaMetricReporterClasses;
    }

    public int KafkaMetricsPollingIntervalSeconds() {
        return this.KafkaMetricsPollingIntervalSeconds;
    }

    public boolean ProducerMetricssEnable() {
        return this.ProducerMetricssEnable;
    }

    public int ProducerMetricsCacheMaxSize() {
        return this.ProducerMetricsCacheMaxSize;
    }

    public int ProducerMetricsCacheEntryExpiryMs() {
        return this.ProducerMetricsCacheEntryExpiryMs;
    }

    public String SslProtocol() {
        return this.SslProtocol;
    }

    public String SslEnabledProtocols() {
        return this.SslEnabledProtocols;
    }

    public String SslKeystoreType() {
        return this.SslKeystoreType;
    }

    public String SslTruststoreType() {
        return this.SslTruststoreType;
    }

    public String SslKeyManagerAlgorithm() {
        return this.SslKeyManagerAlgorithm;
    }

    public String SslTrustManagerAlgorithm() {
        return this.SslTrustManagerAlgorithm;
    }

    public String SslEndpointIdentificationAlgorithm() {
        return this.SslEndpointIdentificationAlgorithm;
    }

    public String SslClientAuthentication() {
        return this.SslClientAuthentication;
    }

    public String[] SslClientAuthenticationValidValues() {
        return this.SslClientAuthenticationValidValues;
    }

    public String SslPrincipalMappingRules() {
        return this.SslPrincipalMappingRules;
    }

    public long ConnectionsMaxReauthMsDefault() {
        return this.ConnectionsMaxReauthMsDefault;
    }

    public String SaslMechanismInterBrokerProtocol() {
        return this.SaslMechanismInterBrokerProtocol;
    }

    public List<String> SaslEnabledMechanisms() {
        return this.SaslEnabledMechanisms;
    }

    public String SaslKerberosKinitCmd() {
        return this.SaslKerberosKinitCmd;
    }

    public double SaslKerberosTicketRenewWindowFactor() {
        return this.SaslKerberosTicketRenewWindowFactor;
    }

    public double SaslKerberosTicketRenewJitter() {
        return this.SaslKerberosTicketRenewJitter;
    }

    public long SaslKerberosMinTimeBeforeRelogin() {
        return this.SaslKerberosMinTimeBeforeRelogin;
    }

    public List<String> SaslKerberosPrincipalToLocalRules() {
        return this.SaslKerberosPrincipalToLocalRules;
    }

    public double SaslLoginRefreshWindowFactor() {
        return this.SaslLoginRefreshWindowFactor;
    }

    public double SaslLoginRefreshWindowJitter() {
        return this.SaslLoginRefreshWindowJitter;
    }

    public short SaslLoginRefreshMinPeriodSeconds() {
        return this.SaslLoginRefreshMinPeriodSeconds;
    }

    public short SaslLoginRefreshBufferSeconds() {
        return this.SaslLoginRefreshBufferSeconds;
    }

    public long DelegationTokenMaxLifeTimeMsDefault() {
        return this.DelegationTokenMaxLifeTimeMsDefault;
    }

    public long DelegationTokenExpiryTimeMsDefault() {
        return this.DelegationTokenExpiryTimeMsDefault;
    }

    public long DelegationTokenExpiryCheckIntervalMsDefault() {
        return this.DelegationTokenExpiryCheckIntervalMsDefault;
    }

    public String PasswordEncoderCipherAlgorithm() {
        return this.PasswordEncoderCipherAlgorithm;
    }

    public int PasswordEncoderKeyLength() {
        return this.PasswordEncoderKeyLength;
    }

    public int PasswordEncoderIterations() {
        return this.PasswordEncoderIterations;
    }

    private Defaults$() {
        MODULE$ = this;
        this.ZkSessionTimeoutMs = 6000;
        this.ZkSyncTimeMs = 2000;
        this.ZkEnableSecureAcls = false;
        this.ZkMaxInFlightRequests = 10;
        this.BrokerIdGenerationEnable = true;
        this.MaxReservedBrokerId = 1000;
        this.BrokerId = -1;
        this.MessageMaxBytes = 1000012;
        this.NumNetworkThreads = 3;
        this.NumIoThreads = 8;
        this.BackgroundThreads = 10;
        this.QueuedMaxRequests = 500;
        this.QueuedMaxRequestBytes = -1;
        this.AuthorizerClassName = "";
        this.Port = 9092;
        this.HostName = new String("");
        this.ListenerSecurityProtocolMap = ((TraversableOnce)EndPoint$.MODULE$.DefaultSecurityProtocolMap().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<ListenerName, SecurityProtocol> x0$3) {
                Tuple2<ListenerName, SecurityProtocol> tuple2 = x0$3;
                if (tuple2 != null) {
                    ListenerName listenerName = (ListenerName)tuple2._1();
                    SecurityProtocol securityProtocol2 = (SecurityProtocol)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenerName.value(), securityProtocol2.name}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
        this.SocketSendBufferBytes = 102400;
        this.SocketReceiveBufferBytes = 102400;
        this.SocketRequestMaxBytes = 0x6400000;
        this.MaxConnectionsPerIp = Integer.MAX_VALUE;
        this.MaxConnectionsPerIpOverrides = "";
        this.MaxConnections = Integer.MAX_VALUE;
        this.ConnectionsMaxIdleMs = 600000L;
        this.RequestTimeoutMs = 30000;
        this.FailedAuthenticationDelayMs = 100;
        this.NumPartitions = 1;
        this.LogDir = "/tmp/kafka-logs";
        this.LogSegmentBytes = 0x40000000;
        this.LogRollHours = 168;
        this.LogRollJitterHours = 0;
        this.LogRetentionHours = 168;
        this.LogRetentionBytes = -1L;
        this.LogCleanupIntervalMs = 300000L;
        this.Delete = "delete";
        this.Compact = "compact";
        this.LogCleanupPolicy = this.Delete();
        this.LogCleanerThreads = 1;
        this.LogCleanerIoMaxBytesPerSecond = Double.MAX_VALUE;
        this.LogCleanerDedupeBufferSize = 0x8000000L;
        this.LogCleanerIoBufferSize = 524288;
        this.LogCleanerDedupeBufferLoadFactor = 0.9;
        this.LogCleanerBackoffMs = 15000;
        this.LogCleanerMinCleanRatio = 0.5;
        this.LogCleanerEnable = true;
        this.LogCleanerDeleteRetentionMs = 86400000L;
        this.LogCleanerMinCompactionLagMs = 0L;
        this.LogCleanerMaxCompactionLagMs = Long.MAX_VALUE;
        this.LogIndexSizeMaxBytes = 0xA00000;
        this.LogIndexIntervalBytes = 4096;
        this.LogFlushIntervalMessages = Long.MAX_VALUE;
        this.LogDeleteDelayMs = 60000;
        this.LogFlushSchedulerIntervalMs = Long.MAX_VALUE;
        this.LogFlushOffsetCheckpointIntervalMs = 60000;
        this.LogFlushStartOffsetCheckpointIntervalMs = 60000;
        this.LogPreAllocateEnable = false;
        this.LogMessageTimestampType = "CreateTime";
        this.LogMessageTimestampDifferenceMaxMs = Long.MAX_VALUE;
        this.NumRecoveryThreadsPerDataDir = 1;
        this.AutoCreateTopicsEnable = true;
        this.MinInSyncReplicas = 1;
        this.MessageDownConversionEnable = true;
        this.ControllerSocketTimeoutMs = this.RequestTimeoutMs();
        this.ControllerMessageQueueSize = Integer.MAX_VALUE;
        this.DefaultReplicationFactor = 1;
        this.ReplicaLagTimeMaxMs = 10000L;
        this.ReplicaSocketTimeoutMs = 30000;
        this.ReplicaSocketReceiveBufferBytes = 65536;
        this.ReplicaFetchMaxBytes = 0x100000;
        this.ReplicaFetchWaitMaxMs = 500;
        this.ReplicaFetchMinBytes = 1;
        this.ReplicaFetchResponseMaxBytes = 0xA00000;
        this.NumReplicaFetchers = 1;
        this.ReplicaFetchBackoffMs = 1000;
        this.ReplicaHighWatermarkCheckpointIntervalMs = 5000L;
        this.FetchPurgatoryPurgeIntervalRequests = 1000;
        this.ProducerPurgatoryPurgeIntervalRequests = 1000;
        this.DeleteRecordsPurgatoryPurgeIntervalRequests = 1;
        this.AutoLeaderRebalanceEnable = true;
        this.LeaderImbalancePerBrokerPercentage = 10;
        this.LeaderImbalanceCheckIntervalSeconds = 300;
        this.UncleanLeaderElectionEnable = false;
        this.InterBrokerSecurityProtocol = SecurityProtocol.PLAINTEXT.toString();
        this.InterBrokerProtocolVersion = ApiVersion$.MODULE$.latestVersion().toString();
        this.ControlledShutdownMaxRetries = 3;
        this.ControlledShutdownRetryBackoffMs = 5000;
        this.ControlledShutdownEnable = true;
        this.GroupMinSessionTimeoutMs = 6000;
        this.GroupMaxSessionTimeoutMs = 1800000;
        this.GroupInitialRebalanceDelayMs = 3000;
        this.GroupMaxSize = Integer.MAX_VALUE;
        this.OffsetMetadataMaxSize = OffsetConfig$.MODULE$.DefaultMaxMetadataSize();
        this.OffsetsLoadBufferSize = OffsetConfig$.MODULE$.DefaultLoadBufferSize();
        this.OffsetsTopicReplicationFactor = OffsetConfig$.MODULE$.DefaultOffsetsTopicReplicationFactor();
        this.OffsetsTopicPartitions = OffsetConfig$.MODULE$.DefaultOffsetsTopicNumPartitions();
        this.OffsetsTopicSegmentBytes = OffsetConfig$.MODULE$.DefaultOffsetsTopicSegmentBytes();
        this.OffsetsTopicCompressionCodec = OffsetConfig$.MODULE$.DefaultOffsetsTopicCompressionCodec().codec();
        this.OffsetsRetentionMinutes = 10080;
        this.OffsetsRetentionCheckIntervalMs = OffsetConfig$.MODULE$.DefaultOffsetsRetentionCheckIntervalMs();
        this.OffsetCommitTimeoutMs = OffsetConfig$.MODULE$.DefaultOffsetCommitTimeoutMs();
        this.OffsetCommitRequiredAcks = OffsetConfig$.MODULE$.DefaultOffsetCommitRequiredAcks();
        this.TransactionalIdExpirationMs = TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs();
        this.TransactionsMaxTimeoutMs = TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs();
        this.TransactionsTopicMinISR = TransactionLog$.MODULE$.DefaultMinInSyncReplicas();
        this.TransactionsLoadBufferSize = TransactionLog$.MODULE$.DefaultLoadBufferSize();
        this.TransactionsTopicReplicationFactor = TransactionLog$.MODULE$.DefaultReplicationFactor();
        this.TransactionsTopicPartitions = TransactionLog$.MODULE$.DefaultNumPartitions();
        this.TransactionsTopicSegmentBytes = TransactionLog$.MODULE$.DefaultSegmentBytes();
        this.TransactionsAbortTimedOutTransactionsCleanupIntervalMS = TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs();
        this.TransactionsRemoveExpiredTransactionsCleanupIntervalMS = TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs();
        this.MaxIncrementalFetchSessionCacheSlots = 1000;
        this.ProducerQuotaBytesPerSecondDefault = ClientQuotaManagerConfig$.MODULE$.QuotaBytesPerSecondDefault();
        this.ConsumerQuotaBytesPerSecondDefault = ClientQuotaManagerConfig$.MODULE$.QuotaBytesPerSecondDefault();
        this.NumQuotaSamples = ClientQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        this.QuotaWindowSizeSeconds = ClientQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        this.NumReplicationQuotaSamples = ReplicationQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        this.ReplicationQuotaWindowSizeSeconds = ReplicationQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        this.NumAlterLogDirsReplicationQuotaSamples = ReplicationQuotaManagerConfig$.MODULE$.DefaultNumQuotaSamples();
        this.AlterLogDirsReplicationQuotaWindowSizeSeconds = ReplicationQuotaManagerConfig$.MODULE$.DefaultQuotaWindowSizeSeconds();
        this.TransactionalIdExpirationMsDefault = 604800000;
        this.DeleteTopicEnable = true;
        this.CompressionType = "producer";
        this.MaxIdMapSnapshots = 2;
        this.MetricNumSamples = 2;
        this.MetricSampleWindowMs = 30000;
        this.MetricReporterClasses = "";
        this.MetricRecordingLevel = Sensor.RecordingLevel.INFO.toString();
        this.KafkaMetricReporterClasses = "";
        this.KafkaMetricsPollingIntervalSeconds = 10;
        this.ProducerMetricssEnable = false;
        this.ProducerMetricsCacheMaxSize = 1000;
        this.ProducerMetricsCacheEntryExpiryMs = 300000;
        this.SslProtocol = "TLS";
        this.SslEnabledProtocols = "TLSv1.2,TLSv1.1,TLSv1";
        this.SslKeystoreType = "JKS";
        this.SslTruststoreType = "JKS";
        this.SslKeyManagerAlgorithm = SslConfigs.DEFAULT_SSL_KEYMANGER_ALGORITHM;
        this.SslTrustManagerAlgorithm = SslConfigs.DEFAULT_SSL_TRUSTMANAGER_ALGORITHM;
        this.SslEndpointIdentificationAlgorithm = "https";
        this.SslClientAuthentication = SslClientAuth.NONE.name().toLowerCase(Locale.ROOT);
        this.SslClientAuthenticationValidValues = (String[])((List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(SslClientAuth.VALUES).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(SslClientAuth v) {
                return v.toString().toLowerCase(Locale.ROOT);
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava()).toArray((Object[])new String[0]);
        this.SslPrincipalMappingRules = "DEFAULT";
        this.ConnectionsMaxReauthMsDefault = 0L;
        this.SaslMechanismInterBrokerProtocol = "GSSAPI";
        this.SaslEnabledMechanisms = SaslConfigs.DEFAULT_SASL_ENABLED_MECHANISMS;
        this.SaslKerberosKinitCmd = "/usr/bin/kinit";
        this.SaslKerberosTicketRenewWindowFactor = 0.8;
        this.SaslKerberosTicketRenewJitter = 0.05;
        this.SaslKerberosMinTimeBeforeRelogin = 60000L;
        this.SaslKerberosPrincipalToLocalRules = BrokerSecurityConfigs.DEFAULT_SASL_KERBEROS_PRINCIPAL_TO_LOCAL_RULES;
        this.SaslLoginRefreshWindowFactor = 0.8;
        this.SaslLoginRefreshWindowJitter = 0.05;
        this.SaslLoginRefreshMinPeriodSeconds = (short)60;
        this.SaslLoginRefreshBufferSeconds = (short)300;
        this.DelegationTokenMaxLifeTimeMsDefault = 604800000L;
        this.DelegationTokenExpiryTimeMsDefault = 86400000L;
        this.DelegationTokenExpiryCheckIntervalMsDefault = 3600000L;
        this.PasswordEncoderCipherAlgorithm = "AES/CBC/PKCS5Padding";
        this.PasswordEncoderKeyLength = 128;
        this.PasswordEncoderIterations = 4096;
    }
}

