/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u000511m\u001c8gS\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0003\u0002\rM,'O^3s\u0013\tY\u0002DA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0005\u0002 A5\t!!\u0003\u0002\"\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\n1C]3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016\u0004\"aH\u0013\n\u0005\u0019\u0012!a\u0005*fa2L7-Y*uCR,W*Y2iS:,\u0007\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002+A\f'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oKB\u0011qDK\u0005\u0003W\t\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\r\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003\u0019\u0019G.[3oiB\u0011qdL\u0005\u0003a\t\u0011a\u0002R3mKRLwN\\\"mS\u0016tG\u000fC\u00033\u0001\u0011\u00051'\u0001\u0004=S:LGO\u0010\u000b\u0007iU2t\u0007O\u001d\u0011\u0005}\u0001\u0001\"B\u000b2\u0001\u00041\u0002\"B\u000f2\u0001\u0004q\u0002\"B\u00122\u0001\u0004!\u0003\"\u0002\u00152\u0001\u0004I\u0003\"B\u00172\u0001\u0004q\u0003bB\u001e\u0001\u0005\u0004%\t\u0001P\u0001\u0015SN$U\r\\3uKR{\u0007/[2F]\u0006\u0014G.\u001a3\u0016\u0003u\u0002\"!\u0003 \n\u0005}R!a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001f\u0002+%\u001cH)\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3eA!)1\t\u0001C\u0001\t\u0006!\u0011N\\5u)\r)\u0005j\u0016\t\u0003\u0013\u0019K!a\u0012\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0013\n\u0003\rAS\u0001\u0019S:LG/[1m)>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007cA&O!6\tAJ\u0003\u0002N\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005=c%aA*fiB\u0011\u0011\u000b\u0016\b\u0003\u0013IK!a\u0015\u0006\u0002\rA\u0013X\rZ3g\u0013\t)fK\u0001\u0004TiJLgn\u001a\u0006\u0003'*AQ\u0001\u0017\"A\u0002)\u000b!%\u001b8ji&\fG\u000eV8qS\u000e\u001c\u0018J\\3mS\u001eL'\r\\3G_J$U\r\\3uS>t\u0007\"\u0002.\u0001\t\u0003Y\u0016\u0001\u0005;ssR{\u0007/[2EK2,G/[8o)\u0005)\u0005\"B/\u0001\t\u0003q\u0016\u0001G3ocV,W/\u001a+pa&\u001c7OR8s\t\u0016dW\r^5p]R\u0011Qi\u0018\u0005\u0006Ar\u0003\rAS\u0001\u0007i>\u0004\u0018nY:\t\u000b\t\u0004A\u0011A2\u0002/I,7/^7f\t\u0016dW\r^5p]\u001a{'\u000fV8qS\u000e\u001cHCA#e\u0011\u001d\u0001\u0017\r%AA\u0002)CQA\u001a\u0001\u0005\u0002\u001d\f1CZ1jYJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:$\"!\u00125\t\u000b%,\u0007\u0019\u00016\u0002\u0011I,\u0007\u000f\\5dCN\u00042a\u0013(l!\tyB.\u0003\u0002n\u0005\t\u0019\u0002+\u0019:uSRLwN\\!oIJ+\u0007\u000f\\5dC\")q\u000e\u0001C\u0001a\u0006qR.\u0019:l)>\u0004\u0018nY%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u000b\u0004\u000bF\u0014\b\"\u00021o\u0001\u0004Q\u0005BB:o\t\u0003\u0007A/\u0001\u0004sK\u0006\u001cxN\u001c\t\u0004\u0013U\u0004\u0016B\u0001<\u000b\u0005!a$-\u001f8b[\u0016t\u0004\"\u0002=\u0001\t\u0013I\u0018\u0001H5t)>\u0004\u0018nY%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u000b\u0003{iDQa_<A\u0002A\u000bQ\u0001^8qS\u000eDQ! \u0001\u0005\ny\f\u0011$[:U_BL7\rR3mKRLwN\\%o!J|wM]3tgR\u0011Qh \u0005\u0006wr\u0004\r\u0001\u0015\u0005\b\u0003\u0007\u0001A\u0011AA\u0003\u0003iI7\u000fV8qS\u000e\fV/Z;fIV\u0003hi\u001c:EK2,G/[8o)\ri\u0014q\u0001\u0005\u0007w\u0006\u0005\u0001\u0019\u0001)\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u000592m\\7qY\u0016$XMU3qY&\u001c\u0017\rR3mKRLwN\u001c\u000b\u0004\u000b\u0006=\u0001BB5\u0002\n\u0001\u0007!\u000eC\u0004\u0002\u0014\u0001!I!!\u0006\u00025%\u001cHk\u001c9jG\u0016c\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007u\n9\u0002\u0003\u0004|\u0003#\u0001\r\u0001\u0015\u0005\b\u00037\u0001A\u0011BA\u000f\u0003\t\u0012X\r\u001e:z\t\u0016dW\r^5p]\u001a{'/\u00138fY&<\u0017N\u00197f%\u0016\u0004H.[2bgR\u0019Q)a\b\t\rm\fI\u00021\u0001Q\u0011\u001d\t\u0019\u0003\u0001C\u0005\u0003K\t1cY8na2,G/\u001a#fY\u0016$X\rV8qS\u000e$2!RA\u0014\u0011\u0019Y\u0018\u0011\u0005a\u0001!\"9\u00111\u0006\u0001\u0005\n\u00055\u0012aD8o)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8\u0015\u0007\u0015\u000by\u0003\u0003\u0004a\u0003S\u0001\rA\u0013\u0005\b\u0003g\u0001A\u0011BA\u001b\u0003Q\u0019H/\u0019:u%\u0016\u0004H.[2b\t\u0016dW\r^5p]R\u0019Q)a\u000e\t\u000f\u0005e\u0012\u0011\u0007a\u0001U\u0006a\"/\u001a9mS\u000e\f7OR8s)>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007bBA\u001f\u0001\u0011%\u0011qH\u0001\u0014_:\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0004\u000b\u0006\u0005\u0003\u0002CA\"\u0003w\u0001\r!!\u0012\u0002+A\f'\u000f^5uS>t7\u000fV8CK\u0012+G.\u001a;fIB!1JTA$!\u0011\tI%!\u0017\u000e\u0005\u0005-#\u0002BA'\u0003\u001f\naaY8n[>t'bA\u0003\u0002R)!\u00111KA+\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qK\u0001\u0004_J<\u0017\u0002BA.\u0003\u0017\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0004\u0002`\u0001!IaW\u0001\u0010e\u0016\u001cX/\\3EK2,G/[8og\"I\u00111\r\u0001\u0012\u0002\u0013\u0005\u0011QM\u0001\"e\u0016\u001cX/\\3EK2,G/[8o\r>\u0014Hk\u001c9jGN$C-\u001a4bk2$H%M\u000b\u0003\u0003OR3ASA5W\t\tY\u0007\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\u0013Ut7\r[3dW\u0016$'bAA;\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0014q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TopicDeletionManager
implements Logging {
    public final ControllerContext kafka$controller$TopicDeletionManager$$controllerContext;
    public final ReplicaStateMachine kafka$controller$TopicDeletionManager$$replicaStateMachine;
    private final PartitionStateMachine partitionStateMachine;
    private final DeletionClient client;
    private final boolean isDeleteTopicEnabled;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.info((Function0<String>)new Serializable(this, initialTopicsToBeDeleted, initialTopicsIneligibleForDeletion){
            public static final long serialVersionUID = 0L;
            private final Set initialTopicsToBeDeleted$1;
            private final Set initialTopicsIneligibleForDeletion$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing manager with initial deletions: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.initialTopicsToBeDeleted$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"initial ineligible deletions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.initialTopicsIneligibleForDeletion$1}))).toString();
            }
            {
                this.initialTopicsToBeDeleted$1 = initialTopicsToBeDeleted$1;
                this.initialTopicsIneligibleForDeletion$1 = initialTopicsIneligibleForDeletion$1;
            }
        });
        if (this.isDeleteTopicEnabled()) {
            this.kafka$controller$TopicDeletionManager$$controllerContext.queueTopicDeletion(initialTopicsToBeDeleted);
            this.kafka$controller$TopicDeletionManager$$controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.kafka$controller$TopicDeletionManager$$controllerContext.topicsToBeDeleted()));
        } else {
            this.info((Function0<String>)new Serializable(this, initialTopicsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Set initialTopicsToBeDeleted$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " since delete topic is disabled"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.initialTopicsToBeDeleted$1}));
                }
                {
                    this.initialTopicsToBeDeleted$1 = initialTopicsToBeDeleted$1;
                }
            });
            this.client.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq(), this.kafka$controller$TopicDeletionManager$$controllerContext.epochZkVersion());
        }
    }

    public void tryTopicDeletion() {
        if (this.isDeleteTopicEnabled()) {
            this.resumeDeletions();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            this.kafka$controller$TopicDeletionManager$$controllerContext.queueTopicDeletion(topics);
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (this.isDeleteTopicEnabled() && (topicsToResumeDeletion = (Set)topics.$amp(this.kafka$controller$TopicDeletionManager$$controllerContext.topicsToBeDeleted())).nonEmpty()) {
            this.kafka$controller$TopicDeletionManager$$controllerContext.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (this.isDeleteTopicEnabled() && (replicasThatFailedToDelete = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).nonEmpty()) {
            Set topics = (Set)replicasThatFailedToDelete.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionAndReplica x$1) {
                    return x$1.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(this, replicasThatFailedToDelete, topics){
                public static final long serialVersionUID = 0L;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion failed for replicas ", ". Halting deletion for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = replicasThatFailedToDelete$1;
                    this.topics$1 = topics$1;
                }
            });
            this.kafka$controller$TopicDeletionManager$$replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$);
            this.markTopicIneligibleForDeletion((Set<String>)topics, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "replica deletion failure";
                }
            });
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics, Function0<String> reason) {
        if (this.isDeleteTopicEnabled()) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.kafka$controller$TopicDeletionManager$$controllerContext.topicsToBeDeleted().$amp(topics);
            this.kafka$controller$TopicDeletionManager$$controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)new Serializable(this, reason, newTopicsToHaltDeletion){
                    public static final long serialVersionUID = 0L;
                    private final Function0 reason$1;
                    private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Halted deletion of topics ", " due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopicsToHaltDeletion$1.mkString(","), this.reason$1.apply()}));
                    }
                    {
                        this.reason$1 = reason$1;
                        this.newTopicsToHaltDeletion$1 = newTopicsToHaltDeletion$1;
                    }
                });
            }
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.kafka$controller$TopicDeletionManager$$controllerContext.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return this.isDeleteTopicEnabled() ? this.kafka$controller$TopicDeletionManager$$controllerContext.isAnyReplicaInState(topic, ReplicaDeletionStarted$.MODULE$) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.kafka$controller$TopicDeletionManager$$controllerContext.isTopicQueuedUpForDeletion(topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this, successfullyDeletedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set successfullyDeletedReplicas$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion successfully completed for replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = successfullyDeletedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$);
        this.resumeDeletions();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.kafka$controller$TopicDeletionManager$$controllerContext.isTopicQueuedUpForDeletion(topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$retryDeletionForIneligibleReplicas(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controllerContext.replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)new Serializable(this, topic, failedReplicas){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Set failedReplicas$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying deletion of topic ", " since replicas ", " were not successfully deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.failedReplicas$1.mkString(",")}));
            }
            {
                this.topic$1 = topic$1;
                this.failedReplicas$1 = failedReplicas$1;
            }
        });
        this.kafka$controller$TopicDeletionManager$$replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$);
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.client.mutePartitionModifications(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.kafka$controller$TopicDeletionManager$$replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$);
        this.kafka$controller$TopicDeletionManager$$controllerContext.topicsToBeDeleted().$minus$eq((Object)topic);
        this.kafka$controller$TopicDeletionManager$$controllerContext.topicsWithDeletionStarted().$minus$eq((Object)topic);
        this.client.deleteTopic(topic, this.kafka$controller$TopicDeletionManager$$controllerContext.epochZkVersion());
        this.kafka$controller$TopicDeletionManager$$controllerContext.removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)new Serializable(this, topics){
            public static final long serialVersionUID = 0L;
            private final Set topics$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic deletion callback for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = topics$2;
            }
        });
        Set partitions = (Set)topics.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicPartition> apply(String topic) {
                return this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        Set unseenTopicsForDeletion = (Set)topics.$minus$minus(this.kafka$controller$TopicDeletionManager$$controllerContext.topicsWithDeletionStarted());
        if (unseenTopicsForDeletion.nonEmpty()) {
            Set unseenPartitionsForDeletion = (Set)unseenTopicsForDeletion.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicPartition> apply(String topic) {
                    return this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom());
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), OfflinePartition$.MODULE$);
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), NonExistentPartition$.MODULE$);
            this.kafka$controller$TopicDeletionManager$$controllerContext.beginTopicDeletion((Set<String>)unseenTopicsForDeletion);
        }
        this.client.sendMetadataUpdate((Set<TopicPartition>)partitions);
        topics.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion(this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.partitionsForTopic(topic));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(PartitionAndReplica x$2) {
                return x$2.topic();
            }
        }).keys().foreach((Function1)new Serializable(this, replicasForTopicsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            public final void apply(String topic) {
                Set aliveReplicasForTopic = (Set)this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.allLiveReplicas().filter((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$2;

                    public final boolean apply(PartitionAndReplica p) {
                        String string = p.topic();
                        String string2 = this.topic$2;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.topic$2 = topic$2;
                    }
                });
                Set deadReplicasForTopic = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus((GenTraversableOnce)aliveReplicasForTopic);
                Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
                Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                this.$outer.kafka$controller$TopicDeletionManager$$replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)deadReplicasForTopic.toSeq(), ReplicaDeletionIneligible$.MODULE$);
                this.$outer.kafka$controller$TopicDeletionManager$$replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), OfflineReplica$.MODULE$);
                this.$outer.debug((Function0<String>)new Serializable(this, replicasForDeletionRetry){
                    public static final long serialVersionUID = 0L;
                    private final Set replicasForDeletionRetry$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion started for replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                    }
                    {
                        this.replicasForDeletionRetry$1 = replicasForDeletionRetry$1;
                    }
                });
                this.$outer.kafka$controller$TopicDeletionManager$$replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletionRetry.toSeq(), ReplicaDeletionStarted$.MODULE$);
                if (deadReplicasForTopic.nonEmpty()) {
                    this.$outer.debug((Function0<String>)new Serializable(this, deadReplicasForTopic, topic){
                        public static final long serialVersionUID = 0L;
                        private final Set deadReplicasForTopic$1;
                        private final String topic$2;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dead Replicas (", ") found for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deadReplicasForTopic$1.mkString(","), this.topic$2}));
                        }
                        {
                            this.deadReplicasForTopic$1 = deadReplicasForTopic$1;
                            this.topic$2 = topic$2;
                        }
                    });
                    this.$outer.markTopicIneligibleForDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "offline replicas";
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = replicasForTopicsToBeDeleted$1;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)new Serializable(this, partitionsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final Set partitionsToBeDeleted$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition deletion callback for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = partitionsToBeDeleted$1;
            }
        });
        Set<PartitionAndReplica> replicasPerPartition = this.kafka$controller$TopicDeletionManager$$controllerContext.replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.kafka$controller$TopicDeletionManager$$controllerContext.topicsToBeDeleted());
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)new Serializable(this, topicsQueuedForDeletion){
                public static final long serialVersionUID = 0L;
                private final Set topicsQueuedForDeletion$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Handling deletion for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicsQueuedForDeletion$1.mkString(",")}));
                }
                {
                    this.topicsQueuedForDeletion$1 = topicsQueuedForDeletion$1;
                }
            });
        }
        topicsQueuedForDeletion.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply(String topic) {
                if (this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.areAllReplicasInState(topic, ReplicaDeletionSuccessful$.MODULE$)) {
                    this.$outer.kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of topic ", " successfully completed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3}));
                        }
                        {
                            this.topic$3 = topic$3;
                        }
                    });
                } else if (!this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.isAnyReplicaInState(topic, ReplicaDeletionStarted$.MODULE$) && this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                    this.$outer.kafka$controller$TopicDeletionManager$$retryDeletionForIneligibleReplicas(topic);
                }
                if (this.$outer.kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of topic ", " (re)started"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$3}));
                        }
                        {
                            this.topic$3 = topic$3;
                        }
                    });
                    this.$outer.kafka$controller$TopicDeletionManager$$onTopicDeletion((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public TopicDeletionManager(KafkaConfig config, ControllerContext controllerContext, ReplicaStateMachine replicaStateMachine, PartitionStateMachine partitionStateMachine, DeletionClient client) {
        this.kafka$controller$TopicDeletionManager$$controllerContext = controllerContext;
        this.kafka$controller$TopicDeletionManager$$replicaStateMachine = replicaStateMachine;
        this.partitionStateMachine = partitionStateMachine;
        this.client = client;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Topic Deletion Manager ", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.brokerId())})));
        this.isDeleteTopicEnabled = Predef$.MODULE$.Boolean2boolean(config.deleteTopicEnable());
    }
}

