/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import joptsimple.AbstractOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.LeaderElectionCommandOptions;
import kafka.common.AdminCommandFailedException;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LeaderElectionCommand$
implements Logging {
    public static final LeaderElectionCommand$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LeaderElectionCommand$();
    }

    private Logger logger$lzycompute() {
        LeaderElectionCommand$ leaderElectionCommand$ = this;
        synchronized (leaderElectionCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        this.run(args, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(30)).second());
    }

    /*
     * Unable to fully structure code
     */
    public void run(String[] args, Duration timeout) {
        commandOptions = new LeaderElectionCommandOptions(args);
        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(commandOptions, "This tool attempts to elect a new leader for a set of topic partitions. The type of elections supported are preferred replicas and unclean replicas.");
        this.validate(commandOptions);
        electionType = (ElectionType)commandOptions.options().valueOf(commandOptions.electionType());
        jsonFileTopicPartitions = Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.pathToJsonFile())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<TopicPartition> apply(String path) {
                return LeaderElectionCommand$.MODULE$.kafka$admin$LeaderElectionCommand$$parseReplicaElectionData(Utils.readFileAsString((String)path));
            }
        });
        var7_6 = new Tuple2((Object)Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.topic())), (Object)Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.partition())));
        if (var7_6 == null) ** GOTO lbl-1000
        var8_7 = (Option)var7_6._1();
        var9_8 = (Option)var7_6._2();
        if (!(var8_7 instanceof Some)) ** GOTO lbl-1000
        var10_9 = (Some)var8_7;
        topic = (String)var10_9.x();
        if (var9_8 instanceof Some) {
            var12_11 = (Some)var9_8;
            partition = (Integer)var12_11.x();
            var14_13 = new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition(topic, Predef$.MODULE$.Integer2int(partition))})));
        } else lbl-1000:
        // 3 sources

        {
            var14_13 = None$.MODULE$;
        }
        singleTopicPartition = var14_13;
        topicPartitions = jsonFileTopicPartitions.orElse((Function0)new Serializable((Option)singleTopicPartition){
            public static final long serialVersionUID = 0L;
            private final Option singleTopicPartition$1;

            public final Option<scala.collection.immutable.Set<TopicPartition>> apply() {
                return this.singleTopicPartition$1;
            }
            {
                this.singleTopicPartition$1 = singleTopicPartition$1;
            }
        });
        props = (Properties)Option$.MODULE$.apply(commandOptions.options().valueOf(commandOptions.adminClientConfig())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Properties apply(String config) {
                return Utils.loadProps((String)config);
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Properties apply() {
                return new Properties();
            }
        });
        props.setProperty("bootstrap.servers", (String)commandOptions.options().valueOf(commandOptions.bootstrapServer()));
        props.setProperty("request.timeout.ms", BoxesRunTime.boxToLong((long)timeout.toMillis()).toString());
        adminClient = AdminClient.create((Properties)props);
        try {
            this.electLeaders((Admin)adminClient, electionType, (Option<scala.collection.immutable.Set<TopicPartition>>)topicPartitions);
        }
        catch (Throwable var18_18) {
            var16_17.close();
            throw var18_18;
        }
        adminClient.close();
    }

    public scala.collection.immutable.Set<TopicPartition> kafka$admin$LeaderElectionCommand$$parseReplicaElectionData(String jsonString) {
        Option<JsonValue> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Some some = (Some)option;
            JsonValue js = (JsonValue)some.x();
            Option<JsonValue> option2 = js.asJsonObject().get("partitions");
            if (option2 instanceof Some) {
                scala.collection.immutable.Set set;
                Some some2 = (Some)option2;
                JsonValue partitionsList = (JsonValue)some2.x();
                Iterator partitionsRaw = partitionsList.asJsonArray().iterator().map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final JsonObject apply(JsonValue x$1) {
                        return x$1.asJsonObject();
                    }
                });
                Buffer partitions = partitionsRaw.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final TopicPartition apply(JsonObject p) {
                        String topic = p.apply("topic").to(DecodeJson$DecodeString$.MODULE$);
                        int partition = BoxesRunTime.unboxToInt((Object)p.apply("partition").to(DecodeJson$DecodeInt$.MODULE$));
                        return new TopicPartition(topic, partition);
                    }
                }).toBuffer();
                Iterable duplicatePartitions = CoreUtils$.MODULE$.duplicates(partitions);
                if (duplicatePartitions.nonEmpty()) {
                    throw new AdminOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica election data contains duplicate partitions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
                }
                scala.collection.immutable.Set set2 = set = partitions.toSet();
                return set2;
            }
            if (None$.MODULE$.equals(option2)) {
                throw new AdminOperationException("Replica election data is missing \"partitions\" field");
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            throw new AdminOperationException("Replica election data is empty");
        }
        throw new MatchError(option);
    }

    private void electLeaders(Admin client, ElectionType electionType, Option<scala.collection.immutable.Set<TopicPartition>> topicPartitions2) {
        scala.collection.mutable.Map electionResults;
        try {
            Set partitions = (Set)topicPartitions2.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Set<TopicPartition> apply(scala.collection.immutable.Set<TopicPartition> x$2) {
                    return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(x$2).asJava();
                }
            }).orNull(Predef$.MODULE$.$conforms());
            this.debug((Function0<String>)new Serializable(electionType, partitions){
                public static final long serialVersionUID = 0L;
                private final ElectionType electionType$1;
                private final Set partitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Calling AdminClient.electLeaders(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.electionType$1, this.partitions$1}));
                }
                {
                    this.electionType$1 = electionType$1;
                    this.partitions$1 = partitions$1;
                }
            });
            electionResults = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)client.electLeaders(electionType, partitions).partitions().get()).asScala();
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)"Error while making request");
            throw throwable;
        }
        catch (ExecutionException executionException) {
            Throwable throwable = executionException.getCause();
            if (throwable instanceof TimeoutException) {
                TimeoutException timeoutException = (TimeoutException)throwable;
                String message = "Timeout waiting for election results";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, (Throwable)timeoutException);
            }
            if (throwable instanceof ClusterAuthorizationException) {
                ClusterAuthorizationException clusterAuthorizationException = (ClusterAuthorizationException)throwable;
                String message = "Not authorized to perform leader election";
                Predef$.MODULE$.println((Object)message);
                throw new AdminCommandFailedException(message, (Throwable)clusterAuthorizationException);
            }
            throw executionException;
        }
        scala.collection.mutable.Set succeeded = Set$.MODULE$.empty();
        scala.collection.mutable.Set noop = Set$.MODULE$.empty();
        scala.collection.mutable.Map failed = Map$.MODULE$.empty();
        electionResults.foreach((Function1)new Serializable(succeeded, noop, failed){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Set succeeded$1;
            private final scala.collection.mutable.Set noop$1;
            private final scala.collection.mutable.Map failed$1;

            public final void apply(Tuple2<TopicPartition, Optional<Throwable>> x0$1) {
                Tuple2<TopicPartition, Optional<Throwable>> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition topicPartition = (TopicPartition)tuple2._1();
                    Optional error = (Optional)tuple2._2();
                    if (error.isPresent()) {
                        Throwable throwable = (Throwable)error.get();
                        if (throwable instanceof ElectionNotNeededException) {
                            this.noop$1.$plus$eq((Object)topicPartition);
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            this.failed$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), error.get()));
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.succeeded$1.$plus$eq((Object)topicPartition);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit4 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.succeeded$1 = succeeded$1;
                this.noop$1 = noop$1;
                this.failed$1 = failed$1;
            }
        });
        if (succeeded.nonEmpty()) {
            String partitions = succeeded.mkString(", ");
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully completed leader election (", ") for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{electionType, partitions})));
        }
        if (noop.nonEmpty()) {
            String partitions = succeeded.mkString(", ");
            Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Valid replica already elected for partitions ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitions})));
        }
        if (failed.nonEmpty()) {
            AdminCommandFailedException rootException = new AdminCommandFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " replica(s) could not be elected"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)failed.size())})));
            failed.foreach((Function1)new Serializable(electionType, rootException){
                public static final long serialVersionUID = 0L;
                private final ElectionType electionType$1;
                private final AdminCommandFailedException rootException$1;

                public final void apply(Tuple2<TopicPartition, Throwable> x0$2) {
                    Tuple2<TopicPartition, Throwable> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition topicPartition = (TopicPartition)tuple2._1();
                        Throwable exception = (Throwable)tuple2._2();
                        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error completing leader election (", ") for partition: ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.electionType$1, topicPartition, exception})));
                        this.rootException$1.addSuppressed(exception);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.electionType$1 = electionType$1;
                    this.rootException$1 = rootException$1;
                }
            });
            throw rootException;
        }
        return;
    }

    private void validate(LeaderElectionCommandOptions commandOptions) {
        List missingOptions = List$.MODULE$.empty();
        if (!commandOptions.options().has(commandOptions.bootstrapServer())) {
            String string = (String)commandOptions.bootstrapServer().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (!commandOptions.options().has(commandOptions.electionType())) {
            String string = (String)commandOptions.electionType().options().get(0);
            missingOptions = missingOptions.$colon$colon((Object)string);
        }
        if (missingOptions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing required option(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingOptions.mkString(", ")})));
        }
        Seq mutuallyExclusiveOptions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractOptionSpec[]{commandOptions.topic(), commandOptions.allTopicPartitions(), commandOptions.pathToJsonFile()}));
        OptionSet optionSet = commandOptions.options();
        int n = mutuallyExclusiveOptions.count((Function1)new Serializable(optionSet){
            public static final long serialVersionUID = 0L;
            private final OptionSet eta$0$1$1;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.eta$0$1$1.has(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
        switch (n) {
            default: {
                throw new AdminCommandFailedException(new StringBuilder().append((Object)"One and only one of the following options is required: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)mutuallyExclusiveOptions.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(AbstractOptionSpec<? super Void> x$5) {
                        return (String)x$5.options().get(0);
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(", ")}))).toString());
            }
            case 1: 
        }
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(commandOptions.options().has(commandOptions.topic()), commandOptions.options().has(commandOptions.partition()));
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && !bl2) {
                throw new AdminCommandFailedException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing required option(s): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commandOptions.partition().options().get(0)})));
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (!bl && bl3) {
                throw new AdminCommandFailedException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is only allowed if "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commandOptions.partition().options().get(0)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is used"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commandOptions.topic().options().get(0)}))).toString());
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private LeaderElectionCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

