/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.solr.authorizer;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.solr.authorizer.FieldToAttributeMapping;
import org.apache.ranger.authorization.solr.authorizer.RangerSolrAuditHandler;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.contextenricher.RangerUserStoreEnricher;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;

public class RangerSolrAuthorizer
extends SearchComponent
implements AuthorizationPlugin {
    private static final Log logger = LogFactory.getLog(RangerSolrAuthorizer.class);
    private static final Log PERF_SOLRAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"solrauth.request");
    public static final String SUPERUSER = System.getProperty("solr.authorization.superuser", "solr");
    public static final String AUTH_FIELD_PROP = "rangerAuthField";
    public static final String DEFAULT_AUTH_FIELD = "ranger_auth";
    public static final String ALL_ROLES_TOKEN_PROP = "allRolesToken";
    public static final String ENABLED_PROP = "enabled";
    public static final String MODE_PROP = "matchMode";
    public static final String DEFAULT_MODE_PROP = MatchType.DISJUNCTIVE.toString();
    public static final String ALLOW_MISSING_VAL_PROP = "allow_missing_val";
    public static final String TOKEN_COUNT_PROP = "tokenCountField";
    public static final String DEFAULT_TOKEN_COUNT_FIELD_PROP = "ranger_auth_count";
    public static final String QPARSER_PROP = "qParser";
    public static final String PROP_USE_PROXY_IP = "xasecure.solr.use_proxy_ip";
    public static final String PROP_PROXY_IP_HEADER = "xasecure.solr.proxy_ip_header";
    public static final String PROP_SOLR_APP_NAME = "xasecure.solr.app.name";
    public static final String KEY_COLLECTION = "collection";
    public static final String ACCESS_TYPE_CREATE = "create";
    public static final String ACCESS_TYPE_UPDATE = "update";
    public static final String ACCESS_TYPE_QUERY = "query";
    public static final String ACCESS_TYPE_OTHERS = "others";
    public static final String ACCESS_TYPE_ADMIN = "solr_admin";
    public static final String ATTRS_ENABLED_PROP = "attrs_enabled";
    public static final String FIELD_ATTR_MAPPINGS = "field_attr_mappings";
    public static final String FIELD_FILTER_TYPE = "filter_type";
    public static final String ATTR_NAMES = "attr_names";
    public static final String PERMIT_EMPTY_VALUES = "permit_empty";
    public static final String ALL_USERS_VALUE = "all_users_value";
    public static final String ATTRIBUTE_FILTER_REGEX = "value_filter_regex";
    public static final String AND_OP_QPARSER = "andQParser";
    public static final String EXTRA_OPTS = "extra_opts";
    private List<FieldToAttributeMapping> fieldAttributeMappings = new LinkedList<FieldToAttributeMapping>();
    private String andQParserName;
    private static volatile RangerBasePlugin solrPlugin = null;
    private RangerSolrAuditHandler auditHandler = null;
    boolean useProxyIP = false;
    String proxyIPHeader = "HTTP_X_FORWARDED_FOR";
    String solrAppName = "Client";
    private String authField;
    private String allRolesToken;
    private boolean enabled;
    private MatchType matchMode;
    private String tokenCountField;
    private boolean allowMissingValue;
    private String qParserName;
    private boolean attrsEnabled;

    public RangerSolrAuthorizer() {
        logger.info((Object)"RangerSolrAuthorizer()");
    }

    public void init(NamedList args) {
        SolrParams params = args.toSolrParams();
        this.authField = params.get(AUTH_FIELD_PROP, DEFAULT_AUTH_FIELD);
        this.allRolesToken = params.get(ALL_ROLES_TOKEN_PROP, "");
        this.enabled = params.getBool(ENABLED_PROP, false);
        this.matchMode = MatchType.valueOf(params.get(MODE_PROP, DEFAULT_MODE_PROP).toUpperCase());
        if (this.matchMode == MatchType.CONJUNCTIVE) {
            this.qParserName = params.get(QPARSER_PROP, "subset").trim();
            this.allowMissingValue = params.getBool(ALLOW_MISSING_VAL_PROP, false);
            this.tokenCountField = params.get(TOKEN_COUNT_PROP, DEFAULT_TOKEN_COUNT_FIELD_PROP);
        }
        this.attrsEnabled = params.getBool(ATTRS_ENABLED_PROP, false);
        logger.info((Object)("RangerSolrAuthorizer.init(): authField={" + this.authField + "}, allRolesToken={" + this.allRolesToken + "}, enabled={" + this.enabled + "}, matchType={" + (Object)((Object)this.matchMode) + "}, qParserName={" + this.qParserName + "}, allowMissingValue={" + this.allowMissingValue + "}, tokenCountField={" + this.tokenCountField + "}, attrsEnabled={" + this.attrsEnabled + "}"));
        if (this.attrsEnabled) {
            if (params.get(FIELD_ATTR_MAPPINGS) != null) {
                logger.info((Object)("Solr params = " + params.get(FIELD_ATTR_MAPPINGS)));
                NamedList mappings = (NamedList)this.checkAndGet(args, FIELD_ATTR_MAPPINGS);
                for (Map.Entry entry : mappings) {
                    String solrFieldName = (String)entry.getKey();
                    String attributeNames = (String)this.checkAndGet((NamedList)entry.getValue(), ATTR_NAMES);
                    String filterType = (String)this.checkAndGet((NamedList)entry.getValue(), FIELD_FILTER_TYPE);
                    boolean acceptEmpty = false;
                    if (((NamedList)entry.getValue()).getBooleanArg(PERMIT_EMPTY_VALUES) != null) {
                        acceptEmpty = ((NamedList)entry.getValue()).getBooleanArg(PERMIT_EMPTY_VALUES);
                    }
                    String allUsersValue = this.getWithDefault((NamedList)entry.getValue(), ALL_USERS_VALUE, "");
                    String regex = this.getWithDefault((NamedList)entry.getValue(), ATTRIBUTE_FILTER_REGEX, "");
                    String extraOpts = this.getWithDefault((NamedList)entry.getValue(), EXTRA_OPTS, "");
                    FieldToAttributeMapping mapping = new FieldToAttributeMapping(solrFieldName, attributeNames, filterType, acceptEmpty, allUsersValue, regex, extraOpts);
                    this.fieldAttributeMappings.add(mapping);
                }
            }
            this.andQParserName = ((String)this.checkAndGet(args, AND_OP_QPARSER)).trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init(Map<String, Object> initInfo) {
        logger.info((Object)"init()");
        try {
            RangerBasePlugin me = solrPlugin;
            if (me == null) {
                Class<RangerSolrAuthorizer> clazz = RangerSolrAuthorizer.class;
                // MONITORENTER : org.apache.ranger.authorization.solr.authorizer.RangerSolrAuthorizer.class
                me = solrPlugin;
                logger.info((Object)"RangerSolrAuthorizer(): init called");
                if (me == null) {
                    me = solrPlugin = new RangerBasePlugin("solr", "solr");
                }
                // MONITOREXIT : clazz
            }
            solrPlugin.init();
            this.auditHandler = new RangerSolrAuditHandler((Configuration)solrPlugin.getConfig());
            solrPlugin.setResultProcessor((RangerAccessResultProcessor)this.auditHandler);
        }
        catch (Throwable t) {
            logger.fatal((Object)"Error creating and initializing RangerBasePlugin()");
        }
        try {
            this.useProxyIP = solrPlugin.getConfig().getBoolean(PROP_USE_PROXY_IP, this.useProxyIP);
            this.proxyIPHeader = solrPlugin.getConfig().get(PROP_PROXY_IP_HEADER, this.proxyIPHeader);
            this.solrAppName = System.getProperty("solr.kerberos.jaas.appname", this.solrAppName);
            this.solrAppName = solrPlugin.getConfig().get(PROP_SOLR_APP_NAME, this.solrAppName);
            logger.info((Object)("init(): useProxyIP=" + this.useProxyIP));
            logger.info((Object)("init(): proxyIPHeader=" + this.proxyIPHeader));
            logger.info((Object)("init(): solrAppName=" + this.solrAppName));
            logger.info((Object)("init(): KerberosName.rules=" + MiscUtil.getKerberosNamesRules()));
            this.authToJAASFile();
            return;
        }
        catch (Throwable t) {
            logger.fatal((Object)"Error init", t);
        }
    }

    public void close() throws IOException {
        logger.info((Object)"close() called");
        try {
            solrPlugin.cleanup();
            if (solrPlugin.getAuditProviderFactory() != null) {
                solrPlugin.getAuditProviderFactory().shutdown();
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error cleaning up Ranger plugin. Ignoring error", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse authorize(AuthorizationContext context) {
        boolean isDenied = false;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"==> RangerSolrAuthorizer.authorize()");
                this.logAuthorizationConext(context);
            }
            RangerPerfTracer perf = null;
            if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_SOLRAUTH_REQUEST_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Log)PERF_SOLRAUTH_REQUEST_LOG, (String)"RangerSolrAuthorizer.authorize()");
            }
            String userName = this.getUserName(context);
            Set<String> userGroups = this.getGroupsForUser(userName);
            String ip = null;
            Date eventTime = new Date();
            if (this.useProxyIP) {
                ip = context.getHttpHeader(this.proxyIPHeader);
            }
            if (ip == null) {
                ip = context.getHttpHeader("REMOTE_ADDR");
            }
            if (ip == null) {
                ip = context.getRemoteAddr();
            }
            ArrayList<RangerAccessRequestImpl> rangerRequests = new ArrayList<RangerAccessRequestImpl>();
            List collectionRequests = context.getCollectionRequests();
            if (CollectionUtils.isEmpty((Collection)collectionRequests)) {
                RangerAccessRequestImpl requestForCollection = this.createRequest(userName, userGroups, ip, eventTime, context, null);
                if (requestForCollection != null) {
                    rangerRequests.add(requestForCollection);
                }
            } else {
                for (AuthorizationContext.CollectionRequest collectionRequest : context.getCollectionRequests()) {
                    RangerAccessRequestImpl requestForCollection = this.createRequest(userName, userGroups, ip, eventTime, context, collectionRequest);
                    if (requestForCollection == null) continue;
                    rangerRequests.add(requestForCollection);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("rangerRequests.size()=" + rangerRequests.size()));
            }
            try {
                for (RangerAccessRequestImpl rangerRequest : rangerRequests) {
                    RangerAccessResult result = solrPlugin.isAccessAllowed((RangerAccessRequest)rangerRequest, (RangerAccessResultProcessor)this.auditHandler);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("rangerRequest=" + result));
                    }
                    if (result != null && result.getIsAllowed()) continue;
                    isDenied = true;
                    break;
                }
            }
            finally {
                this.auditHandler.flushAudit();
                RangerPerfTracer.log((RangerPerfTracer)perf);
            }
        }
        catch (Throwable t) {
            isDenied = true;
            MiscUtil.logErrorMessageByInterval((Log)logger, (String)t.getMessage(), (Throwable)t);
        }
        AuthorizationResponse response = null;
        response = isDenied ? new AuthorizationResponse(403) : new AuthorizationResponse(200);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("<== RangerSolrAuthorizer.authorize() result: " + isDenied + "Response : " + response.getMessage()));
        }
        return response;
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        if (!this.enabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Solr Document level Authorization is not enabled!");
            }
            return;
        }
        String userName = this.getUserName(rb.req);
        if (SUPERUSER.equals(userName)) {
            return;
        }
        if (this.attrsEnabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Checking Ldap attributes to be added to the query filter");
            }
            if (this.getUserStoreEnricher() == null || this.getUserStoreEnricher().getRangerUserStore() == null) {
                logger.error((Object)"No User store enricher to read the ldap attributes");
                return;
            }
            Map userAttrMapping = this.getUserStoreEnricher().getRangerUserStore().getUserAttrMapping();
            if (MapUtils.isNotEmpty((Map)userAttrMapping)) {
                ModifiableSolrParams newParams = new ModifiableSolrParams(rb.req.getParams());
                Map userAttributes = (Map)userAttrMapping.get(userName);
                for (FieldToAttributeMapping mapping : this.fieldAttributeMappings) {
                    String filterQuery = this.buildFilterQueryString(userName, userAttributes, mapping);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Adding filter clause : {}" + filterQuery));
                    }
                    newParams.add("fq", new String[]{filterQuery});
                }
                rb.req.setParams((SolrParams)newParams);
            }
        } else {
            Set<String> roles;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Checking User roles to be added to the query filter");
            }
            if ((roles = this.getRolesForUser(userName)) != null && !roles.isEmpty()) {
                String filterQuery = this.matchMode == MatchType.DISJUNCTIVE ? this.getDisjunctiveFilterQueryStr(roles) : this.getConjunctiveFilterQueryStr(roles);
                ModifiableSolrParams newParams = new ModifiableSolrParams(rb.req.getParams());
                newParams.add("fq", new String[]{filterQuery});
                rb.req.setParams((SolrParams)newParams);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Adding filter query {" + filterQuery + "} for user {" + userName + "} with roles {" + roles + "}"));
                }
            } else {
                throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "Request from user: " + userName + " rejected because user is not associated with any roles");
            }
        }
    }

    public void process(ResponseBuilder rb) throws IOException {
    }

    public String getDescription() {
        return "Handle Query Document Authorization";
    }

    private void authToJAASFile() {
        try {
            MiscUtil.setUGIFromJAASConfig((String)this.solrAppName);
            logger.info((Object)("LoginUser=" + MiscUtil.getUGILoginUser()));
        }
        catch (Throwable t) {
            logger.error((Object)("Error authenticating for appName=" + this.solrAppName), t);
        }
    }

    private void logAuthorizationConext(AuthorizationContext context) {
        try {
            String collections = "";
            int i = -1;
            for (AuthorizationContext.CollectionRequest collectionRequest : context.getCollectionRequests()) {
                if (++i > 0) {
                    collections = collections + ",";
                }
                collections = collections + collectionRequest.collectionName;
            }
            String headers = "";
            i = -1;
            Enumeration eList = context.getHeaderNames();
            while (eList.hasMoreElements()) {
                if (++i > 0) {
                    headers = headers + ",";
                }
                String header = (String)eList.nextElement();
                String value = context.getHttpHeader(header);
                headers = headers + header + "=" + value;
            }
            String ipAddress = context.getHttpHeader("HTTP_X_FORWARDED_FOR");
            if (ipAddress == null) {
                ipAddress = context.getHttpHeader("REMOTE_HOST");
            }
            if (ipAddress == null) {
                ipAddress = context.getHttpHeader("REMOTE_ADDR");
            }
            if (ipAddress == null) {
                ipAddress = context.getRemoteAddr();
            }
            String userName = this.getUserName(context);
            Set<String> groups = this.getGroupsForUser(userName);
            String resource = context.getResource();
            String solrParams = "";
            try {
                solrParams = context.getParams().toQueryString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            AuthorizationContext.RequestType requestType = context.getRequestType();
            String accessType = this.mapToRangerAccessType(context);
            Principal principal = context.getUserPrincipal();
            String contextString = new String("AuthorizationContext: ");
            contextString = contextString + "context.getResource()= " + (resource != null ? resource : "");
            contextString = contextString + ", solarParams= " + (solrParams != null ? solrParams : "");
            contextString = contextString + ", requestType= " + (requestType != null ? requestType : "");
            contextString = contextString + ", ranger.requestType= " + (accessType != null ? accessType : "");
            contextString = contextString + ", userPrincipal= " + (principal != null ? principal : "");
            contextString = contextString + ", userName= " + userName;
            contextString = contextString + ", groups= " + groups;
            contextString = contextString + ", ipAddress= " + ipAddress;
            contextString = contextString + ", collections= " + collections;
            contextString = contextString + ", headers= " + headers;
            logger.debug((Object)contextString);
        }
        catch (Throwable t) {
            logger.error((Object)"Error getting request context!!!", t);
        }
    }

    private RangerAccessRequestImpl createRequest(String userName, Set<String> userGroups, String ip, Date eventTime, AuthorizationContext context, AuthorizationContext.CollectionRequest collectionRequest) {
        String accessType;
        String action = accessType = this.mapToRangerAccessType(context);
        RangerAccessRequestImpl rangerRequest = this.createBaseRequest(userName, userGroups, ip, eventTime);
        RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
        if (collectionRequest == null) {
            rangerResource.setValue(KEY_COLLECTION, (Object)"*");
        } else {
            rangerResource.setValue(KEY_COLLECTION, (Object)collectionRequest.collectionName);
        }
        rangerRequest.setResource((RangerAccessResource)rangerResource);
        rangerRequest.setAccessType(accessType);
        rangerRequest.setAction(action);
        return rangerRequest;
    }

    private RangerAccessRequestImpl createBaseRequest(String userName, Set<String> userGroups, String ip, Date eventTime) {
        RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl();
        if (userName != null && !userName.isEmpty()) {
            rangerRequest.setUser(userName);
        }
        if (userGroups != null && userGroups.size() > 0) {
            rangerRequest.setUserGroups(userGroups);
        }
        if (ip != null && !ip.isEmpty()) {
            rangerRequest.setClientIPAddress(ip);
        }
        rangerRequest.setAccessTime(eventTime);
        return rangerRequest;
    }

    private String getUserName(AuthorizationContext context) {
        Principal principal = context.getUserPrincipal();
        if (principal != null) {
            return MiscUtil.getShortNameFromPrincipalName((String)principal.getName());
        }
        return null;
    }

    private Set<String> getGroupsForUser(String name) {
        return MiscUtil.getGroupsForRequestUser((String)name);
    }

    String mapToRangerAccessType(AuthorizationContext context) {
        String accessType = ACCESS_TYPE_OTHERS;
        AuthorizationContext.RequestType requestType = context.getRequestType();
        if (AuthorizationContext.RequestType.ADMIN.equals((Object)requestType)) {
            accessType = ACCESS_TYPE_ADMIN;
        } else if (AuthorizationContext.RequestType.READ.equals((Object)requestType)) {
            accessType = ACCESS_TYPE_QUERY;
        } else if (AuthorizationContext.RequestType.WRITE.equals((Object)requestType)) {
            accessType = ACCESS_TYPE_UPDATE;
        } else if (AuthorizationContext.RequestType.UNKNOWN.equals((Object)requestType)) {
            logger.info((Object)("UNKNOWN request type. Mapping it to " + accessType + ". Resource=" + context.getResource()));
            accessType = ACCESS_TYPE_OTHERS;
        } else {
            logger.info((Object)("Request type is not supported. requestType=" + requestType + ". Mapping it to " + accessType + ". Resource=" + context.getResource()));
        }
        return accessType;
    }

    private void addDisjunctiveRawClause(StringBuilder builder, String value) {
        builder.append(" {!raw f=").append(this.authField).append(" v=").append(value).append("}");
    }

    private String getDisjunctiveFilterQueryStr(Set<String> roles) {
        if (roles != null && !roles.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (String role : roles) {
                this.addDisjunctiveRawClause(builder, role);
            }
            if (this.allRolesToken != null && !this.allRolesToken.isEmpty()) {
                this.addDisjunctiveRawClause(builder, this.allRolesToken);
            }
            return builder.toString();
        }
        return null;
    }

    private String getConjunctiveFilterQueryStr(Set<String> roles) {
        StringBuilder filterQuery = new StringBuilder();
        filterQuery.append(" {!").append(this.qParserName).append(" set_field=\"").append(this.authField).append("\"").append(" set_value=\"").append(Joiner.on((char)',').join(roles.iterator())).append("\"").append(" count_field=\"").append(this.tokenCountField).append("\"");
        if (this.allRolesToken != null && !this.allRolesToken.equals("")) {
            filterQuery.append(" wildcard_token=\"").append(this.allRolesToken).append("\"");
        }
        filterQuery.append(" allow_missing_val=").append(this.allowMissingValue).append(" }");
        return filterQuery.toString();
    }

    private Set<String> getRolesForUser(String name) {
        if (solrPlugin.getCurrentRangerAuthContext() != null) {
            return solrPlugin.getRolesFromUserAndGroups(name, this.getGroupsForUser(name));
        }
        logger.info((Object)"Current Ranger Auth Context is null!!");
        return null;
    }

    private final String getUserName(SolrQueryRequest req) {
        if (req instanceof LocalSolrQueryRequest) {
            return SUPERUSER;
        }
        SolrCore solrCore = req.getCore();
        HttpServletRequest httpServletRequest = (HttpServletRequest)req.getContext().get("httpRequest");
        if (httpServletRequest == null) {
            StringBuilder builder = new StringBuilder("Unable to locate HttpServletRequest");
            if (solrCore != null && !solrCore.getSolrConfig().getBool("requestDispatcher/requestParsers/@addHttpRequestToContext", true)) {
                builder.append(", ensure requestDispatcher/requestParsers/@addHttpRequestToContext is set to true in solrconfig.xml");
            }
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, builder.toString());
        }
        String userName = httpServletRequest.getRemoteUser();
        if (userName == null) {
            userName = MiscUtil.getShortNameFromPrincipalName((String)httpServletRequest.getUserPrincipal().getName());
        }
        if (userName == null) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "This request is not authenticated.");
        }
        return userName;
    }

    private RangerUserStoreEnricher getUserStoreEnricher() {
        Map contextEnricherMap;
        RangerUserStoreEnricher ret = null;
        RangerAuthContext authContext = solrPlugin.getCurrentRangerAuthContext();
        if (authContext != null && MapUtils.isNotEmpty((Map)(contextEnricherMap = authContext.getRequestContextEnrichers()))) {
            Set contextEnrichers = contextEnricherMap.keySet();
            for (RangerContextEnricher enricher : contextEnrichers) {
                if (!(enricher instanceof RangerUserStoreEnricher)) continue;
                ret = (RangerUserStoreEnricher)enricher;
                break;
            }
        }
        return ret;
    }

    private <T> T checkAndGet(NamedList args, String key) {
        logger.info((Object)("checkAndGet() " + key));
        return (T)Preconditions.checkNotNull((Object)args.get(key));
    }

    private <T> T getWithDefault(NamedList args, String key, T defaultValue) {
        Object value = args.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    private String buildFilterQueryString(String userName, Map<String, String> userAttributes, FieldToAttributeMapping mapping) {
        String fieldName = mapping.getFieldName();
        Collection<String> attributeValues = this.getUserAttributesForField(userName, userAttributes, mapping);
        switch (mapping.getFilterType()) {
            case OR: {
                return this.buildSimpleORFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
            case AND: {
                return this.buildSubsetFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
            case GTE: {
                return this.buildGreaterThanFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
            case LTE: {
                return this.buildLessThanFilterQuery(fieldName, attributeValues, mapping.getAcceptEmpty(), mapping.getAllUsersValue(), mapping.getExtraOpts());
            }
        }
        return null;
    }

    private Collection<String> getUserAttributesForField(String userName, Map<String, String> userAttributes, FieldToAttributeMapping mapping) {
        HashSet<String> userAttributesSubset = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(mapping.getAttributes()) && mapping.getAttributes().contains("groups")) {
            userAttributesSubset.addAll(this.getGroupsForUser(userName));
        }
        for (String attributeName : mapping.getAttributes()) {
            userAttributesSubset.add(userAttributes.get(attributeName));
        }
        return userAttributesSubset;
    }

    private String buildSimpleORFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        StringBuilder s = new StringBuilder();
        for (String attributeValue : attributeValues) {
            s.append(fieldName).append(":\"").append(attributeValue).append("\" ");
        }
        if (allUsersValue != null && !allUsersValue.equals("")) {
            s.append(fieldName).append(":\"").append(allUsersValue).append("\" ");
        }
        if (allowEmptyField) {
            s.append("(*:* AND -").append(fieldName).append(":*) ");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            s.append(extraOpts + " ");
        }
        s.deleteCharAt(s.length() - 1);
        return s.toString();
    }

    private String buildSubsetFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        StringBuilder s = new StringBuilder();
        s.append("{!").append(this.andQParserName).append(" set_field=").append(fieldName).append(" set_value=").append(Joiner.on((char)',').join(attributeValues));
        if (allUsersValue != null && !allUsersValue.equals("")) {
            s.append(" wildcard_token=").append(allUsersValue);
        }
        if (allowEmptyField) {
            s.append(" allow_missing_val=true");
        } else {
            s.append(" allow_missing_val=false");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            s.append(" " + extraOpts);
        }
        s.append("}");
        return s.toString();
    }

    private String buildGreaterThanFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        String value;
        if (attributeValues.size() == 1) {
            value = attributeValues.iterator().next();
        } else if (allUsersValue != null && !allUsersValue.equals("")) {
            value = allUsersValue;
        } else {
            throw new IllegalArgumentException("Greater Than Filter Query cannot be built for field " + fieldName);
        }
        StringBuilder extraClause = new StringBuilder();
        if (allowEmptyField) {
            extraClause.append(" (*:* AND -").append(fieldName).append(":*)");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            extraClause.append(" ").append(extraOpts);
        }
        return fieldName + ":[" + value + " TO *]" + extraClause.toString();
    }

    private String buildLessThanFilterQuery(String fieldName, Collection<String> attributeValues, boolean allowEmptyField, String allUsersValue, String extraOpts) {
        String value;
        if (attributeValues.size() == 1) {
            value = attributeValues.iterator().next();
        } else if (allUsersValue != null && !allUsersValue.equals("")) {
            value = allUsersValue;
        } else {
            throw new IllegalArgumentException("Less Than Filter Query cannot be built for field " + fieldName);
        }
        StringBuilder extraClause = new StringBuilder();
        if (allowEmptyField) {
            extraClause.append(" (*:* AND -").append(fieldName).append(":*)");
        }
        if (extraOpts != null && !extraOpts.equals("")) {
            extraClause.append(" ").append(extraOpts);
        }
        return fieldName + ":[* TO " + value + "]" + extraClause.toString();
    }

    private static enum MatchType {
        DISJUNCTIVE,
        CONJUNCTIVE;

    }
}

