/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.util.Arrays;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.datanode.BlockMetadataHeader;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.FinalizedReplica;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.DataChecksum;

@InterfaceAudience.Private
public class FsDatasetUtil {
    static boolean isUnlinkTmpFile(File f) {
        return f.getName().endsWith(".unlinked");
    }

    public static byte[] createNullChecksumByteArray() {
        DataChecksum csum = DataChecksum.newDataChecksum((DataChecksum.Type)DataChecksum.Type.NULL, (int)512);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(out);
        try {
            BlockMetadataHeader.writeHeader((DataOutputStream)dataOut, (DataChecksum)csum);
            dataOut.close();
        }
        catch (IOException e) {
            FsVolumeImpl.LOG.error("Exception in creating null checksum stream: " + e);
            return null;
        }
        return out.toByteArray();
    }

    static File getOrigFile(File unlinkTmpFile) {
        String name = unlinkTmpFile.getName();
        if (!name.endsWith(".unlinked")) {
            throw new IllegalArgumentException("unlinkTmpFile=" + unlinkTmpFile + " does not end with " + ".unlinked");
        }
        int n = name.length() - ".unlinked".length();
        return new File(unlinkTmpFile.getParentFile(), name.substring(0, n));
    }

    static File getMetaFile(File f, long gs) {
        return new File(f.getParent(), DatanodeUtil.getMetaName(f.getName(), gs));
    }

    public static File findMetaFile(File blockFile) throws IOException {
        final String prefix = blockFile.getName() + "_";
        final File parent = blockFile.getParentFile();
        File[] matches = parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.equals(parent) && name.startsWith(prefix) && name.endsWith(".meta");
            }
        });
        if (matches == null || matches.length == 0) {
            throw new IOException("Meta file not found, blockFile=" + blockFile);
        }
        if (matches.length > 1) {
            throw new IOException("Found more than one meta files: " + Arrays.asList(matches));
        }
        return matches[0];
    }

    public static FileDescriptor openAndSeek(File file, long offset) throws IOException {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "r");
            if (offset > 0L) {
                raf.seek(offset);
            }
            return raf.getFD();
        }
        catch (IOException ioe) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{raf});
            throw ioe;
        }
    }

    static long getGenerationStampFromFile(File[] listdir, File blockFile, int index) {
        String metaFile;
        String blockName = blockFile.getName();
        if (index + 1 < listdir.length && (metaFile = listdir[index + 1].getName()).startsWith(blockName)) {
            return Block.getGenerationStamp((String)metaFile);
        }
        FsDatasetImpl.LOG.warn("Block " + blockFile + " does not have a metafile!");
        return 0L;
    }

    static long parseGenerationStamp(File blockFile, File metaFile) throws IOException {
        String metaname = metaFile.getName();
        String gs = metaname.substring(blockFile.getName().length() + 1, metaname.length() - ".meta".length());
        try {
            return Long.parseLong(gs);
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Failed to parse generation stamp: blockFile=" + blockFile + ", metaFile=" + metaFile, nfe);
        }
    }

    public static void computeChecksum(final File srcMeta, File dstMeta, final File blockFile, int smallBufferSize, Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)srcMeta);
        Preconditions.checkNotNull((Object)dstMeta);
        Preconditions.checkNotNull((Object)blockFile);
        FinalizedReplica wrapper = new FinalizedReplica(0L, 0L, 0L, null, null){

            @Override
            public URI getMetadataURI() {
                return srcMeta.toURI();
            }

            @Override
            public InputStream getDataInputStream(long seekOffset) throws IOException {
                return new FileInputStream(blockFile);
            }
        };
        FsDatasetImpl.computeChecksum(wrapper, dstMeta, smallBufferSize, conf);
    }
}

