/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.server.request;

import org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import org.apache.kerby.kerberos.kerb.server.request.TgsRequest;
import org.apache.kerby.kerberos.kerb.server.request.TicketIssuer;
import org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.base.TransitedEncoding;
import org.apache.kerby.kerberos.kerb.type.ticket.Ticket;

public class ServiceTicketIssuer
extends TicketIssuer {
    private final Ticket tgtTicket;
    private final AuthToken token;

    public ServiceTicketIssuer(TgsRequest kdcRequest) {
        super(kdcRequest);
        this.tgtTicket = kdcRequest.getTgtTicket();
        this.token = kdcRequest.getToken();
    }

    protected KdcRequest getTgsRequest() {
        return this.getKdcRequest();
    }

    @Override
    protected PrincipalName getclientPrincipal() {
        PrincipalName clientPrincipal;
        if (this.token != null) {
            clientPrincipal = new PrincipalName(this.token.getSubject());
        } else {
            clientPrincipal = this.tgtTicket.getEncPart().getCname();
            clientPrincipal.setRealm(this.tgtTicket.getEncPart().getCrealm());
        }
        return clientPrincipal;
    }

    @Override
    protected TransitedEncoding getTransitedEncoding() {
        if (this.token != null) {
            return super.getTransitedEncoding();
        }
        return this.tgtTicket.getEncPart().getTransited();
    }
}

