/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.server.tomcat;

import com.google.protobuf.TextFormat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.util.XMLUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.Krb5HttpClientBuilder;
import org.apache.solr.client.solrj.impl.SolrHttpClientBuilder;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.SolrZooKeeper;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.zookeeper.CreateMode;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;

public class SolrCollectionBootstrapper
extends Thread {
    private static final Logger logger = Logger.getLogger(SolrCollectionBootstrapper.class.getName());
    static final String SOLR_ZK_HOSTS = "ranger.audit.solr.zookeepers";
    static final String SOLR_COLLECTION_NAME = "ranger.audit.solr.collection.name";
    static final String SOLR_CONFIG_NAME = "ranger.audit.solr.config.name";
    static final String SOLR_NO_SHARDS = "ranger.audit.solr.no.shards";
    static final String SOLR_MAX_SHARD_PER_NODE = "ranger.audit.solr.max.shards.per.node";
    static final String SOLR_NO_REPLICA = "ranger.audit.solr.no.replica";
    static final String SOLR_TIME_INTERVAL = "ranger.audit.solr.time.interval";
    static final String SOLR_BOOTSTRP_MAX_RETRY = "ranger.audit.solr.max.retry";
    static final String SOLR_ACL_USER_LIST_SASL = "ranger.audit.solr.acl.user.list.sasl";
    static final String PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    public static final String DEFAULT_COLLECTION_NAME = "ranger_audits";
    public static final String DEFAULT_CONFIG_NAME = "ranger_audits";
    public static final String DEFAULT_SERVICE_NAME = "rangeradmin";
    public static final long DEFAULT_SOLR_TIME_INTERVAL_MS = 60000L;
    public static final int DEFAULT_SOLR_BOOTSTRP_MAX_RETRY = 30;
    private static final String CONFIG_FILE = "ranger-admin-site.xml";
    private static final String CORE_SITE_CONFIG_FILENAME = "core-site.xml";
    private static final String DEFAULT_CONFIG_FILENAME = "ranger-admin-default-site.xml";
    private static final String AUTH_TYPE_KERBEROS = "kerberos";
    private static final String AUTHENTICATION_TYPE = "hadoop.security.authentication";
    private static final String RANGER_SERVICE_HOSTNAME = "ranger.service.host";
    private static final String RANGER_ADMIN_HOME = "ranger.admin.home";
    private static final String ADMIN_USER_PRINCIPAL = "ranger.admin.kerberos.principal";
    private static final String SOLR_CONFIG_FILE = "solrconfig.xml";
    private static final String SSL_ENABLED_PARAM = "ranger.service.https.attrib.ssl.enabled";
    private File configSetFolder = null;
    boolean solr_cloud_mode = false;
    boolean is_completed = false;
    boolean isKERBEROS = false;
    private boolean isSSLEnabled = false;
    String principal = null;
    String hostName;
    String keytab;
    String nameRules;
    String solr_collection_name;
    String solr_config_name;
    Path path_for_cloud_mode;
    int no_of_replicas;
    int no_of_shards;
    int max_node_per_shards;
    int max_retry;
    int retry_counter = 0;
    Long time_interval;
    SolrClient solrClient = null;
    CloudSolrClient solrCloudClient = null;
    SolrZooKeeper solrZookeeper = null;
    SolrZkClient zkClient = null;
    private Properties serverConfigProperties = new Properties();

    public SolrCollectionBootstrapper() throws IOException {
        String rangerHomeDir;
        logger.info("Starting Solr Setup");
        XMLUtils.loadConfig((String)DEFAULT_CONFIG_FILENAME, (Map)this.serverConfigProperties);
        XMLUtils.loadConfig((String)CORE_SITE_CONFIG_FILENAME, (Map)this.serverConfigProperties);
        XMLUtils.loadConfig((String)CONFIG_FILE, (Map)this.serverConfigProperties);
        logger.info("AUTHENTICATION_TYPE : " + this.getConfig(AUTHENTICATION_TYPE));
        if (this.getConfig(AUTHENTICATION_TYPE) != null && this.getConfig(AUTHENTICATION_TYPE).trim().equalsIgnoreCase(AUTH_TYPE_KERBEROS)) {
            this.isKERBEROS = true;
            this.hostName = this.getConfig(RANGER_SERVICE_HOSTNAME);
            try {
                this.principal = SecureClientLogin.getPrincipal((String)this.getConfig(ADMIN_USER_PRINCIPAL), (String)this.hostName);
            }
            catch (IOException ignored) {
                logger.warning("Failed to get ranger.admin.kerberos.principal. Reason: " + ignored.toString());
            }
        }
        this.solr_collection_name = this.getConfig(SOLR_COLLECTION_NAME, "ranger_audits");
        logger.info("Solr Collection name provided is : " + this.solr_collection_name);
        this.solr_config_name = this.getConfig(SOLR_CONFIG_NAME, "ranger_audits");
        logger.info("Solr Config name provided is : " + this.solr_config_name);
        this.no_of_replicas = this.getIntConfig(SOLR_NO_REPLICA, 1);
        logger.info("No. of replicas provided is : " + this.no_of_replicas);
        this.no_of_shards = this.getIntConfig(SOLR_NO_SHARDS, 1);
        logger.info("No. of shards provided is : " + this.no_of_shards);
        this.max_node_per_shards = this.getIntConfig(SOLR_MAX_SHARD_PER_NODE, 1);
        logger.info("Max no of nodes per shards provided is : " + this.max_node_per_shards);
        this.time_interval = this.getLongConfig(SOLR_TIME_INTERVAL, 60000L);
        logger.info("Solr time interval provided is : " + this.time_interval);
        this.max_retry = this.getIntConfig(SOLR_BOOTSTRP_MAX_RETRY, 30);
        if (System.getProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG) == null) {
            System.setProperty(PROP_JAVA_SECURITY_AUTH_LOGIN_CONFIG, "/dev/null");
        }
        if (StringUtil.isEmpty((String)(rangerHomeDir = this.getConfig(RANGER_ADMIN_HOME)))) {
            logger.severe("Ranger Home Directory is missing. Kindly set it.");
        } else {
            this.path_for_cloud_mode = Paths.get(rangerHomeDir, "contrib", "solr_for_audit_setup", "conf");
            this.configSetFolder = this.path_for_cloud_mode.toFile();
        }
        String sslEnabledProp = this.getConfig(SSL_ENABLED_PARAM);
        this.isSSLEnabled = "true".equalsIgnoreCase(sslEnabledProp);
    }

    @Override
    public void run() {
        logger.info("Started run method");
        String zkHosts = "";
        ArrayList<String> zookeeperHosts = null;
        if (this.getConfig(SOLR_ZK_HOSTS) != null && !StringUtil.isEmpty((String)this.getConfig(SOLR_ZK_HOSTS))) {
            zkHosts = this.getConfig(SOLR_ZK_HOSTS).trim();
            zookeeperHosts = new ArrayList<String>(Arrays.asList(zkHosts.split(",")));
        }
        if (zookeeperHosts != null && !zookeeperHosts.isEmpty() && zookeeperHosts.stream().noneMatch(h -> h.equalsIgnoreCase("none"))) {
            logger.info("Solr zkHosts=" + zkHosts + ", collectionName=" + this.solr_collection_name);
            while (!this.is_completed && this.retry_counter < this.max_retry) {
                try {
                    if (this.connect(zookeeperHosts)) {
                        if (!this.solr_cloud_mode) continue;
                        if (this.uploadConfiguration() && this.createCollection()) {
                            this.is_completed = true;
                            break;
                        }
                        this.logErrorMessageAndWait("Error while performing operations on solr. ", null);
                        continue;
                    }
                    this.logErrorMessageAndWait("Cannot connect to solr kindly check the solr related configs. ", null);
                }
                catch (Exception ex) {
                    this.logErrorMessageAndWait("Error while configuring solr. ", ex);
                }
            }
        } else {
            logger.severe("Solr ZKHosts for Audit are empty. Please set property ranger.audit.solr.zookeepers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map postDataAndGetResponse(CloudSolrClient cloudClient, String uri, ByteBuffer bytarr) throws IOException {
        HttpPost httpPost = null;
        String response = null;
        Map m = null;
        try {
            httpPost = new HttpPost(uri);
            httpPost.setHeader("Content-Type", "application/octet-stream");
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(bytarr.array(), bytarr.arrayOffset(), bytarr.limit()));
            HttpEntity entity = cloudClient.getLbClient().getHttpClient().execute((HttpUriRequest)httpPost).getEntity();
            try {
                response = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                m = (Map)ObjectBuilder.getVal((JSONParser)new JSONParser((Reader)new StringReader(response)));
            }
            catch (JSONParser.ParseException e) {
                logger.severe("Error response: " + response);
            }
        }
        catch (Exception ex) {
            logger.severe("Error while configuring solr : " + ex);
        }
        finally {
            httpPost.releaseConnection();
        }
        return m;
    }

    private boolean connect(List<String> zookeeperHosts) {
        try {
            logger.info("Solr is in Cloud mode");
            if (this.isKERBEROS) {
                this.setHttpClientBuilderForKrb();
            }
            this.solrCloudClient = new CloudSolrClient.Builder(zookeeperHosts, Optional.empty()).build();
            this.solrCloudClient.setDefaultCollection(this.solr_collection_name);
            this.solrClient = this.solrCloudClient;
            this.solr_cloud_mode = true;
            return true;
        }
        catch (Exception ex) {
            logger.severe("Can't connect to Solr server. ZooKeepers=" + zookeeperHosts + ", collection=" + this.solr_collection_name + ex);
            return false;
        }
    }

    private void setHttpClientBuilderForKrb() {
        Krb5HttpClientBuilder krbBuild = new Krb5HttpClientBuilder();
        SolrHttpClientBuilder kb = krbBuild.getBuilder();
        HttpClientUtil.setHttpClientBuilder((SolrHttpClientBuilder)kb);
    }

    private boolean uploadConfiguration() {
        try {
            this.solrCloudClient.connect();
            this.zkClient = this.solrCloudClient.getZkStateReader().getZkClient();
            if (this.zkClient != null) {
                ZkConfigManager zkConfigManager = new ZkConfigManager(this.zkClient);
                boolean configExists = zkConfigManager.configExists(this.solr_config_name);
                if (!configExists) {
                    try {
                        String[] files;
                        logger.info("Config does not exist with name " + this.solr_config_name);
                        String zipOfConfigs = null;
                        for (String file : files = this.configSetFolder.list()) {
                            if (file == null || !file.equals("solr_audit_conf.zip")) continue;
                            zipOfConfigs = file;
                            break;
                        }
                        if (zipOfConfigs == null) {
                            throw new FileNotFoundException("Could Not Find Configs Zip File : " + this.getConfigSetFolder());
                        }
                        File file = new File(this.configSetFolder + "/" + zipOfConfigs);
                        byte[] arrByte = Files.readAllBytes(file.toPath());
                        ByteBuffer byteBuffer = ByteBuffer.wrap(arrByte);
                        Set nodes = this.solrCloudClient.getClusterStateProvider().getLiveNodes();
                        String baseUrl = null;
                        String[] nodeArr = nodes.toArray(new String[0]);
                        baseUrl = nodeArr[0].replaceAll("_", "/");
                        String protocol = this.isSSLEnabled ? "https" : "http";
                        String uploadConfigsUrl = String.format("%s://%s/admin/configs?action=UPLOAD&name=%s", protocol, baseUrl.toString(), this.solr_config_name);
                        this.postDataAndGetResponse(this.solrCloudClient, uploadConfigsUrl, byteBuffer);
                        return true;
                    }
                    catch (Exception ex) {
                        logger.severe("Error while uploading configs : " + ex);
                        return false;
                    }
                }
                logger.info("Config already exists with name " + this.solr_config_name);
                return true;
            }
            logger.severe("Solr is in cloud mode and could not find the zookeeper client for performing upload operations. ");
            return false;
        }
        catch (Exception ex) {
            logger.severe("Error while uploading configuration : " + ex);
            return false;
        }
    }

    private void logErrorMessageAndWait(String msg, Exception exception) {
        ++this.retry_counter;
        String attempMessage = this.retry_counter == this.max_retry ? "Maximum attempts reached for setting up Solr." : "[retrying after " + this.time_interval + " ms]. No. of attempts left : " + (this.max_retry - this.retry_counter) + " . Maximum attempts : " + this.max_retry;
        StringBuilder errorBuilder = new StringBuilder();
        errorBuilder.append(msg);
        if (exception != null) {
            errorBuilder.append("Error : ".concat(exception.getMessage() + ". "));
        }
        errorBuilder.append(attempMessage);
        logger.severe(errorBuilder.toString());
        try {
            Thread.sleep(this.time_interval);
        }
        catch (InterruptedException ex) {
            logger.info("sleep interrupted: " + ex.getMessage());
        }
    }

    private boolean createCollection() {
        try {
            List<String> allCollectionList = this.getCollections();
            if (allCollectionList != null) {
                if (!allCollectionList.contains(this.solr_collection_name)) {
                    CollectionAdminRequest.Create createCollection = CollectionAdminRequest.createCollection((String)this.solr_collection_name, (String)this.solr_config_name, (int)this.no_of_shards, (int)this.no_of_replicas);
                    createCollection.setMaxShardsPerNode(Integer.valueOf(this.max_node_per_shards));
                    CollectionAdminResponse createResponse = (CollectionAdminResponse)createCollection.process(this.solrClient);
                    if (createResponse.getStatus() != 0) {
                        logger.severe("Error creating collection. collectionName=" + this.solr_collection_name + " , solr config name = " + this.solr_config_name + " , replicas = " + this.no_of_replicas + ", shards=" + this.no_of_shards + " , max node per shards = " + this.max_node_per_shards + ", response=" + createResponse);
                        return false;
                    }
                    allCollectionList = this.getCollections();
                    if (allCollectionList != null) {
                        if (allCollectionList.contains(this.solr_collection_name)) {
                            logger.info("Created collection " + this.solr_collection_name + " with config name " + this.solr_config_name + " replicas =  " + this.no_of_replicas + " Shards = " + this.no_of_shards + " max node per shards  = " + this.max_node_per_shards);
                            return true;
                        }
                        logger.severe("Collection does not exist. collectionName=" + this.solr_collection_name + " , solr config name = " + this.solr_config_name + " , replicas = " + this.no_of_replicas + ", shards=" + this.no_of_shards + " , max node per shards = " + this.max_node_per_shards + ", response=" + createResponse);
                        return false;
                    }
                    logger.severe("Error while getting collection list after creating collection ========== ");
                    return false;
                }
                logger.info("Collection already exists with name " + this.solr_collection_name);
                return true;
            }
            logger.severe("Error while connecting to solr ");
            return false;
        }
        catch (Exception ex) {
            logger.severe("Error while creating collection in solr : " + ex);
            return false;
        }
    }

    private String getConfig(String key, String defaultValue) {
        String ret = this.getConfig(key);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    private List<String> getCollections() throws IOException, TextFormat.ParseException {
        try {
            CollectionAdminRequest.List colListReq = new CollectionAdminRequest.List();
            CollectionAdminResponse response = (CollectionAdminResponse)colListReq.process(this.solrClient);
            if (response.getStatus() != 0) {
                logger.severe("Error getting collection list from solr.  response=" + response);
                return null;
            }
            return (List)response.getResponse().get("collections");
        }
        catch (SolrException e) {
            logger.severe("getCollections() operation failed : " + (Object)((Object)e));
            return null;
        }
        catch (SolrServerException e) {
            logger.severe("getCollections() operation failed : " + (Object)((Object)e));
            return null;
        }
    }

    private int getIntConfig(String key, int defaultValue) {
        int ret = defaultValue;
        String retStr = this.getConfig(key);
        try {
            if (retStr != null) {
                ret = Integer.parseInt(retStr);
            }
        }
        catch (Exception err) {
            logger.severe(retStr + " can't be parsed to int. Reason: " + err.toString());
        }
        return ret;
    }

    private Long getLongConfig(String key, Long defaultValue) {
        Long ret = defaultValue;
        String retStr = this.getConfig(key);
        try {
            if (retStr != null) {
                ret = Long.parseLong(retStr);
            }
        }
        catch (Exception err) {
            logger.severe(retStr + " can't be parsed to long. Reason: " + err.toString());
        }
        return ret;
    }

    private String getConfig(String key) {
        String value = this.serverConfigProperties.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            value = System.getProperty(key);
        }
        return value;
    }

    private void uploadFileToZk(SolrZkClient zkClient, Path filePath, Path configsPath) throws FileNotFoundException {
        FileInputStream is = new FileInputStream(filePath.toString());
        try {
            if (zkClient.exists(configsPath.toString(), true).booleanValue()) {
                zkClient.setData(configsPath.toString(), IOUtils.toByteArray((InputStream)is), true);
            } else {
                zkClient.create(configsPath.toString(), IOUtils.toByteArray((InputStream)is), CreateMode.PERSISTENT, true);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private File getConfigSetFolder() {
        return this.configSetFolder;
    }

    private String getConfigFileName() {
        return SOLR_CONFIG_FILE;
    }
}

