/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.server.tomcat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.Subject;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.ranger.authorization.hadoop.utils.RangerCredentialProvider;
import org.apache.ranger.plugin.util.XMLUtils;
import org.apache.ranger.server.tomcat.SolrCollectionBootstrapper;

public class EmbeddedServer {
    private static final Logger LOG = Logger.getLogger(EmbeddedServer.class.getName());
    private static final String DEFAULT_NAME_RULE = "DEFAULT";
    private static final String DEFAULT_CONFIG_FILENAME = "ranger-admin-default-site.xml";
    private static final String CORE_SITE_CONFIG_FILENAME = "core-site.xml";
    private static final String DEFAULT_WEBAPPS_ROOT_FOLDER = "webapps";
    private static String configFile = "ranger-admin-site.xml";
    private static final String AUTH_TYPE_KERBEROS = "kerberos";
    private static final String AUTHENTICATION_TYPE = "hadoop.security.authentication";
    private static final String ADMIN_USER_PRINCIPAL = "ranger.admin.kerberos.principal";
    private static final String SOLR_BOOTSTRAP_ENABLED = "ranger.audit.solr.bootstrap.enabled";
    private static final String ADMIN_USER_KEYTAB = "ranger.admin.kerberos.keytab";
    private static final String ADMIN_NAME_RULES = "hadoop.security.auth_to_local";
    private static final String ADMIN_SERVER_NAME = "rangeradmin";
    private Properties serverConfigProperties = new Properties();
    public static final String RANGER_KEYSTORE_FILE_TYPE_DEFAULT = "jks";
    public static final String RANGER_TRUSTSTORE_FILE_TYPE_DEFAULT = "jks";
    public static final String RANGER_SSL_CONTEXT_ALGO_TYPE = "TLS";
    public static final String RANGER_SSL_KEYMANAGER_ALGO_TYPE = KeyManagerFactory.getDefaultAlgorithm();
    public static final String RANGER_SSL_TRUSTMANAGER_ALGO_TYPE = TrustManagerFactory.getDefaultAlgorithm();
    public static int DEFAULT_SHUTDOWN_PORT = 6185;
    public static String DEFAULT_SHUTDOWN_COMMAND = "SHUTDOWN";

    public static void main(String[] args) {
        new EmbeddedServer(args).start();
    }

    public EmbeddedServer(String[] args) {
        if (args.length > 0) {
            configFile = args[0];
        } else {
            XMLUtils.loadConfig((String)DEFAULT_CONFIG_FILENAME, (Map)this.serverConfigProperties);
        }
        XMLUtils.loadConfig((String)CORE_SITE_CONFIG_FILENAME, (Map)this.serverConfigProperties);
        XMLUtils.loadConfig((String)configFile, (Map)this.serverConfigProperties);
    }

    public void start() {
        SSLContext sslContext = this.getSSLContext();
        if (sslContext != null) {
            SSLContext.setDefault(sslContext);
        }
        final Tomcat server = new Tomcat();
        String logDir = null;
        logDir = this.getConfig("logdir");
        if (logDir == null) {
            logDir = this.getConfig("kms.log.dir");
        }
        String servername = this.getConfig("servername");
        String hostName = this.getConfig("ranger.service.host");
        int serverPort = this.getIntConfig("ranger.service.http.port", 6181);
        int sslPort = this.getIntConfig("ranger.service.https.port", -1);
        int shutdownPort = this.getIntConfig("ranger.service.shutdown.port", DEFAULT_SHUTDOWN_PORT);
        String shutdownCommand = this.getConfig("ranger.service.shutdown.command", DEFAULT_SHUTDOWN_COMMAND);
        server.setHostname(hostName);
        server.setPort(serverPort);
        server.getServer().setPort(shutdownPort);
        server.getServer().setShutdown(shutdownCommand);
        boolean isHttpsEnabled = Boolean.valueOf(this.getConfig("ranger.service.https.attrib.ssl.enabled", "false"));
        boolean ajpEnabled = Boolean.valueOf(this.getConfig("ajp.enabled", "false"));
        if (ajpEnabled) {
            Connector ajpConnector = new Connector("org.apache.coyote.ajp.AjpNioProtocol");
            ajpConnector.setPort(serverPort);
            ajpConnector.setProperty("protocol", "AJP/1.3");
            server.getService().addConnector(ajpConnector);
            server.setConnector(ajpConnector);
            LOG.info("Created AJP Connector");
        } else if (sslPort > 0 && isHttpsEnabled) {
            Connector ssl = new Connector();
            ssl.setPort(sslPort);
            ssl.setSecure(true);
            ssl.setScheme("https");
            ssl.setAttribute("SSLEnabled", (Object)"true");
            ssl.setAttribute("sslProtocol", (Object)this.getConfig("ranger.service.https.attrib.ssl.protocol", RANGER_SSL_CONTEXT_ALGO_TYPE));
            String clientAuth = this.getConfig("ranger.service.https.attrib.clientAuth", "false");
            if ("false".equalsIgnoreCase(clientAuth)) {
                clientAuth = this.getConfig("ranger.service.https.attrib.client.auth", "want");
            }
            ssl.setAttribute("clientAuth", (Object)clientAuth);
            String providerPath = this.getConfig("ranger.credential.provider.path");
            String keyAlias = this.getConfig("ranger.service.https.attrib.keystore.credential.alias", "keyStoreCredentialAlias");
            String keystorePass = null;
            if (providerPath != null && keyAlias != null && ((keystorePass = this.getDecryptedString(providerPath.trim(), keyAlias.trim())) == null || keystorePass.trim().isEmpty() || "none".equalsIgnoreCase(keystorePass.trim()))) {
                keystorePass = this.getConfig("ranger.service.https.attrib.keystore.pass");
            }
            ssl.setAttribute("keyAlias", (Object)this.getConfig("ranger.service.https.attrib.keystore.keyalias", ADMIN_SERVER_NAME));
            ssl.setAttribute("keystorePass", (Object)keystorePass);
            ssl.setAttribute("keystoreFile", (Object)this.getKeystoreFile());
            String defaultEnabledProtocols = "SSLv2Hello, TLSv1, TLSv1.1, TLSv1.2";
            String enabledProtocols = this.getConfig("ranger.service.https.attrib.ssl.enabled.protocols", defaultEnabledProtocols);
            ssl.setAttribute("sslEnabledProtocols", (Object)enabledProtocols);
            String ciphers = this.getConfig("ranger.tomcat.ciphers");
            if (ciphers != null && ciphers.trim() != null && ciphers.trim().length() > 0) {
                ssl.setAttribute("ciphers", (Object)ciphers);
            }
            server.getService().addConnector(ssl);
            server.setConnector(ssl);
        }
        this.updateHttpConnectorAttribConfig(server);
        File logDirectory = new File(logDir);
        if (!logDirectory.exists()) {
            logDirectory.mkdirs();
        }
        AccessLogValve valve = new AccessLogValve();
        valve.setRotatable(true);
        valve.setAsyncSupported(true);
        valve.setBuffered(false);
        valve.setEnabled(true);
        valve.setFileDateFormat(this.getConfig("ranger.accesslog.dateformat", "yyyy-MM-dd.HH"));
        valve.setDirectory(logDirectory.getAbsolutePath());
        valve.setSuffix(".log");
        String logPattern = this.getConfig("ranger.accesslog.pattern", "%h %l %u %t \"%r\" %s %b");
        valve.setPattern(logPattern);
        server.getHost().getPipeline().addValve((Valve)valve);
        try {
            String webContextName;
            String webapp_dir = this.getConfig("xa.webapp.dir");
            if (webapp_dir == null || webapp_dir.trim().isEmpty()) {
                String catalina_base = this.getConfig("catalina.base");
                if (catalina_base == null || catalina_base.trim().isEmpty()) {
                    LOG.severe("Tomcat Server failed to start: catalina.base and/or xa.webapp.dir is not set");
                    System.exit(1);
                }
                webapp_dir = catalina_base + File.separator + "webapp";
                LOG.info("Deriving webapp folder from catalina.base property. folder=" + webapp_dir);
            }
            if ((webContextName = this.getConfig("ranger.contextName", "/")) == null) {
                webContextName = "/";
            } else if (!webContextName.startsWith("/")) {
                LOG.info("Context Name [" + webContextName + "] is being loaded as [ /" + webContextName + "]");
                webContextName = "/" + webContextName;
            }
            File wad = new File(webapp_dir);
            if (wad.isDirectory()) {
                LOG.info("Webapp file =" + webapp_dir + ", webAppName = " + webContextName);
            } else if (wad.isFile()) {
                File webAppDir = new File(DEFAULT_WEBAPPS_ROOT_FOLDER);
                if (!webAppDir.exists()) {
                    webAppDir.mkdirs();
                }
                LOG.info("Webapp file =" + webapp_dir + ", webAppName = " + webContextName);
            }
            LOG.info("Adding webapp [" + webContextName + "] = path [" + webapp_dir + "] .....");
            Context webappCtx = server.addWebapp(webContextName, new File(webapp_dir).getAbsolutePath());
            webappCtx.init();
            LOG.info("Finished init of webapp [" + webContextName + "] = path [" + webapp_dir + "].");
        }
        catch (LifecycleException lce) {
            LOG.severe("Tomcat Server failed to start webapp:" + lce.toString());
            lce.printStackTrace();
        }
        if (servername.equalsIgnoreCase(ADMIN_SERVER_NAME)) {
            String keytab = this.getConfig(ADMIN_USER_KEYTAB);
            String principal = null;
            try {
                principal = SecureClientLogin.getPrincipal((String)this.getConfig(ADMIN_USER_PRINCIPAL), (String)hostName);
            }
            catch (IOException ignored) {
                LOG.warning("Failed to get ranger.admin.kerberos.principal. Reason: " + ignored.toString());
            }
            String nameRules = this.getConfig(ADMIN_NAME_RULES);
            if (nameRules == null || nameRules.length() == 0) {
                LOG.info("Name is empty. Setting Name Rule as 'DEFAULT'");
                nameRules = DEFAULT_NAME_RULE;
            }
            if (this.getConfig(AUTHENTICATION_TYPE) != null && this.getConfig(AUTHENTICATION_TYPE).trim().equalsIgnoreCase(AUTH_TYPE_KERBEROS) && SecureClientLogin.isKerberosCredentialExists((String)principal, (String)keytab)) {
                try {
                    LOG.info("Provided Kerberos Credential : Principal = " + principal + " and Keytab = " + keytab);
                    Subject sub = SecureClientLogin.loginUserFromKeytab((String)principal, (String)keytab, (String)nameRules);
                    Subject.doAs(sub, new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            LOG.info("Starting Server using kerberos credential");
                            EmbeddedServer.this.startServer(server);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    LOG.severe("Tomcat Server failed to start:" + e.toString());
                    e.printStackTrace();
                }
            } else {
                this.startServer(server);
            }
        } else {
            this.startServer(server);
        }
    }

    private void startServer(Tomcat server) {
        try {
            try {
                boolean solrBootstrapEnabled = Boolean.valueOf(this.getConfig(SOLR_BOOTSTRAP_ENABLED, "true"));
                if (solrBootstrapEnabled) {
                    String servername = this.getConfig("servername");
                    LOG.info("Server Name : " + servername);
                    if (servername.equalsIgnoreCase(ADMIN_SERVER_NAME)) {
                        SolrCollectionBootstrapper solrSetup = new SolrCollectionBootstrapper();
                        solrSetup.start();
                    }
                }
            }
            catch (Exception e) {
                LOG.severe("Error while setting solr " + e);
            }
            server.start();
            server.getServer().await();
            this.shutdownServer();
        }
        catch (LifecycleException e) {
            LOG.severe("Tomcat Server failed to start:" + e.toString());
            e.printStackTrace();
        }
        catch (Exception e) {
            LOG.severe("Tomcat Server failed to start:" + e.toString());
            e.printStackTrace();
        }
    }

    private String getKeystoreFile() {
        String keystoreFile = this.getConfig("ranger.service.https.attrib.keystore.file");
        if (keystoreFile == null || keystoreFile.trim().isEmpty()) {
            keystoreFile = this.getConfig("ranger.https.attrib.keystore.file");
        }
        return keystoreFile;
    }

    protected String getConfig(String key) {
        String value = this.serverConfigProperties.getProperty(key);
        if (value == null || value.trim().isEmpty()) {
            value = System.getProperty(key);
        }
        return value;
    }

    protected String getConfig(String key, String defaultValue) {
        String ret = this.getConfig(key);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }

    protected int getIntConfig(String key, int defaultValue) {
        int ret = defaultValue;
        String retStr = this.getConfig(key);
        try {
            if (retStr != null) {
                ret = Integer.parseInt(retStr);
            }
        }
        catch (Exception err) {
            LOG.warning(retStr + " can't be parsed to int. Reason: " + err.toString());
        }
        return ret;
    }

    public void shutdownServer() {
        int timeWaitForShutdownInSeconds = this.getIntConfig("service.waitTimeForForceShutdownInSeconds", 0);
        if (timeWaitForShutdownInSeconds > 0) {
            long endTime = System.currentTimeMillis() + (long)timeWaitForShutdownInSeconds * 1000L;
            LOG.info("Will wait for all threads to shutdown gracefully. Final shutdown Time: " + new Date(endTime));
            while (System.currentTimeMillis() < endTime) {
                int activeCount = Thread.activeCount();
                if (activeCount == 0) {
                    LOG.info("Number of active threads = " + activeCount + ".");
                    break;
                }
                LOG.info("Number of active threads = " + activeCount + ". Waiting for all threads to shutdown ...");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOG.warning("shutdownServer process is interrupted with exception: " + e);
                    break;
                }
            }
        }
        LOG.info("Shuting down the Server.");
        System.exit(0);
    }

    protected long getLongConfig(String key, long defaultValue) {
        long ret = defaultValue;
        String retStr = this.getConfig(key);
        try {
            if (retStr != null) {
                ret = Long.parseLong(retStr);
            }
        }
        catch (Exception err) {
            LOG.warning(retStr + " can't be parsed to long. Reason: " + err.toString());
        }
        return ret;
    }

    public void updateHttpConnectorAttribConfig(Tomcat server) {
        server.getConnector().setAllowTrace(Boolean.valueOf(this.getConfig("ranger.service.http.connector.attrib.allowTrace", "false")).booleanValue());
        server.getConnector().setAsyncTimeout(this.getLongConfig("ranger.service.http.connector.attrib.asyncTimeout", 10000L));
        server.getConnector().setEnableLookups(Boolean.valueOf(this.getConfig("ranger.service.http.connector.attrib.enableLookups", "false")).booleanValue());
        server.getConnector().setMaxHeaderCount(this.getIntConfig("ranger.service.http.connector.attrib.maxHeaderCount", 100));
        server.getConnector().setMaxParameterCount(this.getIntConfig("ranger.service.http.connector.attrib.maxParameterCount", 10000));
        server.getConnector().setMaxPostSize(this.getIntConfig("ranger.service.http.connector.attrib.maxPostSize", 0x200000));
        server.getConnector().setMaxSavePostSize(this.getIntConfig("ranger.service.http.connector.attrib.maxSavePostSize", 4096));
        server.getConnector().setParseBodyMethods(this.getConfig("ranger.service.http.connector.attrib.methods", "POST"));
        server.getConnector().setURIEncoding(this.getConfig("ranger.service.http.connector.attrib.URIEncoding", "UTF-8"));
        server.getConnector().setXpoweredBy(false);
        server.getConnector().setAttribute("server", (Object)"Apache Ranger");
        Iterator<Object> iterator = this.serverConfigProperties.keySet().iterator();
        String key = null;
        String property = null;
        while (iterator.hasNext()) {
            key = iterator.next().toString();
            if (key == null || !key.startsWith("ranger.service.http.connector.property.")) continue;
            property = key.replace("ranger.service.http.connector.property.", "");
            server.getConnector().setProperty(property, this.getConfig(key));
            LOG.info(property + ":" + server.getConnector().getProperty(property));
        }
    }

    public String getDecryptedString(String CrendentialProviderPath, String alias) {
        String credential = null;
        try {
            if (CrendentialProviderPath == null || alias == null || CrendentialProviderPath.trim().isEmpty() || alias.trim().isEmpty()) {
                return null;
            }
            char[] pass = null;
            Configuration conf = new Configuration();
            String crendentialProviderPrefixJceks = "jceks://file";
            String crendentialProviderPrefixLocalJceks = "localjceks://file";
            crendentialProviderPrefixJceks = crendentialProviderPrefixJceks.toLowerCase();
            CrendentialProviderPath = CrendentialProviderPath.trim();
            alias = alias.trim();
            if (CrendentialProviderPath.toLowerCase().startsWith(crendentialProviderPrefixJceks) || CrendentialProviderPath.toLowerCase().startsWith(crendentialProviderPrefixLocalJceks)) {
                conf.set("hadoop.security.credential.provider.path", CrendentialProviderPath);
            } else if (CrendentialProviderPath.startsWith("/")) {
                conf.set("hadoop.security.credential.provider.path", "jceks://file" + CrendentialProviderPath);
            } else {
                conf.set("hadoop.security.credential.provider.path", "jceks://file/" + CrendentialProviderPath);
            }
            List providers = CredentialProviderFactory.getProviders((Configuration)conf);
            CredentialProvider.CredentialEntry credEntry = null;
            for (CredentialProvider provider : providers) {
                List aliasesList = provider.getAliases();
                if (aliasesList == null || !aliasesList.contains(alias.toLowerCase())) continue;
                credEntry = null;
                credEntry = provider.getCredentialEntry(alias);
                pass = credEntry.getCredential();
                if (pass == null || pass.length <= 0) continue;
                credential = String.valueOf(pass);
                break;
            }
        }
        catch (Exception ex) {
            LOG.severe("CredentialReader failed while decrypting provided string. Reason: " + ex.toString());
            credential = null;
        }
        return credential;
    }

    private SSLContext getSSLContext() {
        KeyManager[] kmList = this.getKeyManagers();
        TrustManager[] tmList = this.getTrustManagers();
        SSLContext sslContext = null;
        if (tmList != null) {
            try {
                sslContext = SSLContext.getInstance(RANGER_SSL_CONTEXT_ALGO_TYPE);
                sslContext.init(kmList, tmList, new SecureRandom());
            }
            catch (NoSuchAlgorithmException e) {
                LOG.severe("SSL algorithm is not available in the environment. Reason: " + e.toString());
            }
            catch (KeyManagementException e) {
                LOG.severe("Unable to initials the SSLContext. Reason: " + e.toString());
            }
        }
        return sslContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] getKeyManagers() {
        KeyManager[] kmList = null;
        String keyStoreFile = this.getConfig("ranger.keystore.file");
        String keyStoreAlias = this.getConfig("ranger.keystore.alias", "keyStoreCredentialAlias");
        if (StringUtils.isBlank((String)keyStoreFile)) {
            keyStoreFile = this.getKeystoreFile();
            keyStoreAlias = this.getConfig("ranger.service.https.attrib.keystore.credential.alias", "keyStoreCredentialAlias");
        }
        String credentialProviderPath = this.getConfig("ranger.credential.provider.path");
        String keyStoreFilepwd = this.getCredential(credentialProviderPath, keyStoreAlias);
        if (StringUtils.isNotEmpty((String)keyStoreFile) && StringUtils.isNotEmpty((String)keyStoreFilepwd)) {
            InputStream in = null;
            try {
                in = this.getFileInputStream(keyStoreFile);
                if (in != null) {
                    KeyStore keyStore = KeyStore.getInstance("jks");
                    keyStore.load(in, keyStoreFilepwd.toCharArray());
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(RANGER_SSL_KEYMANAGER_ALGO_TYPE);
                    keyManagerFactory.init(keyStore, keyStoreFilepwd.toCharArray());
                    kmList = keyManagerFactory.getKeyManagers();
                }
                LOG.severe("Unable to obtain keystore from file [" + keyStoreFile + "]");
            }
            catch (KeyStoreException e) {
                LOG.log(Level.SEVERE, "Unable to obtain from KeyStore :" + e.getMessage(), e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.log(Level.SEVERE, "SSL algorithm is NOT available in the environment", e);
            }
            catch (CertificateException e) {
                LOG.log(Level.SEVERE, "Unable to obtain the requested certification ", e);
            }
            catch (FileNotFoundException e) {
                LOG.log(Level.SEVERE, "Unable to find the necessary SSL Keystore Files", e);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Unable to read the necessary SSL Keystore Files", e);
            }
            catch (UnrecoverableKeyException e) {
                LOG.log(Level.SEVERE, "Unable to recover the key from keystore", e);
            }
            finally {
                this.close(in, keyStoreFile);
            }
        } else if (StringUtils.isBlank((String)keyStoreFile)) {
            LOG.warning("Config 'ranger.keystore.file' or 'ranger.service.https.attrib.keystore.file' is not found or contains blank value");
        } else if (StringUtils.isBlank((String)keyStoreAlias)) {
            LOG.warning("Config 'ranger.keystore.alias' or 'ranger.service.https.attrib.keystore.credential.alias' is not found or contains blank value");
        } else if (StringUtils.isBlank((String)credentialProviderPath)) {
            LOG.warning("Config 'ranger.credential.provider.path' is not found or contains blank value");
        } else if (StringUtils.isBlank((String)keyStoreFilepwd)) {
            LOG.warning("Unable to read credential from credential store file [" + credentialProviderPath + "] for given alias:" + keyStoreAlias);
        }
        return kmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManager[] getTrustManagers() {
        TrustManager[] tmList = null;
        String truststoreFile = this.getConfig("ranger.truststore.file");
        String truststoreAlias = this.getConfig("ranger.truststore.alias");
        String credentialProviderPath = this.getConfig("ranger.credential.provider.path");
        String trustStoreFilepwd = this.getCredential(credentialProviderPath, truststoreAlias);
        if (StringUtils.isNotEmpty((String)truststoreFile) && StringUtils.isNotEmpty((String)trustStoreFilepwd)) {
            InputStream in = null;
            try {
                in = this.getFileInputStream(truststoreFile);
                if (in != null) {
                    KeyStore trustStore = KeyStore.getInstance("jks");
                    trustStore.load(in, trustStoreFilepwd.toCharArray());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(RANGER_SSL_TRUSTMANAGER_ALGO_TYPE);
                    trustManagerFactory.init(trustStore);
                    tmList = trustManagerFactory.getTrustManagers();
                }
                LOG.log(Level.SEVERE, "Unable to obtain truststore from file [" + truststoreFile + "]");
            }
            catch (KeyStoreException e) {
                LOG.log(Level.SEVERE, "Unable to obtain from KeyStore", e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.log(Level.SEVERE, "SSL algorithm is NOT available in the environment :" + e.getMessage(), e);
            }
            catch (CertificateException e) {
                LOG.log(Level.SEVERE, "Unable to obtain the requested certification :" + e.getMessage(), e);
            }
            catch (FileNotFoundException e) {
                LOG.log(Level.SEVERE, "Unable to find the necessary SSL TrustStore File:" + truststoreFile, e);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "Unable to read the necessary SSL TrustStore Files :" + truststoreFile, e);
            }
            finally {
                this.close(in, truststoreFile);
            }
        } else if (StringUtils.isBlank((String)truststoreFile)) {
            LOG.warning("Config 'ranger.truststore.file' is not found or contains blank value!");
        } else if (StringUtils.isBlank((String)truststoreAlias)) {
            LOG.warning("Config 'ranger.truststore.alias' is not found or contains blank value!");
        } else if (StringUtils.isBlank((String)credentialProviderPath)) {
            LOG.warning("Config 'ranger.credential.provider.path' is not found or contains blank value!");
        } else if (StringUtils.isBlank((String)trustStoreFilepwd)) {
            LOG.warning("Unable to read credential from credential store file [" + credentialProviderPath + "] for given alias:" + truststoreAlias);
        }
        return tmList;
    }

    private String getCredential(String url, String alias) {
        return RangerCredentialProvider.getInstance().getCredentialString(url, alias);
    }

    private InputStream getFileInputStream(String fileName) throws IOException {
        InputStream in = null;
        if (StringUtils.isNotEmpty((String)fileName)) {
            File f = new File(fileName);
            in = f.exists() ? new FileInputStream(f) : ClassLoader.getSystemResourceAsStream(fileName);
        }
        return in;
    }

    private void close(InputStream str, String filename) {
        if (str != null) {
            try {
                str.close();
            }
            catch (IOException excp) {
                LOG.log(Level.SEVERE, "Error while closing file: [" + filename + "]", excp);
            }
        }
    }
}

