/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.service;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.RangerRolesUtil;

public class RangerAuthContext {
    private final Map<RangerContextEnricher, Object> requestContextEnrichers;
    private RangerRolesUtil rolesUtil;

    public RangerAuthContext(Map<RangerContextEnricher, Object> requestContextEnrichers, RangerRoles roles) {
        this.requestContextEnrichers = requestContextEnrichers != null ? requestContextEnrichers : new ConcurrentHashMap();
        this.setRoles(roles);
    }

    @Deprecated
    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        RangerBasePlugin plugin = RangerBasePlugin.getInstance();
        RangerResourceACLs ret = plugin != null ? plugin.getResourceACLs(request) : new RangerResourceACLs();
        return ret;
    }

    public Map<RangerContextEnricher, Object> getRequestContextEnrichers() {
        return this.requestContextEnrichers;
    }

    public void addOrReplaceRequestContextEnricher(RangerContextEnricher enricher, Object database) {
        this.requestContextEnrichers.put(enricher, database != null ? database : enricher);
    }

    public void cleanupRequestContextEnricher(RangerContextEnricher enricher) {
        this.requestContextEnrichers.remove(enricher);
    }

    public void setRoles(RangerRoles roles) {
        this.rolesUtil = roles != null ? new RangerRolesUtil(roles) : new RangerRolesUtil(null);
    }

    public Set<String> getRolesForUserAndGroups(String user, Set<String> groups) {
        Object userRoles;
        RangerRolesUtil rolesUtil = this.rolesUtil;
        Map<String, Set<String>> userRoleMapping = rolesUtil.getUserRoleMapping();
        Map<String, Set<String>> groupRoleMapping = rolesUtil.getGroupRoleMapping();
        HashSet<String> allRoles = new HashSet<String>();
        if (MapUtils.isNotEmpty(userRoleMapping) && StringUtils.isNotEmpty((String)user) && CollectionUtils.isNotEmpty(userRoles = userRoleMapping.get(user))) {
            allRoles.addAll((Collection<String>)userRoles);
        }
        if (MapUtils.isNotEmpty(groupRoleMapping)) {
            Set<String> publicGroupRoles;
            if (CollectionUtils.isNotEmpty(groups)) {
                for (String group : groups) {
                    Set<String> groupRoles = groupRoleMapping.get(group);
                    if (!CollectionUtils.isNotEmpty(groupRoles)) continue;
                    allRoles.addAll(groupRoles);
                }
            }
            if (CollectionUtils.isNotEmpty(publicGroupRoles = groupRoleMapping.get("public"))) {
                allRoles.addAll(publicGroupRoles);
            }
        }
        return allRoles;
    }

    public long getRoleVersion() {
        return this.rolesUtil.getRoleVersion();
    }
}

