/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.PolicyEngine;
import org.apache.ranger.plugin.policyengine.PolicyEvaluatorForTag;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestProcessor;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyRepository;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyengine.RangerTagAccessRequest;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.service.RangerDefaultRequestProcessor;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerPolicyEngineImpl
implements RangerPolicyEngine {
    private static final Log LOG = LogFactory.getLog(RangerPolicyEngineImpl.class);
    private static final Log PERF_POLICYENGINE_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policyengine.request");
    private static final Log PERF_POLICYENGINE_AUDIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.audit");
    private static final Log PERF_POLICYENGINE_GET_ACLS_LOG = RangerPerfTracer.getPerfLogger("policyengine.getResourceACLs");
    private final PolicyEngine policyEngine;
    private final RangerAccessRequestProcessor requestProcessor;
    private final Set<String> svcCfgSuperUsers;
    private final Set<String> svcCfgSuperGroups;
    private Set<String> superUsers;
    private Set<String> superGroups;
    private boolean isEmptySupers = true;

    public static RangerPolicyEngine getPolicyEngine(RangerPolicyEngineImpl other, ServicePolicies servicePolicies) {
        PolicyEngine policyEngine;
        RangerPolicyEngineImpl ret = null;
        if (other != null && servicePolicies != null && (policyEngine = other.policyEngine.cloneWithDelta(servicePolicies)) != null) {
            ret = new RangerPolicyEngineImpl(policyEngine, other);
        }
        return ret;
    }

    public RangerPolicyEngineImpl(ServicePolicies servicePolicies, RangerPluginContext pluginContext, RangerRoles roles) {
        this(servicePolicies, pluginContext, roles, null, null);
    }

    public RangerPolicyEngineImpl(ServicePolicies servicePolicies, RangerPluginContext pluginContext, RangerRoles roles, Set<String> superUsers, Set<String> superGroups) {
        this.policyEngine = new PolicyEngine(servicePolicies, pluginContext, roles);
        this.policyEngine.getPluginContext().getAuthContext().setRoles(roles);
        this.requestProcessor = new RangerDefaultRequestProcessor(this.policyEngine);
        Map<String, String> svcConfig = servicePolicies.getServiceConfig();
        String cfgSuperUsers = null;
        String cfgSuperGroups = null;
        if (svcConfig != null) {
            cfgSuperUsers = svcConfig.get("ranger.plugin.super.users");
            cfgSuperGroups = svcConfig.get("ranger.plugin.super.groups");
        }
        this.svcCfgSuperUsers = StringUtils.isNotBlank(cfgSuperUsers) ? StringUtil.toSet(cfgSuperUsers) : Collections.emptySet();
        this.svcCfgSuperGroups = StringUtils.isNotBlank(cfgSuperGroups) ? StringUtil.toSet(cfgSuperGroups) : Collections.emptySet();
        this.setSuperUsersAndGroups(superUsers, superGroups);
    }

    public String toString() {
        return this.policyEngine.toString();
    }

    @Override
    public RangerAccessResult evaluatePolicies(RangerAccessRequest request, int policyType, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluatePolicies(" + request + ", policyType=" + policyType + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REQUEST_LOG)) {
            String requestHashCode = Integer.toHexString(System.identityHashCode(request)) + "_" + policyType;
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REQUEST_LOG, "RangerPolicyEngine.evaluatePolicies(requestHashCode=" + requestHashCode + ")");
            LOG.info((Object)("RangerPolicyEngineImpl.evaluatePolicies(" + requestHashCode + ", " + request + ")"));
        }
        this.requestProcessor.preProcess(request);
        RangerAccessResult ret = this.zoneAwareAccessEvaluationWithNoAudit(request, policyType);
        if (resultProcessor != null) {
            RangerPerfTracer perfAuditTracer = null;
            if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_AUDIT_LOG)) {
                String requestHashCode = Integer.toHexString(System.identityHashCode(request)) + "_" + policyType;
                perfAuditTracer = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_AUDIT_LOG, "RangerPolicyEngine.processAudit(requestHashCode=" + requestHashCode + ")");
            }
            resultProcessor.processResult(ret);
            RangerPerfTracer.log(perfAuditTracer);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluatePolicies(" + request + ", policyType=" + policyType + "): " + ret));
        }
        return ret;
    }

    @Override
    public Collection<RangerAccessResult> evaluatePolicies(Collection<RangerAccessRequest> requests, int policyType, RangerAccessResultProcessor resultProcessor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluatePolicies(" + requests + ", policyType=" + policyType + ")"));
        }
        ArrayList<RangerAccessResult> ret = new ArrayList<RangerAccessResult>();
        if (requests != null) {
            for (RangerAccessRequest request : requests) {
                this.requestProcessor.preProcess(request);
                RangerAccessResult result = this.zoneAwareAccessEvaluationWithNoAudit(request, policyType);
                ret.add(result);
            }
        }
        if (resultProcessor != null) {
            resultProcessor.processResults(ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluatePolicies(" + requests + ", policyType=" + policyType + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerResourceACLs getResourceACLs(RangerAccessRequest request) {
        RangerPolicyRepository matchedRepository;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getResourceACLs(request=" + request + ")"));
        }
        RangerResourceACLs ret = new RangerResourceACLs();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_GET_ACLS_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_GET_ACLS_LOG, "RangerPolicyEngine.getResourceACLs(requestHashCode=" + request.getResource().getAsString() + ")");
        }
        this.requestProcessor.preProcess(request);
        String zoneName = this.policyEngine.getMatchedZoneName(request.getResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        if ((matchedRepository = StringUtils.isNotEmpty((String)zoneName) ? this.policyEngine.getZonePolicyRepositories().get(zoneName) : this.policyEngine.getPolicyRepository()) == null) {
            LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "],  serviceName:[" + this.policyEngine.getPolicyRepository().getServiceName() + "], policyVersion:[" + this.getPolicyVersion() + "] is null!! ERROR!"));
        } else {
            List<PolicyEvaluatorForTag> tagPolicyEvaluators;
            ArrayList<RangerPolicyEvaluator> allEvaluators = new ArrayList<RangerPolicyEvaluator>();
            HashMap<Long, RangerPolicyResourceMatcher.MatchType> tagMatchTypeMap = null;
            HashSet<Long> policyIdForTemporalTags = null;
            Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
            List<PolicyEvaluatorForTag> list = tagPolicyEvaluators = this.policyEngine.getTagPolicyRepository() == null ? null : this.policyEngine.getTagPolicyRepository().getLikelyMatchPolicyEvaluators(tags, 0, null);
            if (CollectionUtils.isNotEmpty(tagPolicyEvaluators)) {
                tagMatchTypeMap = new HashMap<Long, RangerPolicyResourceMatcher.MatchType>();
                boolean useTagPoliciesFromDefaultZone = !this.policyEngine.isResourceZoneAssociatedWithTagService(zoneName);
                for (PolicyEvaluatorForTag tagEvaluator : tagPolicyEvaluators) {
                    RangerPolicyEvaluator evaluator = tagEvaluator.getEvaluator();
                    String policyZoneName = evaluator.getPolicy().getZoneName();
                    if (useTagPoliciesFromDefaultZone) {
                        if (StringUtils.isNotEmpty((String)policyZoneName)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to default zone. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                            continue;
                        }
                    } else if (!StringUtils.equals((String)zoneName, (String)policyZoneName)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to the zone:[" + zoneName + "] of the accessed resource. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                        continue;
                    }
                    RangerTagForEval tag = tagEvaluator.getTag();
                    allEvaluators.add(evaluator);
                    tagMatchTypeMap.put(evaluator.getId(), tag.getMatchType());
                    if (!CollectionUtils.isNotEmpty(tag.getValidityPeriods())) continue;
                    if (policyIdForTemporalTags == null) {
                        policyIdForTemporalTags = new HashSet<Long>();
                    }
                    policyIdForTemporalTags.add(evaluator.getId());
                }
            }
            List<RangerPolicyEvaluator> resourcePolicyEvaluators = matchedRepository.getLikelyMatchPolicyEvaluators(request.getResource(), 0);
            allEvaluators.addAll(resourcePolicyEvaluators);
            allEvaluators.sort(RangerPolicyEvaluator.EVAL_ORDER_COMPARATOR);
            if (CollectionUtils.isNotEmpty(allEvaluators)) {
                Integer policyPriority = null;
                for (RangerPolicyEvaluator evaluator : allEvaluators) {
                    RangerPolicy policy;
                    Integer accessResult;
                    RangerPolicyEvaluator.PolicyACLSummary aclSummary;
                    boolean isMatched;
                    RangerPolicyResourceMatcher.MatchType matchType;
                    if (policyPriority == null) {
                        policyPriority = evaluator.getPolicyPriority();
                    }
                    if (policyPriority.intValue() != evaluator.getPolicyPriority()) {
                        ret.finalizeAcls();
                        policyPriority = evaluator.getPolicyPriority();
                    }
                    RangerPolicyResourceMatcher.MatchType matchType2 = matchType = tagMatchTypeMap != null ? (RangerPolicyResourceMatcher.MatchType)((Object)tagMatchTypeMap.get(evaluator.getId())) : null;
                    if (matchType == null) {
                        matchType = evaluator.getPolicyResourceMatcher().getMatchType(request.getResource(), request.getContext());
                    }
                    if (request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS) {
                        isMatched = matchType != RangerPolicyResourceMatcher.MatchType.NONE;
                    } else {
                        boolean bl = isMatched = matchType == RangerPolicyResourceMatcher.MatchType.SELF || matchType == RangerPolicyResourceMatcher.MatchType.SELF_AND_ALL_DESCENDANTS;
                    }
                    if (!isMatched || (aclSummary = evaluator.getPolicyACLSummary()) == null) continue;
                    boolean isConditional = policyIdForTemporalTags != null && policyIdForTemporalTags.contains(evaluator.getId()) || evaluator.getValidityScheduleEvaluatorsCount() != 0;
                    for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> userAccessInfo : aclSummary.getUsersAccessInfo().entrySet()) {
                        String userName = userAccessInfo.getKey();
                        for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : userAccessInfo.getValue().entrySet()) {
                            if (isConditional) {
                                accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                            } else {
                                accessResult = accessInfo.getValue().getResult();
                                if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                    accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                                }
                            }
                            policy = evaluator.getPolicy();
                            ret.setUserAccessInfo(userName, accessInfo.getKey(), accessResult, policy);
                        }
                    }
                    for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> groupAccessInfo : aclSummary.getGroupsAccessInfo().entrySet()) {
                        String groupName = groupAccessInfo.getKey();
                        for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : groupAccessInfo.getValue().entrySet()) {
                            if (isConditional) {
                                accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                            } else {
                                accessResult = accessInfo.getValue().getResult();
                                if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                    accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                                }
                            }
                            policy = evaluator.getPolicy();
                            ret.setGroupAccessInfo(groupName, accessInfo.getKey(), accessResult, policy);
                        }
                    }
                    for (Map.Entry<String, Map<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult>> roleAccessInfo : aclSummary.getRolesAccessInfo().entrySet()) {
                        String roleName = roleAccessInfo.getKey();
                        for (Map.Entry<String, RangerPolicyEvaluator.PolicyACLSummary.AccessResult> accessInfo : roleAccessInfo.getValue().entrySet()) {
                            if (isConditional) {
                                accessResult = RangerPolicyEvaluator.ACCESS_CONDITIONAL;
                            } else {
                                accessResult = accessInfo.getValue().getResult();
                                if (accessResult.equals(RangerPolicyEvaluator.ACCESS_UNDETERMINED)) {
                                    accessResult = RangerPolicyEvaluator.ACCESS_DENIED;
                                }
                            }
                            policy = evaluator.getPolicy();
                            ret.setRoleAccessInfo(roleName, accessInfo.getKey(), accessResult, policy);
                        }
                    }
                }
                ret.finalizeAcls();
            }
        }
        RangerPerfTracer.logAlways(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getResourceACLs(request=" + request + ") : ret=" + ret));
        }
        return ret;
    }

    PolicyEngine getPolicyEngine() {
        return this.policyEngine;
    }

    @Override
    public RangerResourceAccessInfo getResourceAccessInfo(RangerAccessRequest request) {
        RangerPolicyRepository matchedRepository;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getResourceAccessInfo(" + request + ")"));
        }
        this.requestProcessor.preProcess(request);
        RangerResourceAccessInfo ret = new RangerResourceAccessInfo(request);
        String zoneName = this.policyEngine.getMatchedZoneName(request.getResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        if ((matchedRepository = StringUtils.isNotEmpty((String)zoneName) ? this.policyEngine.getZonePolicyRepositories().get(zoneName) : this.policyEngine.getPolicyRepository()) == null) {
            LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "],  serviceName:[" + this.policyEngine.getPolicyRepository().getServiceName() + "], policyVersion:[" + this.getPolicyVersion() + "] is null!! ERROR!"));
        } else {
            List<RangerPolicyEvaluator> resPolicyEvaluators;
            Set<RangerTagForEval> tags;
            List<RangerPolicyEvaluator> tagPolicyEvaluators;
            List<RangerPolicyEvaluator> list = tagPolicyEvaluators = this.policyEngine.getTagPolicyRepository() == null ? null : this.policyEngine.getTagPolicyRepository().getPolicyEvaluators();
            if (CollectionUtils.isNotEmpty(tagPolicyEvaluators) && CollectionUtils.isNotEmpty(tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext()))) {
                boolean useTagPoliciesFromDefaultZone = !this.policyEngine.isResourceZoneAssociatedWithTagService(zoneName);
                for (RangerTagForEval tag : tags) {
                    RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, this.policyEngine.getTagPolicyRepository().getServiceDef(), request);
                    List<RangerPolicyEvaluator> evaluators = this.policyEngine.getTagPolicyRepository().getLikelyMatchPolicyEvaluators(tagEvalRequest.getResource(), 0);
                    for (RangerPolicyEvaluator evaluator : evaluators) {
                        String policyZoneName = evaluator.getPolicy().getZoneName();
                        if (useTagPoliciesFromDefaultZone) {
                            if (StringUtils.isNotEmpty((String)policyZoneName)) {
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to default zone. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                                continue;
                            }
                        } else if (!StringUtils.equals((String)zoneName, (String)policyZoneName)) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to the zone:[" + zoneName + "] of the accessed resource. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                            continue;
                        }
                        evaluator.getResourceAccessInfo(tagEvalRequest, ret);
                    }
                }
            }
            if (CollectionUtils.isNotEmpty(resPolicyEvaluators = matchedRepository.getLikelyMatchPolicyEvaluators(request.getResource(), 0))) {
                for (RangerPolicyEvaluator evaluator : resPolicyEvaluators) {
                    evaluator.getResourceAccessInfo(request, ret);
                }
            }
            ret.getAllowedUsers().removeAll(ret.getDeniedUsers());
            ret.getAllowedGroups().removeAll(ret.getDeniedGroups());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getResourceAccessInfo(" + request + "): " + ret));
        }
        return ret;
    }

    @Override
    public String getMatchedZoneName(GrantRevokeRequest grantRevokeRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.getMatchedZoneName(" + grantRevokeRequest + ")"));
        }
        String ret = this.policyEngine.getMatchedZoneName(grantRevokeRequest.getResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.getMatchedZoneName(" + grantRevokeRequest + ") : " + ret));
        }
        return ret;
    }

    @Override
    public void setUseForwardedIPAddress(boolean useForwardedIPAddress) {
        this.policyEngine.setUseForwardedIPAddress(useForwardedIPAddress);
    }

    @Override
    public void setTrustedProxyAddresses(String[] trustedProxyAddresses) {
        this.policyEngine.setTrustedProxyAddresses(trustedProxyAddresses);
    }

    @Override
    public void setSuperUsersAndGroups(Set<String> users, Set<String> groups) {
        this.superUsers = users == null ? Collections.emptySet() : users;
        this.superGroups = groups == null ? Collections.emptySet() : groups;
        this.isEmptySupers = CollectionUtils.isEmpty(this.superUsers) && CollectionUtils.isEmpty(this.svcCfgSuperUsers) && CollectionUtils.isEmpty(this.superGroups) && CollectionUtils.isEmpty(this.svcCfgSuperGroups);
    }

    @Override
    public boolean isSuperUser(String userName, Set<String> userGroups) {
        return !this.isEmptySupers && (this.superUsers.contains(userName) || this.svcCfgSuperUsers.contains(userName) || CollectionUtils.containsAny(this.superGroups, userGroups) || CollectionUtils.containsAny(this.svcCfgSuperGroups, userGroups));
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.policyEngine.getServiceDef();
    }

    @Override
    public long getPolicyVersion() {
        return this.policyEngine.getPolicyVersion();
    }

    @Override
    public long getRoleVersion() {
        return this.policyEngine.getRoleVersion();
    }

    @Override
    public void setRoles(RangerRoles roles) {
        this.policyEngine.setRoles(roles);
    }

    @Override
    public Set<String> getRolesFromUserAndGroups(String user, Set<String> groups) {
        return this.policyEngine.getPluginContext().getAuthContext().getRolesForUserAndGroups(user, groups);
    }

    @Override
    public List<RangerPolicy> getResourcePolicies(String zoneName) {
        return this.policyEngine.getResourcePolicies(zoneName);
    }

    @Override
    public List<RangerPolicy> getResourcePolicies() {
        RangerPolicyRepository policyRepository = this.policyEngine.getPolicyRepository();
        return policyRepository == null ? ListUtils.EMPTY_LIST : policyRepository.getPolicies();
    }

    @Override
    public List<RangerPolicy> getTagPolicies() {
        RangerPolicyRepository tagPolicyRepository = this.policyEngine.getTagPolicyRepository();
        return tagPolicyRepository == null ? ListUtils.EMPTY_LIST : tagPolicyRepository.getPolicies();
    }

    public void releaseResources() {
        PolicyEngine policyEngine;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPolicyEngineImpl.releaseResources()");
        }
        if ((policyEngine = this.policyEngine) != null) {
            policyEngine.preCleanup();
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Cannot preCleanup policy-engine as it is null!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPolicyEngineImpl.releaseResources()");
        }
    }

    private RangerPolicyEngineImpl(PolicyEngine policyEngine, RangerPolicyEngineImpl other) {
        this.policyEngine = policyEngine;
        this.requestProcessor = new RangerDefaultRequestProcessor(policyEngine);
        this.svcCfgSuperUsers = new HashSet<String>(other.svcCfgSuperUsers);
        this.svcCfgSuperGroups = new HashSet<String>(other.svcCfgSuperGroups);
        this.superUsers = new HashSet<String>(other.superUsers);
        this.superGroups = new HashSet<String>(other.superGroups);
    }

    private RangerAccessResult zoneAwareAccessEvaluationWithNoAudit(RangerAccessRequest request, int policyType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.zoneAwareAccessEvaluationWithNoAudit(" + request + ", policyType =" + policyType + ")"));
        }
        RangerAccessResult ret = null;
        RangerPolicyRepository policyRepository = this.policyEngine.getPolicyRepository();
        RangerPolicyRepository tagPolicyRepository = this.policyEngine.getTagPolicyRepository();
        String zoneName = this.policyEngine.getMatchedZoneName(request.getResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("zoneName:[" + zoneName + "]"));
        }
        if (StringUtils.isNotEmpty((String)zoneName) && (policyRepository = this.policyEngine.getZonePolicyRepositories().get(zoneName)) == null) {
            LOG.error((Object)("policyRepository for zoneName:[" + zoneName + "],  serviceName:[" + this.policyEngine.getPolicyRepository().getServiceName() + "], policyVersion:[" + this.getPolicyVersion() + "] is null!! ERROR!"));
        }
        if (policyRepository != null) {
            ret = this.evaluatePoliciesNoAudit(request, policyType, zoneName, policyRepository, tagPolicyRepository);
            ret.setZoneName(zoneName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.zoneAwareAccessEvaluationWithNoAudit(" + request + ", policyType =" + policyType + "): " + ret));
        }
        return ret;
    }

    private RangerAccessResult evaluatePoliciesNoAudit(RangerAccessRequest request, int policyType, String zoneName, RangerPolicyRepository policyRepository, RangerPolicyRepository tagPolicyRepository) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluatePoliciesNoAudit(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + ")"));
        }
        Date accessTime = request.getAccessTime() != null ? request.getAccessTime() : new Date();
        RangerAccessResult ret = this.policyEngine.createAccessResult(request, policyType);
        boolean isSuperUser = this.isSuperUser(request.getUser(), request.getUserGroups());
        if (isSuperUser) {
            ret.setIsAllowed(true);
            ret.setIsAccessDetermined(true);
            ret.setPolicyId(-1L);
            ret.setPolicyPriority(Integer.MAX_VALUE);
            ret.setReason("superuser");
        }
        this.evaluateTagPolicies(request, policyType, zoneName, tagPolicyRepository, ret);
        if (LOG.isDebugEnabled() && ret.getIsAccessDetermined() && ret.getIsAuditedDetermined()) {
            if (!ret.getIsAllowed()) {
                LOG.debug((Object)("RangerPolicyEngineImpl.evaluatePoliciesNoAudit() - audit determined and access denied by a tag policy. Higher priority resource policies will be evaluated to check for allow, request=" + request + ", result=" + ret));
            } else {
                LOG.debug((Object)("RangerPolicyEngineImpl.evaluatePoliciesNoAudit() - audit determined and access allowed by a tag policy. Same or higher priority resource policies will be evaluated to check for deny, request=" + request + ", result=" + ret));
            }
        }
        boolean isAllowedByTags = ret.getIsAccessDetermined() && ret.getIsAllowed();
        boolean isDeniedByTags = ret.getIsAccessDetermined() && !ret.getIsAllowed();
        boolean evaluateResourcePolicies = this.policyEngine.hasResourcePolicies(policyRepository);
        if (evaluateResourcePolicies) {
            boolean foundInCache;
            boolean findAuditByResource = !ret.getIsAuditedDetermined();
            boolean bl = foundInCache = findAuditByResource && policyRepository.setAuditEnabledFromCache(request, ret);
            if (!isSuperUser) {
                ret.setIsAccessDetermined(false);
            }
            List<RangerPolicyEvaluator> evaluators = policyRepository.getLikelyMatchPolicyEvaluators(request.getResource(), policyType);
            for (RangerPolicyEvaluator evaluator : evaluators) {
                if (!evaluator.isApplicable(accessTime)) continue;
                if (isDeniedByTags) {
                    if (ret.getPolicyPriority() >= evaluator.getPolicyPriority()) {
                        ret.setIsAccessDetermined(true);
                    }
                } else if (isAllowedByTags && ret.getPolicyPriority() > evaluator.getPolicyPriority()) {
                    ret.setIsAccessDetermined(true);
                }
                ret.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(request, ret);
                if (ret.getIsAllowed() && !evaluator.hasDeny()) {
                    ret.setIsAccessDetermined(true);
                }
                if (!ret.getIsAuditedDetermined() || !ret.getIsAccessDetermined()) continue;
                break;
            }
            if (!ret.getIsAccessDetermined()) {
                if (isDeniedByTags) {
                    ret.setIsAllowed(false);
                } else if (isAllowedByTags) {
                    ret.setIsAllowed(true);
                }
            }
            if (ret.getIsAllowed()) {
                ret.setIsAccessDetermined(true);
            }
            if (findAuditByResource && !foundInCache) {
                policyRepository.storeAuditEnabledInCache(request, ret);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluatePoliciesNoAudit(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + "): " + ret));
        }
        return ret;
    }

    private void evaluateTagPolicies(RangerAccessRequest request, int policyType, String zoneName, RangerPolicyRepository tagPolicyRepository, RangerAccessResult result) {
        List<PolicyEvaluatorForTag> policyEvaluators;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyEngineImpl.evaluateTagPolicies(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + ", " + result + ")"));
        }
        Date accessTime = request.getAccessTime() != null ? request.getAccessTime() : new Date();
        Set<RangerTagForEval> tags = RangerAccessRequestUtil.getRequestTagsFromContext(request.getContext());
        List<PolicyEvaluatorForTag> list = policyEvaluators = tagPolicyRepository == null ? null : tagPolicyRepository.getLikelyMatchPolicyEvaluators(tags, policyType, accessTime);
        if (CollectionUtils.isNotEmpty(policyEvaluators)) {
            boolean useTagPoliciesFromDefaultZone = !this.policyEngine.isResourceZoneAssociatedWithTagService(zoneName);
            for (PolicyEvaluatorForTag policyEvaluator : policyEvaluators) {
                RangerPolicyEvaluator evaluator = policyEvaluator.getEvaluator();
                String policyZoneName = evaluator.getPolicy().getZoneName();
                if (useTagPoliciesFromDefaultZone) {
                    if (StringUtils.isNotEmpty((String)policyZoneName)) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to default zone. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                        continue;
                    }
                } else if (!StringUtils.equals((String)zoneName, (String)policyZoneName)) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Tag policy [zone:" + policyZoneName + "] does not belong to the zone:[" + zoneName + "] of the accessed resource. Not evaluating this policy:[" + evaluator.getPolicy() + "]"));
                    continue;
                }
                RangerTagForEval tag = policyEvaluator.getTag();
                RangerTagAccessRequest tagEvalRequest = new RangerTagAccessRequest(tag, tagPolicyRepository.getServiceDef(), request);
                RangerAccessResult tagEvalResult = this.policyEngine.createAccessResult(tagEvalRequest, policyType);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerPolicyEngineImpl.evaluateTagPolicies: Evaluating policies for tag (" + tag.getType() + ")"));
                }
                tagEvalResult.setAccessResultFrom(result);
                tagEvalResult.setAuditResultFrom(result);
                result.incrementEvaluatedPoliciesCount();
                evaluator.evaluate(tagEvalRequest, tagEvalResult);
                if (tagEvalResult.getIsAllowed() && !evaluator.hasDeny()) {
                    tagEvalResult.setIsAccessDetermined(true);
                }
                if (tagEvalResult.getIsAudited()) {
                    result.setAuditResultFrom(tagEvalResult);
                }
                if (!result.getIsAccessDetermined()) {
                    if (tagEvalResult.getIsAccessDetermined()) {
                        result.setAccessResultFrom(tagEvalResult);
                    } else if (!result.getIsAllowed() && tagEvalResult.getIsAllowed()) {
                        result.setAccessResultFrom(tagEvalResult);
                    }
                }
                if (!result.getIsAuditedDetermined() || !result.getIsAccessDetermined()) continue;
                break;
            }
        }
        if (result.getIsAllowed()) {
            result.setIsAccessDetermined(true);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyEngineImpl.evaluateTagPolicies(" + request + ", policyType =" + policyType + ", zoneName=" + zoneName + ", " + result + ")"));
        }
    }
}

