/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidationFailureDetails {
    private static final Log LOG = LogFactory.getLog(ValidationFailureDetails.class);
    final String _fieldName;
    final String _subFieldName;
    final boolean _missing;
    final boolean _semanticError;
    final boolean _internalError;
    final String _reason;
    final int _errorCode;

    public ValidationFailureDetails(int errorCode, String fieldName, String subFieldName, boolean missing, boolean semanticError, boolean internalError, String reason) {
        this._errorCode = errorCode;
        this._missing = missing;
        this._semanticError = semanticError;
        this._internalError = internalError;
        this._fieldName = fieldName;
        this._subFieldName = subFieldName;
        this._reason = reason;
    }

    public String getFieldName() {
        return this._fieldName;
    }

    public boolean isMissingRequiredValue() {
        return this._missing;
    }

    public boolean isSemanticallyIncorrect() {
        return this._semanticError;
    }

    String getType() {
        if (this._missing) {
            return "missing";
        }
        if (this._semanticError) {
            return "semantically incorrect";
        }
        if (this._internalError) {
            return "internal error";
        }
        return "";
    }

    public String getSubFieldName() {
        return this._subFieldName;
    }

    public String toString() {
        LOG.debug((Object)"ValidationFailureDetails.toString()");
        return String.format(" %s: error code[%d], reason[%s], field[%s], subfield[%s], type[%s]", "Validation failure", this._errorCode, this._reason, this._fieldName, this._subFieldName, this.getType());
    }

    public int hashCode() {
        return Objects.hash(this._fieldName, this._subFieldName, this._missing, this._semanticError, this._internalError, this._reason, this._errorCode);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ValidationFailureDetails)) {
            return false;
        }
        ValidationFailureDetails that = (ValidationFailureDetails)obj;
        return Objects.equals(this._fieldName, that._fieldName) && Objects.equals(this._subFieldName, that._subFieldName) && Objects.equals(this._reason, that._reason) && this._internalError == that._internalError && this._missing == that._missing && this._semanticError == that._semanticError && this._errorCode == that._errorCode;
    }
}

