/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerSecurityZone;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.model.validation.RangerValidator;
import org.apache.ranger.plugin.model.validation.RangerZoneResourceMatcher;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetailsBuilder;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerResourceTrie;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.store.SecurityZoneStore;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.SearchFilter;

public class RangerSecurityZoneValidator
extends RangerValidator {
    private static final Log LOG = LogFactory.getLog(RangerSecurityZoneValidator.class);
    private final SecurityZoneStore securityZoneStore;

    public RangerSecurityZoneValidator(ServiceStore store, SecurityZoneStore securityZoneStore) {
        super(store);
        this.securityZoneStore = securityZoneStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(RangerSecurityZone securityZone, RangerValidator.Action action) throws Exception {
        block5: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("==> RangerPolicyValidator.validate(%s, %s)", new Object[]{securityZone, action}));
            }
            ArrayList<ValidationFailureDetails> failures = new ArrayList<ValidationFailureDetails>();
            boolean valid = this.isValid(securityZone, action, failures);
            try {
                if (valid) break block5;
                String message = RangerSecurityZoneValidator.serializeFailures(failures);
                throw new Exception(message);
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("<== RangerPolicyValidator.validate(%s, %s)", new Object[]{securityZone, action}));
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.validate(%s, %s)", new Object[]{securityZone, action}));
        }
    }

    @Override
    boolean isValid(String name, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", new Object[]{name, action, failures}));
        }
        boolean ret = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            ret = false;
        } else if (StringUtils.isEmpty((String)name)) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone name was null/missing").field("name").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("name")).build());
            ret = false;
        } else if (this.getSecurityZone(name) == null) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_ZONE_ID;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone does not exist").field("name").errorCode(error.getErrorCode()).becauseOf(error.getMessage(name)).build());
            ret = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s) : %s", new Object[]{name, action, failures, ret}));
        }
        return ret;
    }

    @Override
    boolean isValid(Long id, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", new Object[]{id, action, failures}));
        }
        boolean ret = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            ret = false;
        } else if (id == null) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone id was null/missing").field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("id")).build());
            ret = false;
        } else if (this.getSecurityZone(id) == null) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_ZONE_ID;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone id does not exist").field("id").errorCode(error.getErrorCode()).becauseOf(error.getMessage(id)).build());
            ret = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s) : %s", new Object[]{id, action, failures, ret}));
        }
        return ret;
    }

    boolean isValid(RangerSecurityZone securityZone, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        ValidationErrorCode error;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", new Object[]{securityZone, action, failures}));
        }
        if (action != RangerValidator.Action.CREATE && action != RangerValidator.Action.UPDATE) {
            throw new IllegalArgumentException("isValid(RangerPolicy, ...) is only supported for create/update");
        }
        boolean ret = true;
        String zoneName = securityZone.getName();
        if (StringUtils.isEmpty((String)StringUtils.trim((String)zoneName))) {
            error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone name was null/missing").field("name").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("name")).build());
            ret = false;
        }
        if (action == RangerValidator.Action.CREATE) {
            securityZone.setId(-1L);
            RangerSecurityZone existingZone = this.getSecurityZone(zoneName);
            if (existingZone != null) {
                error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_ZONE_NAME_CONFLICT;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone name exists").field("name").errorCode(error.getErrorCode()).becauseOf(error.getMessage(existingZone.getId())).build());
                ret = false;
            }
        } else {
            Long zoneId = securityZone.getId();
            RangerSecurityZone existingZone = this.getSecurityZone(zoneId);
            if (existingZone == null) {
                ValidationErrorCode error2 = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_ZONE_ID;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone with id does not exist").field("id").errorCode(error2.getErrorCode()).becauseOf(error2.getMessage(zoneId)).build());
                ret = false;
            } else if (StringUtils.isNotEmpty((String)StringUtils.trim((String)zoneName)) && !StringUtils.equals((String)zoneName, (String)existingZone.getName()) && (existingZone = this.getSecurityZone(zoneName)) != null && !StringUtils.equals((String)existingZone.getName(), (String)zoneName)) {
                ValidationErrorCode error3 = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_ZONE_NAME_CONFLICT;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone name").field("name").errorCode(error3.getErrorCode()).becauseOf(error3.getMessage(existingZone.getId())).build());
                ret = false;
            }
        }
        ret = ret && this.validateWithinSecurityZone(securityZone, action, failures);
        boolean bl = ret = ret && this.validateAgainstAllSecurityZones(securityZone, action, failures);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s) : %s", new Object[]{securityZone, action, failures, ret}));
        }
        return ret;
    }

    private boolean validateWithinSecurityZone(RangerSecurityZone securityZone, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        ValidationErrorCode error;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.validateWithinSecurityZone(%s, %s, %s)", new Object[]{securityZone, action, failures}));
        }
        boolean ret = true;
        if (MapUtils.isNotEmpty(securityZone.getServices())) {
            for (Map.Entry<String, RangerSecurityZone.RangerSecurityZoneService> serviceSpecification : securityZone.getServices().entrySet()) {
                String serviceName = serviceSpecification.getKey();
                RangerSecurityZone.RangerSecurityZoneService rangerSecurityZoneService = serviceSpecification.getValue();
                ret = ret && this.validateSecurityZoneService(serviceName, rangerSecurityZoneService, failures);
            }
        } else {
            error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_SERVICES;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("security zone services").isMissing().field("services").errorCode(error.getErrorCode()).becauseOf(error.getMessage(securityZone.getName())).build());
            ret = false;
        }
        if (CollectionUtils.isEmpty(securityZone.getAdminUsers()) && CollectionUtils.isEmpty(securityZone.getAdminUserGroups())) {
            error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_USER_AND_GROUPS;
            failures.add(new ValidationFailureDetailsBuilder().field("security zone admin users/user-groups").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            ret = false;
        }
        if (CollectionUtils.isEmpty(securityZone.getAuditUsers()) && CollectionUtils.isEmpty(securityZone.getAuditUserGroups())) {
            error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_USER_AND_GROUPS;
            failures.add(new ValidationFailureDetailsBuilder().field("security zone audit users/user-groups").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            ret = false;
        }
        if (securityZone.getServices() != null) {
            for (Map.Entry<String, RangerSecurityZone.RangerSecurityZoneService> serviceResouceMapEntry : securityZone.getServices().entrySet()) {
                if (serviceResouceMapEntry.getValue().getResources() == null) continue;
                for (Map map : serviceResouceMapEntry.getValue().getResources()) {
                    if (map == null) continue;
                    for (Map.Entry entry : map.entrySet()) {
                        if (!CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
                        ValidationErrorCode error2 = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_RESOURCES;
                        failures.add(new ValidationFailureDetailsBuilder().field("security zone resources").subField("resources").isMissing().becauseOf(error2.getMessage(serviceResouceMapEntry.getKey())).errorCode(error2.getErrorCode()).build());
                        ret = false;
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.validateWithinSecurityZone(%s, %s, %s) : %s", new Object[]{securityZone, action, failures, ret}));
        }
        return ret;
    }

    private boolean validateAgainstAllSecurityZones(RangerSecurityZone securityZone, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        String zoneName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.validateAgainstAllSecurityZones(%s, %s, %s)", new Object[]{securityZone, action, failures}));
        }
        boolean ret = true;
        if (securityZone.getId() != -1L) {
            RangerSecurityZone existingZone = this.getSecurityZone(securityZone.getId());
            zoneName = existingZone.getName();
        } else {
            zoneName = securityZone.getName();
        }
        for (Map.Entry<String, RangerSecurityZone.RangerSecurityZoneService> entry : securityZone.getServices().entrySet()) {
            RangerServiceDef serviceDef;
            String serviceName = entry.getKey();
            RangerSecurityZone.RangerSecurityZoneService serviceResources = entry.getValue();
            if (!CollectionUtils.isNotEmpty(serviceResources.getResources())) continue;
            SearchFilter filter = new SearchFilter();
            List<RangerSecurityZone> zones = null;
            filter.setParam("serviceName", serviceName);
            filter.setParam("zoneName", zoneName);
            try {
                zones = this.securityZoneStore.getSecurityZones(filter);
            }
            catch (Exception excp) {
                LOG.error((Object)"Failed to get Security-Zones", (Throwable)excp);
                ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INTERNAL_ERROR;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf(error.getMessage(excp.getMessage())).errorCode(error.getErrorCode()).build());
                ret = false;
            }
            if (!CollectionUtils.isNotEmpty(zones)) continue;
            RangerService service = this.getService(serviceName);
            RangerServiceDef rangerServiceDef = serviceDef = service != null ? this.getServiceDef(service.getType()) : null;
            if (serviceDef == null) {
                ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INTERNAL_ERROR;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf(error.getMessage(serviceName)).errorCode(error.getErrorCode()).build());
                ret = false;
                continue;
            }
            zones.add(securityZone);
            ret = ret && this.validateZoneServiceInAllZones(zones, serviceName, serviceDef, failures);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.validateAgainstAllSecurityZones(%s, %s, %s) : %s", new Object[]{securityZone, action, failures, ret}));
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private boolean validateZoneServiceInAllZones(List<RangerSecurityZone> zones, String serviceName, RangerServiceDef serviceDef, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.validateZoneServiceInAllZones(%s, %s, %s, %s)", zones, serviceName, serviceDef, failures));
        }
        boolean ret = true;
        HashMap matchersForResourceDef = new HashMap();
        for (RangerSecurityZone zone : zones) {
            List<HashMap<String, List<String>>> resources = zone.getServices().get(serviceName).getResources();
            for (Map map : resources) {
                HashMap<String, RangerPolicy.RangerPolicyResource> policyResources = new HashMap<String, RangerPolicy.RangerPolicyResource>();
                for (Map.Entry entry : map.entrySet()) {
                    String resourceDefName = (String)entry.getKey();
                    List resourceValues = (List)entry.getValue();
                    RangerPolicy.RangerPolicyResource rangerPolicyResource = new RangerPolicy.RangerPolicyResource();
                    rangerPolicyResource.setIsExcludes(false);
                    rangerPolicyResource.setIsRecursive(StringUtils.equals((String)serviceDef.getName(), (String)"hdfs"));
                    rangerPolicyResource.setValues(resourceValues);
                    policyResources.put(resourceDefName, rangerPolicyResource);
                    if (matchersForResourceDef.get(resourceDefName) != null) continue;
                    matchersForResourceDef.put(resourceDefName, new ArrayList());
                }
                RangerZoneResourceMatcher rangerZoneResourceMatcher = new RangerZoneResourceMatcher(zone.getName(), policyResources, serviceDef);
                for (String resourceDefName : map.keySet()) {
                    ((List)matchersForResourceDef.get(resourceDefName)).add(rangerZoneResourceMatcher);
                }
            }
        }
        HashMap trieMap = new HashMap();
        List<RangerServiceDef.RangerResourceDef> resourceDefs = serviceDef.getResources();
        for (Map.Entry entry : matchersForResourceDef.entrySet()) {
            void var13_22;
            String string = (String)entry.getKey();
            List matchers = (List)entry.getValue();
            Object var13_20 = null;
            for (RangerServiceDef.RangerResourceDef element : resourceDefs) {
                if (!StringUtils.equals((String)element.getName(), (String)string)) continue;
                RangerServiceDef.RangerResourceDef rangerResourceDef = element;
                break;
            }
            trieMap.put(entry.getKey(), new RangerResourceTrie((RangerServiceDef.RangerResourceDef)var13_22, matchers));
        }
        block6: for (RangerSecurityZone zone : zones) {
            List<HashMap<String, List<String>>> list = zone.getServices().get(serviceName).getResources();
            for (Map map : list) {
                Object zoneMatchers2;
                HashSet intersection;
                void var14_35;
                Object var14_31 = null;
                Set<Object> smallestList = null;
                for (Map.Entry entry : map.entrySet()) {
                    void var14_32;
                    String resourceDefName = (String)entry.getKey();
                    List list2 = (List)entry.getValue();
                    RangerResourceTrie trie = (RangerResourceTrie)trieMap.get(resourceDefName);
                    Set matchedZones = trie.getEvaluatorsForResource(list2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("ResourceDefName:[" + resourceDefName + "], values:[" + list2 + "], matched-zones:[" + matchedZones + "]"));
                    }
                    if (CollectionUtils.isEmpty(matchedZones)) {
                        Object var14_33 = null;
                        smallestList = null;
                        break;
                    }
                    if (smallestList == null) {
                        smallestList = matchedZones;
                        continue;
                    }
                    if (var14_32 == null) {
                        ArrayList<Set<Object>> arrayList = new ArrayList<Set<Object>>();
                        arrayList.add(smallestList);
                    }
                    var14_32.add(matchedZones);
                    if (smallestList.size() <= matchedZones.size()) continue;
                    smallestList = matchedZones;
                }
                if (smallestList == null) continue;
                if (var14_35 != null) {
                    intersection = new HashSet(smallestList);
                    for (Object zoneMatchers2 : var14_35) {
                        if (zoneMatchers2 == smallestList) continue;
                        intersection.retainAll((Collection<?>)zoneMatchers2);
                        if (!CollectionUtils.isEmpty(intersection)) continue;
                        break;
                    }
                } else {
                    intersection = smallestList;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Resource:[" + map + "], matched-zones:[" + intersection + "]"));
                }
                if (intersection.size() <= 1) continue;
                RangerAccessResourceImpl rangerAccessResourceImpl = new RangerAccessResourceImpl();
                rangerAccessResourceImpl.setServiceDef(serviceDef);
                zoneMatchers2 = map.entrySet().iterator();
                while (zoneMatchers2.hasNext()) {
                    Map.Entry entry = (Map.Entry)zoneMatchers2.next();
                    rangerAccessResourceImpl.setValue((String)entry.getKey(), entry.getValue());
                }
                HashSet<String> matchedZoneNames = new HashSet<String>();
                for (RangerZoneResourceMatcher zoneMatcher : intersection) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Trying to match resource:[" + rangerAccessResourceImpl + "] using zoneMatcher:[" + zoneMatcher + "]"));
                    }
                    if (zoneMatcher.getPolicyResourceMatcher().isMatch(rangerAccessResourceImpl, RangerPolicyResourceMatcher.MatchScope.ANY, null)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Matched resource:[" + rangerAccessResourceImpl + "] using zoneMatcher:[" + zoneMatcher + "]"));
                        }
                        matchedZoneNames.add(zoneMatcher.getSecurityZoneName());
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Did not match resource:[" + rangerAccessResourceImpl + "] using zoneMatcher:[" + zoneMatcher + "]"));
                }
                LOG.info((Object)("The following zone-names matched resource:[" + map + "]: " + matchedZoneNames));
                if (matchedZoneNames.size() <= 1) continue;
                ValidationErrorCode validationErrorCode = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_ZONE_RESOURCE_CONFLICT;
                failures.add(new ValidationFailureDetailsBuilder().becauseOf(validationErrorCode.getMessage(matchedZoneNames, map)).errorCode(validationErrorCode.getErrorCode()).build());
                ret = false;
                continue block6;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.validateZoneServiceInAllZones(%s, %s, %s, %s) : %s", zones, serviceName, serviceDef, failures, ret));
        }
        return ret;
    }

    private boolean validateSecurityZoneService(String serviceName, RangerSecurityZone.RangerSecurityZoneService securityZoneService, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.validateSecurityZoneService(%s, %s, %s)", serviceName, securityZoneService, failures));
        }
        boolean ret = true;
        RangerService service = this.getService(serviceName);
        if (service == null) {
            ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_SERVICE_NAME;
            failures.add(new ValidationFailureDetailsBuilder().field("security zone resource service-name").becauseOf(error.getMessage(serviceName)).errorCode(error.getErrorCode()).build());
            ret = false;
        } else {
            RangerServiceDef serviceDef = this.getServiceDef(service.getType());
            if (serviceDef == null) {
                ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_SERVICE_TYPE;
                failures.add(new ValidationFailureDetailsBuilder().field("security zone resource service-type").becauseOf(error.getMessage(service.getType())).errorCode(error.getErrorCode()).build());
                ret = false;
            } else {
                String serviceType = serviceDef.getName();
                if (StringUtils.equals((String)serviceType, (String)"tag")) {
                    if (CollectionUtils.isNotEmpty(securityZoneService.getResources())) {
                        ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_UNEXPECTED_RESOURCES;
                        failures.add(new ValidationFailureDetailsBuilder().field("security zone resources").becauseOf(error.getMessage(serviceName)).errorCode(error.getErrorCode()).build());
                        ret = false;
                    }
                } else if (CollectionUtils.isEmpty(securityZoneService.getResources())) {
                    ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_MISSING_RESOURCES;
                    failures.add(new ValidationFailureDetailsBuilder().field("security zone resources").isMissing().becauseOf(error.getMessage(serviceName)).errorCode(error.getErrorCode()).build());
                    ret = false;
                } else {
                    for (Map map : securityZoneService.getResources()) {
                        Set<String> resourceDefNames = map.keySet();
                        RangerServiceDefHelper serviceDefHelper = new RangerServiceDefHelper(serviceDef);
                        boolean isValidHierarchy = false;
                        block1: for (int policyType : RangerPolicy.POLICY_TYPES) {
                            Set<List<RangerServiceDef.RangerResourceDef>> resourceHierarchies = serviceDefHelper.getResourceHierarchies(policyType, resourceDefNames);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Size of resourceHierarchies for resourceDefNames:[" + resourceDefNames + ", policyType=" + policyType + "] = " + resourceHierarchies.size()));
                            }
                            for (List<RangerServiceDef.RangerResourceDef> resourceHierarchy : resourceHierarchies) {
                                if (RangerDefaultPolicyResourceMatcher.isHierarchyValidForResources(resourceHierarchy, map)) {
                                    isValidHierarchy = true;
                                    continue block1;
                                }
                                LOG.info((Object)("gaps found in resource, skipping hierarchy:[" + resourceHierarchies + "]"));
                            }
                        }
                        if (isValidHierarchy) continue;
                        ValidationErrorCode error = ValidationErrorCode.SECURITY_ZONE_VALIDATION_ERR_INVALID_RESOURCE_HIERARCHY;
                        failures.add(new ValidationFailureDetailsBuilder().field("security zone resource hierarchy").becauseOf(error.getMessage(serviceName, resourceDefNames)).errorCode(error.getErrorCode()).build());
                        ret = false;
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.validateSecurityZoneService(%s, %s, %s) : %s", serviceName, securityZoneService, failures, ret));
        }
        return ret;
    }
}

