/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.conditionevaluator.RangerScriptExecutionContext;
import org.apache.ranger.plugin.contextenricher.RangerTagForEval;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;

public class RangerScriptConditionEvaluator
extends RangerAbstractConditionEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerScriptConditionEvaluator.class);
    private ScriptEngine scriptEngine;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerScriptConditionEvaluator.init(" + this.condition + ")"));
        }
        super.init();
        String engineName = "JavaScript";
        Map<String, String> evalOptions = this.conditionDef.getEvaluatorOptions();
        if (MapUtils.isNotEmpty(evalOptions)) {
            engineName = evalOptions.get("engineName");
        }
        if (StringUtils.isBlank((String)engineName)) {
            engineName = "JavaScript";
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerScriptConditionEvaluator.init() - engineName=" + engineName));
        }
        try {
            ScriptEngineManager manager = new ScriptEngineManager();
            this.scriptEngine = manager.getEngineByName(engineName);
        }
        catch (Exception exp) {
            LOG.error((Object)("RangerScriptConditionEvaluator.init() failed with exception=" + exp));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerScriptConditionEvaluator.init(" + this.condition + ")"));
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        String script;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerScriptConditionEvaluator.isMatched()");
        }
        boolean result = true;
        if (this.scriptEngine != null && StringUtils.isNotBlank((String)(script = this.getScript()))) {
            RangerAccessRequest readOnlyRequest = request.getReadOnlyCopy();
            RangerScriptExecutionContext context = new RangerScriptExecutionContext(readOnlyRequest);
            RangerTagForEval currentTag = context.getCurrentTag();
            Map<Object, Object> tagAttribs = currentTag != null ? currentTag.getAttributes() : Collections.emptyMap();
            Bindings bindings = this.scriptEngine.createBindings();
            bindings.put("ctx", (Object)context);
            bindings.put("tag", (Object)currentTag);
            bindings.put("tagAttr", (Object)tagAttribs);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerScriptConditionEvaluator.isMatched(): script={" + script + "}"));
            }
            try {
                Object ret = this.scriptEngine.eval(script, bindings);
                if (ret == null) {
                    ret = context.getResult();
                }
                if (ret instanceof Boolean) {
                    result = (Boolean)ret;
                }
            }
            catch (NullPointerException nullp) {
                LOG.error((Object)"RangerScriptConditionEvaluator.isMatched(): eval called with NULL argument(s)", (Throwable)nullp);
            }
            catch (ScriptException exception) {
                LOG.error((Object)("RangerScriptConditionEvaluator.isMatched(): failed to evaluate script, exception=" + exception));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerScriptConditionEvaluator.isMatched(), result=" + result));
        }
        return result;
    }

    protected String getScript() {
        String value;
        String ret = null;
        List<String> values = this.condition.getValues();
        if (CollectionUtils.isNotEmpty(values) && StringUtils.isNotBlank((String)(value = values.get(0)))) {
            ret = value.trim();
        }
        return ret;
    }
}

