/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import java.net.URL;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class RangerConfiguration
extends Configuration {
    private static final Logger LOG = Logger.getLogger(RangerConfiguration.class);

    protected RangerConfiguration() {
        super(false);
    }

    public boolean addResourceIfReadable(String aResourceName) {
        URL fUrl;
        boolean ret = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> addResourceIfReadable(" + aResourceName + ")"));
        }
        if ((fUrl = this.getFileLocation(aResourceName)) != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("addResourceIfReadable(" + aResourceName + "): resource file is " + fUrl));
            }
            try {
                this.addResource(fUrl);
                ret = true;
            }
            catch (Exception e) {
                LOG.error((Object)("Unable to load the resource name [" + aResourceName + "]. Ignoring the resource:" + fUrl));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Resource loading failed for " + fUrl), (Throwable)e);
                }
            }
        } else {
            LOG.error((Object)("addResourceIfReadable(" + aResourceName + "): couldn't find resource file location"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== addResourceIfReadable(" + aResourceName + "), result=" + ret));
        }
        return ret;
    }

    public Properties getProperties() {
        return this.getProps();
    }

    private URL getFileLocation(String fileName) {
        URL lurl = RangerConfiguration.class.getClassLoader().getResource(fileName);
        if (lurl == null) {
            lurl = RangerConfiguration.class.getClassLoader().getResource("/" + fileName);
        }
        return lurl;
    }
}

