/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.Constants;
import org.apache.coyote.ErrorState;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractAjpProcessor<S>
extends AbstractProcessor<S> {
    protected static final StringManager sm = StringManager.getManager("org.apache.coyote.ajp");
    protected static final byte[] endMessageArray;
    protected static final byte[] endAndCloseMessageArray;
    protected static final byte[] flushMessageArray;
    protected static final byte[] pongMessageArray;
    private static final Set<String> javaxAttributes;
    protected final byte[] getBodyMessageArray;
    protected int packetSize;
    protected AjpMessage requestHeaderMessage = null;
    protected AjpMessage responseMessage = null;
    protected AjpMessage bodyMessage = null;
    protected MessageBytes bodyBytes = MessageBytes.newInstance();
    protected MessageBytes tmpMB = MessageBytes.newInstance();
    protected MessageBytes certificates = MessageBytes.newInstance();
    protected boolean endOfStream = false;
    protected boolean empty = true;
    protected boolean first = true;
    protected boolean replay = false;
    private boolean swallowResponse = false;
    protected boolean finished = false;
    protected long bytesWritten = 0L;
    protected boolean ajpFlush = true;
    protected int keepAliveTimeout = -1;
    protected boolean tomcatAuthentication = true;
    private boolean tomcatAuthorization = false;
    @Deprecated
    protected String requiredSecret = null;
    protected String secret = null;
    protected String clientCertProvider = null;
    private Pattern allowedRequestAttributesPatternPattern;

    public AbstractAjpProcessor(int packetSize, AbstractEndpoint<S> endpoint) {
        super(endpoint);
        this.packetSize = packetSize;
        this.request.setInputBuffer(new SocketInputBuffer());
        this.requestHeaderMessage = new AjpMessage(packetSize);
        this.responseMessage = new AjpMessage(packetSize);
        this.bodyMessage = new AjpMessage(packetSize);
        AjpMessage getBodyMessage = new AjpMessage(16);
        getBodyMessage.reset();
        getBodyMessage.appendByte(6);
        getBodyMessage.appendInt(8186 + packetSize - 8192);
        getBodyMessage.end();
        this.getBodyMessageArray = new byte[getBodyMessage.getLen()];
        System.arraycopy(getBodyMessage.getBuffer(), 0, this.getBodyMessageArray, 0, getBodyMessage.getLen());
    }

    public boolean getAjpFlush() {
        return this.ajpFlush;
    }

    public void setAjpFlush(boolean ajpFlush) {
        this.ajpFlush = ajpFlush;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public boolean getTomcatAuthorization() {
        return this.tomcatAuthorization;
    }

    public void setTomcatAuthorization(boolean tomcatAuthorization) {
        this.tomcatAuthorization = tomcatAuthorization;
    }

    public void setSecret(String secret) {
        this.secret = secret;
        this.requiredSecret = secret;
    }

    @Deprecated
    public void setRequiredSecret(String requiredSecret) {
        this.setSecret(requiredSecret);
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String s) {
        this.clientCertProvider = s;
    }

    public void setAllowedRequestAttributesPatternPattern(Pattern allowedRequestAttributesPatternPattern) {
        this.allowedRequestAttributesPatternPattern = allowedRequestAttributesPatternPattern;
    }

    @Override
    public final void action(ActionCode actionCode, Object param) {
        switch (actionCode) {
            case COMMIT: {
                if (this.response.isCommitted()) {
                    return;
                }
                try {
                    this.prepareResponse();
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                try {
                    this.flush(false);
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                break;
            }
            case CLIENT_FLUSH: {
                if (!this.response.isCommitted()) {
                    try {
                        this.prepareResponse();
                    }
                    catch (IOException e) {
                        this.setErrorState(ErrorState.CLOSE_NOW, e);
                        return;
                    }
                }
                try {
                    this.flush(true);
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                break;
            }
            case IS_ERROR: {
                ((AtomicBoolean)param).set(this.getErrorState().isError());
                break;
            }
            case DISABLE_SWALLOW_INPUT: {
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                break;
            }
            case CLOSE: {
                try {
                    this.finish();
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                if (this.certificates.isNull()) break;
                ByteChunk certData = this.certificates.getByteChunk();
                X509Certificate[] jsseCerts = null;
                ByteArrayInputStream bais = new ByteArrayInputStream(certData.getBytes(), certData.getStart(), certData.getLength());
                try {
                    CertificateFactory cf = this.clientCertProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.clientCertProvider);
                    while (bais.available() > 0) {
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                        if (jsseCerts == null) {
                            jsseCerts = new X509Certificate[]{cert};
                            continue;
                        }
                        X509Certificate[] temp = new X509Certificate[jsseCerts.length + 1];
                        System.arraycopy(jsseCerts, 0, temp, 0, jsseCerts.length);
                        temp[jsseCerts.length] = cert;
                        jsseCerts = temp;
                    }
                }
                catch (CertificateException e) {
                    this.getLog().error((Object)sm.getString("ajpprocessor.certs.fail"), (Throwable)e);
                    return;
                }
                catch (NoSuchProviderException e) {
                    this.getLog().error((Object)sm.getString("ajpprocessor.certs.fail"), (Throwable)e);
                    return;
                }
                this.request.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (!this.request.remoteHost().isNull()) break;
                try {
                    this.request.remoteHost().setString(InetAddress.getByName(this.request.remoteAddr().toString()).getHostName());
                }
                catch (IOException iex) {}
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (!this.request.localAddr().isNull()) break;
                this.request.localAddr().setString(this.request.localName().toString());
                break;
            }
            case REQ_SET_BODY_REPLAY: {
                ByteChunk bc = (ByteChunk)param;
                int length = bc.getLength();
                this.bodyBytes.setBytes(bc.getBytes(), bc.getStart(), length);
                this.request.setContentLength(length);
                this.first = false;
                this.empty = false;
                this.replay = true;
                this.endOfStream = false;
                break;
            }
            case ASYNC_START: {
                this.asyncStateMachine.asyncStart((AsyncContextCallback)param);
                this.getSocketWrapper().access();
                break;
            }
            case ASYNC_DISPATCHED: {
                this.asyncStateMachine.asyncDispatched();
                break;
            }
            case ASYNC_TIMEOUT: {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.asyncStateMachine.asyncTimeout());
                break;
            }
            case ASYNC_RUN: {
                this.asyncStateMachine.asyncRun((Runnable)param);
                break;
            }
            case ASYNC_ERROR: {
                this.asyncStateMachine.asyncError();
                break;
            }
            case ASYNC_IS_STARTED: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncStarted());
                break;
            }
            case ASYNC_IS_COMPLETING: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isCompleting());
                break;
            }
            case ASYNC_IS_DISPATCHING: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncDispatching());
                break;
            }
            case ASYNC_IS_ASYNC: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsync());
                break;
            }
            case ASYNC_IS_TIMINGOUT: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncTimingOut());
                break;
            }
            case ASYNC_IS_ERROR: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncError());
                break;
            }
            case ASYNC_POST_PROCESS: {
                this.asyncStateMachine.asyncPostProcess();
                break;
            }
            case UPGRADE_TOMCAT: {
                break;
            }
            case CLOSE_NOW: {
                this.swallowResponse = true;
                if (param instanceof Throwable) {
                    this.setErrorState(ErrorState.CLOSE_NOW, (Throwable)param);
                    break;
                }
                this.setErrorState(ErrorState.CLOSE_NOW, null);
                break;
            }
            case END_REQUEST: {
                break;
            }
            default: {
                this.actionInternal(actionCode, param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus status) {
        AbstractEndpoint.Handler.SocketState state;
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            if (!this.getAdapter().asyncDispatch(this.request, this.response, status)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
            this.resetTimeouts();
        }
        catch (InterruptedIOException e) {
            this.setErrorState(ErrorState.CLOSE_NOW, e);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.setErrorState(ErrorState.CLOSE_NOW, t);
            this.getLog().error((Object)sm.getString("http11processor.request.process"), t);
        }
        finally {
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
                this.adapter.log(this.request, this.response, 0L);
            }
        }
        rp.setStage(7);
        if (this.isAsync()) {
            if (this.getErrorState().isError()) {
                this.request.updateCounters();
                state = AbstractEndpoint.Handler.SocketState.CLOSED;
            } else {
                state = AbstractEndpoint.Handler.SocketState.LONG;
            }
        } else {
            this.request.updateCounters();
            if (this.getErrorState().isError()) {
                state = AbstractEndpoint.Handler.SocketState.CLOSED;
            } else {
                this.recycle(false);
                state = AbstractEndpoint.Handler.SocketState.OPEN;
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("Socket: [" + this.socketWrapper + "], Status in: [" + (Object)((Object)status) + "], State out: [" + (Object)((Object)state) + "]"));
        }
        return state;
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
        throw new IllegalStateException(sm.getString("ajpprocessor.ssl.notsupported"));
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        throw new IOException(sm.getString("ajpprocessor.comet.notsupported"));
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch() throws IOException {
        throw new IOException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    @Deprecated
    public UpgradeInbound getUpgradeInbound() {
        return null;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketStatus status) throws IOException {
        throw new IOException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    public HttpUpgradeHandler getHttpUpgradeHandler() {
        throw new IllegalStateException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    public void recycle(boolean socketClosing) {
        this.getAdapter().checkRecycled(this.request, this.response);
        this.asyncStateMachine.recycle();
        this.first = true;
        this.endOfStream = false;
        this.empty = true;
        this.replay = false;
        this.finished = false;
        this.request.recycle();
        this.response.recycle();
        this.certificates.recycle();
        this.swallowResponse = false;
        this.bytesWritten = 0L;
        this.resetErrorState();
    }

    protected abstract void actionInternal(ActionCode var1, Object var2);

    protected abstract void resetTimeouts();

    protected abstract void output(byte[] var1, int var2, int var3) throws IOException;

    protected abstract boolean receive() throws IOException;

    @Override
    public final boolean isComet() {
        return false;
    }

    @Override
    public final boolean isUpgrade() {
        return false;
    }

    protected boolean refillReadBuffer() throws IOException {
        if (this.replay) {
            this.endOfStream = true;
        }
        if (this.endOfStream) {
            return false;
        }
        this.output(this.getBodyMessageArray, 0, this.getBodyMessageArray.length);
        boolean moreData = this.receive();
        if (!moreData) {
            this.endOfStream = true;
        }
        return moreData;
    }

    protected void prepareRequest() {
        ByteChunk uriBC;
        byte attributeCode;
        boolean isSSL;
        byte methodCode = this.requestHeaderMessage.getByte();
        if (methodCode != -1) {
            String methodName = org.apache.coyote.ajp.Constants.getMethodForCode(methodCode - 1);
            this.request.method().setString(methodName);
        }
        this.requestHeaderMessage.getBytes(this.request.protocol());
        this.requestHeaderMessage.getBytes(this.request.requestURI());
        this.requestHeaderMessage.getBytes(this.request.remoteAddr());
        this.requestHeaderMessage.getBytes(this.request.remoteHost());
        this.requestHeaderMessage.getBytes(this.request.localName());
        this.request.setLocalPort(this.requestHeaderMessage.getInt());
        boolean bl = isSSL = this.requestHeaderMessage.getByte() != 0;
        if (isSSL) {
            this.request.scheme().setString("https");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        headers.setLimit(this.endpoint.getMaxHeaderCount());
        this.request.getCookies().setLimit(this.getMaxCookieCount());
        boolean contentLengthSet = false;
        int hCount = this.requestHeaderMessage.getInt();
        for (int i = 0; i < hCount; ++i) {
            String hName = null;
            int isc = this.requestHeaderMessage.peekInt();
            int hId = isc & 0xFF;
            MessageBytes vMB = null;
            if (40960 == (isc &= 0xFF00)) {
                this.requestHeaderMessage.getInt();
                hName = org.apache.coyote.ajp.Constants.getHeaderForCode(hId - 1);
                vMB = headers.addValue(hName);
            } else {
                hId = -1;
                this.requestHeaderMessage.getBytes(this.tmpMB);
                ByteChunk bc = this.tmpMB.getByteChunk();
                vMB = headers.addValue(bc.getBuffer(), bc.getStart(), bc.getLength());
            }
            this.requestHeaderMessage.getBytes(vMB);
            if (hId == 8 || hId == -1 && this.tmpMB.equalsIgnoreCase("Content-Length")) {
                long cl = vMB.getLong();
                if (contentLengthSet) {
                    this.response.setStatus(400);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    continue;
                }
                contentLengthSet = true;
                this.request.setContentLength(cl);
                continue;
            }
            if (hId != 7 && (hId != -1 || !this.tmpMB.equalsIgnoreCase("Content-Type"))) continue;
            ByteChunk bchunk = vMB.getByteChunk();
            this.request.contentType().setBytes(bchunk.getBytes(), bchunk.getOffset(), bchunk.getLength());
        }
        boolean secretPresentInRequest = false;
        while ((attributeCode = this.requestHeaderMessage.getByte()) != -1) {
            switch (attributeCode) {
                case 10: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String n = this.tmpMB.toString();
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String v = this.tmpMB.toString();
                    if (n.equals("AJP_LOCAL_ADDR")) {
                        this.request.localAddr().setString(v);
                        break;
                    }
                    if (n.equals("AJP_REMOTE_PORT")) {
                        try {
                            this.request.setRemotePort(Integer.parseInt(v));
                        }
                        catch (NumberFormatException nfe) {}
                        break;
                    }
                    if (n.equals("AJP_SSL_PROTOCOL")) {
                        this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", v);
                        break;
                    }
                    if (n.equals("JK_LB_ACTIVATION")) {
                        this.request.setAttribute(n, v);
                        break;
                    }
                    if (javaxAttributes.contains(n)) {
                        this.request.setAttribute(n, v);
                        break;
                    }
                    if (this.allowedRequestAttributesPatternPattern == null) {
                        this.response.setStatus(403);
                        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                        break;
                    }
                    Matcher m = this.allowedRequestAttributesPatternPattern.matcher(n);
                    if (m.matches()) {
                        this.request.setAttribute(n, v);
                        break;
                    }
                    this.response.setStatus(403);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    break;
                }
                case 1: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    break;
                }
                case 2: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    break;
                }
                case 3: {
                    if (this.tomcatAuthorization || !this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.request.getRemoteUser());
                        this.request.setRemoteUserNeedsAuthorization(this.tomcatAuthorization);
                        break;
                    }
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    break;
                }
                case 4: {
                    if (this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.tmpMB);
                        break;
                    }
                    this.requestHeaderMessage.getBytes(this.request.getAuthType());
                    break;
                }
                case 5: {
                    this.requestHeaderMessage.getBytes(this.request.queryString());
                    break;
                }
                case 6: {
                    this.requestHeaderMessage.getBytes(this.request.instanceId());
                    break;
                }
                case 7: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.certificates);
                    break;
                }
                case 8: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.cipher_suite", this.tmpMB.toString());
                    break;
                }
                case 9: {
                    this.request.scheme().setString("https");
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.ssl_session_id", this.tmpMB.toString());
                    break;
                }
                case 11: {
                    this.request.setAttribute("javax.servlet.request.key_size", this.requestHeaderMessage.getInt());
                    break;
                }
                case 13: {
                    this.requestHeaderMessage.getBytes(this.request.method());
                    break;
                }
                case 12: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    if (this.secret == null) break;
                    secretPresentInRequest = true;
                    if (this.tmpMB.equals(this.secret)) break;
                    this.response.setStatus(403);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    break;
                }
            }
        }
        if (this.secret != null && !secretPresentInRequest) {
            this.response.setStatus(403);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        MessageBytes valueMB = this.request.getMimeHeaders().getValue("host");
        this.parseHost(valueMB);
        if (this.getErrorState().isError()) {
            this.adapter.log(this.request, this.response, 0L);
        }
    }

    @Override
    protected void populateHost() {
        try {
            this.request.serverName().duplicate(this.request.localName());
        }
        catch (IOException e) {
            this.response.setStatus(400);
            this.setErrorState(ErrorState.CLOSE_CLEAN, e);
        }
    }

    @Override
    protected void populatePort() {
        this.request.setServerPort(this.request.getLocalPort());
    }

    protected void prepareResponse() throws IOException {
        long contentLength;
        String contentLanguage;
        MessageBytes methodMB;
        this.response.setCommitted(true);
        this.responseMessage.reset();
        this.responseMessage.appendByte(4);
        int statusCode = this.response.getStatus();
        if (statusCode < 200 || statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.swallowResponse = true;
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.swallowResponse = true;
        }
        this.responseMessage.appendInt(statusCode);
        String message = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader(this.response.getMessage())) {
            message = this.response.getMessage();
        }
        if (message == null) {
            message = HttpMessages.getInstance(this.response.getLocale()).getMessage(this.response.getStatus());
        }
        if (message == null) {
            message = Integer.toString(this.response.getStatus());
        }
        this.tmpMB.setString(message);
        this.responseMessage.appendBytes(this.tmpMB);
        MimeHeaders headers = this.response.getMimeHeaders();
        String contentType = this.response.getContentType();
        if (contentType != null) {
            headers.setValue("Content-Type").setString(contentType);
        }
        if ((contentLanguage = this.response.getContentLanguage()) != null) {
            headers.setValue("Content-Language").setString(contentLanguage);
        }
        if ((contentLength = this.response.getContentLengthLong()) >= 0L) {
            headers.setValue("Content-Length").setLong(contentLength);
        }
        int numHeaders = headers.size();
        this.responseMessage.appendInt(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            MessageBytes hN = headers.getName(i);
            int hC = org.apache.coyote.ajp.Constants.getResponseAjpIndex(hN.toString());
            if (hC > 0) {
                this.responseMessage.appendInt(hC);
            } else {
                this.responseMessage.appendBytes(hN);
            }
            MessageBytes hV = headers.getValue(i);
            this.responseMessage.appendBytes(hV);
        }
        this.responseMessage.end();
        this.output(this.responseMessage.getBuffer(), 0, this.responseMessage.getLen());
    }

    protected void flush(boolean explicit) throws IOException {
        if (this.ajpFlush && explicit && !this.finished) {
            this.output(flushMessageArray, 0, flushMessageArray.length);
        }
    }

    protected void finish() throws IOException {
        if (!this.response.isCommitted()) {
            try {
                this.prepareResponse();
            }
            catch (IOException e) {
                this.setErrorState(ErrorState.CLOSE_NOW, e);
                return;
            }
        }
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.first && this.request.getContentLengthLong() > 0L) {
            this.receive();
        }
        if (this.getErrorState().isError()) {
            this.output(endAndCloseMessageArray, 0, endAndCloseMessageArray.length);
        } else {
            this.output(endMessageArray, 0, endMessageArray.length);
        }
    }

    static {
        AjpMessage endMessage = new AjpMessage(16);
        endMessage.reset();
        endMessage.appendByte(5);
        endMessage.appendByte(1);
        endMessage.end();
        endMessageArray = new byte[endMessage.getLen()];
        System.arraycopy(endMessage.getBuffer(), 0, endMessageArray, 0, endMessage.getLen());
        AjpMessage endAndCloseMessage = new AjpMessage(16);
        endAndCloseMessage.reset();
        endAndCloseMessage.appendByte(5);
        endAndCloseMessage.appendByte(0);
        endAndCloseMessage.end();
        endAndCloseMessageArray = new byte[endAndCloseMessage.getLen()];
        System.arraycopy(endAndCloseMessage.getBuffer(), 0, endAndCloseMessageArray, 0, endAndCloseMessage.getLen());
        AjpMessage flushMessage = new AjpMessage(16);
        flushMessage.reset();
        flushMessage.appendByte(3);
        flushMessage.appendInt(0);
        flushMessage.appendByte(0);
        flushMessage.end();
        flushMessageArray = new byte[flushMessage.getLen()];
        System.arraycopy(flushMessage.getBuffer(), 0, flushMessageArray, 0, flushMessage.getLen());
        AjpMessage pongMessage = new AjpMessage(16);
        pongMessage.reset();
        pongMessage.appendByte(9);
        pongMessage.end();
        pongMessageArray = new byte[pongMessage.getLen()];
        System.arraycopy(pongMessage.getBuffer(), 0, pongMessageArray, 0, pongMessage.getLen());
        HashSet<String> s = new HashSet<String>();
        s.add("javax.servlet.request.cipher_suite");
        s.add("javax.servlet.request.key_size");
        s.add("javax.servlet.request.ssl_session");
        s.add("javax.servlet.request.X509Certificate");
        javaxAttributes = Collections.unmodifiableSet(s);
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            if (!AbstractAjpProcessor.this.response.isCommitted()) {
                try {
                    AbstractAjpProcessor.this.prepareResponse();
                }
                catch (IOException e) {
                    AbstractAjpProcessor.this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
            }
            if (!AbstractAjpProcessor.this.swallowResponse) {
                try {
                    int len = chunk.getLength();
                    int chunkSize = 8184 + AbstractAjpProcessor.this.packetSize - 8192;
                    int off = 0;
                    while (len > 0) {
                        int thisTime = len;
                        if (thisTime > chunkSize) {
                            thisTime = chunkSize;
                        }
                        len -= thisTime;
                        AbstractAjpProcessor.this.responseMessage.reset();
                        AbstractAjpProcessor.this.responseMessage.appendByte(3);
                        AbstractAjpProcessor.this.responseMessage.appendBytes(chunk.getBytes(), chunk.getOffset() + off, thisTime);
                        AbstractAjpProcessor.this.responseMessage.end();
                        AbstractAjpProcessor.this.output(AbstractAjpProcessor.this.responseMessage.getBuffer(), 0, AbstractAjpProcessor.this.responseMessage.getLen());
                        off += thisTime;
                    }
                    AbstractAjpProcessor.this.bytesWritten += (long)chunk.getLength();
                }
                catch (IOException ioe) {
                    AbstractAjpProcessor.this.response.action(ActionCode.CLOSE_NOW, ioe);
                    throw ioe;
                }
            }
            return chunk.getLength();
        }

        @Override
        public long getBytesWritten() {
            return AbstractAjpProcessor.this.bytesWritten;
        }
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        @Override
        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (AbstractAjpProcessor.this.endOfStream) {
                return -1;
            }
            if (AbstractAjpProcessor.this.first && req.getContentLengthLong() > 0L) {
                if (!AbstractAjpProcessor.this.receive()) {
                    return 0;
                }
            } else if (AbstractAjpProcessor.this.empty && !AbstractAjpProcessor.this.refillReadBuffer()) {
                return -1;
            }
            ByteChunk bc = AbstractAjpProcessor.this.bodyBytes.getByteChunk();
            chunk.setBytes(bc.getBuffer(), bc.getStart(), bc.getLength());
            AbstractAjpProcessor.this.empty = true;
            return chunk.getLength();
        }
    }
}

