/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.util.ParameterMap;
import org.apache.catalina.util.URLEncoder;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Parameters;
import org.apache.tomcat.util.res.StringManager;

class ApplicationHttpRequest
extends HttpServletRequestWrapper {
    private static final StringManager sm = StringManager.getManager(ApplicationHttpRequest.class);
    protected static final String[] specials = new String[]{"javax.servlet.include.request_uri", "javax.servlet.include.context_path", "javax.servlet.include.servlet_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string", "javax.servlet.forward.request_uri", "javax.servlet.forward.context_path", "javax.servlet.forward.servlet_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string"};
    protected Context context = null;
    protected String contextPath = null;
    protected boolean crossContext = false;
    protected DispatcherType dispatcherType = null;
    protected static final String info = "org.apache.catalina.core.ApplicationHttpRequest/1.0";
    protected Map<String, String[]> parameters = null;
    private boolean parsedParams = false;
    protected String pathInfo = null;
    private String queryParamString = null;
    protected String queryString = null;
    protected Object requestDispatcherPath = null;
    protected String requestURI = null;
    protected String servletPath = null;
    protected Session session = null;
    protected Object[] specialAttributes = new Object[specials.length];

    public ApplicationHttpRequest(HttpServletRequest request, Context context, boolean crossContext) {
        super(request);
        this.context = context;
        this.crossContext = crossContext;
        this.setRequest(request);
    }

    @Override
    public ServletContext getServletContext() {
        if (this.context == null) {
            return null;
        }
        return this.context.getServletContext();
    }

    @Override
    public Object getAttribute(String name) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            return this.dispatcherType;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            if (this.requestDispatcherPath != null) {
                return this.requestDispatcherPath.toString();
            }
            return null;
        }
        int pos = this.getSpecial(name);
        if (pos == -1) {
            return this.getRequest().getAttribute(name);
        }
        if (this.specialAttributes[pos] == null && this.specialAttributes[5] == null && pos >= 5) {
            return this.getRequest().getAttribute(name);
        }
        return this.specialAttributes[pos];
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return new AttributeNamesEnumerator();
    }

    @Override
    public void removeAttribute(String name) {
        if (!this.removeSpecial(name)) {
            this.getRequest().removeAttribute(name);
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name.equals("org.apache.catalina.core.DISPATCHER_TYPE")) {
            this.dispatcherType = (DispatcherType)((Object)value);
            return;
        }
        if (name.equals("org.apache.catalina.core.DISPATCHER_REQUEST_PATH")) {
            this.requestDispatcherPath = value;
            return;
        }
        if (!this.setSpecial(name, value)) {
            this.getRequest().setAttribute(name, value);
        }
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.context == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        int fragmentPos = path.indexOf(35);
        if (fragmentPos > -1) {
            this.context.getLogger().warn((Object)sm.getString("applicationHttpRequest.fragmentInDispatchPath", path));
            path = path.substring(0, fragmentPos);
        }
        if (path.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        String pathInfo = this.getPathInfo();
        String requestPath = null;
        requestPath = pathInfo == null ? servletPath : servletPath + pathInfo;
        int pos = requestPath.lastIndexOf(47);
        String relative = null;
        relative = this.context.getDispatchersUseEncodedPaths() ? (pos >= 0 ? URLEncoder.DEFAULT.encode(requestPath.substring(0, pos + 1), "UTF-8") + path : URLEncoder.DEFAULT.encode(requestPath, "UTF-8") + path) : (pos >= 0 ? requestPath.substring(0, pos + 1) + path : requestPath + path);
        return this.context.getServletContext().getRequestDispatcher(relative);
    }

    @Override
    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getParameter(String name) {
        this.parseParameters();
        String[] value = this.parameters.get(name);
        if (value == null) {
            return null;
        }
        return value[0];
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        this.parseParameters();
        return this.parameters;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        this.parseParameters();
        return Collections.enumeration(this.parameters.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        this.parseParameters();
        return this.parameters.get(name);
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getPathTranslated() {
        if (this.getPathInfo() == null || this.getServletContext() == null) {
            return null;
        }
        return this.getServletContext().getRealPath(this.getPathInfo());
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    @Override
    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public HttpSession getSession() {
        return this.getSession(true);
    }

    @Override
    public HttpSession getSession(boolean create) {
        if (this.crossContext) {
            if (this.context == null) {
                return null;
            }
            if (this.session != null && this.session.isValid()) {
                return this.session.getSession();
            }
            HttpSession other = super.getSession(false);
            if (create && other == null) {
                other = super.getSession(true);
            }
            if (other != null) {
                Session localSession = null;
                try {
                    localSession = this.context.getManager().findSession(other.getId());
                    if (localSession != null && !localSession.isValid()) {
                        localSession = null;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (localSession == null && create) {
                    localSession = this.context.getManager().createSession(other.getId());
                }
                if (localSession != null) {
                    localSession.access();
                    this.session = localSession;
                    return this.session.getSession();
                }
            }
            return null;
        }
        return super.getSession(create);
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        if (this.crossContext) {
            String requestedSessionId = this.getRequestedSessionId();
            if (requestedSessionId == null) {
                return false;
            }
            if (this.context == null) {
                return false;
            }
            Manager manager = this.context.getManager();
            if (manager == null) {
                return false;
            }
            Session session = null;
            try {
                session = manager.findSession(requestedSessionId);
            }
            catch (IOException e) {
                // empty catch block
            }
            return session != null && session.isValid();
        }
        return super.isRequestedSessionIdValid();
    }

    public void recycle() {
        if (this.session != null) {
            this.session.endAccess();
        }
    }

    public String getInfo() {
        return info;
    }

    void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    void setRequest(HttpServletRequest request) {
        super.setRequest(request);
        this.dispatcherType = (DispatcherType)((Object)request.getAttribute("org.apache.catalina.core.DISPATCHER_TYPE"));
        this.requestDispatcherPath = request.getAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH");
        this.contextPath = request.getContextPath();
        this.pathInfo = request.getPathInfo();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.servletPath = request.getServletPath();
    }

    void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    void parseParameters() {
        if (this.parsedParams) {
            return;
        }
        this.parameters = new ParameterMap<String, String[]>();
        this.parameters.putAll(this.getRequest().getParameterMap());
        this.mergeParameters();
        ((ParameterMap)this.parameters).setLocked(true);
        this.parsedParams = true;
    }

    void setQueryParams(String queryString) {
        this.queryParamString = queryString;
    }

    protected boolean isSpecial(String name) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    protected int getSpecial(String name) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    protected boolean setSpecial(String name, Object value) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            this.specialAttributes[i] = value;
            return true;
        }
        return false;
    }

    protected boolean removeSpecial(String name) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            this.specialAttributes[i] = null;
            return true;
        }
        return false;
    }

    protected String[] mergeValues(Object values1, Object values2) {
        ArrayList<String> results = new ArrayList<String>();
        if (values1 != null) {
            if (values1 instanceof String[]) {
                for (String value : (String[])values1) {
                    results.add(value);
                }
            } else {
                results.add(values1.toString());
            }
        }
        if (values2 != null) {
            if (values2 instanceof String[]) {
                for (String value : (String[])values2) {
                    results.add(value);
                }
            } else {
                results.add(values2.toString());
            }
        }
        String[] values = new String[results.size()];
        return results.toArray(values);
    }

    private void mergeParameters() {
        if (this.queryParamString == null || this.queryParamString.length() < 1) {
            return;
        }
        Parameters paramParser = new Parameters();
        MessageBytes queryMB = MessageBytes.newInstance();
        queryMB.setString(this.queryParamString);
        String encoding = this.getCharacterEncoding();
        if (encoding != null) {
            try {
                queryMB.setCharset(B2CConverter.getCharset(encoding));
            }
            catch (UnsupportedEncodingException ignored) {
                // empty catch block
            }
        }
        paramParser.setQuery(queryMB);
        paramParser.setQueryStringEncoding(encoding);
        paramParser.handleQueryParameters();
        Enumeration<String> dispParamNames = paramParser.getParameterNames();
        while (dispParamNames.hasMoreElements()) {
            String dispParamName = dispParamNames.nextElement();
            String[] dispParamValues = paramParser.getParameterValues(dispParamName);
            String[] originalValues = this.parameters.get(dispParamName);
            if (originalValues == null) {
                this.parameters.put(dispParamName, dispParamValues);
                continue;
            }
            this.parameters.put(dispParamName, this.mergeValues(dispParamValues, originalValues));
        }
    }

    protected class AttributeNamesEnumerator
    implements Enumeration<String> {
        protected int pos = -1;
        protected int last = -1;
        protected Enumeration<String> parentEnumeration = null;
        protected String next = null;

        public AttributeNamesEnumerator() {
            this.parentEnumeration = ApplicationHttpRequest.this.getRequest().getAttributeNames();
            for (int i = ApplicationHttpRequest.this.specialAttributes.length - 1; i >= 0; --i) {
                if (ApplicationHttpRequest.this.getAttribute(specials[i]) == null) continue;
                this.last = i;
                break;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.pos != this.last || this.next != null || (this.next = this.findNext()) != null;
        }

        @Override
        public String nextElement() {
            if (this.pos != this.last) {
                for (int i = this.pos + 1; i <= this.last; ++i) {
                    if (ApplicationHttpRequest.this.getAttribute(specials[i]) == null) continue;
                    this.pos = i;
                    return specials[i];
                }
            }
            String result = this.next;
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext();
            return result;
        }

        protected String findNext() {
            String result = null;
            while (result == null && this.parentEnumeration.hasMoreElements()) {
                String current = this.parentEnumeration.nextElement();
                if (ApplicationHttpRequest.this.isSpecial(current)) continue;
                result = current;
            }
            return result;
        }
    }
}

