/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.pam.internals;

import java.util.List;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.common.security.plain.internals.PlainServerCallbackHandler;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PamPlainServerCallbackHandler
extends PlainServerCallbackHandler {
    private static final Logger log = LoggerFactory.getLogger(PamPlainServerCallbackHandler.class);
    private String pamService;

    @Override
    public void configure(Map<String, ?> configs, String mechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.jaasConfigEntries = jaasConfigEntries;
        this.pamService = JaasContext.configEntryOption(jaasConfigEntries, "pam_service", PlainLoginModule.class.getName());
        if (this.pamService == null) {
            throw new IllegalStateException("pam_service is missing from the jaas conf file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean authenticate(String username, char[] password) {
        PAM pam = null;
        if (username != null) {
            try {
                pam = this.getPAM(this.pamService);
                pam.authenticate(username, new String(password));
                boolean bl = true;
                return bl;
            }
            catch (PAMException e) {
                log.error("Authentication failed", (Throwable)e);
            }
            finally {
                if (pam != null) {
                    pam.dispose();
                }
            }
        }
        return false;
    }

    @Override
    public void close() throws KafkaException {
    }

    protected PAM getPAM(String pamService) throws PAMException {
        return new PAM(pamService);
    }
}

