/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.yarn.client.json.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class YarnSchedulerResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private YarnScheduler scheduler = null;

    public YarnScheduler getScheduler() {
        return this.scheduler;
    }

    public List<String> getQueueNames() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.scheduler != null) {
            this.scheduler.collectQueueNames(ret);
        }
        return ret;
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class YarnQueues
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private List<YarnSchedulerInfo> queue = null;

        public List<YarnSchedulerInfo> getQueue() {
            return this.queue;
        }

        public void collectQueueNames(List<String> queueNames, String parentQueueName) {
            if (this.queue != null) {
                for (YarnSchedulerInfo schedulerInfo : this.queue) {
                    schedulerInfo.collectQueueNames(queueNames, parentQueueName);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class YarnSchedulerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String queueName = null;
        private YarnQueues queues = null;

        public String getQueueName() {
            return this.queueName;
        }

        public YarnQueues getQueues() {
            return this.queues;
        }

        public void collectQueueNames(List<String> queueNames, String parentQueueName) {
            if (this.queueName != null) {
                String queueFqdn = parentQueueName == null ? this.queueName : parentQueueName + "." + this.queueName;
                queueNames.add(queueFqdn);
                if (this.queues != null) {
                    this.queues.collectQueueNames(queueNames, queueFqdn);
                }
            }
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class YarnScheduler
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private YarnSchedulerInfo schedulerInfo = null;

        public YarnSchedulerInfo getSchedulerInfo() {
            return this.schedulerInfo;
        }

        public void collectQueueNames(List<String> queueNames) {
            if (this.schedulerInfo != null) {
                this.schedulerInfo.collectQueueNames(queueNames, null);
            }
        }
    }
}

