/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.yarn.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.services.yarn.client.json.model.YarnSchedulerResponse;

public class YarnClient
extends BaseClient {
    private static final Logger LOG = Logger.getLogger(YarnClient.class);
    private static final String EXPECTED_MIME_TYPE = "application/json";
    private static final String YARN_LIST_API_ENDPOINT = "/ws/v1/cluster/scheduler";
    private static final String errMessage = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    String yarnQUrl;
    String userName;
    String password;

    public YarnClient(String serviceName, Map<String, String> configs) {
        super(serviceName, configs, "yarn-client");
        this.yarnQUrl = configs.get("yarn.url");
        this.userName = configs.get("username");
        this.password = configs.get("password");
        if (this.yarnQUrl == null || this.yarnQUrl.isEmpty()) {
            LOG.error((Object)"No value found for configuration 'yarn.url'. YARN resource lookup will fail");
        }
        if (this.userName == null || this.userName.isEmpty()) {
            LOG.error((Object)"No value found for configuration 'username'. YARN resource lookup will fail");
        }
        if (this.password == null || this.password.isEmpty()) {
            LOG.error((Object)"No value found for configuration 'password'. YARN resource lookup will fail");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Yarn Client is build with url [" + this.yarnQUrl + "] user: [" + this.userName + "], password: [" + "*********" + "]"));
        }
    }

    public List<String> getQueueList(final String queueNameMatching, final List<String> existingQueueList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting Yarn queue list for queueNameMatching : " + queueNameMatching));
        }
        String errMsg = errMessage;
        List<String> ret = null;
        Callable<List<String>> callableYarnQListGetter = new Callable<List<String>>(){

            @Override
            public List<String> call() {
                List<String> yarnQueueListGetter = null;
                Subject subj = YarnClient.this.getLoginSubject();
                if (subj != null) {
                    yarnQueueListGetter = Subject.doAs(subj, new PrivilegedAction<List<String>>(){

                        @Override
                        public List<String> run() {
                            ArrayList<String> lret;
                            block17: {
                                if (YarnClient.this.yarnQUrl == null || YarnClient.this.yarnQUrl.trim().isEmpty()) {
                                    return null;
                                }
                                String[] yarnQUrls = YarnClient.this.yarnQUrl.trim().split("[,;]");
                                if (yarnQUrls == null || yarnQUrls.length == 0) {
                                    return null;
                                }
                                Client client = Client.create();
                                ClientResponse response = null;
                                for (String currentUrl : yarnQUrls) {
                                    if (currentUrl == null || currentUrl.trim().isEmpty()) continue;
                                    String url = currentUrl.trim() + YarnClient.YARN_LIST_API_ENDPOINT;
                                    try {
                                        response = this.getQueueResponse(url, client);
                                        if (response == null) continue;
                                        if (response.getStatus() == 200) break;
                                        response.close();
                                    }
                                    catch (Throwable t) {
                                        String msgDesc = "Exception while getting Yarn Queue List. URL : " + url;
                                        LOG.error((Object)msgDesc, t);
                                    }
                                }
                                lret = new ArrayList<String>();
                                try {
                                    if (response != null && response.getStatus() == 200) {
                                        List<String> yarnQueueList;
                                        String jsonString = (String)response.getEntity(String.class);
                                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                                        YarnSchedulerResponse yarnQResponse = (YarnSchedulerResponse)gson.fromJson(jsonString, YarnSchedulerResponse.class);
                                        if (yarnQResponse != null && (yarnQueueList = yarnQResponse.getQueueNames()) != null) {
                                            for (String yarnQueueName : yarnQueueList) {
                                                if (existingQueueList != null && existingQueueList.contains(yarnQueueName) || queueNameMatching != null && !queueNameMatching.isEmpty() && !yarnQueueName.startsWith(queueNameMatching)) continue;
                                                if (LOG.isDebugEnabled()) {
                                                    LOG.debug((Object)("getQueueList():Adding yarnQueue " + yarnQueueName));
                                                }
                                                lret.add(yarnQueueName);
                                            }
                                        }
                                        break block17;
                                    }
                                    String msgDesc = "Unable to get a valid response for expected mime type : [application/json] URL : " + YarnClient.this.yarnQUrl + " - got null response.";
                                    LOG.error((Object)msgDesc);
                                    HadoopException hdpException = new HadoopException(msgDesc);
                                    hdpException.generateResponseDataMap(false, msgDesc, msgDesc + YarnClient.errMessage, null, null);
                                    throw hdpException;
                                }
                                catch (HadoopException he) {
                                    throw he;
                                }
                                catch (Throwable t) {
                                    String msgDesc = "Exception while getting Yarn Queue List. URL : " + YarnClient.this.yarnQUrl;
                                    HadoopException hdpException = new HadoopException(msgDesc, t);
                                    LOG.error((Object)msgDesc, t);
                                    hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + YarnClient.errMessage, null, null);
                                    throw hdpException;
                                }
                                finally {
                                    if (response != null) {
                                        response.close();
                                    }
                                    if (client != null) {
                                        client.destroy();
                                    }
                                }
                            }
                            return lret;
                        }

                        private ClientResponse getQueueResponse(String url, Client client) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("getQueueResponse():calling " + url));
                            }
                            WebResource webResource = client.resource(url);
                            ClientResponse response = (ClientResponse)webResource.accept(new String[]{YarnClient.EXPECTED_MIME_TYPE}).get(ClientResponse.class);
                            if (response != null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("getQueueResponse():response.getStatus()= " + response.getStatus()));
                                }
                                if (response.getStatus() != 200) {
                                    LOG.info((Object)("getQueueResponse():response.getStatus()= " + response.getStatus() + " for URL " + url + ", failed to get queue list"));
                                    String jsonString = (String)response.getEntity(String.class);
                                    LOG.info((Object)jsonString);
                                }
                            }
                            return response;
                        }
                    });
                }
                return yarnQueueListGetter;
            }
        };
        try {
            ret = YarnClient.timedTask(callableYarnQListGetter, 5L, TimeUnit.SECONDS);
        }
        catch (Throwable t) {
            LOG.error((Object)("Unable to get Yarn Queue list from [" + this.yarnQUrl + "]"), t);
            String msgDesc = "Unable to get a valid response for expected mime type : [application/json] URL : " + this.yarnQUrl;
            HadoopException hdpException = new HadoopException(msgDesc, t);
            LOG.error((Object)msgDesc, t);
            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + errMessage, null, null);
            throw hdpException;
        }
        return ret;
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) {
        String errMsg = errMessage;
        boolean connectivityStatus = false;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        YarnClient yarnClient = YarnClient.getYarnClient(serviceName, configs);
        List<String> strList = YarnClient.getYarnResource(yarnClient, "", null);
        if (strList != null && strList.size() > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("TESTING list size" + strList.size() + " Yarn Queues"));
            }
            connectivityStatus = true;
        }
        if (connectivityStatus) {
            String successMsg = "ConnectionTest Successful";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
        } else {
            String failureMsg = "Unable to retrieve any Yarn Queues using given parameters.";
            BaseClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + errMsg), null, null, responseData);
        }
        return responseData;
    }

    public static YarnClient getYarnClient(String serviceName, Map<String, String> configs) {
        YarnClient yarnClient = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting YarnClient for datasource: " + serviceName));
        }
        String errMsg = errMessage;
        if (configs == null || configs.isEmpty()) {
            String msgDesc = "Could not connect as Connection ConfigMap is empty.";
            LOG.error((Object)msgDesc);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
            throw hdpException;
        }
        yarnClient = new YarnClient(serviceName, configs);
        return yarnClient;
    }

    public static List<String> getYarnResource(YarnClient yarnClient, String yarnQname, List<String> existingQueueName) {
        List<String> resultList = new ArrayList<String>();
        String errMsg = errMessage;
        try {
            String finalyarnQueueName;
            if (yarnClient == null) {
                String msgDesc = "Unable to get Yarn Queue : YarnClient is null.";
                LOG.error((Object)msgDesc);
                HadoopException hdpException = new HadoopException(msgDesc);
                hdpException.generateResponseDataMap(false, msgDesc, msgDesc + errMsg, null, null);
                throw hdpException;
            }
            if (yarnQname != null && (resultList = yarnClient.getQueueList(finalyarnQueueName = yarnQname.trim(), existingQueueName)) != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Returning list of " + resultList.size() + " Yarn Queues"));
            }
        }
        catch (HadoopException he) {
            throw he;
        }
        catch (Throwable t) {
            String msgDesc = "getYarnResource: Unable to get Yarn resources.";
            LOG.error((Object)msgDesc, t);
            HadoopException hdpException = new HadoopException(msgDesc);
            hdpException.generateResponseDataMap(false, BaseClient.getMessage((Throwable)t), msgDesc + errMsg, null, null);
            throw hdpException;
        }
        return resultList;
    }

    public static <T> T timedTask(Callable<T> callableObj, long timeout, TimeUnit timeUnit) throws Exception {
        return callableObj.call();
    }
}

