/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.yarn.authorizer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.Permission;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.authorization.yarn.authorizer.RangerYarnAccessRequest;
import org.apache.ranger.authorization.yarn.authorizer.RangerYarnAuditHandler;
import org.apache.ranger.authorization.yarn.authorizer.RangerYarnPlugin;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.util.RangerPerfTracer;

public class RangerYarnAuthorizer
extends YarnAuthorizationProvider {
    public static final String ACCESS_TYPE_ADMIN_QUEUE = "admin-queue";
    public static final String ACCESS_TYPE_SUBMIT_APP = "submit-app";
    public static final String ACCESS_TYPE_ADMIN = "admin";
    public static final String KEY_RESOURCE_QUEUE = "queue";
    private static final Log LOG = LogFactory.getLog(RangerYarnAuthorizer.class);
    private static volatile RangerYarnPlugin yarnPlugin = null;
    private boolean yarnAuthEnabled = true;
    private String yarnModuleName = "yarn-acl";
    private AccessControlList admins = null;
    private final ConcurrentMap<PrivilegedEntity, Map<AccessType, AccessControlList>> yarnAcl = new ConcurrentHashMap<PrivilegedEntity, Map<AccessType, AccessControlList>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init(Configuration conf) {
        RangerYarnPlugin plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerYarnAuthorizer.init()");
        }
        if ((plugin = yarnPlugin) == null) {
            Class<RangerYarnAuthorizer> clazz = RangerYarnAuthorizer.class;
            // MONITORENTER : org.apache.ranger.authorization.yarn.authorizer.RangerYarnAuthorizer.class
            plugin = yarnPlugin;
            if (plugin == null) {
                plugin = new RangerYarnPlugin();
                plugin.init();
                yarnPlugin = plugin;
            }
            // MONITOREXIT : clazz
        }
        this.yarnAuthEnabled = yarnPlugin.getConfig().getBoolean("ranger.add-yarn-authorization", true);
        this.yarnModuleName = yarnPlugin.getConfig().get("ranger.auditlog.yarnAcl.name", "yarn-acl");
        if (!LOG.isDebugEnabled()) return;
        LOG.debug((Object)"<== RangerYarnAuthorizer.init()");
    }

    public boolean checkPermission(AccessRequest accessRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerYarnAuthorizer.checkPermission(" + accessRequest + ")"));
        }
        boolean ret = false;
        RangerYarnPlugin plugin = yarnPlugin;
        RangerYarnAuditHandler auditHandler = null;
        RangerAccessResult result = null;
        RangerPerfTracer perf = null;
        RangerPerfTracer yarnAclPerf = null;
        if (plugin != null) {
            RangerYarnAccessRequest request = new RangerYarnAccessRequest(accessRequest);
            auditHandler = new RangerYarnAuditHandler(this.yarnModuleName);
            result = plugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
        }
        if (this.yarnAuthEnabled && (result == null || !result.getIsAccessDetermined())) {
            ret = this.isAllowedByYarnAcl(accessRequest, auditHandler);
        } else {
            boolean bl = ret = result != null && result.getIsAllowed();
        }
        if (auditHandler != null) {
            auditHandler.flushAudit();
        }
        RangerPerfTracer.log(yarnAclPerf);
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerYarnAuthorizer.checkPermission(" + accessRequest + "): " + ret));
        }
        return ret;
    }

    public boolean isAdmin(UserGroupInformation ugi) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerYarnAuthorizer.isAdmin(" + ugi + ")"));
        }
        boolean ret = false;
        AccessControlList admins = this.admins;
        if (admins != null) {
            ret = admins.isUserAllowed(ugi);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerYarnAuthorizer.isAdmin(" + ugi + "): " + ret));
        }
        return ret;
    }

    public void setAdmins(AccessControlList acl, UserGroupInformation ugi) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerYarnAuthorizer.setAdmins(" + acl + ", " + ugi + ")"));
        }
        this.admins = acl;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerYarnAuthorizer.setAdmins(" + acl + ", " + ugi + ")"));
        }
    }

    public void setPermission(List<Permission> permissions, UserGroupInformation ugi) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerYarnAuthorizer.setPermission(" + permissions + ", " + ugi + ")"));
        }
        for (Permission permission : permissions) {
            this.yarnAcl.put(permission.getTarget(), permission.getAcls());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerYarnAuthorizer.setPermission(" + permissions + ", " + ugi + ")"));
        }
    }

    public boolean isAllowedByYarnAcl(AccessRequest accessRequest, RangerYarnAuditHandler auditHandler) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerYarnAuthorizer.isAllowedByYarnAcl(" + accessRequest + ")"));
        }
        boolean ret = false;
        AccessType accessType = accessRequest.getAccessType();
        PrivilegedEntity entity = accessRequest.getEntity();
        UserGroupInformation ugi = accessRequest.getUser();
        for (Map.Entry e : this.yarnAcl.entrySet()) {
            PrivilegedEntity aclEntity = (PrivilegedEntity)e.getKey();
            Map entityPermissions = (Map)e.getValue();
            AccessControlList acl = entityPermissions == null ? null : (AccessControlList)entityPermissions.get(accessType);
            if (acl == null || !acl.isUserAllowed(ugi) || !this.isSelfOrChildOf(entity, aclEntity)) continue;
            ret = true;
            break;
        }
        if (auditHandler != null) {
            auditHandler.logYarnAclEvent(ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerYarnAuthorizer.isAllowedByYarnAcl(" + accessRequest + "): " + ret));
        }
        return ret;
    }

    private boolean isSelfOrChildOf(PrivilegedEntity queue, PrivilegedEntity parentQueue) {
        boolean ret = queue.equals((Object)parentQueue);
        if (!ret && queue.getType() == PrivilegedEntity.EntityType.QUEUE) {
            String queueName = queue.getName();
            String parentQueueName = parentQueue.getName();
            if (queueName.contains(".") && !StringUtil.isEmpty((String)parentQueueName)) {
                if (parentQueueName.charAt(parentQueueName.length() - 1) != '.') {
                    parentQueueName = parentQueueName + ".";
                }
                ret = queueName.startsWith(parentQueueName);
            }
        }
        return ret;
    }
}

