/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.yarn.authorizer;

import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.security.AccessRequest;
import org.apache.hadoop.yarn.security.AccessType;
import org.apache.hadoop.yarn.security.PrivilegedEntity;
import org.apache.ranger.authorization.yarn.authorizer.RangerYarnResource;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;

class RangerYarnAccessRequest
extends RangerAccessRequestImpl {
    public RangerYarnAccessRequest(AccessRequest accessRequest) {
        String accessType = RangerYarnAccessRequest.getRangerAccessType(accessRequest.getAccessType());
        String action = accessRequest.getAccessType().name();
        PrivilegedEntity entity = accessRequest.getEntity();
        UserGroupInformation ugi = accessRequest.getUser();
        super.setResource((RangerAccessResource)new RangerYarnResource(entity));
        super.setAccessType(accessType);
        super.setUser(ugi.getShortUserName());
        super.setUserGroups((Set)Sets.newHashSet((Object[])ugi.getGroupNames()));
        super.setAccessTime(new Date());
        String remoteIP = accessRequest.getRemoteAddress();
        if (StringUtils.isEmpty((String)remoteIP)) {
            remoteIP = RangerYarnAccessRequest.getRemoteIp();
        }
        super.setClientIPAddress(remoteIP);
        super.setAction(action);
        super.setRemoteIPAddress(accessRequest.getRemoteAddress());
        super.setForwardedAddresses(accessRequest.getForwardedAddresses());
        super.setRequestData(accessRequest.getAppName());
    }

    private static String getRemoteIp() {
        String ret = null;
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            ret = ip.getHostAddress();
        }
        return ret;
    }

    private static String getRangerAccessType(AccessType accessType) {
        String ret = null;
        switch (accessType) {
            case ADMINISTER_QUEUE: {
                ret = "admin-queue";
                break;
            }
            case SUBMIT_APP: {
                ret = "submit-app";
            }
        }
        return ret;
    }
}

