/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kms.authorizer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMS;
import org.apache.hadoop.crypto.key.kms.server.KMSACLsType;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KMSWebApp;
import org.apache.hadoop.crypto.key.kms.server.KeyAuthorizationKeyProvider;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.SecureClientLogin;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.kms.authorizer.RangerKMSAccessRequest;
import org.apache.ranger.authorization.kms.authorizer.RangerKMSPlugin;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerKmsAuthorizer
implements Runnable,
KeyAuthorizationKeyProvider.KeyACLs {
    private static final Logger LOG = LoggerFactory.getLogger(RangerKmsAuthorizer.class);
    private static final Log PERF_KMSAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"kmsauth.request");
    private static final String KMS_USER_PRINCIPAL = "ranger.ks.kerberos.principal";
    private static final String KMS_USER_KEYTAB = "ranger.ks.kerberos.keytab";
    private static final String KMS_NAME_RULES = "hadoop.security.auth_to_local";
    private static final String UNAUTHORIZED_MSG_WITH_KEY = "User:%s not allowed to do '%s' on '%s'";
    private static final String UNAUTHORIZED_MSG_WITHOUT_KEY = "User:%s not allowed to do '%s'";
    public static final int RELOADER_SLEEP_MILLIS = 1000;
    private static final Map<KMSACLsType.Type, String> ACCESS_TYPE_MAP = new HashMap<KMSACLsType.Type, String>();
    private volatile Map<KMSACLsType.Type, AccessControlList> blacklistedAcls;
    private long lastReload;
    private ScheduledExecutorService executorService;
    public static final String ACCESS_TYPE_DECRYPT_EEK = "decrypteek";
    public static final String ACCESS_TYPE_GENERATE_EEK = "generateeek";
    public static final String ACCESS_TYPE_GET_METADATA = "getmetadata";
    public static final String ACCESS_TYPE_GET_KEYS = "getkeys";
    public static final String ACCESS_TYPE_GET = "get";
    public static final String ACCESS_TYPE_SET_KEY_MATERIAL = "setkeymaterial";
    public static final String ACCESS_TYPE_ROLLOVER = "rollover";
    public static final String ACCESS_TYPE_CREATE = "create";
    public static final String ACCESS_TYPE_DELETE = "delete";
    private static volatile RangerKMSPlugin kmsPlugin = null;
    public static final String TYPE = "kerberos";
    public static final String PRINCIPAL = "kerberos.principal";
    public static final String KEYTAB = "kerberos.keytab";

    RangerKmsAuthorizer(Configuration conf) {
        LOG.info("RangerKmsAuthorizer(conf)...");
        if (conf == null) {
            conf = this.loadACLs();
        }
        this.authWithKerberos(conf);
        this.setKMSACLs(conf);
        this.init(conf);
    }

    private void authWithKerberos(Configuration conf) {
        String localHostName = null;
        try {
            localHostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e1) {
            LOG.warn("Error getting local host name : " + e1.getMessage());
        }
        String principal = null;
        try {
            principal = SecureClientLogin.getPrincipal((String)conf.get(KMS_USER_PRINCIPAL), (String)localHostName);
        }
        catch (IOException e1) {
            LOG.warn("Error getting ranger.ks.kerberos.principal : " + e1.getMessage());
        }
        String keytab = conf.get(KMS_USER_KEYTAB);
        String nameRules = conf.get(KMS_NAME_RULES);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ranger KMS Principal : " + principal + ", Keytab : " + keytab + ", NameRule : " + nameRules);
        }
        MiscUtil.authWithKerberos((String)keytab, (String)principal, (String)nameRules);
    }

    public RangerKmsAuthorizer() {
        this(null);
    }

    @Override
    public void run() {
        try {
            if (KMSConfiguration.isACLsFileNewer((long)this.lastReload)) {
                this.setKMSACLs(this.loadACLs());
            }
        }
        catch (Exception ex) {
            LOG.warn(String.format("Could not reload ACLs file: '%s'", ex.toString()), (Throwable)ex);
        }
    }

    private Configuration loadACLs() {
        LOG.debug("Loading ACLs file");
        this.lastReload = System.currentTimeMillis();
        Configuration conf = KMSConfiguration.getACLsConf();
        conf.get(KMSACLsType.Type.CREATE.getAclConfigKey());
        return conf;
    }

    public synchronized void startReloader() {
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1);
            this.executorService.scheduleAtFixedRate(this, 1000L, 1000L, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stopReloader() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }

    public boolean hasAccess(KMSACLsType.Type type, UserGroupInformation ugi, String clientIp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.hasAccess(" + type + ", " + ugi + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_KMSAUTH_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Log)PERF_KMSAUTH_REQUEST_LOG, (String)("RangerKmsAuthorizer.hasAccess(type=" + type + ")"));
        }
        boolean ret = false;
        RangerKMSPlugin plugin = kmsPlugin;
        String rangerAccessType = RangerKmsAuthorizer.getRangerAccessType(type);
        AccessControlList blacklist = this.blacklistedAcls.get(type);
        boolean bl = ret = blacklist == null || !blacklist.isUserInList(ugi);
        if (!ret) {
            LOG.debug("Operation " + rangerAccessType + " blocked in the blacklist for user " + ugi.getUserName());
        }
        if (plugin != null && ret) {
            RangerKMSAccessRequest request = new RangerKMSAccessRequest("", rangerAccessType, ugi, clientIp);
            RangerAccessResult result = plugin.isAccessAllowed((RangerAccessRequest)request);
            ret = result != null && result.getIsAllowed();
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerkmsAuthorizer.hasAccess(" + type + ", " + ugi + "): " + ret);
        }
        return ret;
    }

    public boolean hasAccess(KMSACLsType.Type type, UserGroupInformation ugi, String keyName, String clientIp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.hasAccess(" + type + ", " + ugi + " , " + keyName + ")");
        }
        boolean ret = false;
        RangerKMSPlugin plugin = kmsPlugin;
        String rangerAccessType = RangerKmsAuthorizer.getRangerAccessType(type);
        AccessControlList blacklist = this.blacklistedAcls.get(type);
        boolean bl = ret = blacklist == null || !blacklist.isUserInList(ugi);
        if (!ret) {
            LOG.debug("Operation " + rangerAccessType + " blocked in the blacklist for user " + ugi.getUserName());
        }
        if (plugin != null && ret) {
            RangerKMSAccessRequest request = new RangerKMSAccessRequest(keyName, rangerAccessType, ugi, clientIp);
            RangerAccessResult result = plugin.isAccessAllowed((RangerAccessRequest)request);
            boolean bl2 = ret = result != null && result.getIsAllowed();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerkmsAuthorizer.hasAccess(" + type + ", " + ugi + " , " + keyName + "): " + ret);
        }
        return ret;
    }

    public void assertAccess(KMSACLsType.Type aclType, UserGroupInformation ugi, KMS.KMSOp operation, String key, String clientIp) throws AccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.assertAccess(" + key + ", " + ugi + ", " + aclType + ")");
        }
        String string = key = key == null ? "" : key;
        if (!this.hasAccess(aclType, ugi, key, clientIp)) {
            KMSWebApp.getUnauthorizedCallsMeter().mark();
            KMSWebApp.getKMSAudit().unauthorized(ugi, operation, key);
            throw new AuthorizationException(String.format(!key.equals("") ? UNAUTHORIZED_MSG_WITH_KEY : UNAUTHORIZED_MSG_WITHOUT_KEY, ugi.getShortUserName(), operation, key));
        }
    }

    public boolean hasAccessToKey(String keyName, UserGroupInformation ugi, KeyAuthorizationKeyProvider.KeyOpType opType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerKmsAuthorizer.hasAccessToKey(" + keyName + ", " + ugi + ", " + opType + ")");
        }
        return true;
    }

    public boolean isACLPresent(String keyName, KeyAuthorizationKeyProvider.KeyOpType opType) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init(Configuration conf) {
        RangerKMSPlugin plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerKmsAuthorizer.init()");
        }
        if ((plugin = kmsPlugin) == null) {
            Class<RangerKmsAuthorizer> clazz = RangerKmsAuthorizer.class;
            // MONITORENTER : org.apache.ranger.authorization.kms.authorizer.RangerKmsAuthorizer.class
            plugin = kmsPlugin;
            if (plugin == null) {
                plugin = new RangerKMSPlugin();
                plugin.init();
                kmsPlugin = plugin;
            }
            // MONITOREXIT : clazz
        }
        if (!LOG.isDebugEnabled()) return;
        LOG.debug("<== RangerkmsAuthorizer.init()");
    }

    private void setKMSACLs(Configuration conf) {
        HashMap<KMSACLsType.Type, AccessControlList> tempBlacklist = new HashMap<KMSACLsType.Type, AccessControlList>();
        for (KMSACLsType.Type aclType : KMSACLsType.Type.values()) {
            String blacklistStr = conf.get(aclType.getBlacklistConfigKey());
            if (blacklistStr == null) continue;
            tempBlacklist.put(aclType, new AccessControlList(blacklistStr));
            LOG.info("'{}' Blacklist '{}'", (Object)aclType, (Object)blacklistStr);
        }
        this.blacklistedAcls = tempBlacklist;
    }

    private static String getRangerAccessType(KMSACLsType.Type accessType) {
        if (ACCESS_TYPE_MAP.containsKey(accessType)) {
            return ACCESS_TYPE_MAP.get(accessType);
        }
        return null;
    }

    static {
        ACCESS_TYPE_MAP.put(KMSACLsType.Type.CREATE, ACCESS_TYPE_CREATE);
        ACCESS_TYPE_MAP.put(KMSACLsType.Type.DELETE, ACCESS_TYPE_DELETE);
        ACCESS_TYPE_MAP.put(KMSACLsType.Type.ROLLOVER, ACCESS_TYPE_ROLLOVER);
        ACCESS_TYPE_MAP.put(KMSACLsType.Type.GET, ACCESS_TYPE_GET);
        ACCESS_TYPE_MAP.put(KMSACLsType.Type.GET_KEYS, ACCESS_TYPE_GET_KEYS);
        ACCESS_TYPE_MAP.put(KMSACLsType.Type.GET_METADATA, ACCESS_TYPE_GET_METADATA);
        ACCESS_TYPE_MAP.put(KMSACLsType.Type.SET_KEY_MATERIAL, ACCESS_TYPE_SET_KEY_MATERIAL);
        ACCESS_TYPE_MAP.put(KMSACLsType.Type.GENERATE_EEK, ACCESS_TYPE_GENERATE_EEK);
        ACCESS_TYPE_MAP.put(KMSACLsType.Type.DECRYPT_EEK, ACCESS_TYPE_DECRYPT_EEK);
    }
}

