/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.ozone.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.ozone.client.OzoneClient;
import org.apache.ranger.services.ozone.client.OzoneConnectionMgr;

public class OzoneResourceMgr {
    private static final Logger LOG = Logger.getLogger(OzoneResourceMgr.class);
    private static final String VOLUME = "volume";
    private static final String BUCKET = "bucket";
    private static final String KEY = "key";

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> OzoneResourceMgr.connectionTest ServiceName: " + serviceName + "Configs" + configs));
        }
        try {
            ret = OzoneClient.connectionTest(serviceName, configs);
        }
        catch (HadoopException e) {
            LOG.error((Object)("<== OzoneResourceMgr.connectionTest Error: " + (Object)((Object)e)));
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== OzoneResourceMgr.connectionTest Result : " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getOzoneResources(String serviceName, String serviceType, Map<String, String> configs, ResourceLookupContext context) throws Exception {
        List keyList;
        List bucketList;
        List volumeList;
        List resultList;
        String userInput;
        block27: {
            userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            volumeList = null;
            bucketList = null;
            keyList = null;
            String volumePrefix = null;
            String bucketPrefix = null;
            String keyPrefix = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== OzoneResourceMgr.getOzoneResources()  UserInput: \"" + userInput + "\" resource : " + resource + " resourceMap: " + resourceMap));
            }
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    volumeList = (List)resourceMap.get(VOLUME);
                    bucketList = (List)resourceMap.get(BUCKET);
                    keyList = (List)resourceMap.get(KEY);
                }
                switch (resource.trim().toLowerCase()) {
                    case "volume": {
                        volumePrefix = userInput;
                        break;
                    }
                    case "bucket": {
                        bucketPrefix = userInput;
                        break;
                    }
                    case "key": {
                        keyPrefix = userInput;
                        break;
                    }
                }
            }
            if (serviceName != null && userInput != null) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("==> OzoneResourceMgr.getOzoneResources() UserInput: " + userInput + " configs: " + configs + " volumeList: " + volumeList + " bucketList: " + bucketList + " keyList: " + keyList));
                    }
                    final OzoneClient ozoneClient = new OzoneConnectionMgr().getOzoneConnection(serviceName, serviceType, configs);
                    Callable<List<String>> callableObj = null;
                    final List finalvolumeList = volumeList;
                    final List finalbucketList = bucketList;
                    if (ozoneClient == null) break block27;
                    if (volumePrefix != null && !volumePrefix.isEmpty()) {
                        final String finalVolPrefix = volumePrefix;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                return ozoneClient.getVolumeList(finalVolPrefix);
                            }
                        };
                    } else if (bucketPrefix != null && !bucketPrefix.isEmpty()) {
                        final String finalBucketPrefix = bucketPrefix;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                return ozoneClient.getBucketList(finalBucketPrefix, finalvolumeList);
                            }
                        };
                    } else if (keyPrefix != null && !keyPrefix.isEmpty()) {
                        final String finalKeyPrefix = keyPrefix;
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                return ozoneClient.getKeyList(finalKeyPrefix, finalvolumeList, finalbucketList);
                            }
                        };
                    }
                    if (callableObj != null) {
                        OzoneClient ozoneClient2 = ozoneClient;
                        synchronized (ozoneClient2) {
                            resultList = (List)TimedEventUtil.timedTask((Callable)callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                            break block27;
                        }
                    }
                    LOG.error((Object)"Could not initiate at timedTask");
                }
                catch (Exception e) {
                    LOG.error((Object)"Unable to get ozone resources.", (Throwable)e);
                    throw e;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== OzoneResourceMgr.getOzoneResources() UserInput: " + userInput + " configs: " + configs + " volumeList: " + volumeList + " bucketList: " + bucketList + " keyList: " + keyList + "Result :" + resultList));
        }
        return resultList;
    }
}

