/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.ozone.client;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.util.TimedEventUtil;
import org.apache.ranger.services.ozone.client.OzoneClient;

public class OzoneConnectionMgr {
    private static final Logger LOG = Logger.getLogger(OzoneConnectionMgr.class);
    protected ConcurrentMap<String, OzoneClient> ozoneConnectionCache = new ConcurrentHashMap<String, OzoneClient>();
    protected ConcurrentMap<String, Boolean> repoConnectStatusMap = new ConcurrentHashMap<String, Boolean>();

    public OzoneClient getOzoneConnection(final String serviceName, String serviceType, final Map<String, String> configs) {
        OzoneClient ozoneClient = null;
        if (serviceType != null) {
            ozoneClient = (OzoneClient)((Object)this.ozoneConnectionCache.get(serviceName));
            if (ozoneClient == null) {
                if (configs != null) {
                    Callable<OzoneClient> connectHive = new Callable<OzoneClient>(){

                        @Override
                        public OzoneClient call() throws Exception {
                            return new OzoneClient(serviceName, configs);
                        }
                    };
                    try {
                        ozoneClient = (OzoneClient)((Object)TimedEventUtil.timedTask((Callable)connectHive, (long)5L, (TimeUnit)TimeUnit.SECONDS));
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error connecting ozone repository : " + serviceName + " using config : " + configs), (Throwable)e);
                    }
                    OzoneClient oldClient = null;
                    oldClient = ozoneClient != null ? this.ozoneConnectionCache.putIfAbsent(serviceName, ozoneClient) : (OzoneClient)((Object)this.ozoneConnectionCache.get(serviceName));
                    if (oldClient != null) {
                        if (ozoneClient != null) {
                            ozoneClient.close();
                        }
                        ozoneClient = oldClient;
                    }
                    this.repoConnectStatusMap.put(serviceName, true);
                } else {
                    LOG.error((Object)("Connection Config not defined for asset :" + serviceName), new Throwable());
                }
            } else {
                try {
                    ozoneClient.getVolumeList(null);
                }
                catch (Exception e) {
                    this.ozoneConnectionCache.remove(serviceName);
                    ozoneClient.close();
                    ozoneClient = this.getOzoneConnection(serviceName, serviceType, configs);
                }
            }
        } else {
            LOG.error((Object)("Asset not found with name " + serviceName), new Throwable());
        }
        return ozoneClient;
    }
}

