/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.ozone.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClientFactory;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.ranger.plugin.client.BaseClient;

public class OzoneClient
extends BaseClient {
    private static final Log LOG = LogFactory.getLog(OzoneClient.class);
    private static final String ERR_MSG = "You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
    private Configuration conf = new Configuration();
    private org.apache.hadoop.ozone.client.OzoneClient ozoneClient = null;

    public OzoneClient(String serviceName, Map<String, String> connectionProperties) throws Exception {
        super(serviceName, connectionProperties, "ozone-client");
        Set rangerInternalPropertyKeys = this.getConfigHolder().getRangerInternalPropertyKeys();
        for (Map.Entry<String, String> entry : connectionProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (rangerInternalPropertyKeys.contains(key) || value == null) continue;
            this.conf.set(key, value);
        }
        this.ozoneClient = OzoneClientFactory.getRpcClient((String)this.conf.get("ozone.om.http-address"));
    }

    public void close() {
        try {
            this.ozoneClient.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Unable to close Ozone Client connection", (Throwable)e);
        }
    }

    public List<String> getVolumeList(String volumePrefix) {
        ArrayList<String> ret;
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> OzoneClient getVolume volumePrefix : " + volumePrefix));
            }
            ret = new ArrayList<String>();
            try {
                Iterator ozoneVolList;
                if (this.ozoneClient != null && (ozoneVolList = this.ozoneClient.getObjectStore().listVolumesByUser(this.conf.get("username"), volumePrefix, null)) != null) {
                    while (ozoneVolList.hasNext()) {
                        ret.add(((OzoneVolume)ozoneVolList.next()).getName());
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to get Volume List");
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)"<== OzoneClient.getVolumeList() Error : ", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== OzoneClient.getVolumeList(): " + ret));
        }
        return ret;
    }

    public List<String> getBucketList(String bucketPrefix, List<String> finalvolumeList) {
        ArrayList<String> ret;
        block7: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> OzoneClient getBucketList bucketPrefix : " + bucketPrefix));
            }
            ret = new ArrayList<String>();
            try {
                if (this.ozoneClient != null && finalvolumeList != null && !finalvolumeList.isEmpty()) {
                    for (String ozoneVol : finalvolumeList) {
                        Iterator ozoneBucketList = this.ozoneClient.getObjectStore().getVolume(ozoneVol).listBuckets(bucketPrefix);
                        if (ozoneBucketList == null) continue;
                        while (ozoneBucketList.hasNext()) {
                            ret.add(((OzoneBucket)ozoneBucketList.next()).getName());
                        }
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to get Volume List");
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)"<== OzoneClient.getVolumeList() Error : ", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== OzoneClient.getVolumeList(): " + ret));
        }
        return ret;
    }

    public List<String> getKeyList(String keyPrefix, List<String> finalvolumeList, List<String> finalbucketList) {
        ArrayList<String> ret;
        block8: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> OzoneClient getKeyList keyPrefix : " + keyPrefix));
            }
            ret = new ArrayList<String>();
            try {
                if (this.ozoneClient != null && finalvolumeList != null && !finalvolumeList.isEmpty()) {
                    for (String ozoneVol : finalvolumeList) {
                        Iterator ozoneBucketList = this.ozoneClient.getObjectStore().getVolume(ozoneVol).listBuckets(null);
                        if (ozoneBucketList == null) continue;
                        while (ozoneBucketList.hasNext()) {
                            Iterator ozoneKeyList;
                            String bucketName = ((OzoneBucket)ozoneBucketList.next()).getName();
                            if (!finalbucketList.contains(bucketName) || (ozoneKeyList = ((OzoneBucket)ozoneBucketList.next()).listKeys(keyPrefix)) == null) continue;
                            while (ozoneKeyList.hasNext()) {
                                ret.add(((OzoneKey)ozoneKeyList.next()).getName());
                            }
                        }
                    }
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to get Volume List");
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)"<== OzoneClient.getVolumeList() Error : ", (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== OzoneClient.getVolumeList(): " + ret));
        }
        return ret;
    }

    public static Map<String, Object> connectionTest(String serviceName, Map<String, String> connectionProperties) throws Exception {
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        OzoneClient connectionObj = null;
        boolean connectivityStatus = false;
        List<String> testResult = null;
        try {
            connectionObj = new OzoneClient(serviceName, connectionProperties);
            if (connectionObj != null) {
                testResult = connectionObj.getVolumeList(null);
                if (testResult != null && testResult.size() != 0) {
                    connectivityStatus = true;
                }
                if (connectivityStatus) {
                    String successMsg = "ConnectionTest Successful";
                    OzoneClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
                } else {
                    String failureMsg = "Unable to retrieve any volumes using given parameters.";
                    OzoneClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + ERR_MSG), null, null, responseData);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (connectionObj != null) {
                connectionObj.close();
            }
        }
        return responseData;
    }
}

