/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.atlas.authorizer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.authorize.AtlasAdminAccessRequest;
import org.apache.atlas.authorize.AtlasAuthorizationException;
import org.apache.atlas.authorize.AtlasAuthorizer;
import org.apache.atlas.authorize.AtlasEntityAccessRequest;
import org.apache.atlas.authorize.AtlasPrivilege;
import org.apache.atlas.authorize.AtlasRelationshipAccessRequest;
import org.apache.atlas.authorize.AtlasSearchResultScrubRequest;
import org.apache.atlas.authorize.AtlasTypeAccessRequest;
import org.apache.atlas.model.discovery.AtlasSearchResult;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.apache.ranger.plugin.util.RangerPerfTracer;

public class RangerAtlasAuthorizer
implements AtlasAuthorizer {
    private static final Log LOG = LogFactory.getLog(RangerAtlasAuthorizer.class);
    private static final Log PERF_LOG = RangerPerfTracer.getPerfLogger((String)"atlasauth.request");
    private static volatile RangerBasePlugin atlasPlugin = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init() {
        RangerBasePlugin plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAtlasPlugin.init()");
        }
        if ((plugin = atlasPlugin) == null) {
            Class<RangerAtlasPlugin> clazz = RangerAtlasPlugin.class;
            // MONITORENTER : org.apache.ranger.authorization.atlas.authorizer.RangerAtlasAuthorizer$RangerAtlasPlugin.class
            plugin = atlasPlugin;
            if (plugin == null) {
                plugin = new RangerAtlasPlugin();
                plugin.init();
                plugin.setResultProcessor((RangerAccessResultProcessor)new RangerDefaultAuditHandler((Configuration)plugin.getConfig()));
                atlasPlugin = plugin;
            }
            // MONITOREXIT : clazz
        }
        if (!LOG.isDebugEnabled()) return;
        LOG.debug((Object)"<== RangerAtlasPlugin.init()");
    }

    public void cleanUp() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> cleanUp ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessAllowed(AtlasAdminAccessRequest request) throws AtlasAuthorizationException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> isAccessAllowed(" + request + ")"));
        }
        RangerPerfTracer perf = null;
        try {
            if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Log)PERF_LOG, (String)("RangerAtlasAuthorizer.isAccessAllowed(" + request + ")"));
            }
            String action = request.getAction() != null ? request.getAction().getType() : null;
            RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl(Collections.singletonMap("atlas-service", "*"));
            RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl((RangerAccessResource)rangerResource, action, request.getUser(), request.getUserGroups());
            rangerRequest.setClientIPAddress(request.getClientIPAddress());
            rangerRequest.setAccessTime(request.getAccessTime());
            rangerRequest.setAction(action);
            rangerRequest.setForwardedAddresses(request.getForwardedAddresses());
            rangerRequest.setRemoteIPAddress(request.getRemoteIPAddress());
            ret = this.checkAccess(rangerRequest);
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== isAccessAllowed(" + request + "): " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessAllowed(AtlasEntityAccessRequest request) throws AtlasAuthorizationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> isAccessAllowed(" + request + ")"));
        }
        boolean ret = true;
        RangerPerfTracer perf = null;
        RangerAtlasAuditHandler auditHandler = null;
        try {
            if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Log)PERF_LOG, (String)("RangerAtlasAuthorizer.isAccessAllowed(" + request + ")"));
            }
            if (!StringUtils.isEmpty((String)request.getEntityId()) || request.getClassification() != null || request.getEntity() != null) {
                auditHandler = new RangerAtlasAuditHandler(request, this.getServiceDef());
            }
            ret = this.isAccessAllowed(request, auditHandler);
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== isAccessAllowed(" + request + "): " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessAllowed(AtlasTypeAccessRequest request) throws AtlasAuthorizationException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> isAccessAllowed(" + request + ")"));
        }
        RangerPerfTracer perf = null;
        try {
            if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Log)PERF_LOG, (String)("RangerAtlasAuthorizer.isAccessAllowed(" + request + ")"));
            }
            String typeName = request.getTypeDef() != null ? request.getTypeDef().getName() : null;
            String typeCategory = request.getTypeDef() != null && request.getTypeDef().getCategory() != null ? request.getTypeDef().getCategory().name() : null;
            String action = request.getAction() != null ? request.getAction().getType() : null;
            RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
            rangerResource.setValue("type", (Object)typeName);
            rangerResource.setValue("type-category", (Object)typeCategory);
            RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl((RangerAccessResource)rangerResource, action, request.getUser(), request.getUserGroups());
            rangerRequest.setClientIPAddress(request.getClientIPAddress());
            rangerRequest.setAccessTime(request.getAccessTime());
            rangerRequest.setAction(action);
            rangerRequest.setForwardedAddresses(request.getForwardedAddresses());
            rangerRequest.setRemoteIPAddress(request.getRemoteIPAddress());
            ret = this.checkAccess(rangerRequest);
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== isAccessAllowed(" + request + "): " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAccessAllowed(AtlasRelationshipAccessRequest request) throws AtlasAuthorizationException {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> isAccessAllowed(" + request + ")"));
        }
        RangerPerfTracer perf = null;
        try {
            if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Log)PERF_LOG, (String)("RangerAtlasAuthorizer.isAccessAllowed(" + request + ")"));
            }
            String action = request.getAction() != null ? request.getAction().getType() : null;
            Set end1EntityTypeAndSuperTypes = request.getEnd1EntityTypeAndAllSuperTypes();
            HashSet end1Classifications = new HashSet(request.getEnd1EntityClassifications());
            String end1EntityId = request.getEnd1EntityId();
            Set end2EntityTypeAndSuperTypes = request.getEnd2EntityTypeAndAllSuperTypes();
            HashSet end2Classifications = new HashSet(request.getEnd2EntityClassifications());
            String end2EntityId = request.getEnd2EntityId();
            String relationShipType = request.getRelationshipType();
            RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
            RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl((RangerAccessResource)rangerResource, action, request.getUser(), request.getUserGroups());
            rangerRequest.setClientIPAddress(request.getClientIPAddress());
            rangerRequest.setAccessTime(request.getAccessTime());
            rangerRequest.setAction(action);
            rangerRequest.setForwardedAddresses(request.getForwardedAddresses());
            rangerRequest.setRemoteIPAddress(request.getRemoteIPAddress());
            rangerResource.setValue("relationship-type", (Object)relationShipType);
            HashSet classificationsWithSuperTypesEnd1 = new HashSet();
            for (String classificationToAuthorize : end1Classifications) {
                classificationsWithSuperTypesEnd1.addAll(request.getClassificationTypeAndAllSuperTypes(classificationToAuthorize));
            }
            rangerResource.setValue("end-one-entity-type", (Object)end1EntityTypeAndSuperTypes);
            rangerResource.setValue("end-one-entity-classification", classificationsWithSuperTypesEnd1);
            rangerResource.setValue("end-one-entity", (Object)end1EntityId);
            HashSet classificationsWithSuperTypesEnd2 = new HashSet();
            for (String classificationToAuthorize : end2Classifications) {
                classificationsWithSuperTypesEnd2.addAll(request.getClassificationTypeAndAllSuperTypes(classificationToAuthorize));
            }
            rangerResource.setValue("end-two-entity-type", (Object)end2EntityTypeAndSuperTypes);
            rangerResource.setValue("end-two-entity-classification", classificationsWithSuperTypesEnd2);
            rangerResource.setValue("end-two-entity", (Object)end2EntityId);
            ret = this.checkAccess(rangerRequest);
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== isAccessAllowed(" + request + "): " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrubSearchResults(AtlasSearchResultScrubRequest request) throws AtlasAuthorizationException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> scrubSearchResults(" + request + ")"));
        }
        RangerPerfTracer perf = null;
        try {
            AtlasSearchResult result;
            if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Log)PERF_LOG, (String)("RangerAtlasAuthorizer.scrubSearchResults(" + request + ")"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(result = request.getSearchResult()).getEntities())) {
                for (AtlasEntityHeader entity : result.getEntities()) {
                    this.checkAccessAndScrub(entity, request);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)result.getFullTextResult())) {
                for (AtlasSearchResult.AtlasFullTextResult fullTextResult : result.getFullTextResult()) {
                    if (fullTextResult == null) continue;
                    this.checkAccessAndScrub(fullTextResult.getEntity(), request);
                }
            }
            if (MapUtils.isNotEmpty((Map)result.getReferredEntities())) {
                for (AtlasEntityHeader entity : result.getReferredEntities().values()) {
                    this.checkAccessAndScrub(entity, request);
                }
            }
        }
        catch (Throwable throwable) {
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== scrubSearchResults(): " + request));
        }
    }

    private RangerServiceDef getServiceDef() {
        RangerBasePlugin plugin = atlasPlugin;
        return plugin != null ? plugin.getServiceDef() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAccessAllowed(AtlasEntityAccessRequest request, RangerAtlasAuditHandler auditHandler) throws AtlasAuthorizationException {
        boolean ret;
        block12: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> isAccessAllowed(" + request + ")"));
            }
            ret = true;
            try {
                String action = request.getAction() != null ? request.getAction().getType() : null;
                Set entityTypes = request.getEntityTypeAndAllSuperTypes();
                String entityId = request.getEntityId();
                String classification = request.getClassification() != null ? request.getClassification().getTypeName() : null;
                RangerAccessRequestImpl rangerRequest = new RangerAccessRequestImpl();
                RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
                String ownerUser = request.getEntity() != null ? (String)request.getEntity().getAttribute("owner") : null;
                rangerResource.setValue("entity-type", (Object)entityTypes);
                rangerResource.setValue("entity", (Object)entityId);
                rangerResource.setOwnerUser(ownerUser);
                rangerRequest.setAccessType(action);
                rangerRequest.setAction(action);
                rangerRequest.setUser(request.getUser());
                rangerRequest.setUserGroups(request.getUserGroups());
                rangerRequest.setClientIPAddress(request.getClientIPAddress());
                rangerRequest.setAccessTime(request.getAccessTime());
                rangerRequest.setResource((RangerAccessResource)rangerResource);
                rangerRequest.setForwardedAddresses(request.getForwardedAddresses());
                rangerRequest.setRemoteIPAddress(request.getRemoteIPAddress());
                if (AtlasPrivilege.ENTITY_ADD_LABEL.equals((Object)request.getAction()) || AtlasPrivilege.ENTITY_REMOVE_LABEL.equals((Object)request.getAction())) {
                    rangerResource.setValue("entity-label", (Object)request.getLabel());
                } else if (AtlasPrivilege.ENTITY_UPDATE_BUSINESS_METADATA.equals((Object)request.getAction())) {
                    rangerResource.setValue("entity-business-metadata", (Object)request.getBusinessMetadata());
                }
                if (StringUtils.isNotEmpty((String)classification)) {
                    rangerResource.setValue("entity-classification", (Object)request.getClassificationTypeAndAllSuperTypes(classification));
                    ret = this.checkAccess(rangerRequest, auditHandler);
                }
                if (!ret) break block12;
                if (CollectionUtils.isNotEmpty((Collection)request.getEntityClassifications())) {
                    for (String classificationToAuthorize : request.getEntityClassifications()) {
                        rangerResource.setValue("entity-classification", (Object)request.getClassificationTypeAndAllSuperTypes(classificationToAuthorize));
                        ret = this.checkAccess(rangerRequest, auditHandler);
                        if (ret) continue;
                        break block12;
                    }
                    break block12;
                }
                rangerResource.setValue("entity-classification", (Object)"_NOT_CLASSIFIED");
                ret = this.checkAccess(rangerRequest, auditHandler);
            }
            finally {
                if (auditHandler != null) {
                    auditHandler.flushAudit();
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== isAccessAllowed(" + request + "): " + ret));
        }
        return ret;
    }

    private boolean checkAccess(RangerAccessRequestImpl request) {
        boolean ret = false;
        RangerBasePlugin plugin = atlasPlugin;
        if (plugin != null) {
            RangerAccessResult result = plugin.isAccessAllowed((RangerAccessRequest)request);
            ret = result != null && result.getIsAllowed();
        } else {
            LOG.warn((Object)"RangerAtlasPlugin not initialized. Access blocked!!!");
        }
        return ret;
    }

    private boolean checkAccess(RangerAccessRequestImpl request, RangerAtlasAuditHandler auditHandler) {
        boolean ret = false;
        RangerBasePlugin plugin = atlasPlugin;
        if (plugin != null) {
            RangerAccessResult result = plugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
            ret = result != null && result.getIsAllowed();
        } else {
            LOG.warn((Object)"RangerAtlasPlugin not initialized. Access blocked!!!");
        }
        return ret;
    }

    private void checkAccessAndScrub(AtlasEntityHeader entity, AtlasSearchResultScrubRequest request) throws AtlasAuthorizationException {
        if (entity != null && request != null) {
            AtlasEntityAccessRequest entityAccessRequest = new AtlasEntityAccessRequest(request.getTypeRegistry(), AtlasPrivilege.ENTITY_READ, entity, request.getUser(), request.getUserGroups());
            entityAccessRequest.setClientIPAddress(request.getClientIPAddress());
            entityAccessRequest.setForwardedAddresses(request.getForwardedAddresses());
            entityAccessRequest.setRemoteIPAddress(request.getRemoteIPAddress());
            if (!this.isAccessAllowed(entityAccessRequest, null)) {
                this.scrubEntityHeader(entity);
            }
        }
    }

    class RangerAtlasAuditHandler
    extends RangerDefaultAuditHandler {
        private final Map<String, AuthzAuditEvent> auditEvents;
        private final String resourcePath;
        private boolean denyExists = false;

        public RangerAtlasAuditHandler(AtlasEntityAccessRequest request, RangerServiceDef serviceDef) {
            String strClassifications;
            Set classifications = request.getEntityClassifications();
            String string = strClassifications = classifications == null ? "[]" : classifications.toString();
            if (request.getClassification() != null) {
                strClassifications = strClassifications + "," + request.getClassification().getTypeName();
            }
            RangerAccessResourceImpl rangerResource = new RangerAccessResourceImpl();
            rangerResource.setServiceDef(serviceDef);
            rangerResource.setValue("entity-type", (Object)request.getEntityType());
            rangerResource.setValue("entity-classification", (Object)strClassifications);
            rangerResource.setValue("entity", (Object)request.getEntityId());
            if (AtlasPrivilege.ENTITY_ADD_LABEL.equals((Object)request.getAction()) || AtlasPrivilege.ENTITY_REMOVE_LABEL.equals((Object)request.getAction())) {
                rangerResource.setValue("entity-label", (Object)("label=" + request.getLabel()));
            } else if (AtlasPrivilege.ENTITY_UPDATE_BUSINESS_METADATA.equals((Object)request.getAction())) {
                rangerResource.setValue("entity-business-metadata", (Object)("business-metadata=" + request.getBusinessMetadata()));
            }
            this.auditEvents = new HashMap<String, AuthzAuditEvent>();
            this.resourcePath = rangerResource.getAsString();
        }

        public void processResult(RangerAccessResult result) {
            if (this.denyExists) {
                return;
            }
            AuthzAuditEvent auditEvent = super.getAuthzEvents(result);
            if (auditEvent != null) {
                if (this.resourcePath != null) {
                    auditEvent.setResourcePath(this.resourcePath);
                }
                if (!result.getIsAllowed()) {
                    this.denyExists = true;
                    this.auditEvents.clear();
                }
                this.auditEvents.put(auditEvent.getPolicyId() + auditEvent.getAccessType(), auditEvent);
            }
        }

        public void flushAudit() {
            if (this.auditEvents != null) {
                for (AuthzAuditEvent auditEvent : this.auditEvents.values()) {
                    this.logAuthzAudit(auditEvent);
                }
            }
        }
    }

    class RangerAtlasPlugin
    extends RangerBasePlugin {
        RangerAtlasPlugin() {
            super("atlas", "atlas");
        }
    }
}

