/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.test;

import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.AuditProviderFactory;

public class TestEvents {
    private static final Log LOG = LogFactory.getLog(TestEvents.class);

    public static void main(String[] args) {
        DOMConfigurator.configure((String)"log4j.xml");
        LOG.info((Object)"==> TestEvents.main()");
        try {
            Properties auditProperties = new Properties();
            String AUDIT_PROPERTIES_FILE = "xasecure-audit.properties";
            File propFile = new File(AUDIT_PROPERTIES_FILE);
            if (propFile.exists()) {
                LOG.info((Object)("Loading Audit properties file" + AUDIT_PROPERTIES_FILE));
                auditProperties.load(new FileInputStream(propFile));
            } else {
                LOG.info((Object)("Audit properties file missing: " + AUDIT_PROPERTIES_FILE));
                auditProperties.setProperty("xasecure.audit.jpa.javax.persistence.jdbc.url", "jdbc:mysql://localhost:3306/xa_db");
                auditProperties.setProperty("xasecure.audit.jpa.javax.persistence.jdbc.user", "xaaudit");
                auditProperties.setProperty("xasecure.audit.jpa.javax.persistence.jdbc.password", "xaaudit");
                auditProperties.setProperty("xasecure.audit.jpa.javax.persistence.jdbc.driver", "com.mysql.jdbc.Driver");
                auditProperties.setProperty("xasecure.audit.is.enabled", "true");
                auditProperties.setProperty("xasecure.audit.log4j.is.enabled", "false");
                auditProperties.setProperty("xasecure.audit.log4j.is.async", "false");
                auditProperties.setProperty("xasecure.audit.log4j.async.max.queue.size", "100000");
                auditProperties.setProperty("xasecure.audit.log4j.async.max.flush.interval.ms", "30000");
                auditProperties.setProperty("xasecure.audit.db.is.enabled", "false");
                auditProperties.setProperty("xasecure.audit.db.is.async", "true");
                auditProperties.setProperty("xasecure.audit.db.async.max.queue.size", "100000");
                auditProperties.setProperty("xasecure.audit.db.async.max.flush.interval.ms", "30000");
                auditProperties.setProperty("xasecure.audit.db.batch.size", "100");
            }
            AuditProviderFactory factory = new AuditProviderFactory();
            factory.init(auditProperties, "hdfs");
            AuditHandler provider = factory.getAuditProvider();
            LOG.info((Object)("provider=" + provider.toString()));
            String strEventCount = args.length > 0 ? args[0] : auditProperties.getProperty("xasecure.audit.test.event.count");
            String strEventPauseTimeInMs = args.length > 1 ? args[1] : auditProperties.getProperty("xasecure.audit.test.event.pause.time.ms");
            String strSleepTimeBeforeExit = args.length > 2 ? args[2] : auditProperties.getProperty("xasecure.audit.test.sleep.time.before.exit.seconds");
            int eventCount = strEventCount == null ? 1024 : Integer.parseInt(strEventCount);
            int eventPauseTime = strEventPauseTimeInMs == null ? 0 : Integer.parseInt(strEventPauseTimeInMs);
            int sleepTimeBeforeExit = (strSleepTimeBeforeExit == null ? 0 : Integer.parseInt(strSleepTimeBeforeExit)) * 1000;
            for (int i = 0; i < eventCount; ++i) {
                AuditEventBase event = TestEvents.getTestEvent(i);
                LOG.info((Object)("==> TestEvents.main(" + (i + 1) + "): adding " + event.getClass().getName()));
                provider.log(event);
                if (eventPauseTime <= 0) continue;
                Thread.sleep(eventPauseTime);
            }
            provider.waitToComplete();
            if (sleepTimeBeforeExit > 0) {
                LOG.info((Object)("waiting for " + sleepTimeBeforeExit + "ms before exiting.."));
                try {
                    Thread.sleep(sleepTimeBeforeExit);
                }
                catch (Exception excp) {
                    LOG.info((Object)"error while waiting before exiting..");
                }
            }
            provider.stop();
        }
        catch (Exception excp) {
            LOG.info((Object)excp.getLocalizedMessage());
            excp.printStackTrace();
        }
        LOG.info((Object)"<== TestEvents.main()");
    }

    private static AuditEventBase getTestEvent(int idx) {
        AuthzAuditEvent event = new AuthzAuditEvent();
        event.setClientIP("127.0.0.1");
        event.setAccessResult((short)(idx % 2 > 0 ? 1 : 0));
        event.setAclEnforcer("ranger-acl");
        switch (idx % 5) {
            case 0: {
                event.setRepositoryName("hdfsdev");
                event.setRepositoryType(1);
                event.setResourcePath("/tmp/test-audit.log");
                event.setResourceType("file");
                event.setAccessType("read");
                if (idx % 2 <= 0) break;
                event.setAclEnforcer("hadoop-acl");
                break;
            }
            case 1: {
                event.setRepositoryName("hbasedev");
                event.setRepositoryType(2);
                event.setResourcePath("test_table/test_cf/test_col");
                event.setResourceType("column");
                event.setAccessType("read");
                break;
            }
            case 2: {
                event.setRepositoryName("hivedev");
                event.setRepositoryType(3);
                event.setResourcePath("test_database/test_table/test_col");
                event.setResourceType("column");
                event.setAccessType("select");
                break;
            }
            case 3: {
                event.setRepositoryName("knoxdev");
                event.setRepositoryType(5);
                event.setResourcePath("topologies/ranger-admin");
                event.setResourceType("service");
                event.setAccessType("get");
                break;
            }
            case 4: {
                event.setRepositoryName("stormdev");
                event.setRepositoryType(6);
                event.setResourcePath("topologies/read-finance-stream");
                event.setResourceType("topology");
                event.setAccessType("submit");
            }
        }
        event.setEventTime(new Date());
        event.setResultReason(Integer.toString(idx));
        return event;
    }
}

