/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.queue;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.MDC;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;

public class AuditFileCacheProviderSpool
implements Runnable {
    private static final Log logger = LogFactory.getLog(AuditFileCacheProviderSpool.class);
    public static final String PROP_FILE_SPOOL_LOCAL_DIR = "filespool.dir";
    public static final String PROP_FILE_SPOOL_LOCAL_FILE_NAME = "filespool.filename.format";
    public static final String PROP_FILE_SPOOL_ARCHIVE_DIR = "filespool.archive.dir";
    public static final String PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT = "filespool.archive.max.files";
    public static final String PROP_FILE_SPOOL_FILENAME_PREFIX = "filespool.file.prefix";
    public static final String PROP_FILE_SPOOL_FILE_ROLLOVER = "filespool.file.rollover.sec";
    public static final String PROP_FILE_SPOOL_INDEX_FILE = "filespool.index.filename";
    public static final String PROP_FILE_SPOOL_DEST_RETRY_MS = "filespool.destination.retry.ms";
    public static final String AUDIT_IS_FILE_CACHE_PROVIDER_ENABLE_PROP = "xasecure.audit.provider.filecache.is.enabled";
    public static final String FILE_CACHE_PROVIDER_NAME = "AuditFileCacheProviderSpool";
    public static final int AUDIT_BATCH_SIZE_DEFAULT = 1000;
    AuditHandler consumerProvider = null;
    BlockingQueue<AuditIndexRecord> indexQueue = new LinkedBlockingQueue<AuditIndexRecord>();
    List<AuditIndexRecord> indexRecords = new ArrayList<AuditIndexRecord>();
    File logFolder = null;
    String logFileNameFormat = null;
    File archiveFolder = null;
    String fileNamePrefix = null;
    String indexFileName = null;
    File indexFile = null;
    String indexDoneFileName = null;
    File indexDoneFile = null;
    int retryDestinationMS = 30000;
    int fileRolloverSec = 86400;
    int maxArchiveFiles = 100;
    int errorLogIntervalMS = 30000;
    long lastErrorLogMS = 0L;
    boolean isAuditFileCacheProviderEnabled = false;
    boolean closeFile = false;
    boolean isPending = false;
    long lastAttemptTime = 0L;
    boolean initDone = false;
    PrintWriter logWriter = null;
    AuditIndexRecord currentWriterIndexRecord = null;
    AuditIndexRecord currentConsumerIndexRecord = null;
    BufferedReader logReader = null;
    Thread destinationThread = null;
    boolean isWriting = true;
    boolean isDrain = false;
    boolean isDestDown = false;
    boolean isSpoolingSuccessful = true;
    private Gson gson = null;

    public AuditFileCacheProviderSpool(AuditHandler consumerProvider) {
        this.consumerProvider = consumerProvider;
    }

    public void init(Properties prop) {
        this.init(prop, null);
    }

    public boolean init(Properties props, String basePropertyName) {
        logger.debug((Object)"==> AuditFileCacheProviderSpool.init()");
        if (this.initDone) {
            logger.error((Object)("init() called more than once. queueProvider=, consumerProvider=" + this.consumerProvider.getName()));
            return true;
        }
        String propPrefix = "xasecure.audit.filespool";
        if (basePropertyName != null) {
            propPrefix = basePropertyName;
        }
        try {
            boolean ret;
            boolean ret2;
            boolean result;
            this.gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss.SSS").create();
            String logFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_LOCAL_DIR);
            this.logFileNameFormat = MiscUtil.getStringProperty(props, basePropertyName + "." + PROP_FILE_SPOOL_LOCAL_FILE_NAME);
            String archiveFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_ARCHIVE_DIR);
            this.fileNamePrefix = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_FILENAME_PREFIX);
            this.indexFileName = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_INDEX_FILE);
            this.retryDestinationMS = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_DEST_RETRY_MS, this.retryDestinationMS);
            this.fileRolloverSec = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_FILE_ROLLOVER, this.fileRolloverSec);
            this.maxArchiveFiles = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT, this.maxArchiveFiles);
            this.isAuditFileCacheProviderEnabled = MiscUtil.getBooleanProperty(props, AUDIT_IS_FILE_CACHE_PROVIDER_ENABLE_PROP, false);
            logger.info((Object)("retryDestinationMS=" + this.retryDestinationMS + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
            logger.info((Object)("fileRolloverSec=" + this.fileRolloverSec + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
            logger.info((Object)("maxArchiveFiles=" + this.maxArchiveFiles + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
            if (logFolderProp == null || logFolderProp.isEmpty()) {
                logger.fatal((Object)("Audit spool folder is not configured. Please set " + propPrefix + "." + PROP_FILE_SPOOL_LOCAL_DIR + ". queueName=" + FILE_CACHE_PROVIDER_NAME));
                return false;
            }
            this.logFolder = new File(logFolderProp);
            if (!this.logFolder.isDirectory()) {
                result = this.logFolder.mkdirs();
                if (!this.logFolder.isDirectory() || !result) {
                    logger.fatal((Object)("File Spool folder not found and can't be created. folder=" + this.logFolder.getAbsolutePath() + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
                    return false;
                }
            }
            logger.info((Object)("logFolder=" + this.logFolder + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
            if (this.logFileNameFormat == null || this.logFileNameFormat.isEmpty()) {
                this.logFileNameFormat = "spool_%app-type%_%time:yyyyMMdd-HHmm.ss%.log";
            }
            logger.info((Object)("logFileNameFormat=" + this.logFileNameFormat + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
            this.archiveFolder = archiveFolderProp == null || archiveFolderProp.isEmpty() ? new File(this.logFolder, "archive") : new File(archiveFolderProp);
            if (!this.archiveFolder.isDirectory()) {
                result = this.archiveFolder.mkdirs();
                if (!this.archiveFolder.isDirectory() || !result) {
                    logger.error((Object)("File Spool archive folder not found and can't be created. folder=" + this.archiveFolder.getAbsolutePath() + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
                    return false;
                }
            }
            logger.info((Object)("archiveFolder=" + this.archiveFolder + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
            if (this.indexFileName == null || this.indexFileName.isEmpty()) {
                if (this.fileNamePrefix == null || this.fileNamePrefix.isEmpty()) {
                    this.fileNamePrefix = "AuditFileCacheProviderSpool_" + this.consumerProvider.getName();
                }
                this.indexFileName = "index_" + this.fileNamePrefix + "_" + "%app-type%" + ".json";
                this.indexFileName = MiscUtil.replaceTokens(this.indexFileName, System.currentTimeMillis());
            }
            this.indexFile = new File(this.logFolder, this.indexFileName);
            if (!this.indexFile.exists() && !(ret2 = this.indexFile.createNewFile())) {
                logger.fatal((Object)("Error creating index file. fileName=" + this.indexFile.getPath()));
                return false;
            }
            logger.info((Object)("indexFile=" + this.indexFile + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
            int lastDot = this.indexFileName.lastIndexOf(46);
            if (lastDot < 0) {
                lastDot = this.indexFileName.length() - 1;
            }
            this.indexDoneFileName = this.indexFileName.substring(0, lastDot) + "_closed.json";
            this.indexDoneFile = new File(this.logFolder, this.indexDoneFileName);
            if (!this.indexDoneFile.exists() && !(ret = this.indexDoneFile.createNewFile())) {
                logger.fatal((Object)("Error creating index done file. fileName=" + this.indexDoneFile.getPath()));
                return false;
            }
            logger.info((Object)("indexDoneFile=" + this.indexDoneFile + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
            this.loadIndexFile();
            for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
                if (!auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.done)) {
                    this.isPending = true;
                }
                if (auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.write_inprogress)) {
                    this.currentWriterIndexRecord = auditIndexRecord;
                    logger.info((Object)("currentWriterIndexRecord=" + this.currentWriterIndexRecord.filePath + ", queueName=" + FILE_CACHE_PROVIDER_NAME));
                }
                if (!auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.read_inprogress)) continue;
                this.indexQueue.add(auditIndexRecord);
            }
            this.printIndex();
            for (int i = 0; i < this.indexRecords.size(); ++i) {
                AuditIndexRecord auditIndexRecord;
                auditIndexRecord = this.indexRecords.get(i);
                if (!auditIndexRecord.status.equals((Object)SPOOL_FILE_STATUS.pending)) continue;
                File consumerFile = new File(auditIndexRecord.filePath);
                if (!consumerFile.exists()) {
                    logger.error((Object)("INIT: Consumer file=" + consumerFile.getPath() + " not found."));
                    continue;
                }
                this.indexQueue.add(auditIndexRecord);
            }
        }
        catch (Throwable t) {
            logger.fatal((Object)"Error initializing File Spooler. queue=AuditFileCacheProviderSpool", t);
            return false;
        }
        this.initDone = true;
        logger.debug((Object)"<== AuditFileCacheProviderSpool.init()");
        return true;
    }

    public void start() {
        if (!this.initDone) {
            logger.error((Object)"Cannot start Audit File Spooler. Initilization not done yet. queueName=AuditFileCacheProviderSpool");
            return;
        }
        logger.info((Object)("Starting writerThread, queueName=AuditFileCacheProviderSpool, consumer=" + this.consumerProvider.getName()));
        this.destinationThread = new Thread((Runnable)this, "AuditFileCacheProviderSpool_" + this.consumerProvider.getName() + "_destWriter");
        this.destinationThread.setDaemon(true);
        this.destinationThread.start();
    }

    public void stop() {
        if (!this.initDone) {
            logger.error((Object)"Cannot stop Audit File Spooler. Initilization not done. queueName=AuditFileCacheProviderSpool");
            return;
        }
        logger.info((Object)("Stop called, queueName=AuditFileCacheProviderSpool, consumer=" + this.consumerProvider.getName()));
        this.isDrain = true;
        this.flush();
        PrintWriter out = this.getOpenLogFileStream();
        if (out != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.isWriting) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    logger.info((Object)("Closing open file, queueName=AuditFileCacheProviderSpool, consumer=" + this.consumerProvider.getName()));
                    out.flush();
                    out.close();
                    break;
                }
                catch (Throwable t) {
                    logger.debug((Object)"Error closing spool out file.", t);
                }
            }
        }
        try {
            if (this.destinationThread != null) {
                this.destinationThread.interrupt();
            }
            this.destinationThread = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void flush() {
        if (!this.initDone) {
            logger.error((Object)"Cannot flush Audit File Spooler. Initilization not done. queueName=AuditFileCacheProviderSpool");
            return;
        }
        PrintWriter out = this.getOpenLogFileStream();
        if (out != null) {
            out.flush();
        }
    }

    public boolean isPending() {
        if (!this.initDone) {
            this.logError("isPending(): File Spooler not initialized. queueName=AuditFileCacheProviderSpool");
            return false;
        }
        return this.isPending;
    }

    public long getLastAttemptTimeDelta() {
        if (this.lastAttemptTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.lastAttemptTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stashLogs(AuditEventBase event) {
        if (this.isDrain) {
            logger.error((Object)("stashLogs() is called after stop is called. event=" + event));
            return;
        }
        try {
            this.isWriting = true;
            PrintWriter logOut = this.getLogFileStream();
            String jsonStr = MiscUtil.stringify(event);
            logOut.println(jsonStr);
            logOut.flush();
            this.isPending = true;
            this.isSpoolingSuccessful = true;
        }
        catch (Throwable t) {
            this.isSpoolingSuccessful = false;
            logger.error((Object)("Error writing to file. event=" + event), t);
        }
        finally {
            this.isWriting = false;
        }
    }

    public synchronized void stashLogs(Collection<AuditEventBase> events) {
        for (AuditEventBase event : events) {
            this.stashLogs(event);
        }
        this.flush();
    }

    public synchronized void stashLogsString(String event) {
        if (this.isDrain) {
            logger.error((Object)("stashLogs() is called after stop is called. event=" + event));
            return;
        }
        try {
            this.isWriting = true;
            PrintWriter logOut = this.getLogFileStream();
            logOut.println(event);
        }
        catch (Exception ex) {
            logger.error((Object)("Error writing to file. event=" + event), (Throwable)ex);
        }
        finally {
            this.isWriting = false;
        }
    }

    public synchronized boolean isSpoolingSuccessful() {
        return this.isSpoolingSuccessful;
    }

    public synchronized void stashLogsString(Collection<String> events) {
        for (String event : events) {
            this.stashLogsString(event);
        }
        this.flush();
    }

    private synchronized PrintWriter getOpenLogFileStream() {
        return this.logWriter;
    }

    private synchronized PrintWriter getLogFileStream() throws Exception {
        this.closeFileIfNeeded();
        if (this.currentWriterIndexRecord == null) {
            String fileName;
            Date currentTime = new Date();
            String newFileName = fileName = MiscUtil.replaceTokens(this.logFileNameFormat, currentTime.getTime());
            File outLogFile = null;
            int i = 0;
            while (true) {
                outLogFile = new File(this.logFolder, newFileName);
                File archiveLogFile = new File(this.archiveFolder, newFileName);
                if (!outLogFile.exists() && !archiveLogFile.exists()) break;
                int lastDot = fileName.lastIndexOf(46);
                String baseName = fileName.substring(0, lastDot);
                String extension = fileName.substring(lastDot);
                newFileName = baseName + "." + ++i + extension;
            }
            fileName = newFileName;
            logger.info((Object)("Creating new file. queueName=AuditFileCacheProviderSpool, fileName=" + fileName));
            this.logWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outLogFile), "UTF-8")));
            AuditIndexRecord tmpIndexRecord = new AuditIndexRecord();
            tmpIndexRecord.id = MiscUtil.generateUniqueId();
            tmpIndexRecord.filePath = outLogFile.getPath();
            tmpIndexRecord.status = SPOOL_FILE_STATUS.write_inprogress;
            tmpIndexRecord.fileCreateTime = currentTime;
            tmpIndexRecord.lastAttempt = true;
            this.currentWriterIndexRecord = tmpIndexRecord;
            this.indexRecords.add(this.currentWriterIndexRecord);
            this.saveIndexFile();
        } else if (this.logWriter == null) {
            logger.info((Object)("Opening existing file for append. queueName=AuditFileCacheProviderSpool, fileName=" + this.currentWriterIndexRecord.filePath));
            this.logWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentWriterIndexRecord.filePath, true), "UTF-8")));
        }
        return this.logWriter;
    }

    private synchronized void closeFileIfNeeded() throws FileNotFoundException, IOException {
        if (this.currentWriterIndexRecord != null) {
            this.rollOverSpoolFileByTime();
            if (this.closeFile) {
                if (this.logWriter != null) {
                    this.logWriter.flush();
                    this.logWriter.close();
                    this.logWriter = null;
                    this.closeFile = false;
                }
                this.currentWriterIndexRecord.status = SPOOL_FILE_STATUS.pending;
                this.currentWriterIndexRecord.writeCompleteTime = new Date();
                this.saveIndexFile();
                logger.info((Object)("Adding file to queue. queueName=AuditFileCacheProviderSpool, fileName=" + this.currentWriterIndexRecord.filePath));
                this.indexQueue.add(this.currentWriterIndexRecord);
                this.currentWriterIndexRecord = null;
            }
        }
    }

    private void rollOverSpoolFileByTime() {
        if (System.currentTimeMillis() - this.currentWriterIndexRecord.fileCreateTime.getTime() > (long)(this.fileRolloverSec * 1000)) {
            this.closeFile = true;
            logger.info((Object)("Closing file. Rolling over. queueName=AuditFileCacheProviderSpool, fileName=" + this.currentWriterIndexRecord.filePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadIndexFile() throws IOException {
        logger.info((Object)("Loading index file. fileName=" + this.indexFile.getPath()));
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.indexFile), "UTF-8"));
            this.indexRecords.clear();
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                AuditIndexRecord record = (AuditIndexRecord)this.gson.fromJson(line, AuditIndexRecord.class);
                this.indexRecords.add(record);
            }
        }
    }

    synchronized void printIndex() {
        logger.info((Object)"INDEX printIndex() ==== START");
        for (AuditIndexRecord record : this.indexRecords) {
            logger.info((Object)("INDEX=" + record + ", isFileExist=" + new File(record.filePath).exists()));
        }
        logger.info((Object)"INDEX printIndex() ==== END");
    }

    synchronized void removeIndexRecord(AuditIndexRecord indexRecord) throws FileNotFoundException, IOException {
        Iterator<AuditIndexRecord> iter = this.indexRecords.iterator();
        while (iter.hasNext()) {
            AuditIndexRecord record = iter.next();
            if (!record.id.equals(indexRecord.id)) continue;
            logger.info((Object)("Removing file from index. file=" + record.filePath + ", queueName=" + FILE_CACHE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName()));
            iter.remove();
            this.appendToDoneFile(record);
        }
        this.saveIndexFile();
        if (this.indexRecords.size() == 0) {
            this.isPending = false;
        }
    }

    synchronized void saveIndexFile() throws FileNotFoundException, IOException {
        PrintWriter out = new PrintWriter(this.indexFile, "UTF-8");
        for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
            out.println(this.gson.toJson((Object)auditIndexRecord));
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendToDoneFile(AuditIndexRecord indexRecord) throws FileNotFoundException, IOException {
        block10: {
            logger.info((Object)("Moving to done file. " + indexRecord.filePath + ", queueName=" + FILE_CACHE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName()));
            String line = this.gson.toJson((Object)indexRecord);
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.indexDoneFile, true), "UTF-8")));
            out.println(line);
            out.flush();
            out.close();
            this.consumerProvider.flush();
            File logFile = null;
            File archiveFile = null;
            try {
                logFile = new File(indexRecord.filePath);
                String fileName = logFile.getName();
                archiveFile = new File(this.archiveFolder, fileName);
                logger.info((Object)("Moving logFile " + logFile + " to " + archiveFile));
                boolean result = logFile.renameTo(archiveFile);
                if (!result) {
                    logger.error((Object)("Error moving log file to archive folder. Unable to rename" + logFile + " to archiveFile=" + archiveFile));
                }
            }
            catch (Throwable t) {
                logger.error((Object)("Error moving log file to archive folder. logFile=" + logFile + ", archiveFile=" + archiveFile), t);
            }
            this.consumerProvider.flush();
            archiveFile = null;
            try {
                File[] logFiles = this.archiveFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().toLowerCase().endsWith(".log");
                    }
                });
                if (logFiles == null || logFiles.length <= this.maxArchiveFiles) break block10;
                int filesToDelete = logFiles.length - this.maxArchiveFiles;
                try (BufferedReader br = new BufferedReader(new FileReader(this.indexDoneFile));){
                    int filesDeletedCount = 0;
                    while ((line = br.readLine()) != null) {
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        AuditIndexRecord record = (AuditIndexRecord)this.gson.fromJson(line, AuditIndexRecord.class);
                        logFile = new File(record.filePath);
                        String fileName = logFile.getName();
                        archiveFile = new File(this.archiveFolder, fileName);
                        if (!archiveFile.exists()) continue;
                        logger.info((Object)("Deleting archive file " + archiveFile));
                        boolean ret = archiveFile.delete();
                        if (!ret) {
                            logger.error((Object)("Error deleting archive file. archiveFile=" + archiveFile));
                        }
                        if (++filesDeletedCount < filesToDelete) continue;
                        logger.info((Object)("Deleted " + filesDeletedCount + " files"));
                        break;
                    }
                }
            }
            catch (Throwable t) {
                logger.error((Object)("Error deleting older archive file. archiveFile=" + archiveFile), t);
            }
        }
    }

    void logError(String msg) {
        long currTimeMS = System.currentTimeMillis();
        if (currTimeMS - this.lastErrorLogMS > (long)this.errorLogIntervalMS) {
            logger.error((Object)msg);
            this.lastErrorLogMS = currTimeMS;
        }
    }

    @Override
    public void run() {
        try {
            MDC.clear();
            this.runLogAudit();
        }
        catch (Throwable t) {
            logger.fatal((Object)("Exited thread without abnormaly. queue=" + this.consumerProvider.getName()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runLogAudit() {
        block8: while (true) {
            try {
                while (true) {
                    if (this.isDestDown) {
                        logger.info((Object)("Destination is down. sleeping for " + this.retryDestinationMS + " milli seconds. indexQueue=" + this.indexQueue.size() + ", queueName=" + FILE_CACHE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName()));
                        Thread.sleep(this.retryDestinationMS);
                    }
                    if (this.currentConsumerIndexRecord == null) {
                        this.currentConsumerIndexRecord = this.indexQueue.poll(this.retryDestinationMS, TimeUnit.MILLISECONDS);
                    } else {
                        Thread.sleep(this.retryDestinationMS);
                    }
                    if (this.isDrain) break block8;
                    if (this.currentConsumerIndexRecord == null) {
                        this.closeFileIfNeeded();
                        continue;
                    }
                    boolean isRemoveIndex = false;
                    File consumerFile = new File(this.currentConsumerIndexRecord.filePath);
                    if (!consumerFile.exists()) {
                        logger.error((Object)("Consumer file=" + consumerFile.getPath() + " not found."));
                        this.printIndex();
                        isRemoveIndex = true;
                    } else {
                        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.currentConsumerIndexRecord.filePath), "UTF-8"));){
                            String line;
                            int startLine = this.currentConsumerIndexRecord.linePosition;
                            int currLine = 0;
                            ArrayList<AuditEventBase> events = new ArrayList<AuditEventBase>();
                            while ((line = br.readLine()) != null) {
                                if (++currLine < startLine) continue;
                                AuditEventBase event = MiscUtil.fromJson(line, AuthzAuditEvent.class);
                                events.add(event);
                                if (events.size() != 1000) continue;
                                boolean ret = this.sendEvent(events, this.currentConsumerIndexRecord, currLine);
                                if (!ret) {
                                    throw new Exception("Destination down");
                                }
                                events.clear();
                            }
                            if (events.size() > 0) {
                                boolean ret = this.sendEvent(events, this.currentConsumerIndexRecord, currLine);
                                if (!ret) {
                                    throw new Exception("Destination down");
                                }
                                events.clear();
                            }
                            logger.info((Object)("Done reading file. file=" + this.currentConsumerIndexRecord.filePath + ", queueName=" + FILE_CACHE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName()));
                            this.currentConsumerIndexRecord.status = SPOOL_FILE_STATUS.done;
                            this.currentConsumerIndexRecord.doneCompleteTime = new Date();
                            this.currentConsumerIndexRecord.lastAttempt = true;
                            isRemoveIndex = true;
                        }
                    }
                    if (!isRemoveIndex) continue;
                    this.removeIndexRecord(this.currentConsumerIndexRecord);
                    this.currentConsumerIndexRecord = null;
                    this.closeFileIfNeeded();
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)"Caught exception in consumer thread. Shutdown might be in progress");
                continue;
            }
            catch (Throwable t) {
                logger.error((Object)"Exception in destination writing thread.", t);
                continue;
            }
            break;
        }
        logger.info((Object)("Exiting file spooler. provider=AuditFileCacheProviderSpool, consumer=" + this.consumerProvider.getName()));
    }

    private boolean sendEvent(List<AuditEventBase> events, AuditIndexRecord indexRecord, int currLine) {
        boolean ret = true;
        try {
            ret = this.consumerProvider.log(events);
            if (!ret) {
                this.logError("Error sending logs to consumer. provider=AuditFileCacheProviderSpool, consumer=" + this.consumerProvider.getName());
            } else {
                indexRecord.linePosition = currLine;
                indexRecord.status = SPOOL_FILE_STATUS.read_inprogress;
                indexRecord.lastSuccessTime = new Date();
                indexRecord.lastAttempt = true;
                this.saveIndexFile();
                if (this.isDestDown) {
                    this.isDestDown = false;
                    logger.info((Object)("Destination up now. " + indexRecord.filePath + ", queueName=" + FILE_CACHE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName()));
                }
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Error while sending logs to consumer. provider=AuditFileCacheProviderSpool, consumer=" + this.consumerProvider.getName() + ", log=" + events), t);
        }
        return ret;
    }

    class AuditIndexRecord {
        String id;
        String filePath;
        int linePosition = 0;
        SPOOL_FILE_STATUS status = SPOOL_FILE_STATUS.write_inprogress;
        Date fileCreateTime;
        Date writeCompleteTime;
        Date doneCompleteTime;
        Date lastSuccessTime;
        Date lastFailedTime;
        int failedAttemptCount = 0;
        boolean lastAttempt = false;

        AuditIndexRecord() {
        }

        public String toString() {
            return "AuditIndexRecord [id=" + this.id + ", filePath=" + this.filePath + ", linePosition=" + this.linePosition + ", status=" + (Object)((Object)this.status) + ", fileCreateTime=" + this.fileCreateTime + ", writeCompleteTime=" + this.writeCompleteTime + ", doneCompleteTime=" + this.doneCompleteTime + ", lastSuccessTime=" + this.lastSuccessTime + ", lastFailedTime=" + this.lastFailedTime + ", failedAttemptCount=" + this.failedAttemptCount + ", lastAttempt=" + this.lastAttempt + "]";
        }
    }

    public static enum SPOOL_FILE_STATUS {
        pending,
        write_inprogress,
        read_inprogress,
        done;

    }
}

