/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.sqoop.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.sqoop.client.SqoopClient;

public class SqoopResourceMgr {
    public static final String CONNECTOR = "connector";
    public static final String LINK = "link";
    public static final String JOB = "job";
    private static final Logger LOG = Logger.getLogger(SqoopResourceMgr.class);

    public static Map<String, Object> validateConfig(String serviceName, Map<String, String> configs) throws Exception {
        Map<String, Object> ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> SqoopResourceMgr.validateConfig ServiceName: " + serviceName + "Configs" + configs));
        }
        try {
            ret = SqoopClient.connectionTest(serviceName, configs);
        }
        catch (Exception e) {
            LOG.error((Object)("<== SqoopResourceMgr.validateConfig Error: " + e));
            throw e;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== SqoopResourceMgr.validateConfig Result: " + ret));
        }
        return ret;
    }

    public static List<String> getSqoopResources(String serviceName, Map<String, String> configs, ResourceLookupContext context) {
        SqoopClient sqoopClient;
        String userInput = context.getUserInput();
        String resource = context.getResourceName();
        Map resourceMap = context.getResources();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> SqoopResourceMgr.getSqoopResources()  userInput: " + userInput + ", resource: " + resource + ", resourceMap: " + resourceMap));
        }
        if (MapUtils.isEmpty(configs)) {
            LOG.error((Object)"Connection Config is empty!");
            return null;
        }
        if (StringUtils.isEmpty((String)userInput)) {
            LOG.warn((Object)"User input is empty, set default value : *");
            userInput = "*";
        }
        if ((sqoopClient = SqoopClient.getSqoopClient(serviceName, configs)) == null) {
            LOG.error((Object)"Failed to getSqoopResources!");
            return null;
        }
        List<String> resultList = null;
        if (StringUtils.isNotEmpty((String)resource)) {
            switch (resource) {
                case "connector": {
                    List existingConnectors = (List)resourceMap.get(CONNECTOR);
                    resultList = sqoopClient.getConnectorList(userInput, existingConnectors);
                    break;
                }
                case "link": {
                    List existingLinks = (List)resourceMap.get(LINK);
                    resultList = sqoopClient.getLinkList(userInput, existingLinks);
                    break;
                }
                case "job": {
                    List existingJobs = (List)resourceMap.get(JOB);
                    resultList = sqoopClient.getJobList(userInput, existingJobs);
                    break;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== SqoopResourceMgr.getSqoopResources() result: " + resultList));
        }
        return resultList;
    }
}

