/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.sqoop.authorizer;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.sqoop.authorizer.RangerSqoopAccessRequest;
import org.apache.ranger.authorization.sqoop.authorizer.RangerSqoopPlugin;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.model.MPrincipal;
import org.apache.sqoop.model.MPrivilege;
import org.apache.sqoop.security.AuthorizationValidator;
import org.apache.sqoop.security.SecurityError;

public class RangerSqoopAuthorizer
extends AuthorizationValidator {
    private static final Log LOG = LogFactory.getLog(RangerSqoopAuthorizer.class);
    private static volatile RangerSqoopPlugin sqoopPlugin = null;
    private static String clientIPAddress = null;

    public RangerSqoopAuthorizer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerSqoopAuthorizer.RangerSqoopAuthorizer()");
        }
        this.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerSqoopAuthorizer.RangerSqoopAuthorizer()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void init() {
        RangerSqoopPlugin plugin;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerSqoopAuthorizer.init()");
        }
        if ((plugin = sqoopPlugin) == null) {
            Class<RangerSqoopAuthorizer> clazz = RangerSqoopAuthorizer.class;
            // MONITORENTER : org.apache.ranger.authorization.sqoop.authorizer.RangerSqoopAuthorizer.class
            plugin = sqoopPlugin;
            if (plugin == null) {
                plugin = new RangerSqoopPlugin();
                plugin.init();
                sqoopPlugin = plugin;
                clientIPAddress = this.getClientIPAddress();
            }
            // MONITOREXIT : clazz
        }
        if (!LOG.isDebugEnabled()) return;
        LOG.debug((Object)"<== RangerSqoopAuthorizer.init()");
    }

    public void checkPrivileges(MPrincipal principal, List<MPrivilege> privileges) throws SqoopException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerSqoopAuthorizer.checkPrivileges( principal=" + principal + ", privileges=" + privileges + ")"));
        }
        if (CollectionUtils.isEmpty(privileges)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"<== RangerSqoopAuthorizer.checkPrivileges() return because privileges is empty.");
            }
            return;
        }
        RangerSqoopPlugin plugin = sqoopPlugin;
        if (plugin != null) {
            for (MPrivilege privilege : privileges) {
                RangerSqoopAccessRequest request = new RangerSqoopAccessRequest(principal, privilege, clientIPAddress);
                RangerAccessResult result = plugin.isAccessAllowed((RangerAccessRequest)request);
                if (result == null || result.getIsAllowed()) continue;
                throw new SqoopException((ErrorCode)SecurityError.AUTH_0014, "principal=" + principal + " does not have privileges for : " + privilege);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerSqoopAuthorizer.checkPrivileges() success without exception.");
        }
    }

    private String getClientIPAddress() {
        InetAddress ip;
        block3: {
            ip = null;
            try {
                ip = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Object)("Failed to get Client IP Address" + e));
            }
        }
        String ret = null;
        if (ip != null) {
            ret = ip.getHostAddress();
        }
        return ret;
    }
}

