/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.kafka.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kafka.zk.KafkaZkClient;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.plugin.util.TimedEventUtil;
import scala.Option;

public class ServiceKafkaClient {
    private static final Logger LOG = Logger.getLogger(ServiceKafkaClient.class);
    String serviceName = null;
    String zookeeperConnect = null;
    private static final String errMessage = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check server logs for more info.";
    private static final String TOPIC_KEY = "topic";
    private static final long LOOKUP_TIMEOUT_SEC = 5L;

    public ServiceKafkaClient(String serviceName, String zookeeperConnect) {
        this.serviceName = serviceName;
        this.zookeeperConnect = zookeeperConnect;
    }

    public Map<String, Object> connectionTest() throws Exception {
        String errMsg = errMessage;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        try {
            this.getTopicList(null);
            String successMsg = "ConnectionTest Successful";
            BaseClient.generateResponseDataMap((boolean)true, (String)successMsg, (String)successMsg, null, null, responseData);
        }
        catch (IOException e) {
            LOG.error((Object)("Error connecting to Kafka. kafkaClient=" + this), (Throwable)e);
            String failureMsg = "Unable to connect to Kafka instance." + e.getMessage();
            BaseClient.generateResponseDataMap((boolean)false, (String)failureMsg, (String)(failureMsg + errMsg), null, null, responseData);
        }
        return responseData;
    }

    private List<String> getTopicList(List<String> ignoreTopicList) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        int sessionTimeout = 5000;
        int connectionTimeout = 10000;
        ZooKeeperClient zookeeperClient = new ZooKeeperClient(this.zookeeperConnect, sessionTimeout, connectionTimeout, 1, Time.SYSTEM, "kafka.server", "SessionExpireListener", Option.empty());
        try (KafkaZkClient kafkaZkClient = new KafkaZkClient(zookeeperClient, true, Time.SYSTEM);){
            for (String topic : kafkaZkClient.getAllTopicsInCluster()) {
                if (ignoreTopicList != null && ignoreTopicList.contains(topic)) continue;
                ret.add(topic);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getResources(ResourceLookupContext context) {
        List resultList;
        block16: {
            String userInput = context.getUserInput();
            String resource = context.getResourceName();
            Map resourceMap = context.getResources();
            resultList = null;
            List topicList = null;
            RESOURCE_TYPE lookupResource = RESOURCE_TYPE.TOPIC;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== getResources()  UserInput: \"" + userInput + "\" resource : " + resource + " resourceMap: " + resourceMap));
            }
            if (userInput != null && resource != null) {
                if (resourceMap != null && !resourceMap.isEmpty()) {
                    topicList = (List)resourceMap.get(TOPIC_KEY);
                }
                switch (resource.trim().toLowerCase()) {
                    case "topic": {
                        lookupResource = RESOURCE_TYPE.TOPIC;
                        break;
                    }
                }
            }
            if (userInput != null) {
                try {
                    Callable<List<String>> callableObj = null;
                    final String userInputFinal = userInput;
                    final List finalTopicList = topicList;
                    if (lookupResource == RESOURCE_TYPE.TOPIC) {
                        callableObj = new Callable<List<String>>(){

                            @Override
                            public List<String> call() {
                                ArrayList<String> retList = new ArrayList<String>();
                                try {
                                    List list = ServiceKafkaClient.this.getTopicList(finalTopicList);
                                    if (userInputFinal != null && !userInputFinal.isEmpty()) {
                                        for (String value : list) {
                                            if (!value.startsWith(userInputFinal)) continue;
                                            retList.add(value);
                                        }
                                    } else {
                                        retList.addAll(list);
                                    }
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)"Error getting topic.", (Throwable)ex);
                                }
                                return retList;
                            }
                        };
                    }
                    if (callableObj == null) break block16;
                    ServiceKafkaClient serviceKafkaClient = this;
                    synchronized (serviceKafkaClient) {
                        resultList = (List)TimedEventUtil.timedTask((Callable)callableObj, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"Unable to get hive resources.", (Throwable)e);
                }
            }
        }
        return resultList;
    }

    public String toString() {
        return "ServiceKafkaClient [serviceName=" + this.serviceName + ", zookeeperConnect=" + this.zookeeperConnect + "]";
    }

    static enum RESOURCE_TYPE {
        TOPIC;

    }
}

