/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.kafka.authorizer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;

public class RangerKafkaAuditHandler
extends RangerDefaultAuditHandler {
    private static final Log LOG = LogFactory.getLog(RangerKafkaAuditHandler.class);
    private AuthzAuditEvent auditEvent = null;

    public void processResult(RangerAccessResult result) {
        if (!this.isAuditingNeeded(result)) {
            return;
        }
        this.auditEvent = super.getAuthzEvents(result);
    }

    private boolean isAuditingNeeded(RangerAccessResult result) {
        boolean ret = true;
        boolean isAllowed = result.getIsAllowed();
        RangerAccessRequest request = result.getAccessRequest();
        RangerAccessResourceImpl resource = (RangerAccessResourceImpl)request.getResource();
        String resourceName = (String)resource.getValue("cluster");
        if (resourceName != null && request.getAccessType().equalsIgnoreCase("create") && !isAllowed) {
            ret = false;
        }
        return ret;
    }

    public void flushAudit() {
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("==> RangerYarnAuditHandler.flushAudit(AuditEvent: " + this.auditEvent + ")"));
        }
        if (this.auditEvent != null) {
            super.logAuthzAudit(this.auditEvent);
        }
        if (LOG.isDebugEnabled()) {
            LOG.info((Object)("<== RangerYarnAuditHandler.flushAudit(AuditEvent: " + this.auditEvent + ")"));
        }
    }
}

