/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TimeBoundary;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.Constants;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.DateValidator;

public class AtlasClassificationType
extends AtlasStructType {
    public static final AtlasClassificationType CLASSIFICATION_ROOT = AtlasClassificationType.initRootClassificationType();
    private static final String CLASSIFICATION_ROOT_NAME = "__CLASSIFICATION_ROOT";
    private final AtlasClassificationDef classificationDef;
    private final String typeQryStr;
    private List<AtlasClassificationType> superTypes = Collections.emptyList();
    private Set<String> allSuperTypes = Collections.emptySet();
    private Set<String> subTypes = Collections.emptySet();
    private Set<String> allSubTypes = Collections.emptySet();
    private Set<String> typeAndAllSubTypes = Collections.emptySet();
    private Set<String> typeAndAllSuperTypes = Collections.emptySet();
    private String typeAndAllSubTypesQryStr = "";
    private Set<String> entityTypes = Collections.emptySet();

    public AtlasClassificationType(AtlasClassificationDef classificationDef) {
        super(classificationDef);
        this.classificationDef = classificationDef;
        this.typeQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(Collections.singleton(this.getTypeName()));
    }

    public AtlasClassificationType(AtlasClassificationDef classificationDef, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(classificationDef);
        this.classificationDef = classificationDef;
        this.typeQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(Collections.singleton(this.getTypeName()));
        this.resolveReferences(typeRegistry);
    }

    public AtlasClassificationDef getClassificationDef() {
        return this.classificationDef;
    }

    public static AtlasClassificationType getClassificationRoot() {
        return CLASSIFICATION_ROOT;
    }

    @Override
    void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferences(typeRegistry);
        ArrayList<AtlasClassificationType> s = new ArrayList<AtlasClassificationType>();
        HashSet<String> allS = new HashSet<String>();
        HashMap<String, AtlasStructType.AtlasAttribute> allA = new HashMap<String, AtlasStructType.AtlasAttribute>();
        this.getTypeHierarchyInfo(typeRegistry, allS, allA);
        for (String superTypeName : this.classificationDef.getSuperTypes()) {
            AtlasType superType = typeRegistry.getType(superTypeName);
            if (superType instanceof AtlasClassificationType) {
                s.add((AtlasClassificationType)superType);
                continue;
            }
            throw new AtlasBaseException(AtlasErrorCode.INCOMPATIBLE_SUPERTYPE, superTypeName, this.classificationDef.getName());
        }
        this.superTypes = Collections.unmodifiableList(s);
        this.allSuperTypes = Collections.unmodifiableSet(allS);
        this.allAttributes = Collections.unmodifiableMap(allA);
        this.uniqAttributes = this.getUniqueAttributes(this.allAttributes);
        this.subTypes = new HashSet<String>();
        this.allSubTypes = new HashSet<String>();
        this.typeAndAllSubTypes = new HashSet<String>();
        this.entityTypes = new HashSet<String>();
        this.typeAndAllSubTypes.add(this.getTypeName());
        this.typeAndAllSuperTypes = new HashSet<String>(this.allSuperTypes);
        this.typeAndAllSuperTypes.add(this.getTypeName());
        this.typeAndAllSuperTypes = Collections.unmodifiableSet(this.typeAndAllSuperTypes);
    }

    @Override
    void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferencesPhase2(typeRegistry);
        for (AtlasClassificationType superType : this.superTypes) {
            superType.addSubType(this);
        }
        for (String superTypeName : this.allSuperTypes) {
            AtlasClassificationType superType = typeRegistry.getClassificationTypeByName(superTypeName);
            superType.addToAllSubTypes(this);
        }
    }

    @Override
    void resolveReferencesPhase3(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        this.subTypes = Collections.unmodifiableSet(this.subTypes);
        this.allSubTypes = Collections.unmodifiableSet(this.allSubTypes);
        this.typeAndAllSubTypes = Collections.unmodifiableSet(this.typeAndAllSubTypes);
        this.typeAndAllSubTypesQryStr = "";
        HashSet<String> superTypeEntityTypes = null;
        Set<String> classificationDefEntityTypes = this.classificationDef.getEntityTypes();
        for (String superType : this.allSuperTypes) {
            AtlasClassificationDef superTypeDef = typeRegistry.getClassificationDefByName(superType);
            Set<String> entityTypeNames = superTypeDef.getEntityTypes();
            if (CollectionUtils.isEmpty(entityTypeNames)) continue;
            Set<String> typesAndSubEntityTypes = AtlasEntityType.getEntityTypesAndAllSubTypes(entityTypeNames, typeRegistry);
            if (superTypeEntityTypes == null) {
                superTypeEntityTypes = new HashSet<String>(typesAndSubEntityTypes);
            } else {
                superTypeEntityTypes.retainAll(typesAndSubEntityTypes);
            }
            if (!superTypeEntityTypes.isEmpty()) continue;
            break;
        }
        if (superTypeEntityTypes == null) {
            this.entityTypes = AtlasEntityType.getEntityTypesAndAllSubTypes(classificationDefEntityTypes, typeRegistry);
        } else {
            if (CollectionUtils.isEmpty(superTypeEntityTypes)) {
                throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATIONDEF_PARENTS_ENTITYTYPES_DISJOINT, this.classificationDef.getName());
            }
            if (CollectionUtils.isEmpty(classificationDefEntityTypes)) {
                this.entityTypes = superTypeEntityTypes;
            } else {
                this.entityTypes = AtlasEntityType.getEntityTypesAndAllSubTypes(classificationDefEntityTypes, typeRegistry);
                if (!superTypeEntityTypes.containsAll(this.entityTypes)) {
                    throw new AtlasBaseException(AtlasErrorCode.CLASSIFICATIONDEF_ENTITYTYPES_NOT_PARENTS_SUBSET, this.classificationDef.getName(), classificationDefEntityTypes.toString());
                }
            }
        }
        this.classificationDef.setSubTypes(this.subTypes);
    }

    @Override
    public AtlasStructType.AtlasAttribute getSystemAttribute(String attributeName) {
        return (AtlasStructType.AtlasAttribute)AtlasClassificationType.CLASSIFICATION_ROOT.allAttributes.get(attributeName);
    }

    private void addSubType(AtlasClassificationType subType) {
        this.subTypes.add(subType.getTypeName());
    }

    private void addToAllSubTypes(AtlasClassificationType subType) {
        this.allSubTypes.add(subType.getTypeName());
        this.typeAndAllSubTypes.add(subType.getTypeName());
    }

    public Set<String> getSuperTypes() {
        return this.classificationDef.getSuperTypes();
    }

    public Set<String> getAllSuperTypes() {
        return this.allSuperTypes;
    }

    public Set<String> getSubTypes() {
        return this.subTypes;
    }

    public Set<String> getAllSubTypes() {
        return this.allSubTypes;
    }

    public Set<String> getTypeAndAllSubTypes() {
        return this.typeAndAllSubTypes;
    }

    public Set<String> getTypeAndAllSuperTypes() {
        return this.typeAndAllSuperTypes;
    }

    public String getTypeQryStr() {
        return this.typeQryStr;
    }

    public String getTypeAndAllSubTypesQryStr() {
        if (StringUtils.isEmpty((String)this.typeAndAllSubTypesQryStr)) {
            this.typeAndAllSubTypesQryStr = AtlasStructType.AtlasAttribute.escapeIndexQueryValue(this.typeAndAllSubTypes);
        }
        return this.typeAndAllSubTypesQryStr;
    }

    public boolean isSuperTypeOf(AtlasClassificationType classificationType) {
        return classificationType != null && this.allSubTypes.contains(classificationType.getTypeName());
    }

    public boolean isSuperTypeOf(String classificationName) {
        return StringUtils.isNotEmpty((String)classificationName) && this.allSubTypes.contains(classificationName);
    }

    public boolean isSubTypeOf(AtlasClassificationType classificationType) {
        return classificationType != null && this.allSuperTypes.contains(classificationType.getTypeName());
    }

    public boolean isSubTypeOf(String classificationName) {
        return StringUtils.isNotEmpty((String)classificationName) && this.allSuperTypes.contains(classificationName);
    }

    public boolean hasAttribute(String attrName) {
        return this.allAttributes.containsKey(attrName);
    }

    public Set<String> getEntityTypes() {
        return this.entityTypes;
    }

    @Override
    public AtlasClassification createDefaultValue() {
        AtlasClassification ret = new AtlasClassification(this.classificationDef.getName());
        this.populateDefaultValues(ret);
        return ret;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                if (superType.isValidValue(obj)) continue;
                return false;
            }
            if (!this.validateTimeBoundaries(obj, null)) {
                return false;
            }
            return super.isValidValue(obj);
        }
        return true;
    }

    @Override
    public boolean areEqualValues(Object val1, Object val2, Map<String, String> guidAssignments) {
        for (AtlasClassificationType superType : this.superTypes) {
            if (superType.areEqualValues(val1, val2, guidAssignments)) continue;
            return false;
        }
        return super.areEqualValues(val1, val2, guidAssignments);
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                if (superType.isValidValueForUpdate(obj)) continue;
                return false;
            }
            if (!this.validateTimeBoundaries(obj, null)) {
                return false;
            }
            return super.isValidValueForUpdate(obj);
        }
        return true;
    }

    @Override
    public Object getNormalizedValue(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValue(obj)) {
            if (obj instanceof AtlasClassification) {
                this.normalizeAttributeValues((AtlasClassification)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValues((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public Object getNormalizedValueForUpdate(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValueForUpdate(obj)) {
            if (obj instanceof AtlasClassification) {
                this.normalizeAttributeValuesForUpdate((AtlasClassification)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValuesForUpdate((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                ret = superType.validateValue(obj, objName, messages) && ret;
            }
            ret = this.validateTimeBoundaries(obj, messages) && ret;
            ret = super.validateValue(obj, objName, messages) && ret;
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                ret = superType.validateValueForUpdate(obj, objName, messages) && ret;
            }
            ret = this.validateTimeBoundaries(obj, messages) && ret;
            ret = super.validateValueForUpdate(obj, objName, messages) && ret;
        }
        return ret;
    }

    public void normalizeAttributeValues(AtlasClassification classification) {
        if (classification != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                superType.normalizeAttributeValues(classification);
            }
            super.normalizeAttributeValues(classification);
        }
    }

    public void normalizeAttributeValuesForUpdate(AtlasClassification classification) {
        if (classification != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                superType.normalizeAttributeValuesForUpdate(classification);
            }
            super.normalizeAttributeValuesForUpdate(classification);
        }
    }

    @Override
    public void normalizeAttributeValues(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                superType.normalizeAttributeValues(obj);
            }
            super.normalizeAttributeValues(obj);
        }
    }

    @Override
    public void normalizeAttributeValuesForUpdate(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                superType.normalizeAttributeValuesForUpdate(obj);
            }
            super.normalizeAttributeValuesForUpdate(obj);
        }
    }

    public void populateDefaultValues(AtlasClassification classification) {
        if (classification != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                superType.populateDefaultValues(classification);
            }
            super.populateDefaultValues(classification);
        }
    }

    public boolean canApplyToEntityType(AtlasEntityType entityType) {
        return CollectionUtils.isEmpty(this.entityTypes) || this.entityTypes.contains(entityType.getTypeName());
    }

    private static AtlasClassificationType initRootClassificationType() {
        ArrayList<AtlasStructDef.AtlasAttributeDef> attributeDefs = new ArrayList<AtlasStructDef.AtlasAttributeDef>(){
            {
                this.add(new AtlasStructDef.AtlasAttributeDef(Constants.TYPE_NAME_PROPERTY_KEY, "string", false, true));
                this.add(new AtlasStructDef.AtlasAttributeDef(Constants.TIMESTAMP_PROPERTY_KEY, "date", false, true));
                this.add(new AtlasStructDef.AtlasAttributeDef(Constants.MODIFICATION_TIMESTAMP_PROPERTY_KEY, "date", false, true));
                this.add(new AtlasStructDef.AtlasAttributeDef(Constants.MODIFIED_BY_KEY, "string", false, true));
                this.add(new AtlasStructDef.AtlasAttributeDef(Constants.CREATED_BY_KEY, "string", false, true));
                this.add(new AtlasStructDef.AtlasAttributeDef(Constants.STATE_PROPERTY_KEY, "string", false, true));
            }
        };
        AtlasClassificationDef classificationDef = new AtlasClassificationDef(CLASSIFICATION_ROOT_NAME, "Root classification for system attributes", "1.0", (List<AtlasStructDef.AtlasAttributeDef>)attributeDefs);
        return new AtlasClassificationType(classificationDef);
    }

    private void getTypeHierarchyInfo(AtlasTypeRegistry typeRegistry, Set<String> allSuperTypeNames, Map<String, AtlasStructType.AtlasAttribute> allAttributes) throws AtlasBaseException {
        ArrayList<String> visitedTypes = new ArrayList<String>();
        this.collectTypeHierarchyInfo(typeRegistry, allSuperTypeNames, allAttributes, visitedTypes);
    }

    private void collectTypeHierarchyInfo(AtlasTypeRegistry typeRegistry, Set<String> allSuperTypeNames, Map<String, AtlasStructType.AtlasAttribute> allAttributes, List<String> visitedTypes) throws AtlasBaseException {
        if (visitedTypes.contains(this.classificationDef.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.CIRCULAR_REFERENCE, this.classificationDef.getName(), visitedTypes.toString());
        }
        if (CollectionUtils.isNotEmpty(this.classificationDef.getSuperTypes())) {
            visitedTypes.add(this.classificationDef.getName());
            for (String superTypeName : this.classificationDef.getSuperTypes()) {
                AtlasClassificationType superType = typeRegistry.getClassificationTypeByName(superTypeName);
                if (superType == null) continue;
                superType.collectTypeHierarchyInfo(typeRegistry, allSuperTypeNames, allAttributes, visitedTypes);
            }
            visitedTypes.remove(this.classificationDef.getName());
            allSuperTypeNames.addAll(this.classificationDef.getSuperTypes());
        }
        if (CollectionUtils.isNotEmpty(this.classificationDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.classificationDef.getAttributeDefs()) {
                AtlasType type = typeRegistry.getType(attributeDef.getTypeName());
                allAttributes.put(attributeDef.getName(), new AtlasStructType.AtlasAttribute(this, attributeDef, type));
            }
        }
    }

    private boolean validateTimeBoundaries(Object classificationObj, List<String> messages) {
        boolean ret = true;
        AtlasClassification classification = null;
        if (classificationObj instanceof AtlasClassification) {
            classification = (AtlasClassification)classificationObj;
        } else if (classificationObj instanceof Map) {
            classification = new AtlasClassification((Map)classificationObj);
        }
        if (classification != null && classification.getValidityPeriods() != null) {
            for (TimeBoundary timeBoundary : classification.getValidityPeriods()) {
                if (timeBoundary == null) continue;
                ret = this.validateTimeBoundry(timeBoundary, messages) && ret;
            }
        }
        return ret;
    }

    private boolean validateTimeBoundry(TimeBoundary timeBoundary, List<String> messages) {
        TimeZone timezone;
        boolean ret = true;
        DateValidator dateValidator = DateValidator.getInstance();
        Date startDate = null;
        Date endDate = null;
        if (StringUtils.isNotEmpty((String)timeBoundary.getTimeZone())) {
            if (!AtlasClassificationType.isValidTimeZone(timeBoundary.getTimeZone())) {
                this.addValidationMessageIfNotPresent(new AtlasBaseException(AtlasErrorCode.INVALID_TIMEBOUNDRY_TIMEZONE, timeBoundary.getTimeZone()), messages);
                ret = false;
            }
            timezone = TimeZone.getTimeZone(timeBoundary.getTimeZone());
        } else {
            timezone = TimeZone.getDefault();
        }
        if (StringUtils.isNotEmpty((String)timeBoundary.getStartTime()) && (startDate = dateValidator.validate(timeBoundary.getStartTime(), "yyyy/MM/dd HH:mm:ss", timezone)) == null) {
            this.addValidationMessageIfNotPresent(new AtlasBaseException(AtlasErrorCode.INVALID_TIMEBOUNDRY_START_TIME, timeBoundary.getStartTime()), messages);
            ret = false;
        }
        if (StringUtils.isNotEmpty((String)timeBoundary.getEndTime()) && (endDate = dateValidator.validate(timeBoundary.getEndTime(), "yyyy/MM/dd HH:mm:ss", timezone)) == null) {
            this.addValidationMessageIfNotPresent(new AtlasBaseException(AtlasErrorCode.INVALID_TIMEBOUNDRY_END_TIME, timeBoundary.getEndTime()), messages);
            ret = false;
        }
        if (startDate != null && endDate != null && endDate.before(startDate)) {
            this.addValidationMessageIfNotPresent(new AtlasBaseException(AtlasErrorCode.INVALID_TIMEBOUNDRY_DATERANGE, timeBoundary.getStartTime(), timeBoundary.getEndTime()), messages);
            ret = false;
        }
        return ret;
    }

    public static boolean isValidTimeZone(String timeZone) {
        String DEFAULT_GMT_TIMEZONE = "GMT";
        if (timeZone.equals("GMT")) {
            return true;
        }
        String id = TimeZone.getTimeZone(timeZone).getID();
        return !id.equals("GMT");
    }

    private void addValidationMessageIfNotPresent(AtlasBaseException excp, List<String> messages) {
        String msg = excp.getMessage();
        if (messages != null && !messages.contains(msg)) {
            messages.add(msg);
        }
    }
}

