/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.pc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusReporter<T, U> {
    private static final Logger LOG = LoggerFactory.getLogger(StatusReporter.class);
    private Map<T, U> producedItems = new LinkedHashMap<T, U>();
    private Set<T> processedSet = new HashSet<T>();
    private long timeoutDuration;
    private long lastAck;

    public StatusReporter() {
        this.timeoutDuration = -1L;
    }

    public StatusReporter(long timeoutDurationInMs) {
        this.timeoutDuration = timeoutDurationInMs;
    }

    public void produced(T item, U index) {
        this.producedItems.put(item, index);
    }

    public void processed(T item) {
        this.processedSet.add(item);
    }

    public void processed(T[] index) {
        this.processedSet.addAll(Arrays.asList(index));
    }

    public U ack() {
        U ret;
        U ack = null;
        do {
            Map.Entry<T, U> firstElement;
            if ((ret = this.completionIndex(firstElement = this.getFirstElement(this.producedItems))) == null) continue;
            ack = ret;
        } while (ret != null);
        return ack;
    }

    private Map.Entry<T, U> getFirstElement(Map<T, U> map) {
        if (map.isEmpty()) {
            return null;
        }
        return map.entrySet().iterator().next();
    }

    private U completionIndex(Map.Entry<T, U> lookFor) {
        U ack = null;
        if (lookFor == null) {
            return ack;
        }
        if (this.hasTimeoutDurationReached(System.currentTimeMillis())) {
            LOG.warn("Ack: Timeout: {} - {}", lookFor.getKey(), lookFor.getValue());
            return this.acknowledged(lookFor);
        }
        if (!this.processedSet.contains(lookFor.getKey())) {
            return ack;
        }
        return this.acknowledged(lookFor);
    }

    private U acknowledged(Map.Entry<T, U> lookFor) {
        U ack = lookFor.getValue();
        this.producedItems.remove(lookFor.getKey());
        this.processedSet.remove(lookFor);
        return ack;
    }

    private boolean hasTimeoutDurationReached(long now) {
        boolean b = this.timeoutDuration > -1L && this.lastAck != 0L && now - this.lastAck >= this.timeoutDuration;
        this.lastAck = System.currentTimeMillis();
        return b;
    }
}

