/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.lineage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasEntityHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasLineageInfo
implements Serializable {
    private String baseEntityGuid;
    private LineageDirection lineageDirection;
    private int lineageDepth;
    private Map<String, AtlasEntityHeader> guidEntityMap;
    private Set<LineageRelation> relations;

    public AtlasLineageInfo() {
    }

    public AtlasLineageInfo(String baseEntityGuid, Map<String, AtlasEntityHeader> guidEntityMap, Set<LineageRelation> relations, LineageDirection lineageDirection, int lineageDepth) {
        this.baseEntityGuid = baseEntityGuid;
        this.lineageDirection = lineageDirection;
        this.lineageDepth = lineageDepth;
        this.guidEntityMap = guidEntityMap;
        this.relations = relations;
    }

    public String getBaseEntityGuid() {
        return this.baseEntityGuid;
    }

    public void setBaseEntityGuid(String baseEntityGuid) {
        this.baseEntityGuid = baseEntityGuid;
    }

    public Map<String, AtlasEntityHeader> getGuidEntityMap() {
        return this.guidEntityMap;
    }

    public void setGuidEntityMap(Map<String, AtlasEntityHeader> guidEntityMap) {
        this.guidEntityMap = guidEntityMap;
    }

    public Set<LineageRelation> getRelations() {
        return this.relations;
    }

    public void setRelations(Set<LineageRelation> relations) {
        this.relations = relations;
    }

    public LineageDirection getLineageDirection() {
        return this.lineageDirection;
    }

    public void setLineageDirection(LineageDirection lineageDirection) {
        this.lineageDirection = lineageDirection;
    }

    public int getLineageDepth() {
        return this.lineageDepth;
    }

    public void setLineageDepth(int lineageDepth) {
        this.lineageDepth = lineageDepth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlasLineageInfo that = (AtlasLineageInfo)o;
        return this.lineageDepth == that.lineageDepth && Objects.equals(this.baseEntityGuid, that.baseEntityGuid) && this.lineageDirection == that.lineageDirection && Objects.equals(this.guidEntityMap, that.guidEntityMap) && Objects.equals(this.relations, that.relations);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseEntityGuid, this.lineageDirection, this.lineageDepth, this.guidEntityMap, this.relations});
    }

    public String toString() {
        return "AtlasLineageInfo{baseEntityGuid=" + this.baseEntityGuid + ", guidEntityMap=" + this.guidEntityMap + ", relations=" + this.relations + ", lineageDirection=" + (Object)((Object)this.lineageDirection) + ", lineageDepth=" + this.lineageDepth + '}';
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class LineageRelation {
        private String fromEntityId;
        private String toEntityId;
        private String relationshipId;

        public LineageRelation() {
        }

        public LineageRelation(String fromEntityId, String toEntityId, String relationshipId) {
            this.fromEntityId = fromEntityId;
            this.toEntityId = toEntityId;
            this.relationshipId = relationshipId;
        }

        public String getFromEntityId() {
            return this.fromEntityId;
        }

        public void setFromEntityId(String fromEntityId) {
            this.fromEntityId = fromEntityId;
        }

        public String getToEntityId() {
            return this.toEntityId;
        }

        public void setToEntityId(String toEntityId) {
            this.toEntityId = toEntityId;
        }

        public String getRelationshipId() {
            return this.relationshipId;
        }

        public void setRelationshipId(String relationshipId) {
            this.relationshipId = relationshipId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineageRelation that = (LineageRelation)o;
            return Objects.equals(this.fromEntityId, that.fromEntityId) && Objects.equals(this.toEntityId, that.toEntityId) && Objects.equals(this.relationshipId, that.relationshipId);
        }

        public int hashCode() {
            return Objects.hash(this.fromEntityId, this.toEntityId, this.relationshipId);
        }

        public String toString() {
            return "LineageRelation{fromEntityId='" + this.fromEntityId + '\'' + ", toEntityId='" + this.toEntityId + '\'' + ", relationshipId='" + this.relationshipId + '\'' + '}';
        }
    }

    public static enum LineageDirection {
        INPUT,
        OUTPUT,
        BOTH;

    }
}

