/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.audit;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Date;
import org.apache.atlas.model.AtlasBaseModelObject;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasAuditEntry
extends AtlasBaseModelObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String userName;
    private AuditOperation operation;
    private String params;
    private Date startTime;
    private Date endTime;
    private String clientId;
    private String result;

    public AtlasAuditEntry() {
    }

    public AtlasAuditEntry(AuditOperation operation, String userName, String clientId) {
        this.operation = operation;
        this.userName = userName;
        this.clientId = clientId;
    }

    public AuditOperation getOperation() {
        return this.operation;
    }

    public void setOperation(AuditOperation operation) {
        this.operation = operation;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public String getParams() {
        return this.params;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append(", userName: ").append(this.userName);
        sb.append(", operation: ").append((Object)this.operation);
        sb.append(", params: ").append(this.params);
        sb.append(", clientId: ").append(this.clientId);
        sb.append(", startTime: ").append(this.startTime);
        sb.append(", endTime: ").append(this.endTime);
        sb.append(", result: ").append(this.result);
        return sb;
    }

    public static enum AuditOperation {
        PURGE,
        EXPORT,
        IMPORT,
        IMPORT_DELETE_REPL;

    }
}

