/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.listener;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasBusinessMetadataDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.commons.collections.CollectionUtils;

public class ChangedTypeDefs {
    private List<? extends AtlasBaseTypeDef> createdTypeDefs;
    private List<? extends AtlasBaseTypeDef> updatedTypeDefs;
    private List<? extends AtlasBaseTypeDef> deletedTypeDefs;

    public ChangedTypeDefs(List<? extends AtlasBaseTypeDef> createdTypeDefs, List<? extends AtlasBaseTypeDef> updatedTypeDefs, List<? extends AtlasBaseTypeDef> deletedTypeDefs) {
        this.createdTypeDefs = createdTypeDefs;
        this.updatedTypeDefs = updatedTypeDefs;
        this.deletedTypeDefs = deletedTypeDefs;
    }

    public ChangedTypeDefs() {
        this.createdTypeDefs = new ArrayList<AtlasBaseTypeDef>();
        this.updatedTypeDefs = new ArrayList<AtlasBaseTypeDef>();
        this.deletedTypeDefs = new ArrayList<AtlasBaseTypeDef>();
    }

    public List<? extends AtlasBaseTypeDef> getCreatedTypeDefs() {
        return this.createdTypeDefs;
    }

    public ChangedTypeDefs setCreatedTypeDefs(List<? extends AtlasBaseTypeDef> createdTypeDefs) {
        this.createdTypeDefs = createdTypeDefs;
        return this;
    }

    public List<? extends AtlasBaseTypeDef> getUpdatedTypeDefs() {
        return this.updatedTypeDefs;
    }

    public ChangedTypeDefs setUpdatedTypeDefs(List<? extends AtlasBaseTypeDef> updatedTypeDefs) {
        this.updatedTypeDefs = updatedTypeDefs;
        return this;
    }

    public List<? extends AtlasBaseTypeDef> getDeletedTypeDefs() {
        return this.deletedTypeDefs;
    }

    public ChangedTypeDefs setDeletedTypeDefs(List<? extends AtlasBaseTypeDef> deletedTypeDefs) {
        this.deletedTypeDefs = deletedTypeDefs;
        return this;
    }

    public boolean hasEntityDef() {
        return this.hasEntityDef(this.createdTypeDefs) || this.hasEntityDef(this.updatedTypeDefs) || this.hasEntityDef(this.deletedTypeDefs);
    }

    private boolean hasEntityDef(List<? extends AtlasBaseTypeDef> typeDefs) {
        boolean ret = false;
        if (CollectionUtils.isNotEmpty(typeDefs)) {
            for (AtlasBaseTypeDef atlasBaseTypeDef : typeDefs) {
                if (!(atlasBaseTypeDef instanceof AtlasEntityDef)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    public boolean hasBusinessMetadataDef() {
        return this.hasBusinessMetadataDef(this.createdTypeDefs) || this.hasEntityDef(this.updatedTypeDefs) || this.hasEntityDef(this.deletedTypeDefs);
    }

    private boolean hasBusinessMetadataDef(List<? extends AtlasBaseTypeDef> typeDefs) {
        boolean ret = false;
        if (CollectionUtils.isNotEmpty(typeDefs)) {
            for (AtlasBaseTypeDef atlasBaseTypeDef : typeDefs) {
                if (!(atlasBaseTypeDef instanceof AtlasBusinessMetadataDef)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }
}

