/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.atlas.entitytransform.BaseEntityHandler;
import org.apache.atlas.entitytransform.EntityAttribute;
import org.apache.atlas.entitytransform.TransformerContext;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Condition {
    private static final Logger LOG = LoggerFactory.getLogger(Condition.class);
    private static final String CONDITION_DELIMITER = ":";
    private static final String CONDITION_ENTITY_OBJECT_ID = "OBJECTID";
    private static final String CONDITION_ENTITY_TOP_LEVEL = "TOPLEVEL";
    private static final String CONDITION_ENTITY_ALL = "ALL";
    private static final String CONDITION_NAME_EQUALS = "EQUALS";
    private static final String CONDITION_NAME_EQUALS_IGNORE_CASE = "EQUALS_IGNORE_CASE";
    private static final String CONDITION_NAME_STARTS_WITH = "STARTS_WITH";
    private static final String CONDITION_NAME_STARTS_WITH_IGNORE_CASE = "STARTS_WITH_IGNORE_CASE";
    private static final String CONDITION_NAME_HAS_VALUE = "HAS_VALUE";
    protected final EntityAttribute attribute;

    protected Condition(EntityAttribute attribute) {
        this.attribute = attribute;
    }

    public EntityAttribute getAttribute() {
        return this.attribute;
    }

    public abstract boolean matches(BaseEntityHandler.AtlasTransformableEntity var1);

    public static Condition createCondition(String key, String value, TransformerContext context) {
        Condition ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> Condition.createCondition(key={}, value={})", (Object)key, (Object)value);
        }
        int idxConditionDelim = value == null ? -1 : value.indexOf(CONDITION_DELIMITER);
        String conditionName = idxConditionDelim == -1 ? CONDITION_NAME_EQUALS : value.substring(0, idxConditionDelim);
        String conditionValue = idxConditionDelim == -1 ? value : value.substring(idxConditionDelim + CONDITION_DELIMITER.length());
        conditionName = StringUtils.trim((String)conditionName);
        conditionValue = StringUtils.trim((String)conditionValue);
        value = StringUtils.trim((String)value);
        EntityAttribute attribute = new EntityAttribute(StringUtils.trim((String)key), context);
        switch (conditionName.toUpperCase()) {
            case "ALL": {
                ret = new ObjectIdEquals(attribute, CONDITION_ENTITY_ALL, context);
                break;
            }
            case "TOPLEVEL": {
                ret = new ObjectIdEquals(attribute, CONDITION_ENTITY_TOP_LEVEL, context);
                break;
            }
            case "OBJECTID": {
                ret = new ObjectIdEquals(attribute, conditionValue, context);
                break;
            }
            case "EQUALS": {
                ret = new EqualsCondition(attribute, conditionValue);
                break;
            }
            case "EQUALS_IGNORE_CASE": {
                ret = new EqualsIgnoreCaseCondition(attribute, conditionValue);
                break;
            }
            case "STARTS_WITH": {
                ret = new StartsWithCondition(attribute, conditionValue);
                break;
            }
            case "STARTS_WITH_IGNORE_CASE": {
                ret = new StartsWithIgnoreCaseCondition(attribute, conditionValue);
                break;
            }
            case "HAS_VALUE": {
                ret = new HasValueCondition(attribute);
                break;
            }
            default: {
                ret = new EqualsCondition(attribute, value);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== Condition.createCondition(key={}, value={}): actionName={}, actionValue={}, ret={}", new Object[]{key, value, conditionName, conditionValue, ret});
        }
        return ret;
    }

    public static class HasValueCondition
    extends Condition {
        public HasValueCondition(EntityAttribute attribute) {
            super(attribute);
        }

        @Override
        public boolean matches(BaseEntityHandler.AtlasTransformableEntity entity) {
            Object attributeValue = entity != null ? entity.getAttribute(this.attribute) : null;
            return attributeValue != null ? StringUtils.isNotEmpty((String)attributeValue.toString()) : false;
        }
    }

    static class ObjectIdEquals
    extends Condition {
        private final boolean isMatchAll;
        private final List<AtlasObjectId> objectIds;

        public ObjectIdEquals(EntityAttribute attribute, String scope, TransformerContext context) {
            super(attribute);
            this.isMatchAll = StringUtils.equals((String)scope, (String)Condition.CONDITION_ENTITY_ALL);
            this.objectIds = new ArrayList<AtlasObjectId>();
            if (!this.isMatchAll && context != null && context.getExportRequest() != null) {
                AtlasExportRequest request = context.getExportRequest();
                for (AtlasObjectId objectId : request.getItemsToExport()) {
                    this.addObjectId(objectId);
                }
            }
        }

        @Override
        public boolean matches(BaseEntityHandler.AtlasTransformableEntity entity) {
            if (this.isMatchAll) {
                return true;
            }
            for (AtlasObjectId objectId : this.objectIds) {
                if (!this.isMatch(objectId, entity.getEntity())) continue;
                return true;
            }
            return false;
        }

        void addObjectId(AtlasObjectId objId) {
            this.objectIds.add(objId);
        }

        private boolean isMatch(AtlasObjectId objectId, AtlasEntity entity) {
            if (!StringUtils.isEmpty((String)objectId.getGuid())) {
                return Objects.equals(objectId.getGuid(), entity.getGuid());
            }
            boolean ret = Objects.equals(objectId.getTypeName(), entity.getTypeName());
            if (ret) {
                for (Map.Entry<String, Object> entry : objectId.getUniqueAttributes().entrySet()) {
                    if (ret = ret && Objects.equals(entity.getAttribute(entry.getKey()), entry.getValue())) continue;
                    break;
                }
            }
            return ret;
        }
    }

    public static class StartsWithIgnoreCaseCondition
    extends Condition {
        protected final String prefix;

        public StartsWithIgnoreCaseCondition(EntityAttribute attribute, String prefix) {
            super(attribute);
            this.prefix = prefix;
        }

        @Override
        public boolean matches(BaseEntityHandler.AtlasTransformableEntity entity) {
            Object attributeValue = entity != null ? entity.getAttribute(this.attribute) : null;
            return attributeValue != null && StringUtils.startsWithIgnoreCase((String)attributeValue.toString(), (String)this.prefix);
        }
    }

    public static class StartsWithCondition
    extends Condition {
        protected final String prefix;

        public StartsWithCondition(EntityAttribute attribute, String prefix) {
            super(attribute);
            this.prefix = prefix;
        }

        @Override
        public boolean matches(BaseEntityHandler.AtlasTransformableEntity entity) {
            Object attributeValue = entity != null ? entity.getAttribute(this.attribute) : null;
            return attributeValue != null && StringUtils.startsWith((String)attributeValue.toString(), (String)this.prefix);
        }
    }

    public static class EqualsIgnoreCaseCondition
    extends Condition {
        protected final String attributeValue;

        public EqualsIgnoreCaseCondition(EntityAttribute attribute, String attributeValue) {
            super(attribute);
            this.attributeValue = attributeValue;
        }

        @Override
        public boolean matches(BaseEntityHandler.AtlasTransformableEntity entity) {
            Object attributeValue = entity != null ? entity.getAttribute(this.attribute) : null;
            return attributeValue != null && StringUtils.equalsIgnoreCase((String)attributeValue.toString(), (String)this.attributeValue);
        }
    }

    public static class EqualsCondition
    extends Condition {
        protected final String attributeValue;

        public EqualsCondition(EntityAttribute attribute, String attributeValue) {
            super(attribute);
            this.attributeValue = attributeValue;
        }

        @Override
        public boolean matches(BaseEntityHandler.AtlasTransformableEntity entity) {
            Object attributeValue = entity != null ? entity.getAttribute(this.attribute) : null;
            return attributeValue != null && StringUtils.equals((String)attributeValue.toString(), (String)this.attributeValue);
        }
    }
}

