/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.entitytransform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.atlas.entitytransform.Action;
import org.apache.atlas.entitytransform.AtlasEntityTransformer;
import org.apache.atlas.entitytransform.EntityAttribute;
import org.apache.atlas.entitytransform.HdfsPathEntityHandler;
import org.apache.atlas.entitytransform.HiveColumnEntityHandler;
import org.apache.atlas.entitytransform.HiveDatabaseEntityHandler;
import org.apache.atlas.entitytransform.HiveStorageDescriptorEntityHandler;
import org.apache.atlas.entitytransform.HiveTableEntityHandler;
import org.apache.atlas.entitytransform.TransformerContext;
import org.apache.atlas.model.impexp.AttributeTransform;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseEntityHandler {
    private static final Logger LOG = LoggerFactory.getLogger(BaseEntityHandler.class);
    protected final List<AtlasEntityTransformer> transformers;

    public BaseEntityHandler(List<AtlasEntityTransformer> transformers) {
        this.transformers = transformers;
    }

    public AtlasEntity transform(AtlasEntity entity) {
        if (CollectionUtils.isEmpty(this.transformers)) {
            return entity;
        }
        AtlasTransformableEntity transformableEntity = this.getTransformableEntity(entity);
        if (transformableEntity == null) {
            return entity;
        }
        for (AtlasEntityTransformer transformer : this.transformers) {
            transformer.transform(transformableEntity);
        }
        transformableEntity.transformComplete();
        return entity;
    }

    public AtlasTransformableEntity getTransformableEntity(AtlasEntity entity) {
        return new AtlasTransformableEntity(entity);
    }

    public static List<BaseEntityHandler> createEntityHandlers(List<AttributeTransform> transforms, TransformerContext context) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> BaseEntityHandler.createEntityHandlers(transforms={})", transforms);
        }
        ArrayList<BaseEntityHandler> ret = new ArrayList<BaseEntityHandler>();
        if (CollectionUtils.isNotEmpty(transforms)) {
            ArrayList<AtlasEntityTransformer> transformers = new ArrayList<AtlasEntityTransformer>();
            for (AttributeTransform transform : transforms) {
                transformers.add(new AtlasEntityTransformer(transform, context));
            }
            if (BaseEntityHandler.hasTransformerForAnyAttribute(transformers, HdfsPathEntityHandler.CUSTOM_TRANSFORM_ATTRIBUTES)) {
                ret.add(new HdfsPathEntityHandler(transformers));
            }
            if (BaseEntityHandler.hasTransformerForAnyAttribute(transformers, HiveDatabaseEntityHandler.CUSTOM_TRANSFORM_ATTRIBUTES)) {
                ret.add(new HiveDatabaseEntityHandler(transformers));
            }
            if (BaseEntityHandler.hasTransformerForAnyAttribute(transformers, HiveTableEntityHandler.CUSTOM_TRANSFORM_ATTRIBUTES)) {
                ret.add(new HiveTableEntityHandler(transformers));
            }
            if (BaseEntityHandler.hasTransformerForAnyAttribute(transformers, HiveColumnEntityHandler.CUSTOM_TRANSFORM_ATTRIBUTES)) {
                ret.add(new HiveColumnEntityHandler(transformers));
            }
            if (BaseEntityHandler.hasTransformerForAnyAttribute(transformers, HiveStorageDescriptorEntityHandler.CUSTOM_TRANSFORM_ATTRIBUTES)) {
                ret.add(new HiveStorageDescriptorEntityHandler(transformers));
            }
            if (CollectionUtils.isEmpty(ret)) {
                ret.add(new BaseEntityHandler(transformers));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== BaseEntityHandler.createEntityHandlers(transforms={}): ret.size={}", transforms, (Object)ret.size());
        }
        return ret;
    }

    private static boolean hasTransformerForAnyAttribute(List<AtlasEntityTransformer> transformers, List<String> attributes) {
        if (CollectionUtils.isNotEmpty(transformers) && CollectionUtils.isNotEmpty(attributes)) {
            for (AtlasEntityTransformer transformer : transformers) {
                for (Action action : transformer.getActions()) {
                    if (!attributes.contains(action.getAttribute().getAttributeKey())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<BaseEntityHandler> fromJson(String transformersString, TransformerContext context) {
        if (StringUtils.isEmpty((String)transformersString)) {
            return null;
        }
        Object transformersObj = AtlasType.fromJson(transformersString, Object.class);
        List transformers = transformersObj != null && transformersObj instanceof List ? (List)transformersObj : null;
        ArrayList<AttributeTransform> attributeTransforms = new ArrayList<AttributeTransform>();
        if (CollectionUtils.isEmpty((Collection)transformers)) {
            return null;
        }
        for (Object transformer : transformers) {
            String transformerStr = AtlasType.toJson(transformer);
            AttributeTransform attributeTransform = AtlasType.fromJson(transformerStr, AttributeTransform.class);
            if (attributeTransform == null) continue;
            attributeTransforms.add(attributeTransform);
        }
        if (CollectionUtils.isEmpty(attributeTransforms)) {
            return null;
        }
        List<BaseEntityHandler> entityHandlers = BaseEntityHandler.createEntityHandlers(attributeTransforms, context);
        if (CollectionUtils.isEmpty(entityHandlers)) {
            return null;
        }
        return entityHandlers;
    }

    public static class AtlasTransformableEntity {
        protected final AtlasEntity entity;

        protected AtlasTransformableEntity(AtlasEntity entity) {
            this.entity = entity;
        }

        public AtlasEntity getEntity() {
            return this.entity;
        }

        public Object getAttribute(EntityAttribute attribute) {
            Object ret = attribute.appliesToEntityType(this.entity.getTypeName()) ? this.entity.getAttribute(attribute.getAttributeName()) : null;
            return ret;
        }

        public void setAttribute(EntityAttribute attribute, String attributeValue) {
            if (attribute.appliesToEntityType(this.entity.getTypeName())) {
                this.entity.setAttribute(attribute.getAttributeName(), attributeValue);
            }
        }

        public boolean hasAttribute(EntityAttribute attribute) {
            return this.getAttribute(attribute) != null;
        }

        public void transformComplete() {
        }
    }
}

