/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.security.InMemoryJAASConfiguration;
import org.apache.atlas.security.SecurityUtil;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationProperties
extends PropertiesConfiguration {
    public static final String ATLAS_CONFIGURATION_DIRECTORY_PROPERTY = "atlas.conf";
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationProperties.class);
    public static final String APPLICATION_PROPERTIES = "atlas-application.properties";
    public static final String GRAPHDB_BACKEND_CONF = "atlas.graphdb.backend";
    public static final String STORAGE_BACKEND_CONF = "atlas.graph.storage.backend";
    public static final String INDEX_BACKEND_CONF = "atlas.graph.index.search.backend";
    public static final String INDEX_MAP_NAME_CONF = "atlas.graph.index.search.map-name";
    public static final String SOLR_WAIT_SEARCHER_CONF = "atlas.graph.index.search.solr.wait-searcher";
    public static final String ENABLE_FULLTEXT_SEARCH_CONF = "atlas.search.fulltext.enable";
    public static final String ENABLE_FREETEXT_SEARCH_CONF = "atlas.search.freetext.enable";
    public static final String ATLAS_RUN_MODE = "atlas.run.mode";
    public static final String GRAPHBD_BACKEND_JANUS = "janus";
    public static final String STORAGE_BACKEND_HBASE = "hbase";
    public static final String STORAGE_BACKEND_HBASE2 = "hbase2";
    public static final String INDEX_BACKEND_SOLR = "solr";
    public static final String LDAP_TYPE = "atlas.authentication.method.ldap.type";
    public static final String LDAP_AD_BIND_PASSWORD = "atlas.authentication.method.ldap.ad.bind.password";
    public static final String LDAP_BIND_PASSWORD = "atlas.authentication.method.ldap.bind.password";
    public static final String MASK_LDAP_PASSWORD = "*****";
    public static final String DEFAULT_GRAPHDB_BACKEND = "janus";
    public static final boolean DEFAULT_SOLR_WAIT_SEARCHER = true;
    public static final boolean DEFAULT_INDEX_MAP_NAME = false;
    public static final AtlasRunMode DEFAULT_ATLAS_RUN_MODE = AtlasRunMode.PROD;
    public static final AbstractMap.SimpleEntry<String, String> DB_CACHE_CONF = new AbstractMap.SimpleEntry<String, String>("atlas.graph.cache.db-cache", "true");
    public static final AbstractMap.SimpleEntry<String, String> DB_CACHE_CLEAN_WAIT_CONF = new AbstractMap.SimpleEntry<String, String>("atlas.graph.cache.db-cache-clean-wait", "20");
    public static final AbstractMap.SimpleEntry<String, String> DB_CACHE_SIZE_CONF = new AbstractMap.SimpleEntry<String, String>("atlas.graph.cache.db-cache-size", "0.5");
    public static final AbstractMap.SimpleEntry<String, String> DB_TX_CACHE_SIZE_CONF = new AbstractMap.SimpleEntry<String, String>("atlas.graph.cache.tx-cache-size", "15000");
    public static final AbstractMap.SimpleEntry<String, String> DB_CACHE_TX_DIRTY_SIZE_CONF = new AbstractMap.SimpleEntry<String, String>("atlas.graph.cache.tx-dirty-size", "120");
    private static volatile Configuration instance = null;

    private ApplicationProperties(URL url) throws ConfigurationException {
        super(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void forceReload() {
        if (instance == null) return;
        Class<ApplicationProperties> clazz = ApplicationProperties.class;
        synchronized (ApplicationProperties.class) {
            if (instance == null) return;
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration get() throws AtlasException {
        if (instance != null) return instance;
        Class<ApplicationProperties> clazz = ApplicationProperties.class;
        synchronized (ApplicationProperties.class) {
            if (instance != null) return instance;
            ApplicationProperties.set(ApplicationProperties.get(APPLICATION_PROPERTIES));
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration set(Configuration configuration) throws AtlasException {
        Class<ApplicationProperties> clazz = ApplicationProperties.class;
        synchronized (ApplicationProperties.class) {
            instance = configuration;
            InMemoryJAASConfiguration.init(instance);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static Configuration get(String fileName) throws AtlasException {
        String confLocation = System.getProperty(ATLAS_CONFIGURATION_DIRECTORY_PROPERTY);
        try {
            URL url = null;
            if (confLocation == null) {
                LOG.info("Looking for {} in classpath", (Object)fileName);
                url = ApplicationProperties.class.getClassLoader().getResource(fileName);
                if (url == null) {
                    LOG.info("Looking for /{} in classpath", (Object)fileName);
                    url = ApplicationProperties.class.getClassLoader().getResource("/" + fileName);
                }
            } else {
                url = new File(confLocation, fileName).toURI().toURL();
            }
            LOG.info("Loading {} from {}", (Object)fileName, (Object)url);
            ApplicationProperties appProperties = new ApplicationProperties(url);
            appProperties.setDefaults();
            ApplicationProperties.setLdapPasswordFromKeystore((Configuration)appProperties);
            Configuration configuration = appProperties.interpolatedConfiguration();
            ApplicationProperties.logConfiguration(configuration);
            return configuration;
        }
        catch (Exception e) {
            throw new AtlasException("Failed to load application properties", e);
        }
    }

    private static void logConfiguration(Configuration configuration) {
        if (LOG.isDebugEnabled()) {
            Iterator keys = configuration.getKeys();
            LOG.debug("Configuration loaded:");
            while (keys.hasNext()) {
                String key = (String)keys.next();
                LOG.debug("{} = {}", (Object)key, configuration.getProperty(key));
            }
        }
    }

    public static Configuration getSubsetConfiguration(Configuration inConf, String prefix) {
        return inConf.subset(prefix);
    }

    public static Properties getSubsetAsProperties(Configuration inConf, String prefix) {
        Configuration subset = inConf.subset(prefix);
        Properties ret = ConfigurationConverter.getProperties((Configuration)subset);
        return ret;
    }

    public static Class getClass(Configuration configuration, String propertyName, String defaultValue, Class assignableClass) throws AtlasException {
        try {
            String propertyValue = configuration.getString(propertyName, defaultValue);
            Class<?> clazz = Class.forName(propertyValue);
            if (assignableClass == null || assignableClass.isAssignableFrom(clazz)) {
                return clazz;
            }
            String message = "Class " + clazz.getName() + " specified in property " + propertyName + " is not assignable to class " + assignableClass.getName();
            LOG.error(message);
            throw new AtlasException(message);
        }
        catch (Exception e) {
            throw new AtlasException(e);
        }
    }

    public static Class getClass(String fullyQualifiedClassName, Class assignableClass) throws AtlasException {
        try {
            Class<?> clazz = Class.forName(fullyQualifiedClassName);
            if (assignableClass == null || assignableClass.isAssignableFrom(clazz)) {
                return clazz;
            }
            String message = "Class " + clazz.getName() + " is not assignable to class " + assignableClass.getName();
            LOG.error(message);
            throw new AtlasException(message);
        }
        catch (Exception e) {
            throw new AtlasException(e);
        }
    }

    public static InputStream getFileAsInputStream(Configuration configuration, String propertyName, String defaultFileName) throws AtlasException {
        File fileToLoad = null;
        String fileName = configuration.getString(propertyName);
        if (fileName == null) {
            if (defaultFileName == null) {
                throw new AtlasException(propertyName + " property not set and no default value specified");
            }
            LOG.info("{} property not set; defaulting to {}", (Object)propertyName, (Object)defaultFileName);
            fileName = defaultFileName;
            String atlasConfDir = System.getProperty(ATLAS_CONFIGURATION_DIRECTORY_PROPERTY);
            fileToLoad = atlasConfDir != null ? new File(atlasConfDir, fileName) : new File(fileName);
        } else {
            fileToLoad = new File(fileName);
        }
        InputStream inStr = null;
        if (fileToLoad.exists()) {
            try {
                LOG.info("Loading file {} from {}", (Object)fileName, (Object)fileToLoad.getPath());
                inStr = new FileInputStream(fileToLoad);
            }
            catch (FileNotFoundException e) {
                throw new AtlasException("Error loading file " + fileName, e);
            }
        } else {
            inStr = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            if (inStr == null) {
                String msg = fileName + " not found in file system or as class loader resource";
                LOG.error(msg);
                throw new AtlasException(msg);
            }
            LOG.info("Loaded {} as resource from {}", (Object)fileName, (Object)Thread.currentThread().getContextClassLoader().getResource(fileName).toString());
        }
        return inStr;
    }

    private static void setLdapPasswordFromKeystore(Configuration configuration) {
        String ldapType = configuration.getString(LDAP_TYPE);
        if (StringUtils.isNotEmpty((String)ldapType)) {
            try {
                String maskPasssword;
                if (ldapType.equalsIgnoreCase("ldap")) {
                    String maskPasssword2 = configuration.getString(LDAP_BIND_PASSWORD);
                    if (MASK_LDAP_PASSWORD.equals(maskPasssword2)) {
                        String password = SecurityUtil.getPassword(configuration, LDAP_BIND_PASSWORD);
                        configuration.clearProperty(LDAP_BIND_PASSWORD);
                        configuration.addProperty(LDAP_BIND_PASSWORD, (Object)password);
                    }
                } else if (ldapType.equalsIgnoreCase("ad") && MASK_LDAP_PASSWORD.equals(maskPasssword = configuration.getString(LDAP_AD_BIND_PASSWORD))) {
                    String password = SecurityUtil.getPassword(configuration, LDAP_AD_BIND_PASSWORD);
                    configuration.clearProperty(LDAP_AD_BIND_PASSWORD);
                    configuration.addProperty(LDAP_AD_BIND_PASSWORD, (Object)password);
                }
            }
            catch (Exception e) {
                LOG.error("Error in getting secure password ", (Throwable)e);
            }
        }
    }

    private void setDefaults() {
        AtlasRunMode runMode = AtlasRunMode.valueOf(this.getString(ATLAS_RUN_MODE, DEFAULT_ATLAS_RUN_MODE.name()));
        String graphDbBackend = this.getString(GRAPHDB_BACKEND_CONF);
        if (StringUtils.isEmpty((String)graphDbBackend)) {
            graphDbBackend = "janus";
        }
        this.clearPropertyDirect(GRAPHDB_BACKEND_CONF);
        this.addPropertyDirect(GRAPHDB_BACKEND_CONF, graphDbBackend);
        LOG.info("Using graphdb backend '" + graphDbBackend + "'");
        String storageBackend = this.getString(STORAGE_BACKEND_CONF);
        if (StringUtils.isEmpty((String)storageBackend) || storageBackend.equalsIgnoreCase(STORAGE_BACKEND_HBASE)) {
            storageBackend = STORAGE_BACKEND_HBASE2;
        }
        this.clearPropertyDirect(STORAGE_BACKEND_CONF);
        this.addPropertyDirect(STORAGE_BACKEND_CONF, storageBackend);
        LOG.info("Using storage backend '" + storageBackend + "'");
        String indexBackend = this.getString(INDEX_BACKEND_CONF);
        if (StringUtils.isEmpty((String)indexBackend)) {
            indexBackend = INDEX_BACKEND_SOLR;
        }
        this.clearPropertyDirect(INDEX_BACKEND_CONF);
        this.addPropertyDirect(INDEX_BACKEND_CONF, indexBackend);
        LOG.info("Using index backend '" + indexBackend + "'");
        if (indexBackend.equalsIgnoreCase(INDEX_BACKEND_SOLR)) {
            LOG.info("Atlas is running in MODE: {}.", (Object)runMode.name());
            if (runMode == AtlasRunMode.PROD) {
                this.clearPropertyDirect(SOLR_WAIT_SEARCHER_CONF);
                this.addPropertyDirect(SOLR_WAIT_SEARCHER_CONF, true);
                LOG.info("Setting solr-wait-searcher property 'true'");
                this.clearPropertyDirect(INDEX_MAP_NAME_CONF);
                this.addPropertyDirect(INDEX_MAP_NAME_CONF, false);
                LOG.info("Setting index.search.map-name property 'false'");
            }
        }
        this.setDbCacheConfDefaults();
    }

    void setDefault(AbstractMap.SimpleEntry<String, String> keyValueDefault, String currentValue) {
        if (StringUtils.isNotEmpty((String)currentValue)) {
            return;
        }
        this.clearPropertyDirect(keyValueDefault.getKey());
        this.addPropertyDirect(keyValueDefault.getKey(), keyValueDefault.getValue());
        LOG.info("Property (set to default) {} = {}", (Object)keyValueDefault.getKey(), (Object)keyValueDefault.getValue());
    }

    private void setDbCacheConfDefaults() {
        AbstractMap.SimpleEntry[] keyValues;
        for (AbstractMap.SimpleEntry kv : keyValues = new AbstractMap.SimpleEntry[]{DB_CACHE_CONF, DB_CACHE_CLEAN_WAIT_CONF, DB_CACHE_SIZE_CONF, DB_TX_CACHE_SIZE_CONF, DB_CACHE_TX_DIRTY_SIZE_CONF}) {
            String currentValue = this.getString((String)kv.getKey());
            this.setDefault(kv, currentValue);
        }
    }

    public static enum AtlasRunMode {
        PROD,
        DEV;

    }
}

