/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.knox.client;

import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.services.knox.client.KnoxClient;

public class KnoxConnectionMgr {
    private static final Logger LOG = Logger.getLogger(KnoxConnectionMgr.class);

    public KnoxClient getKnoxClientbyService(RangerService service) {
        KnoxClient knoxClient = null;
        Map configs = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting knoxClient for ServiceName: " + service.toString()));
        }
        if (service != null) {
            configs = service.getConfigs();
            knoxClient = this.getKnoxClientByConfig(configs);
        }
        return knoxClient;
    }

    public KnoxClient getKnoxClientByConfig(Map<String, String> configs) {
        KnoxClient knoxClient = null;
        if (configs == null) {
            LOG.error((Object)"Connection Config is empty");
        } else {
            String knoxUrl = configs.get("knox.url");
            String knoxAdminUser = configs.get("username");
            String knoxAdminPassword = configs.get("password");
            knoxClient = new KnoxClient(knoxUrl, knoxAdminUser, knoxAdminPassword);
        }
        return knoxClient;
    }

    public KnoxClient getKnoxClient(String serviceName, Map<String, String> configs) {
        KnoxClient knoxClient = null;
        LOG.debug((Object)("Getting knoxClient for datasource: " + serviceName + "configMap: " + configs));
        if (configs == null) {
            LOG.error((Object)"Connection ConfigMap is empty");
        } else {
            String knoxUrl = configs.get("knox.url");
            String knoxAdminUser = configs.get("username");
            String knoxAdminPassword = configs.get("password");
            knoxClient = new KnoxClient(knoxUrl, knoxAdminUser, knoxAdminPassword);
        }
        return knoxClient;
    }

    public KnoxClient getKnoxClient(String knoxUrl, String knoxAdminUser, String knoxAdminPassword) {
        KnoxClient knoxClient = null;
        if (knoxUrl == null || knoxUrl.isEmpty()) {
            LOG.error((Object)"Can not create KnoxClient: knoxUrl is empty");
        } else if (knoxAdminUser == null || knoxAdminUser.isEmpty()) {
            LOG.error((Object)"Can not create KnoxClient: knoxAdminUser is empty");
        } else if (knoxAdminPassword == null || knoxAdminPassword.isEmpty()) {
            LOG.error((Object)"Can not create KnoxClient: knoxAdminPassword is empty");
        } else {
            knoxClient = new KnoxClient(knoxUrl, knoxAdminUser, knoxAdminPassword);
        }
        return knoxClient;
    }
}

