/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.knox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.knox.client.KnoxResourceMgr;

public class RangerServiceKnox
extends RangerBaseService {
    private static final Log LOG = LogFactory.getLog(RangerServiceKnox.class);
    public static final String ACCESS_TYPE_ALLOW = "allow";

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public Map<String, Object> validateConfig() throws Exception {
        Map<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceKnox.validateConfig Service: (" + serviceName + " )"));
        }
        if (this.configs != null) {
            try {
                ret = KnoxResourceMgr.validateConfig(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error((Object)("<== RangerServiceKnox.validateConfig Error:" + e));
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceKnox.validateConfig Response : (" + ret + " )"));
        }
        return ret;
    }

    public List<RangerPolicy> getDefaultRangerPolicies() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerServiceKnox.getDefaultRangerPolicies()");
        }
        List ret = super.getDefaultRangerPolicies();
        for (RangerPolicy defaultPolicy : ret) {
            if (!defaultPolicy.getName().contains("all") || !StringUtils.isNotBlank((String)this.lookUpUser)) continue;
            RangerPolicy.RangerPolicyItem policyItemForLookupUser = new RangerPolicy.RangerPolicyItem();
            policyItemForLookupUser.setUsers(Collections.singletonList(this.lookUpUser));
            policyItemForLookupUser.setAccesses(Collections.singletonList(new RangerPolicy.RangerPolicyItemAccess(ACCESS_TYPE_ALLOW)));
            policyItemForLookupUser.setDelegateAdmin(Boolean.valueOf(false));
            defaultPolicy.getPolicyItems().add(policyItemForLookupUser);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerServiceKnox.getDefaultRangerPolicies()");
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceKnox.lookupResource Context: (" + context + ")"));
        }
        if (context != null) {
            try {
                ret = KnoxResourceMgr.getKnoxResources(serviceName, configs, context);
            }
            catch (Exception e) {
                LOG.error((Object)("<== RangerServiceKnox.lookupResource Error : " + e));
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceKnox.lookupResource Response: (" + ret + ")"));
        }
        return ret;
    }
}

